/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client;

import java.util.List;

import org.gcube.portlets.user.tdtemplate.client.resources.TdTemplateAbstractResources;
import org.gcube.portlets.user.tdtemplate.client.template.view.TemplateSwitcherInteface;
import org.gcube.portlets.user.tdtemplate.client.template.view.updater.TemplateUpdaterFormSwitcherPanel;
import org.gcube.portlets.user.tdtemplate.client.template.view.updater.TemplateUpdaterGenerator;
import org.gcube.portlets.user.tdtemplate.shared.ClientReportTemplateSaved;
import org.gcube.portlets.user.tdtemplate.shared.TdColumnDefinition;
import org.gcube.portlets.user.tdtemplate.shared.TdTTemplateType;
import org.gcube.portlets.user.tdtemplate.shared.TdTemplateDefinition;
import org.gcube.portlets.user.tdtemplate.shared.TdTemplateUpdater;

import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jan 8, 2014
 *
 */
public class TdTemplateControllerUpdater extends TdTemplateController {

	private TemplateUpdaterFormSwitcherPanel switcherUpdater;
	private boolean onErrorLoaded = false;
	private boolean onTemplatesLoaded = false;

	private long templateId;
	private List<TdTTemplateType> templatesType;
	private List<String> errors;
	private TdTemplateControllerUpdater INSTANCE = this;
	
	private TdTemplateUpdater templateUpdater;
	private TdTemplatePrivateEventsBinder binder;
	
	private TemplateUpdaterGenerator tug;
	
	
	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.tdtemplate.client.TdTemplateController#initController()
	 */
	@Override
	protected void initController() {
		GWT.log("Skypping default init, because is a template updating");
	}
	
	public TdTemplateControllerUpdater(long templateId){
		this.templateId = templateId;
		initToolbarSubmit();
		binder = new TdTemplatePrivateEventsBinder();
		binder.bindEvents(INSTANCE);
		bindCommonEvents();
		
//		window.mask("Loading Data");
		
		switcherUpdater = new TemplateUpdaterFormSwitcherPanel(this);
		super.switcher = switcherUpdater;
		
		mainPanel.add(switcherUpdater);

		tdTemplateServiceAsync.getTemplateTypes(new AsyncCallback<List<TdTTemplateType>>() {
			
			
			@Override
			public void onSuccess(List<TdTTemplateType> result) {
				templatesType = result;
				onTemplatesLoaded = true;
				loadTemplateUpdater();
				
			}
			
			@Override
			public void onFailure(Throwable caught) {
				GWT.log("An error occurred on recovering template types, "+caught.getMessage());
				onTemplatesLoaded = true;
				loadTemplateUpdater();
			}
		});
		
		
		tdTemplateServiceAsync.getOnErrorValues(new AsyncCallback<List<String>>() {


			@Override
			public void onFailure(Throwable caught) {
				GWT.log("An error occurred on recovering on errors, "+caught.getMessage());
				onErrorLoaded = true;
				loadTemplateUpdater();
			}

			@Override
			public void onSuccess(List<String> onErrors) {
				errors = onErrors;
				onErrorLoaded = true;
				loadTemplateUpdater();
				
			}
		});
	}

	/**
	 * 
	 */
	protected void loadTemplateUpdater() {
		
		if(onErrorLoaded && onTemplatesLoaded){
		
			tdTemplateServiceAsync.getTemplateUpdaterForTemplateId(templateId, new AsyncCallback<TdTemplateUpdater>() {
	
				@Override
				public void onFailure(Throwable caught) {
//					window.unmask();
					displayError("Error", "Sorry an error occurred on contacting the service");
				}
	
				@Override
				public void onSuccess(TdTemplateUpdater result) {
//					window.unmask();
					GWT.log("Loaded updater: "+result);
					templateUpdater = result;
					TdTemplateDefinition templateDefinition = result.getTemplateDefinition();
					switcherUpdater.setServerId(templateDefinition.getServerId());
					switcherUpdater.setAgency(templateDefinition.getAgency());
					switcherUpdater.setName(templateDefinition.getTemplateName());
					switcherUpdater.setDescription(templateDefinition.getTemplateDescription());
					
					switcherUpdater.setTemplates(templatesType,templateDefinition.getTdTTemplateType());
					
					switcherUpdater.setOnErrors(errors,templateDefinition.getOnError());
					switcherUpdater.setNumberOfColumns(result.getListColumns().size());
					window.layout(true);
					
	//				switcher.setOnErrors(onErrors, select)
					
				}
			});
		
		}
		
	}
	
	@Override
	public void createTemplate(List<TdColumnDefinition> columns){

		if(columns.size()>0){
		
			window.mask("Updating Template Columns");
			tdTemplateServiceAsync.updateTemplate(columns, new AsyncCallback<ClientReportTemplateSaved>() {

				@Override
				public void onFailure(Throwable caught) {
					window.unmask();
					MessageBox.alert(TdTemplateConstants.TEMPLATE_ERROR, TdTemplateConstants.TEMPLATE_UPDATE_ERROR, null).show();
				}

				@Override
				public void onSuccess(ClientReportTemplateSaved result) {
				    messageBoxTitle = TdTemplateConstants.TEMPLATE_UPDATED;
				    messageBoxMsg = TdTemplateConstants.TEMPLATE_UPDATED_SUCCESSFULLY+"!";
					window.unmask();
					showReportTemplateSaved(result);
				}
			});
		}
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.tdtemplate.client.TdTemplateController#doInitTemplate(org.gcube.portlets.user.tdtemplate.client.template.view.TemplateSwitcherInteface)
	 */
	@Override
	public void doInitTemplate(TemplateSwitcherInteface switcherInterface) {
		switcher.mask("Updating template", TdTemplateConstants.LOADINGSTYLE);
//		System.out.println("templateType "+switcherInterface.getType());
//		System.out.println("numcol "+switcherInterface.getNumberOfColumns());
		
		tug = new TemplateUpdaterGenerator(switcherUpdater, INSTANCE);
		tug.initTemplatePanel();
		
		super.initLocaleManager(switcherInterface);
		
//		tug.getUpdater().setColumns(templateUpdater.getListColumns());
		
		TdTemplateController.tdGeneretor = tug;
		
		switcher.hide();
		
		mainPanel.mask("Building template");
		mainPanel.add(tug.getTemplatePanel().getPanel());
//		mainPanel.layout(true);
		
		window.setHeading(TdTemplateConstants.TEMPLATEUPDATER+": " +switcher.getName() +" - Type: "+switcherInterface.getType());
		
		mainPanel.unmask();
	}
	
	/**
	 * Use for GXT 2.5
	 * @return
	 */
	@Override
	public Window getWindowTemplatePanel() {
		
		window.setIcon(TdTemplateAbstractResources.newtemplate());
		window.setResizable(true);
		window.setAnimCollapse(true);
		window.setMaximizable(true);
		window.setHeading(TdTemplateConstants.TEMPLATEUPDATER);
		window.setSize((width+20)+"px", (height+40)+"px");
		window.setLayout(new FitLayout());
		window.setBottomComponent(submitTool);
	    window.add(mainPanel);
	    window.setScrollMode(Scroll.AUTO);
		return window;
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.tdtemplate.client.TdTemplateControllerState#doUpdateTemplate()
	 */
	@Override
	public void doUpdateTemplate() {
		tug.getUpdater().setColumns(templateUpdater.getListColumns());
		mainPanel.layout(true);
	}

}
