/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client.template.view.updater;

import org.gcube.portlets.user.tdtemplate.client.TdTemplateControllerUpdater;
import org.gcube.portlets.user.tdtemplate.client.template.TemplateGenerator;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Mar 25, 2014
 *
 */
public class TemplateUpdaterGenerator extends TemplateGenerator{

	private TemplateUpdaterSwitcherInteface switcherUpdater;
	private TdTemplateControllerUpdater controllerUpdater;
	private TemplatePanelUpdater updater;

	/**
	 * @param switcher
	 * @param controller
	 */
	public TemplateUpdaterGenerator(TemplateUpdaterSwitcherInteface switcher, TdTemplateControllerUpdater controller) {
		super(switcher, controller);
		this.switcherUpdater = switcher;
		this.controllerUpdater = controller;
		
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.tdtemplate.client.template.TemplateGenerator#initTemplatePanel()
	 */
	@Override
	public void initTemplatePanel() {
	
		this.updater = new TemplatePanelUpdater(switcherUpdater, controllerUpdater);
		super.templatePanel = updater;
	}

	public TemplatePanelUpdater getUpdater() {
		return updater;
	}
}
