/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client.template;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.tdtemplate.client.TdTemplateController;
import org.gcube.portlets.user.tdtemplate.client.template.view.BaloonPanel;
import org.gcube.portlets.user.tdtemplate.client.template.view.external.DialogCodelistResolver;
import org.gcube.portlets.user.tdtemplate.shared.SPECIAL_CATEGORY_TYPE;
import org.gcube.portlets.user.tdtemplate.shared.TdTColumnCategory;
import org.gcube.portlets.user.tdtemplate.shared.TdTDataType;

import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.form.ComboBox.TriggerAction;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.client.Style.BorderStyle;
import com.google.gwt.dom.client.Style.Unit;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jan 30, 2014
 *
 */
public class SetColumnTypeDialogManager {
	

	/**
	 * 
	 */
	private static final String CHOOSE_LOCALE = "Choose Locale";

	private SimpleComboBox<String> scbCategory = new SimpleComboBox<String>();
	
	private SimpleComboBox<String> scbDataType = new SimpleComboBox<String>();
	
	private SimpleComboBox<String> scbReference = new SimpleComboBox<String>();
	
	private SimpleComboBox<String> scbLocales = new SimpleComboBox<String>();
	
	private SimpleComboBox<String> scbPeriodTypes = new SimpleComboBox<String>();
	
	private String currentLocaleSelect;
	
	private List<TdTColumnCategory> listCategory;
	
	private SetTypeColumnContainer typingContainer;
	
	private SetColumnTypeDialogManager INSTANCE = this;
	
	private List<ColumnData> lsColumnData = null;
	
	private BaloonPanel baloon;
	
//	private DialogCodelistResolver resolver;

	private TdTemplateController controller;
	
	private String tabularResourceName;

	/**
	 * 
	 */
	public SetColumnTypeDialogManager(List<TdTColumnCategory> columnCategories, TdTemplateController controller) {
		this.listCategory = columnCategories;
		this.controller = controller;
		scbDataType.setEnabled(false);
		initComboSetCategory();
		initComboLocales();
		initComboPeriodTypes();
	
		scbCategory.addSelectionChangedListener(new SelectionChangedListener<SimpleComboValue<String>>() {
					
			@Override
			public void selectionChanged(SelectionChangedEvent<SimpleComboValue<String>> se) {
				
				scbDataType.reset();
				scbReference.reset();
				scbLocales.reset();
				scbDataType.setVisible(true);
				typingContainer.removeCombo(scbLocales);
				
				selectDataType();
				
				if(scbCategory.getSimpleValue().compareToIgnoreCase(SPECIAL_CATEGORY_TYPE.DIMENSION.getLabel())==0){
					scbDataType.setEnabled(true);
					categoryDimensionHandler();
					scbDataType.setVisible(false);
					typingContainer.removeCombo(scbPeriodTypes);
				}else if(scbCategory.getSimpleValue().compareToIgnoreCase(SPECIAL_CATEGORY_TYPE.TIMEDIMENSION.getLabel())==0){
					scbDataType.setEnabled(true);
					categoryTimeDimensionHandler();
					typingContainer.removeCombo(scbReference);
				}else if(scbCategory.getSimpleValue().compareToIgnoreCase(SPECIAL_CATEGORY_TYPE.CODENAME.getLabel())==0){
					categoryCodeNameHandler();
					typingContainer.removeCombo(scbReference);
					typingContainer.removeCombo(scbPeriodTypes);
				}else{ //NORMAL BEHAVIOUR
					typingContainer.removeCombo(scbReference);
					typingContainer.removeCombo(scbPeriodTypes);
				}
			}	
		});
		
		
		scbDataType.addSelectionChangedListener(new SelectionChangedListener<SimpleComboValue<String>>() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent<SimpleComboValue<String>> se) {
					
			}
		});
		
		scbReference.addSelectionChangedListener(new SelectionChangedListener<SimpleComboValue<String>>() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent<SimpleComboValue<String>> se) {
				
				scbReference.getElement().getStyle().setBorderWidth(0, Unit.PX);
				if(baloon!=null)
					baloon.hide();
			}
		});
		
		scbPeriodTypes.addSelectionChangedListener(new SelectionChangedListener<SimpleComboValue<String>>() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent<SimpleComboValue<String>> se) {
				
				scbPeriodTypes.getElement().getStyle().setBorderWidth(0, Unit.PX);
			}
		});
		
		
		typingContainer = new SetTypeColumnContainer(scbCategory, scbDataType);

	}
	
	/**
	 * 
	 */
	private void initComboLocales() {
		
		List<String> ls = new ArrayList<String>();

		for (String locale : controller.getAllowedLocales())
			ls.add(locale);

		scbLocales = new SimpleComboBox<String>();
		scbLocales.setFieldLabel("Locale *");
		scbLocales.setTypeAhead(true);
		scbLocales.setEditable(false);
		scbLocales.setEmptyText(CHOOSE_LOCALE);
		scbLocales.setToolTip("Locale");
		scbLocales.setTriggerAction(TriggerAction.ALL);
		
		scbLocales.add(controller.getLocaleViewManager().getLocales());
			
		scbLocales.addSelectionChangedListener(new SelectionChangedListener<SimpleComboValue<String>>() {

			@Override
			public void selectionChanged(SelectionChangedEvent<SimpleComboValue<String>> se) {
				
				String localeSel = scbLocales.getSimpleValue();
				GWT.log("Selection Locale changed: "+localeSel +", OLD LOCALE: "+currentLocaleSelect);
				setSelectedLocale(localeSel, false);
				
			}
		});
	}

	private void selectDataType(){
		
		for (TdTColumnCategory category : listCategory) {
			if(scbCategory.getSimpleValue().compareTo(category.getName())==0){
				scbDataType.setEnabled(true);
				initComboSetDataType(category);
			}
				
		}
	}
	
	private void initComboSetCategory() {

		List<String> ls = new ArrayList<String>();

		for (TdTColumnCategory category : listCategory)
			ls.add(category.getName());

		scbCategory = new SimpleComboBox<String>();
		scbCategory.setFieldLabel("Category *");
		scbCategory.setTypeAhead(true);
		scbCategory.setEditable(false);
		scbCategory.setEmptyText("Categorize");
		scbCategory.setToolTip("Category");
		scbCategory.setTriggerAction(TriggerAction.ALL);
		scbCategory.add(ls);
	}
	
	private void initComboPeriodTypes() {

		List<String> ls = new ArrayList<String>();

		for (String period : controller.getListPeriodTypes())
			ls.add(period);

		scbPeriodTypes = new SimpleComboBox<String>();
		scbPeriodTypes.setFieldLabel("Period *");
		scbPeriodTypes.setTypeAhead(true);
		scbPeriodTypes.setEditable(false);
		scbPeriodTypes.setEmptyText("Period");
		scbPeriodTypes.setToolTip("Period");
		scbPeriodTypes.setTriggerAction(TriggerAction.ALL);
		scbPeriodTypes.add(ls);
	}
	
	private void categoryDimensionHandler(){
		
		scbReference.removeAll();
		typingContainer.addCombo(scbReference);
		scbReference.addListener(Events.OnClick,listenerDimension);
	}
	
	
	private void categoryCodeNameHandler(){
		
		scbLocales.removeAll();
		
		//UPDATE LOCALES
		scbLocales.add(controller.getLocaleViewManager().getLocales());
		typingContainer.addCombo(scbLocales);
		
		scbLocales.getElement().getStyle().setBorderColor("#EE2C2C");
		scbLocales.getElement().getStyle().setBorderStyle(BorderStyle.SOLID);
		scbLocales.getElement().getStyle().setBorderWidth(1.0, Unit.PX);

		scbLocales.addListener(Events.OnClick,listenerLocale);
	}
	
	protected Listener<BaseEvent> listenerLocale = new Listener<BaseEvent>() {

		@Override
		public void handleEvent(BaseEvent be) {
			scbLocales.removeAll();
			scbLocales.add(controller.getLocaleViewManager().getLocales());
			scbLocales.getElement().getStyle().setBorderWidth(0, Unit.PX);
		}
	};


	private void categoryTimeDimensionHandler(){
		
		typingContainer.addCombo(scbPeriodTypes);
		
		scbPeriodTypes.getElement().getStyle().setBorderColor("#EE2C2C");
		scbPeriodTypes.getElement().getStyle().setBorderStyle(BorderStyle.SOLID);
		scbPeriodTypes.getElement().getStyle().setBorderWidth(1.0, Unit.PX);

		scbPeriodTypes.addListener(Events.OnClick,listenerDimension);
	}
	
	private Listener<BaseEvent> listenerDimension = new Listener<BaseEvent>() {

		@Override
		public void handleEvent(BaseEvent be) {
			if(scbCategory.getSimpleValue().compareToIgnoreCase(SPECIAL_CATEGORY_TYPE.DIMENSION.getLabel())==0){
//				scbDataType.mask("Loading");
				DialogCodelistResolver resolver = new DialogCodelistResolver(INSTANCE);
				resolver.show();
			}else if(scbCategory.getSimpleValue().compareToIgnoreCase(SPECIAL_CATEGORY_TYPE.TIMEDIMENSION.getLabel())==0){
//				DialogCodelistResolver resolver = new DialogCodelistResolver(INSTANCE);
			}
		}
	};


	
	public void initComboSetReference(List<ColumnData> columnReference) {
		
		scbReference.removeAll();
		
		scbReference.getElement().getStyle().setBorderColor("#EE2C2C");
		scbReference.getElement().getStyle().setBorderStyle(BorderStyle.SOLID);
		scbReference.getElement().getStyle().setBorderWidth(1.0, Unit.PX);
//		scbReference.setToolTip("Choose Reference");
	
		String tbResourceName = getReferenceTabularResourceName();
		String baloonDescr="";
		if(tbResourceName!=null){
			baloonDescr="Selected Codelist: '"+tbResourceName +"'<br/>";
		}
		baloonDescr = baloonDescr.length()>0?baloonDescr+"You have to pick column reference":"Choose Column Reference";
				
		baloon = new BaloonPanel(baloonDescr, false);

		int zIndex = controller.getWindowZIndex();
		int zi = zIndex+1;
//		baloon.getElement().setAttribute("z-index", zi+"");
		baloon.getElement().getStyle().setZIndex(zi);
		baloon.showRelativeTo(scbReference);
		
		scbReference.removeListener(Events.OnClick, listenerDimension);
		
		lsColumnData = new ArrayList<ColumnData>(columnReference.size());

		for (ColumnData col : columnReference){
			GWT.log("Adding reference id: "+col.getId()+col.getLabel());
			scbReference.setData(col.getId()+col.getLabel(), col);
			lsColumnData.add(col);
		}
		
		scbReference.setFieldLabel("Choose Reference");
		scbReference.setToolTip("Reference");
		scbReference.setTypeAhead(true);
		scbReference.setEditable(false);
		scbReference.setTriggerAction(TriggerAction.ALL);
		
		for (ColumnData columnData : columnReference) {
			scbReference.add(columnData.getLabel());
		}
	}
	
	
	/**
	 * @param name
	 */
	public void setTabularResourceName(String name) {
		this.tabularResourceName = name;
		
	}

	public void updateComboSetReference(List<ColumnData> columnReference){
		
		scbReference.removeAll();

		scbReference.removeListener(Events.OnClick, listenerDimension);
		
		lsColumnData = new ArrayList<ColumnData>(columnReference.size());

		for (ColumnData col : columnReference){
			GWT.log("Adding reference id: "+col.getId()+col.getLabel());
			scbReference.setData(col.getId()+col.getLabel(), col);
			lsColumnData.add(col);
		}
		
		scbReference.setFieldLabel("Choose Reference");
		scbReference.setToolTip("Reference");
		scbReference.setTypeAhead(true);
		scbReference.setEditable(false);
		scbReference.setTriggerAction(TriggerAction.ALL);
		
		for (ColumnData columnData : columnReference) {
			scbReference.add(columnData.getLabel());
		}
		
	}
	

	
	private void initComboSetDataType(TdTColumnCategory category) {
		
		scbDataType.removeAll();
		
		scbDataType.removeListener(Events.OnClick, listenerDimension);
		
		List<String> ls = new ArrayList<String>();

		for (TdTDataType tdDataType : category.getTdtDataType())
			ls.add(tdDataType.getName());

		scbDataType.setFieldLabel("Data type *");
		scbDataType.setTypeAhead(true);
		scbDataType.setEditable(false);
		scbDataType.setEmptyText("Choose data type");
		scbDataType.setToolTip("Data Type");
		scbDataType.setTriggerAction(TriggerAction.ALL);
		scbDataType.add(ls);

	}

	public TdTColumnCategory getCategorySelected(){
		
		for (TdTColumnCategory category : listCategory) {
			if(scbCategory.getSimpleValue().compareTo(category.getName())==0){
				return category;
			}
				
		}
		return null;
	}
	
	public String getSelectedPeriodType(){
		
			if(scbPeriodTypes.getSelectedIndex()!=-1)
				return scbPeriodTypes.getSimpleValue();
	
		return null;
	}
	
	public TdTDataType getDataTypeSelected(){
		
		TdTColumnCategory category = getCategorySelected();
		
		if(category==null)
			return null;
		
		for (TdTDataType tdDataType : category.getTdtDataType()){
			if(scbDataType.getSimpleValue().compareTo(tdDataType.getName())==0){
				return tdDataType;
			}	
		}
		
		return null;
	}
	
	public ColumnData getReferenceSelected(){

		if(scbReference.getSimpleValue()!=null && lsColumnData!=null){
			for (ColumnData columnData : lsColumnData) {
				String columnId =  columnData.getId()+scbReference.getSimpleValue();
				GWT.log("Trying fetch reference id: "+columnId);
				ColumnData refernceSelected = scbReference.getData(columnId);
				if(refernceSelected!=null){
					GWT.log("Returning reference: "+refernceSelected);
					return refernceSelected;
				}
			}
		}
		return null;
	}
	

	public SimpleComboBox<String> getScbCategory() {
		return scbCategory;
	}

	public SimpleComboBox<String> getScbDataType() {
		return scbDataType;
	}
	
	public SimpleComboBox<String> getScbReference() {
		return scbReference;
	}

	public SetTypeColumnContainer getTypingContainer() {
		return typingContainer;
	}
	
	public String getReferenceTabularResourceName(){
		return tabularResourceName;
	}

	public SimpleComboBox<String> getScbLocales() {
		return scbLocales;
	}

	/**
	 * @return
	 */
	public String getSelectedLocale() {
		if(currentLocaleSelect==null)
			return null;
		
		if(currentLocaleSelect==scbLocales.getSimpleValue())
			return currentLocaleSelect;
		
		return null;
	}
	
	/**
	 * @return
	 */
	public void setSelectedLocale(String value, boolean isUpdate) {
		
		//DESELECT OLD LOCALE
		if(currentLocaleSelect!=null){
			controller.getLocaleViewManager().deselectLocale(currentLocaleSelect);
		}
		
		//SELECT CURRENT LOCALE
		if(value!=null && !value.isEmpty()){
			controller.getLocaleViewManager().selectLocale(value);
			currentLocaleSelect = value;
			
			if(isUpdate){
				scbLocales.getElement().getStyle().setBorderWidth(0, Unit.PX);
				scbLocales.setSimpleValue(value);
			}
		}
		
		
	}
	
	/**
	 * 
	 * @param simpleValue
	 */
	public void setSelectedFirstDataType(){
		
		scbDataType.getStore().getCount();
		SimpleComboValue<String> value = scbDataType.getStore().getAt(0);
		value.getValue();
		
		scbDataType.setSimpleValue(value.getValue());
	}
	
	/**
	 * SELECTE FIRST COMBO VALUE IF THERE IS ONLY ONE VALUE
	 */
	public void selectDataTypeIfIsSingle(){
		if(scbDataType.getStore().getCount()==1){
			SimpleComboValue<String> value = scbDataType.getStore().getAt(0);
			GWT.log("Data type has single value: "+value.getValue()+", selecting");
			scbDataType.setSimpleValue(value.getValue());
		}
	}

	public SimpleComboBox<String> getScbPeriodTypes() {
		return scbPeriodTypes;
	}

	/**
	 * @param timePeriod
	 */
	public void setSelectedTimePeriod(String timePeriod) {
		scbPeriodTypes.setSimpleValue(timePeriod);
	}
	
	public void setSelectedReferenceAs(ColumnData data){
		scbReference.setSimpleValue(data.getLabel());
	}
}
