/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.td.widgetcommonevent.client.event.ExpressionEvent;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_ExpressionContainer;
import org.gcube.portlets.user.tdtemplate.client.event.ExpressionDialogOpenedEvent;
import org.gcube.portlets.user.tdtemplate.client.event.ExpressionDialogOpenedEventHandler;
import org.gcube.portlets.user.tdtemplate.client.event.TemplateComplitedEvent;
import org.gcube.portlets.user.tdtemplate.client.event.TemplateComplitedEventHandler;
import org.gcube.portlets.user.tdtemplate.client.event.TemplateSelectedEvent;
import org.gcube.portlets.user.tdtemplate.client.event.TemplateSelectedEventHandler;
import org.gcube.portlets.user.tdtemplate.client.resources.TdTemplateAbstractResources;
import org.gcube.portlets.user.tdtemplate.client.rpc.TdTemplateService;
import org.gcube.portlets.user.tdtemplate.client.rpc.TdTemplateServiceAsync;
import org.gcube.portlets.user.tdtemplate.client.template.TemplateGenerator;
import org.gcube.portlets.user.tdtemplate.client.template.view.ColumnDefinitionView;
import org.gcube.portlets.user.tdtemplate.client.template.view.TemplateFormSwitcherPanel;
import org.gcube.portlets.user.tdtemplate.client.template.view.TemplateSwitcherInteface;
import org.gcube.portlets.user.tdtemplate.shared.SPECIAL_CATEGORY_TYPE;
import org.gcube.portlets.user.tdtemplate.shared.TdColumnDefinition;
import org.gcube.portlets.user.tdtemplate.shared.TdTTemplateType;

import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.SimpleEventBus;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jan 8, 2014
 *
 */
public class TdTemplateController {
	
	private static EventBus privateTaskBus = new SimpleEventBus();
	private static EventBus commonBus = new SimpleEventBus();
	private TemplateFormSwitcherPanel switcher;
	  // Create a table to layout the content
    private final LayoutContainer mainPanel = new LayoutContainer();
    private int width = TdTemplateConstants.MAINWIDTH+5;
    private int height = TdTemplateConstants.MAINHEIGHT+5;

	private static int expressionDialogIndexUpdate;
	
    public static final TdTemplateServiceAsync tdTemplateServiceAsync = GWT.create(TdTemplateService.class);
	
    private static TemplateGenerator tdGeneretor;
    private static final Window window = new Window();
    

    private ToolBar submitTool = new ToolBar();
    
    public static EventBus getInternalBus(){
    	return privateTaskBus;
    }
    
    /**
	 * 
	 * @param bus
	 */
	public static void bindCommonBus(EventBus bus){
		commonBus = bus;
		bindCommonEvents();
	}
	
	public static int getWindowZIndex(){
		return window.el().getZIndex();
	}
	
	private static void bindCommonEvents() {

//		commonBus.addHandler(UIStateEvent.TYPE, new UIStateEvent.UIStateHandler() {
//			
//			@Override
//			public void onUIState(UIStateEvent event) {
//			
//				if(event.getUIStateType().equals(UIStateType.TR_OPEN)){
//					getInstance().updateTasks(true);
//				}
//				
//			}
//		});
		
		commonBus.addHandler(ExpressionEvent.TYPE, new ExpressionEvent.ExpressionEventHandler() {
			
			@Override
			public void onExpression(ExpressionEvent event) {
				GWT.log("ExpressionEvent catched into Template");
				
				if(event!=null && event.getC_ExpressionContainer()!=null){

					C_ExpressionContainer rule = event.getC_ExpressionContainer();
					
					if(rule!=null && rule.getExp()!=null){
						
						ColumnDefinitionView col = tdGeneretor.getListColumnDefinition().get(expressionDialogIndexUpdate);
						
						if(col!=null){
							GWT.log("Added rule to column, "+expressionDialogIndexUpdate);
							col.addRule(rule);
						}
					}
				}
				else
					GWT.log("Expression dialog closed without a valid expression");
//					MessageBox.alert("Expression event", event.getC_ExpressionContainer().toString(), null);
//					event.getC_ExpressionContainer();
				
			}
		});
	}
    
	/**
	 * 
	 */
	private void initToolbarSubmit() {

		Button butt = new Button("Save");
		butt.setIcon(TdTemplateAbstractResources.submit());
		submitTool.setEnabled(false);
		submitTool.add(new FillToolItem());
		submitTool.add(butt);
	
		
		butt.addSelectionListener(new SelectionListener<ButtonEvent>() {
			
			@Override
			public void componentSelected(ButtonEvent ce) {
				submitTemplateDefinition();
			}
		});
	}
	
	private void submitTemplateDefinition(){
		
		List<ColumnDefinitionView> list = tdGeneretor.getListColumnDefinition();

		List<TdColumnDefinition> columns = new ArrayList<TdColumnDefinition>(list.size());
		
		for (ColumnDefinitionView cDefView : list) {
			
			C_ExpressionContainer rule = cDefView.getRuleExpression();
			C_Expression expression = null;
			if(rule!=null && rule.getExp()!=null){
				expression = rule.getExp();
			}
			
			if(cDefView.getSpecialCategoryType().equals(SPECIAL_CATEGORY_TYPE.NONE) || cDefView.getSpecialCategoryType().equals(SPECIAL_CATEGORY_TYPE.TIMEDIMENSION)){
				columns.add(new TdColumnDefinition(cDefView.getColumnIndex(), cDefView.getSelectedColumnCategory(), cDefView.getSelectedDataType(), expression, cDefView.getSpecialCategoryType()));
			}else if(cDefView.getSpecialCategoryType().equals(SPECIAL_CATEGORY_TYPE.DIMENSION)){
			
				TdColumnDefinition def = new TdColumnDefinition(cDefView.getColumnIndex(), cDefView.getSelectedColumnCategory(), cDefView.getSelectedDataType(), cDefView.getSpecialCategoryType(), cDefView.getReferenceColumnData());
				columns.add(def);
			}
		}
		
		//TODO DEBUG
//		for (TdColumnDefinition tdColumnDefinition : columns) {
//			System.out.println(tdColumnDefinition);	
//		}
//		
		
		
		if(columns.size()>0){
		
			window.mask("Creating template");
			tdTemplateServiceAsync.submitTemplate(columns, new AsyncCallback<Boolean>() {

				@Override
				public void onFailure(Throwable caught) {
					window.unmask();
					MessageBox.alert(TdTemplateConstants.TEMPLATE_ERROR, TdTemplateConstants.SORRY_AN_ERROR_OCCURRED_ON_TEMPLATE_CREATION_TRY_AGAIN, null).show();
				}

				@Override
				public void onSuccess(Boolean result) {
					window.unmask();
					if(result){
						submitTool.disable();
					
//						MessageBox box = MessageBox.confirm(TdTemplateConstants.TEMPLATE_CREATED, TdTemplateConstants.TEMPLATE_CREATED_SUCCESSFULLY+"! <br/> Do you want close current Template Creator?",null);
						
//						MessageBox box = MessageBox.confirm(TdTemplateConstants.TEMPLATE_CREATED, TdTemplateConstants.TEMPLATE_CREATED_SUCCESSFULLY+"!",null);
						
						MessageBox box = MessageBox.info(TdTemplateConstants.TEMPLATE_CREATED, TdTemplateConstants.TEMPLATE_CREATED_SUCCESSFULLY+"!",null);
						box.getDialog().getButtonById(Dialog.OK).addSelectionListener(new SelectionListener<ButtonEvent>() {

							@Override
							public void componentSelected(ButtonEvent ce) {
								window.hide();
							}
						});

						/*box.getDialog().getButtonById(Dialog.NO).addSelectionListener(new SelectionListener<ButtonEvent>() {

							@Override
							public void componentSelected(ButtonEvent ce) {
								submitTool.enable();
							}
						});*/
						
//						box.setButtons(Dialog.YESNO);
						box.setButtons(Dialog.OK);
						box.show();
					}
					
				}
			});
		}
	}
    
	/**
	 * 
	 */
	public TdTemplateController() {
		initToolbarSubmit();
		bindEvents();
		bindCommonEvents();
		
		switcher = new TemplateFormSwitcherPanel();
		mainPanel.add(switcher);
//		window.layout();
		
		tdTemplateServiceAsync.getTemplateTypes(new AsyncCallback<List<TdTTemplateType>>() {
			
			@Override
			public void onSuccess(List<TdTTemplateType> result) {
				switcher.updateTemplates(result);
				
			}
			
			@Override
			public void onFailure(Throwable caught) {
				GWT.log("An error occurred on recovering template types, "+caught.getMessage());
				
			}
		});
		
		
		tdTemplateServiceAsync.getOnErrorValues(new AsyncCallback<List<String>>() {

			@Override
			public void onFailure(Throwable caught) {
				GWT.log("An error occurred on recovering on errors, "+caught.getMessage());
				
			}

			@Override
			public void onSuccess(List<String> onErrors) {
				switcher.updateOnErrors(onErrors);
				
			}
		});
	}
	

	private void bindEvents(){
		
		privateTaskBus.addHandler(TemplateSelectedEvent.TYPE, new TemplateSelectedEventHandler() {
			
			@Override
			public void onTemplateSelectedEvent(TemplateSelectedEvent event) {

				doInitTemplate(event.getSwitcher());
			}

		});
		
		privateTaskBus.addHandler(TemplateComplitedEvent.TYPE, new TemplateComplitedEventHandler() {
			
			@Override
			public void onTemplateComplitedEvent(TemplateComplitedEvent templateValidEvent) {
				submitTool.setEnabled(templateValidEvent.isCompleted());
				
			}
			
		});
		
		privateTaskBus.addHandler(ExpressionDialogOpenedEvent.TYPE, new ExpressionDialogOpenedEventHandler() {
			
		

			@Override
			public void onExpressionDialogOpen(ExpressionDialogOpenedEvent expressionDialogEvent) {
				
				if(expressionDialogEvent!=null && expressionDialogEvent.getColumnId()!=-1){
					expressionDialogIndexUpdate = expressionDialogEvent.getColumnId();
					GWT.log("Updated expression dialog open as index "+expressionDialogIndexUpdate);
				}
				
			}
		});
		
	}
	

	private void doInitTemplate(TemplateSwitcherInteface switcherInterface) {
		switcher.mask("Creating template", TdTemplateConstants.LOADINGSTYLE);
//		System.out.println("templateType "+switcherInterface.getType());
//		System.out.println("numcol "+switcherInterface.getNumberOfColumns());
		
		tdGeneretor = new TemplateGenerator(switcherInterface);
		
		
		switcher.hide();
		mainPanel.add(tdGeneretor.getTemplatePanel().getPanel());
		mainPanel.layout(true);
		
		window.setHeading(TdTemplateConstants.TEMPLATECREATOR+": " +switcher.getName() +" - Type: "+switcherInterface.getType());
		
	}
	
	
	/**
	 * Use for GXT 2.5
	 * @return
	 */
	public Window getWindowTemplatePanel() {
		
		
		window.setResizable(true);
		window.setAnimCollapse(true);
		window.setMaximizable(true);
		window.setHeading(TdTemplateConstants.TEMPLATECREATOR);
		window.setSize((width+20)+"px", (height+40)+"px");
		window.setLayout(new FitLayout());
		window.setBottomComponent(submitTool);
	    window.add(mainPanel);
	    window.setScrollMode(Scroll.AUTO);
		return window;
	}
	
	/**
	 * Use for GWT
	 * @return
	 */
	/*
	public DialogBox getDialogBoxTemplatePanel() {
		
		final DialogBox dialogBox = new DialogBox();
		dialogBox.setGlassEnabled(true);
		dialogBox.setAnimationEnabled(true);
		int width = TdTemplateConstants.MAINWIDTH+5;
		int height = TdTemplateConstants.MAINHEIGHT+5;
		dialogBox.setSize((width+5)+"px", (height+5)+"px");
	  
	    mainPanel.add(switcher);
		
	    com.google.gwt.user.client.ui.Button closeButton = new com.google.gwt.user.client.ui.Button("Close", new ClickHandler() {
          public void onClick(ClickEvent event) {
//        	  Window.alert("qui");
        	  dialogBox.hide();
          }
	    });
		mainPanel.add(closeButton);
		
		dialogBox.add(mainPanel);
		
//	  if (LocaleInfo.getCurrentLocale().isRTL()) {
//		  mainPanel.setCellHorizontalAlignment(
//	          closeButton, HasHorizontalAlignment.ALIGN_LEFT);
//
//	    } else {
//	    	mainPanel.setCellHorizontalAlignment(
//	          closeButton, HasHorizontalAlignment.ALIGN_RIGHT);
//	    }
		return dialogBox;
	}
	*/
	
	
	protected void go(RootPanel rootPanel){
		
//		final DialogBox dialogBox = getDialogBoxTemplatePanel();
		final Window dialogBox = getWindowTemplatePanel();
		com.google.gwt.user.client.ui.Button openTemplateCreator = new com.google.gwt.user.client.ui.Button("Open Template Creator", new ClickHandler() {
	          public void onClick(ClickEvent event) {
	        	 
	 
	              dialogBox.show();
//	              dialogBox.center();
	          }
		    });
		rootPanel.add(openTemplateCreator);
	}

	public static EventBus getCommonBus() {
		return commonBus;
	}

}
