/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client.template.view;

import org.gcube.portlets.user.tdtemplate.client.resources.TdTemplateAbstractResources;

import com.extjs.gxt.ui.client.widget.Html;
import com.google.gwt.user.client.ui.AbstractImagePrototype;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Feb 5, 2014
 * 
 */
public class SuggestionLabel {

	String html;

	AbstractImagePrototype image = TdTemplateAbstractResources.suggest();

	public SuggestionLabel(String caption, String text, String subText, AbstractImagePrototype img) {
		createHtml(caption, text, subText, img);

	}
	
	public SuggestionLabel(String caption, String text, String subText) {
		createHtml(caption, text, subText, image);
	}
	
	private void createHtml(String label, String text, String subText, AbstractImagePrototype img){
		
		html = "<div class=\"suggestionLabel\">"
				+ "<p style=\"display: inline-block; vertical-align: middle; \" >"
				+ img.getHTML()
				+ "</p>"
				+ "<p style=\"padding-left: 5px; display: inline-block; vertical-align: middle;\" >"
				+ label + "</p>"
				+ "<span style=\"padding-left: 5px; vertical-align: middle;\">"
				+ text + "</span>";
		
		if(subText!=null && !subText.isEmpty()){
			
			html+="<br><span style=\"padding-left: 5px; vertical-align: middle; font-size: 9px;\">"
					+ subText + "</span>";
		}
		
		html+="</div>";
	}

	public Html getHtml() {
		return new Html(html);

	}

	public String getHtmlToString() {
		return html;

	}
}
