/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.server.service;

import java.util.List;

import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Template;
import org.gcube.data.analysis.tabulardata.commons.templates.model.TemplateCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.commons.utils.DimensionReference;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.OnRowErrorAction;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.GeometryType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.impl.TabularDataServiceFactory;
import org.gcube.data.analysis.tabulardata.service.template.TemplateId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;



/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Feb 6, 2014
 *
 */
public class TemplateService {
	
	private TabularDataService service;
	private String scope;
	
	public static Logger logger = LoggerFactory.getLogger(TemplateService.class);
	
	public static TemplateColumn<? extends DataType> createTemplateColumn(ColumnCategory columnType, Class<? extends DataType> valueType){
		
		

		 if(valueType.isAssignableFrom(NumericType.class)){
			 return new TemplateColumn<NumericType>(columnType, NumericType.class);
		 }else if(valueType.isAssignableFrom(TextType.class)){
			 return new TemplateColumn<TextType>(columnType, TextType.class);
		 } else if (valueType.isAssignableFrom(IntegerType.class)){
			 return new TemplateColumn<IntegerType>(columnType, IntegerType.class);
		 } else if (valueType.isAssignableFrom(BooleanType.class)){
			 return new TemplateColumn<BooleanType>(columnType, BooleanType.class);
		 } else if (valueType.isAssignableFrom(DateType.class)){
			 return new TemplateColumn<DateType>(columnType, DateType.class);
		 } else if (valueType.isAssignableFrom(GeometryType.class)){
			 return new TemplateColumn<GeometryType>(columnType, GeometryType.class);
		 }
		 
		 return null;
	}
	
	
	public static TemplateColumn<? extends DataType> createTemplateColumnForDimension(ColumnCategory columnType, Class<? extends DataType> valueType, int tableId, String columnId){
		
//		TemplateColumn<IntegerType> dimColumn = new TemplateColumn<IntegerType>(ColumnCategory.DIMENSION, IntegerType.class, new DimensionReference(new TableId(32), new ColumnLocalId("columnId")));

		 if(valueType.isAssignableFrom(NumericType.class)){
			 return new TemplateColumn<NumericType>(columnType, NumericType.class, new DimensionReference(new TableId(tableId), new ColumnLocalId(columnId)));
		 }else if(valueType.isAssignableFrom(TextType.class)){
			 return new TemplateColumn<TextType>(columnType, TextType.class,new DimensionReference(new TableId(tableId), new ColumnLocalId(columnId)));
		 } else if (valueType.isAssignableFrom(IntegerType.class)){
			 return new TemplateColumn<IntegerType>(columnType, IntegerType.class, new DimensionReference(new TableId(tableId), new ColumnLocalId(columnId)));
		 } else if (valueType.isAssignableFrom(BooleanType.class)){
			 return new TemplateColumn<BooleanType>(columnType, BooleanType.class,new DimensionReference(new TableId(tableId), new ColumnLocalId(columnId)));
		 } else if (valueType.isAssignableFrom(DateType.class)){
			 return new TemplateColumn<DateType>(columnType, DateType.class,new DimensionReference(new TableId(tableId), new ColumnLocalId(columnId)));
		 } else if (valueType.isAssignableFrom(GeometryType.class)){
			 return new TemplateColumn<GeometryType>(columnType, GeometryType.class,new DimensionReference(new TableId(tableId), new ColumnLocalId(columnId)));
		 }
		 
		 return null;
	}
	
	public static TemplateColumn<? extends DataType> createTemplateColumnForTimeDimension(ColumnCategory columnType, Class<? extends DataType> valueType, int tableId, String columnId){
		
		 return null;
	}
	
	public static Template generateTemplate(TemplateCategory templateCategory, List<TemplateColumn<? extends DataType>> columns, OnRowErrorAction onErrorAction){
		
//		TemplateColumn<? extends DataType>[] cms = new TemplateColumn<? extends DataType>[2];
		
		TemplateColumn<?>[] cms = columns.toArray(new TemplateColumn<?>[columns.size()]);
		
		Template template = Template.create(templateCategory, cms);
		
		if(onErrorAction!=null)
			template.setOnErrorAction(onErrorAction);

		return template;
	}
	
	public TemplateService(String scope){
		this.scope = scope;
		service = TabularDataServiceFactory.getService();
	}
	
	public TemplateId saveTemplate(String name, String description, String agency, Template template) throws Exception{
		try{
			ScopeProvider.instance.set(scope);
			logger.info("Saving template with parameter: name: "+ name+", description: "+ description+", agency: "+ template+", template: "+ template);
			return service.saveTemplate(name, description, agency, template);
		}catch (Exception e) {
			throw new Exception("Sorry, an error occurred on saving the template ",e);
		}
	}


	public TabularDataService getService() {
		return service;
	}
}
