/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.shared;

import java.io.Serializable;

import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Feb 5, 2014
 * 
 */
public class TdColumnDefinition implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 257447065800064772L;
	
	private int index;
	private TdTColumnCategory category;
	private TdTDataType dataType;

	private C_Expression ruleExpression;

	private SPECIAL_CATEGORY_TYPE specialCategoryType;

	private ColumnData columnData;

	
	/**
	 * 
	 */
	public TdColumnDefinition() {
	}
	/**
	 * @param index
	 * @param category
	 * @param dataType
	 */
	public TdColumnDefinition(int index, TdTColumnCategory category, TdTDataType dataType, C_Expression expr, SPECIAL_CATEGORY_TYPE type) {
		super();
		this.index = index;
		this.category = category;
		this.dataType = dataType;
		this.ruleExpression = expr;
		this.specialCategoryType = type;
	}
	
	/**
	 * @param index
	 * @param category
	 * @param dataType
	 */
	public TdColumnDefinition(int index, TdTColumnCategory category, TdTDataType dataType, SPECIAL_CATEGORY_TYPE type, ColumnData columnData) {
		super();
		this.index = index;
		this.category = category;
		this.dataType = dataType;
		this.specialCategoryType = type;
		this.columnData = columnData;
	}

	public int getIndex() {
		return index;
	}

	public TdTColumnCategory getCategory() {
		return category;
	}

	public TdTDataType getDataType() {
		return dataType;
	}

	public void setIndex(int index) {
		this.index = index;
	}

	public void setCategory(TdTColumnCategory category) {
		this.category = category;
	}

	public void setDataType(TdTDataType dataType) {
		this.dataType = dataType;
	}

	public C_Expression getRuleExpression() {
		return ruleExpression;
	}
	public void setRuleExpression(C_Expression ruleExpression) {
		this.ruleExpression = ruleExpression;
	}

	public SPECIAL_CATEGORY_TYPE getSpecialCategoryType() {
		return specialCategoryType;
	}

	public ColumnData getColumnData() {
		return columnData;
	}
	
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("TdColumnDefinition [index=");
		builder.append(index);
		builder.append(", category=");
		builder.append(category);
		builder.append(", dataType=");
		builder.append(dataType);
		builder.append(", ruleExpression=");
		builder.append(ruleExpression);
		builder.append(", specialCategoryType=");
		builder.append(specialCategoryType);
		builder.append(", columnData=");
		builder.append(columnData);
		builder.append("]");
		return builder.toString();
	}

}
