/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client.template;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.tdtemplate.client.TdTemplateController;
import org.gcube.portlets.user.tdtemplate.client.template.view.BaloonPanel;
import org.gcube.portlets.user.tdtemplate.client.template.view.external.DialogCodelistResolver;
import org.gcube.portlets.user.tdtemplate.shared.SPECIAL_CATEGORY_TYPE;
import org.gcube.portlets.user.tdtemplate.shared.TdTColumnCategory;
import org.gcube.portlets.user.tdtemplate.shared.TdTDataType;

import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.form.ComboBox.TriggerAction;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.client.Style.BorderStyle;
import com.google.gwt.dom.client.Style.Unit;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jan 30, 2014
 *
 */
public class SetColumnTypeDialogManager {
	

	private SimpleComboBox<String> scbCategory = new SimpleComboBox<String>();
	
	private SimpleComboBox<String> scbDataType = new SimpleComboBox<String>();
	
	private SimpleComboBox<String> scbReference = new SimpleComboBox<String>();
	
	private List<TdTColumnCategory> listCategory;
	
	private SetTypeColumnContainer typingContainer;
	
	private SetColumnTypeDialogManager INSTANCE = this;
	
	private List<ColumnData> lsColumnData = null;
	
	private BaloonPanel baloon;
	
	private DialogCodelistResolver resolver;
	
	/**
	 * 
	 */
	public SetColumnTypeDialogManager(List<TdTColumnCategory> columnCategories) {
		this.listCategory = columnCategories;
		scbDataType.setEnabled(false);
		initComboSetCategory();
	
		scbCategory.addSelectionChangedListener(new SelectionChangedListener<SimpleComboValue<String>>() {
					
			@Override
			public void selectionChanged(SelectionChangedEvent<SimpleComboValue<String>> se) {
				
				scbDataType.reset();
				scbReference.reset();
				
				if(scbCategory.getSimpleValue().compareToIgnoreCase(SPECIAL_CATEGORY_TYPE.DIMENSION.getLabel())==0){
//						Window.alert("Dimension");
					scbDataType.setEnabled(true);
					categoryDimensionHandler();
//					selectDataType();
				}else if(scbCategory.getSimpleValue().compareToIgnoreCase(SPECIAL_CATEGORY_TYPE.TIMEDIMENSION.getLabel())==0){
//					Window.alert("Dimension");
					scbDataType.setEnabled(true);
					categoryTimeDimensionHandler();
				}else{ //NORMAL BEHAVIOUR
					typingContainer.removeCombo(scbReference);
//					selectDataType();
				}
				
				selectDataType();
				
//				scbDataType.reset();
	
			}	
		});
		
		
		scbDataType.addSelectionChangedListener(new SelectionChangedListener<SimpleComboValue<String>>() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent<SimpleComboValue<String>> se) {
					
			}
		});
		
		scbReference.addSelectionChangedListener(new SelectionChangedListener<SimpleComboValue<String>>() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent<SimpleComboValue<String>> se) {
				
				scbReference.getElement().getStyle().setBorderWidth(0, Unit.PX);
				if(baloon!=null)
					baloon.hide();
//				scbDataType.getElement().getStyle().setBorderStyle(BorderStyle.SOLID);
//				scbDataType.getElement().getStyle().setBorderWidth(1.0, Unit.PX);
				
			}
		});
		
		
		typingContainer = new SetTypeColumnContainer(scbCategory, scbDataType);

	}
	
	private void selectDataType(){
		
		for (TdTColumnCategory category : listCategory) {
			if(scbCategory.getSimpleValue().compareTo(category.getName())==0){
				scbDataType.setEnabled(true);
				initComboSetDataType(category);
			}
				
		}
	}
	
	private void initComboSetCategory() {

		List<String> ls = new ArrayList<String>();

		for (TdTColumnCategory category : listCategory)
			ls.add(category.getName());

		scbCategory = new SimpleComboBox<String>();
		scbCategory.setFieldLabel("Category *");
		scbCategory.setTypeAhead(true);
		scbCategory.setEditable(false);
		scbCategory.setEmptyText("Categorize");
		scbCategory.setTriggerAction(TriggerAction.ALL);
		scbCategory.add(ls);
	}
	
	private void categoryDimensionHandler(){
		
		scbReference.removeAll();
		
		typingContainer.addCombo(scbReference);
		scbReference.removeAll();
		scbReference.setEditable(false);
		scbReference.setEmptyText("Choose Reference");
		
		scbReference.addListener(Events.OnClick,listenerDimension);
	}
	
	private void categoryTimeDimensionHandler(){
		
		scbReference.removeAll();
		
		scbReference.removeAll();
		scbReference.setEditable(false);
		scbReference.setEmptyText("Choose Reference");
		
		scbReference.addListener(Events.OnClick,listenerDimension);
	}
	
	Listener<BaseEvent> listenerDimension = new Listener<BaseEvent>() {

		@Override
		public void handleEvent(BaseEvent be) {
			if(scbCategory.getSimpleValue().compareToIgnoreCase(SPECIAL_CATEGORY_TYPE.DIMENSION.getLabel())==0){
//				scbDataType.mask("Loading");
				resolver = new DialogCodelistResolver(INSTANCE);
				resolver.show();
				
			/*	baloon = new BaloonPanel("Choose Column Reference", false);

				int zIndex = TdTemplateController.getWindowZIndex();
				int zi = zIndex+1;
//				baloon.getElement().setAttribute("z-index", zi+"");
				baloon.getElement().getStyle().setZIndex(zi);
				baloon.showRelativeTo(scbReference);*/
				
//				scbDataType.unmask();
//				System.out.println("boolean : "+baloon.isShowing());
			}else if(scbCategory.getSimpleValue().compareToIgnoreCase(SPECIAL_CATEGORY_TYPE.TIMEDIMENSION.getLabel())==0){
//				DialogCodelistResolver resolver = new DialogCodelistResolver(INSTANCE);
			}
		}
	};
	
	public void initComboSetReference(List<ColumnData> columnReference) {
		
		scbReference.removeAll();
		
		scbReference.getElement().getStyle().setBorderColor("#EE2C2C");
		scbReference.getElement().getStyle().setBorderStyle(BorderStyle.SOLID);
		scbReference.getElement().getStyle().setBorderWidth(1.0, Unit.PX);
		
	
		baloon = new BaloonPanel("Choose Column Reference", false);

		int zIndex = TdTemplateController.getWindowZIndex();
		int zi = zIndex+1;
//		baloon.getElement().setAttribute("z-index", zi+"");
		baloon.getElement().getStyle().setZIndex(zi);
		baloon.showRelativeTo(scbReference);
		
		scbReference.removeListener(Events.OnClick, listenerDimension);
		
		lsColumnData = new ArrayList<ColumnData>(columnReference.size());

		for (ColumnData col : columnReference){
			GWT.log("Adding reference id: "+col.getId()+col.getLabel());
			scbReference.setData(col.getId()+col.getLabel(), col);
			lsColumnData.add(col);
		}

		scbReference.setFieldLabel("Data type *");
		scbReference.setTypeAhead(true);
		scbReference.setEditable(false);
		scbReference.setEmptyText("Choose data type");
		scbReference.setTriggerAction(TriggerAction.ALL);
		
		for (ColumnData columnData : columnReference) {
			scbReference.add(columnData.getLabel());
		}
		

	}
	
	private void initComboSetDataType(TdTColumnCategory category) {
		
		scbDataType.removeAll();
		
		scbDataType.removeListener(Events.OnClick, listenerDimension);
		
		List<String> ls = new ArrayList<String>();

		for (TdTDataType tdDataType : category.getTdtDataType())
			ls.add(tdDataType.getName());

		scbDataType.setFieldLabel("Data type *");
		scbDataType.setTypeAhead(true);
		scbDataType.setEditable(false);
		scbDataType.setEmptyText("Choose data type");
		scbDataType.setTriggerAction(TriggerAction.ALL);
		scbDataType.add(ls);
		
	}

//	public SetTypeColumnDialog getDialog() {
//		return dialog;
//	}
	
	public TdTColumnCategory getCategorySelected(){
		
		for (TdTColumnCategory category : listCategory) {
			if(scbCategory.getSimpleValue().compareTo(category.getName())==0){
				return category;
			}
				
		}
		return null;
	}
	
	public TdTDataType getDataTypeSelected(){
		
		TdTColumnCategory category = getCategorySelected();
		
		if(category==null)
			return null;
		
		for (TdTDataType tdDataType : category.getTdtDataType()){
			if(scbDataType.getSimpleValue().compareTo(tdDataType.getName())==0){
				return tdDataType;
			}
				
		}
		
		return null;
	}
	
	public ColumnData getReferenceSelected(){

		if(scbReference.getSimpleValue()!=null && lsColumnData!=null){
			for (ColumnData columnData : lsColumnData) {
				String columnId =  columnData.getId()+scbReference.getSimpleValue();
				GWT.log("Trying fetch reference id: "+columnId);
				ColumnData refernceSelected = scbReference.getData(columnId);
				if(refernceSelected!=null){
					GWT.log("Returning reference: "+refernceSelected);
					return refernceSelected;
				}
			}
		}
		return null;
	}
	

	public SimpleComboBox<String> getScbCategory() {
		return scbCategory;
	}

	public SimpleComboBox<String> getScbDataType() {
		return scbDataType;
	}
	
	public SimpleComboBox<String> getScbReference() {
		return scbReference;
	}

	public SetTypeColumnContainer getTypingContainer() {
		return typingContainer;
	}
	
	public TabResource getReferenceTabularResource(){
		return resolver.getTabularResourceSelected();
	}
}
