package org.gcube.portlets.user.tdtemplate.client.rpc;

import java.util.List;

import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.tdtemplate.shared.TdColumnDefinition;
import org.gcube.portlets.user.tdtemplate.shared.TdTColumnCategory;
import org.gcube.portlets.user.tdtemplate.shared.TdTTemplateType;
import org.gcube.portlets.user.tdtemplate.shared.TemplateDefinition;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * The client side stub for the RPC service.
 */
@RemoteServiceRelativePath("tdtemplate")
public interface TdTemplateService extends RemoteService {

	/**
	 * @return
	 */
	List<TdTTemplateType> getTemplateTypes();

	List<TdTColumnCategory> getColumnCategoryByTemplateId(TemplateDefinition def) throws Exception;

	/**
	 * @param listColumns
	 * @return 
	 * @throws Exception
	 */
	boolean submitTemplate(List<TdColumnDefinition> listColumns) throws Exception;

	/**
	 * @return
	 */
	List<String> getOnErrorValues();

	/**
	 * @param type
	 * @return
	 */
	String getConstraintForTemplateType(TdTTemplateType type);

	/**
	 * @param trId
	 * @return
	 * @throws Exception
	 */
	List<ColumnData> resolveColumnForDimension(TRId trId) throws Exception;

  
}
