/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client.template;

import java.util.List;

import org.gcube.portlets.user.tdtemplate.client.TdTemplateController;
import org.gcube.portlets.user.tdtemplate.client.template.view.TemplateSwitcherInteface;
import org.gcube.portlets.user.tdtemplate.shared.TdTColumnCategory;
import org.gcube.portlets.user.tdtemplate.shared.TemplateDefinition;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jan 29, 2014
 * 
 */
public abstract class SetColumnTypeDefinition {

	private TemplateSwitcherInteface templateSwitcherInteface;
	private List<TdTColumnCategory> listCategory;
	
	
	public abstract void updateListCategory();
	

	/**
	 * 
	 * @param templateType
	 *            is template category
	 */
	public SetColumnTypeDefinition(TemplateSwitcherInteface templateSwitcherInteface) {
		this.templateSwitcherInteface = templateSwitcherInteface;
		
		TemplateDefinition def = new TemplateDefinition(templateSwitcherInteface.getName(), templateSwitcherInteface.getDescription(), templateSwitcherInteface.getType(), templateSwitcherInteface.getAgency(), templateSwitcherInteface.getOnError());
		
		GWT.log("Template definition is : "+def);
		
		TdTemplateController.tdTemplateServiceAsync.getColumnCategoryByTemplateId(def,new AsyncCallback<List<TdTColumnCategory>>() {

			@Override
			public void onSuccess(List<TdTColumnCategory> result) {

				System.out.println("result "+result);
				if (result != null){
					listCategory = result;
					updateListCategory();
				}
				

			}

			@Override
			public void onFailure(Throwable caught) {
				caught.printStackTrace();
				//TODO

			}
		});
	}


	public String getTemplateType() {
		return templateSwitcherInteface.getType();
	}


	public List<TdTColumnCategory> getListCategory() {
		return listCategory;
	}

}
