/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client.template.view;

import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_ExpressionContainer;
import org.gcube.portlets.user.tdtemplate.client.TdTemplateConstants;
import org.gcube.portlets.user.tdtemplate.client.TdTemplateController;
import org.gcube.portlets.user.tdtemplate.client.event.ExpressionDialogOpenedEvent;
import org.gcube.portlets.user.tdtemplate.client.resources.TdTemplateAbstractResources;
import org.gcube.portlets.user.tdtemplate.client.template.ColumnDefinition;
import org.gcube.portlets.user.tdtemplate.client.template.SetColumnTypeDialogManager;
import org.gcube.portlets.user.tdtemplate.client.template.smart.SmartAddRuleButton;
import org.gcube.portlets.user.tdtemplate.client.template.smart.SmartButtonDescription;
import org.gcube.portlets.user.tdtemplate.client.template.view.external.ExpressionDialogMng;
import org.gcube.portlets.user.tdtemplate.shared.SPECIAL_CATEGORY_TYPE;
import org.gcube.portlets.user.tdtemplate.shared.TdTColumnCategory;
import org.gcube.portlets.user.tdtemplate.shared.TdTDataType;

import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Label;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jan 16, 2014
 *
 */
public class ColumnDefinitionView implements ColumnDefinition{
	
	private int columnIndex;
	private Text columnHeaderValue = new Text();
	private boolean isValid = false;
	
	private Label columnDescription = new Label("Not defined");
	private SetColumnTypeDialogManager setColumnTypeDialogManager;
	private TemplatePanel templatePanel;
	
	private ColumnDefinitionView INSTANCE = this;
	
	private SmartAddRuleButton buttonSmartAddRule = new SmartAddRuleButton();
	private ExpressionDialogMng expressionDialogMng;
	private C_ExpressionContainer ruleExpression = null;
	private SPECIAL_CATEGORY_TYPE selectedCategoryType = SPECIAL_CATEGORY_TYPE.NONE;
	
	
	/**
	 * @param templatePanel 
	 * @param setColumnTypeDialogManager 
	 * @param setColumnTypeDefinition 
	 * 
	 */
	public ColumnDefinitionView(TemplatePanel templatePanel, int index, SetColumnTypeDialogManager setColumnTypeDialogManager) {
		this.templatePanel = templatePanel;
		this.setColumnTypeDialogManager = setColumnTypeDialogManager;
		columnHeaderValue = new Text("Column "+(index+1));
		columnIndex = index;
		initListners();
		setCommandAddRule();
	}

	/**
	 * 
	 */
	private void initListners() {
		
		setColumnTypeDialogManager.getScbCategory().addSelectionChangedListener(new SelectionChangedListener<SimpleComboValue<String>>() {
			
			

			@Override
			public void selectionChanged(SelectionChangedEvent<SimpleComboValue<String>> se) {
				
				setIsValid(false);
				templatePanel.clearCell(2, columnIndex); //REOMVE ADD RULE IF EXISTS
//				templatePanel.clearCell(3, columnIndex); //REOMVE DESCRIPTION ROW IF EXISTS
				resetRule();
				
				if(setColumnTypeDialogManager.getCategorySelected().getName().compareTo(SPECIAL_CATEGORY_TYPE.DIMENSION.getLabel())==0){
					setSpecialCategoryType(SPECIAL_CATEGORY_TYPE.DIMENSION);
				}else if(setColumnTypeDialogManager.getCategorySelected().getName().compareTo(SPECIAL_CATEGORY_TYPE.TIMEDIMENSION.getLabel())==0){
					setSpecialCategoryType(SPECIAL_CATEGORY_TYPE.TIMEDIMENSION);
				}else{ 
					setSpecialCategoryType(SPECIAL_CATEGORY_TYPE.NONE);
				}
				
				templatePanel.validateTemplate();
			}
		});
		
		setColumnTypeDialogManager.getScbDataType().addSelectionChangedListener(new SelectionChangedListener<SimpleComboValue<String>>() {
			

			@Override
			public void selectionChanged(SelectionChangedEvent<SimpleComboValue<String>> se) {
				
				boolean validating = setColumnTypeDialogManager.getDataTypeSelected()!=null?true:false;
				if(setColumnTypeDialogManager.getCategorySelected().getName().compareTo(SPECIAL_CATEGORY_TYPE.DIMENSION.getLabel())==0){
					validating = setColumnTypeDialogManager.getReferenceSelected()!=null?true:false;
					templatePanel.setWidgetIntoTable(2, columnIndex, new Html("Choose Reference"));
				}else if(setColumnTypeDialogManager.getCategorySelected().getName().compareTo(SPECIAL_CATEGORY_TYPE.TIMEDIMENSION.getLabel())==0){
					validating = setColumnTypeDialogManager.getDataTypeSelected()!=null?true:false;
//					templatePanel.removeCells(2, columnIndex);
				}else{ //NORMAL BEHAVIOUR
					buttonSmartAddRule.update("Rule", TdTemplateAbstractResources.dataType());
					templatePanel.setWidgetIntoTable(2, columnIndex, buttonSmartAddRule);
					validating = setColumnTypeDialogManager.getDataTypeSelected()!=null?true:false;
				}
				
				setIsValid(validating);
				templatePanel.validateTemplate();
			}
		});
		
		setColumnTypeDialogManager.getScbReference().addSelectionChangedListener(new SelectionChangedListener<SimpleComboValue<String>>() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent<SimpleComboValue<String>> se) {
				

				boolean validating = setColumnTypeDialogManager.getDataTypeSelected()!=null?true:false;
				if(setColumnTypeDialogManager.getCategorySelected().getName().compareTo(SPECIAL_CATEGORY_TYPE.DIMENSION.getLabel())==0){
					ColumnData sel = setColumnTypeDialogManager.getReferenceSelected();
					validating = sel!=null?true:false;
					if(validating){
//						Html html = new Html("Added reference: "+sel.getName());
//						html.setWidth(TdTemplateConstants.WIDTHWIDGETCOLUMN);
//						templatePanel.setWidgetIntoTable(2, columnIndex,html);
//						
						templatePanel.clearCell(2, columnIndex); //REMOVE Choose Reference
						updateColumnDescription("Added reference:", sel.getLabel(), false);
					}
				}else if(setColumnTypeDialogManager.getCategorySelected().getName().compareTo(SPECIAL_CATEGORY_TYPE.TIMEDIMENSION.getLabel())==0){
//					validating = setColumnTypeDialogManager.getReferenceSelected()!=null?true:false;
//					templatePanel.removeCells(2, columnIndex);
				}
				setIsValid(validating);
				templatePanel.validateTemplate();
			}
		});
		
	}
	
	private void setCommandAddRule(){
		
		buttonSmartAddRule.setCommand(new Command() {
			@Override
			public void execute() {
				
				try {
				
					buttonSmartAddRule.panelMask(true);
					if(expressionDialogMng==null){
						String columnId = "Column "+(columnIndex+1);
						expressionDialogMng = new ExpressionDialogMng(columnId, getSelectedColumnCategory().getId(), getSelectedDataType().getName());
					}
				
					buttonSmartAddRule.panelMask(false);
					
					TdTemplateController.getInternalBus().fireEvent(new ExpressionDialogOpenedEvent(columnIndex));
					
//					updateColumnDescription("testiamo 1234 index i "+columnIndex);
					
					expressionDialogMng.getExpressionDialog().show();

				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});
	}
	
	public void resetRule(){
		templatePanel.clearCell(3, columnIndex); //REMOVE DESCRIPTION RULE
		expressionDialogMng = null; //RESET RULE
	}
	
	public void addRule(C_ExpressionContainer expression){
		this.ruleExpression = expression;
		updateColumnDescription("Added Rule:", ruleExpression.getReadableExpression(), true);
		
	}
	
	public void updateColumnDescription(String title, String descr, boolean isDeletable){
		
		SmartButtonDescription button = new SmartButtonDescription(title, descr, this, isDeletable);
//		SmartHtmlDiv ruleDescription = new SmartHtmlDiv("Added Rule:", descr, null);
		templatePanel.setWidgetIntoTable(3, columnIndex, button);
	}

	public int getColumnIndex() {
		return columnIndex;
	}

	public void setColumnIndex(int columnIndex) {
		this.columnIndex = columnIndex;
	}

	public Label getColumnDescription() {
		return columnDescription;
	}

	public void setColumnDescription(Label columnDescription) {
		this.columnDescription = columnDescription;
	}

	public Text getColumnHeaderValue() {
		return columnHeaderValue;
	}

	public void setColumnHeaderValue(Text columnHeaderValue) {
		this.columnHeaderValue = columnHeaderValue;
	}

	public SetColumnTypeDialogManager getSetColumnTypeViewManager() {
		return setColumnTypeDialogManager;
	}


	@Override
	public String getColumnName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public TdTDataType getSelectedDataType() {
		return setColumnTypeDialogManager.getDataTypeSelected();
	}

	@Override
	public boolean isValid() {
		return isValid;
	}
	
	private void setIsValid(boolean bool){
		isValid = bool;
	}

	@Override
	public String getColumnId() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public TdTColumnCategory getSelectedColumnCategory() {
		return setColumnTypeDialogManager.getCategorySelected();
	}

	public C_ExpressionContainer getRuleExpression() {
		return ruleExpression;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.tdtemplate.client.template.ColumnDefinition#setCategoryType(org.gcube.portlets.user.tdtemplate.shared.CATEGORY_TYPE)
	 */
	@Override
	public void setSpecialCategoryType(SPECIAL_CATEGORY_TYPE category) {
		this.selectedCategoryType = category;
		
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.tdtemplate.client.template.ColumnDefinition#getCategoryType()
	 */
	@Override
	public SPECIAL_CATEGORY_TYPE getSpecialCategoryType() {
		return this.selectedCategoryType;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.tdtemplate.client.template.ColumnDefinition#getColumnData()
	 */
	@Override
	public ColumnData getReferenceColumnData() {
		return setColumnTypeDialogManager.getReferenceSelected();
	}

}
