/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.server.converter;

import java.util.ArrayList;
import java.util.List;

import org.gcube.data.analysis.tabulardata.commons.templates.model.TemplateCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.OnRowErrorAction;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.portlets.user.tdtemplate.shared.TdTColumnCategory;
import org.gcube.portlets.user.tdtemplate.shared.TdTDataType;
import org.gcube.portlets.user.tdtemplate.shared.TdTTemplateType;
import org.gcube.portlets.user.tdtemplate.shared.util.CutStringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jan 17, 2014
 *
 */
public class ConverterToTdTemplateModel {
	
	
	public static Logger logger = LoggerFactory.getLogger(ConverterToTdTemplateModel.class);
	

	/**
	 * 
	 * @return
	 */
	public static List<TdTTemplateType> getTdTTemplateTypeFromTemplateCategoryValues(){
		
		List<TdTTemplateType> templates = new ArrayList<TdTTemplateType>(TemplateCategory.values().length);
		for (TemplateCategory template : TemplateCategory.values()) {
			
			String constraint = getTemplateCategoryConstraint(template);
			templates.add(new TdTTemplateType(template.name(), template.name(), constraint));
		}
		
		logger.trace("Returning "+templates.size()+" template types");
		
		return templates;
		
	}
	
	public static String getTemplateCategoryConstraint(TemplateCategory cat) {

		switch (cat) {
		
			case CODELIST: return "A Codelist must have one (and only one) Code column";
	
			case DATASET: return "A Dataset must have at least one dimension (reference to a CodeList) and at least one value column";
			
			case GENERIC: return "";
			
			default: return "";
		}

	}
	
	
	/**
	 * 
	 * @return
	 */
	public static List<String> getOnErrorValues(){
		
		List<String> onErrors = new ArrayList<String>(OnRowErrorAction.values().length);
		for (OnRowErrorAction error : OnRowErrorAction.values()) {
			onErrors.add(error.toString());
		}
		
		logger.trace("Returning "+onErrors.size()+" on errors types");
		return onErrors;
	}
	
	/**
	 * 
	 * @return
	 * @throws Exception 
	 */
	public static List<TdTColumnCategory> getTdTColumnCategoryFromTemplateCategory(TemplateCategory template) throws Exception{
		
		if(template==null)
			throw new Exception("TemplateCategory is null");
		
		List<ColumnCategory> listColumns = template.getAllowedColumn();
		if(listColumns==null)
			throw new Exception("ColumnCategory allowed columns is null for template "+template);
		
		
		List<TdTColumnCategory> columns = new ArrayList<TdTColumnCategory>(listColumns.size());
		for (ColumnCategory  col: listColumns) {
			List<Class<? extends DataType>> dataTypes = col.getAllowedClasses();
			TdTColumnCategory tdtCC = new TdTColumnCategory(col.name(), col.name());
			tdtCC.setTdtDataType(getTdTDataTypeFromDataType(dataTypes));
			columns.add(tdtCC);
		}
		
		logger.trace("Returning "+columns.size()+" ColumnCategory");
		
		return columns;
		
	}
	
	public static List<TdTDataType> getTdTDataTypeFromDataType(List<Class<? extends DataType>> dataTypes) throws Exception{
		
		List<TdTDataType> listTdTDataType  = new ArrayList<TdTDataType>();
		
		if(dataTypes==null)
			throw new Exception("List of data type is null");
		
		
		for (Class<? extends DataType> class1 : dataTypes) {
			
//			if(class1.isAssignableFrom(TextType.class)){
//				
//				System.out.println("class get name: "+ ((TextType.class).getName()));
//				System.out.println("name: "+ (class1.getName()));
//			}
			
			String purgedSimpleName = CutStringUtil.stringPurgeSuffix(class1.getSimpleName(), "Type");
	
			listTdTDataType.add(new TdTDataType(class1.getName(), purgedSimpleName));
//			System.out.println("\t \t DataType: "+class1 + " simpleName: " +class1.getSimpleName());
			logger.info("\t \t DataType: "+class1 + " purged simple name: " +purgedSimpleName);
			
		}
		
		logger.trace("Returning "+listTdTDataType.size()+" TdTDataType");
		
		return listTdTDataType;
	}
	
	public List<String> getOnErrorActions(){
		//TODO
		return null;
	}


}
