/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client.template.view;

import org.gcube.portlets.user.tdtemplate.client.resources.TdTemplateAbstractImage;
import org.gcube.portlets.user.tdtemplate.client.template.ColumnDefinition;
import org.gcube.portlets.user.tdtemplate.client.template.SetColumnTypeDialogManager;
import org.gcube.portlets.user.tdtemplate.client.template.smart.SmartPanelButton;
import org.gcube.portlets.user.tdtemplate.shared.TdTColumnCategory;
import org.gcube.portlets.user.tdtemplate.shared.TdTDataType;

import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.google.gwt.user.client.ui.Label;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jan 16, 2014
 *
 */
public class ColumnDefinitionView implements ColumnDefinition{
	
	private int columnIndex;
	private Text columnHeaderValue = new Text();
	private boolean isValid = false;
	
	private Label columnDescription = new Label("Not defined");
	private SetColumnTypeDialogManager setColumnTypeDialogManager;
	private TemplatePanel templatePanel;
	private ColumnDefinitionView INSTANCE = this;
	
	
	/**
	 * @param templatePanel 
	 * @param setColumnTypeDialogManager 
	 * @param setColumnTypeDefinition 
	 * 
	 */
	public ColumnDefinitionView(TemplatePanel templatePanel, int index, SetColumnTypeDialogManager setColumnTypeDialogManager) {
		this.templatePanel = templatePanel;
		this.setColumnTypeDialogManager = setColumnTypeDialogManager;
		columnHeaderValue = new Text("Column "+(index+1));
		columnIndex = index;
		initListners();
	}

	/**
	 * 
	 */
	private void initListners() {
		
		setColumnTypeDialogManager.getScbDataType().addSelectionChangedListener(new SelectionChangedListener<SimpleComboValue<String>>() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent<SimpleComboValue<String>> se) {
				
				
				templatePanel.setWidgetIntoTable(2, columnIndex, new SmartPanelButton("Add Rule", TdTemplateAbstractImage.dataType()));
//				templatePanel.setWidgetIntoTable(3, columnIndex, new SmartTable(INSTANCE, TdTemplateAbstractImage.dataType(), true));
				setIsValid(true);
				
				templatePanel.validateTemplate();
			}
		});
	}

	public int getColumnIndex() {
		return columnIndex;
	}

	public void setColumnIndex(int columnIndex) {
		this.columnIndex = columnIndex;
	}

	public Label getColumnDescription() {
		return columnDescription;
	}

	public void setColumnDescription(Label columnDescription) {
		this.columnDescription = columnDescription;
	}

	public Text getColumnHeaderValue() {
		return columnHeaderValue;
	}

	public void setColumnHeaderValue(Text columnHeaderValue) {
		this.columnHeaderValue = columnHeaderValue;
	}

	public SetColumnTypeDialogManager getSetColumnTypeViewManager() {
		return setColumnTypeDialogManager;
	}


	@Override
	public String getColumnName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public TdTDataType getSelectedDataType() {
		return setColumnTypeDialogManager.getDataTypeSelected();
	}

	@Override
	public boolean isValid() {
		return isValid;
	}
	
	private void setIsValid(boolean bool){
		isValid = bool;
	}

	@Override
	public String getColumnId() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public TdTColumnCategory getSelectedColumnCategory() {
		return setColumnTypeDialogManager.getCategorySelected();
	}

}
