/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client.template;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.tdtemplate.shared.TdTColumnCategory;
import org.gcube.portlets.user.tdtemplate.shared.TdTDataType;

import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.form.ComboBox.TriggerAction;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jan 30, 2014
 *
 */
public class SetColumnTypeDialogManager {
	

	private SimpleComboBox<String> scbCategory = new SimpleComboBox<String>();
	
	private SimpleComboBox<String> scbDataType = new SimpleComboBox<String>();
	
	private List<TdTColumnCategory> listCategory;
	
	private SetTypeColumnContainer typingContainer;
	/**
	 * 
	 */
	public SetColumnTypeDialogManager(List<TdTColumnCategory> columnCategories) {
		this.listCategory = columnCategories;
		scbDataType.setEnabled(false);
		initComboSetCategory();
	
		scbCategory.addSelectionChangedListener(new SelectionChangedListener<SimpleComboValue<String>>() {
					
			@Override
			public void selectionChanged(SelectionChangedEvent<SimpleComboValue<String>> se) {
				
				for (TdTColumnCategory category : listCategory) {
					if(scbCategory.getSimpleValue().compareTo(category.getName())==0){
						scbDataType.setEnabled(true);
						initComboSetDataType(category);
					}
						
				}
			}
		});
		
		
		scbDataType.addSelectionChangedListener(new SelectionChangedListener<SimpleComboValue<String>>() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent<SimpleComboValue<String>> se) {
				
//				SimpleComboValue<String> t = se.getSelectedItem().getValue();
				
			}
		});
		
		typingContainer = new SetTypeColumnContainer(scbCategory, scbDataType);

	}
	
	private void initComboSetCategory() {

		List<String> ls = new ArrayList<String>();

		for (TdTColumnCategory category : listCategory)
			ls.add(category.getName());

		scbCategory = new SimpleComboBox<String>();
		scbCategory.setFieldLabel("Category *");
		scbCategory.setTypeAhead(true);
		scbCategory.setEditable(false);
		scbCategory.setEmptyText("Categorize");
		scbCategory.setTriggerAction(TriggerAction.ALL);
		scbCategory.add(ls);
	}
	
	
	private void initComboSetDataType(TdTColumnCategory category) {
		
		scbDataType.removeAll();
		
		List<String> ls = new ArrayList<String>();

		for (TdTDataType tdDataType : category.getTdtDataType())
			ls.add(tdDataType.getName());

		scbDataType.setFieldLabel("Data type *");
		scbDataType.setTypeAhead(true);
		scbDataType.setEditable(false);
		scbDataType.setEmptyText("Choose data type");
		scbDataType.setTriggerAction(TriggerAction.ALL);
		scbDataType.add(ls);
		
	}

//	public SetTypeColumnDialog getDialog() {
//		return dialog;
//	}
	
	public TdTColumnCategory getCategorySelected(){
		
		for (TdTColumnCategory category : listCategory) {
			if(scbCategory.getSimpleValue().compareTo(category.getName())==0){
				return category;
			}
				
		}
		return null;
	}
	
	public TdTDataType getDataTypeSelected(){
		
		TdTColumnCategory category = getCategorySelected();
		
		if(category==null)
			return null;
		
		for (TdTDataType tdDataType : category.getTdtDataType()){
			if(scbDataType.getSimpleValue().compareTo(tdDataType.getName())==0){
				return tdDataType;
			}
				
		}
		
		return null;
	}

	public SimpleComboBox<String> getScbCategory() {
		return scbCategory;
	}

	public SimpleComboBox<String> getScbDataType() {
		return scbDataType;
	}

	public SetTypeColumnContainer getTypingContainer() {
		return typingContainer;
	}
}
