/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.server.session;

import javax.servlet.http.HttpSession;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.user.tdtemplate.shared.TemplateDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Nov 18, 2013
 *
 */
public class SessionUtil {

	/**
	 * 
	 */
//	protected static final String TDT_TEMPLATE_TYPE = "TDT_TEMPLATE_TYPE";
	protected static final String TDT_TEMPLATE_DEF = "TDT_TEMPLATE_DEF";
	public static Logger logger = LoggerFactory.getLogger(SessionUtil.class);
	
	public static ASLSession getAslSession(HttpSession httpSession)
	{
		String sessionID = httpSession.getId();
		String user = (String) httpSession.getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);

		if (user == null) {

			//for test only
			user = "test.user";
//			user = "lucio.lelii";
//			user = "pasquale.pagano";
//			user = "francesco.mangiacrapa";
			String scope = "/gcube/devsec"; //Development
//			String scope = "/d4science.research-infrastructures.eu/gCubeApps/BiodiversityResearchEnvironment"; //Production
			
			httpSession.setAttribute(ScopeHelper.USERNAME_ATTRIBUTE, user);
			ASLSession session = SessionManager.getInstance().getASLSession(sessionID, user);
			session.setScope(scope);

//			logger.warn("TdTemplateServiceImpl STARTING IN TEST MODE - NO USER FOUND");
//			logger.warn("Created fake Asl session for user "+user + " with scope "+scope);
			
			return session;
		}

		return SessionManager.getInstance().getASLSession(sessionID, user);
	}
	
//	public static void setTemplateType(ASLSession session, String templateType){
//		session.setAttribute(TDT_TEMPLATE_TYPE, templateType);
//	}
	
	public static void setTemplateDefinition(ASLSession session, TemplateDefinition templateType){
		session.setAttribute(TDT_TEMPLATE_DEF, templateType);
	}
	
	
	public static TemplateDefinition getTemplateDefinition(ASLSession session){
		return (TemplateDefinition) session.getAttribute(TDT_TEMPLATE_DEF);
	}
	

}
