package org.gcube.portlets.user.tdtemplate.server;

import java.util.ArrayList;
import java.util.List;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Template;
import org.gcube.data.analysis.tabulardata.commons.templates.model.TemplateCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.OnRowErrorAction;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.service.template.TemplateId;
import org.gcube.portlets.user.tdtemplate.client.rpc.TdTemplateService;
import org.gcube.portlets.user.tdtemplate.server.converter.ConverterToTdTemplateModel;
import org.gcube.portlets.user.tdtemplate.server.converter.ConverterToTemplateServiceModel;
import org.gcube.portlets.user.tdtemplate.server.service.TemplateService;
import org.gcube.portlets.user.tdtemplate.server.session.SessionUtil;
import org.gcube.portlets.user.tdtemplate.shared.TdColumnDefinition;
import org.gcube.portlets.user.tdtemplate.shared.TdTColumnCategory;
import org.gcube.portlets.user.tdtemplate.shared.TdTTemplateType;
import org.gcube.portlets.user.tdtemplate.shared.TemplateDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class TdTemplateServiceImpl extends RemoteServiceServlet implements TdTemplateService {

	public static Logger logger = LoggerFactory.getLogger(TdTemplateServiceImpl.class);
	
//	public TdTemplateGxtObjectBuilder builder = new TdTemplateGxtObjectBuilder();
	/**
	 * 
	 * @return
	 */
	protected ASLSession getASLSession() {
		return SessionUtil.getAslSession(this.getThreadLocalRequest().getSession());
	}
	
	@Override
	public List<TdTColumnCategory> getColumnCategoryByTemplateId(TemplateDefinition templateDefinition) throws Exception{
		
		try{
			
			TemplateCategory tmc = ConverterToTemplateServiceModel.templateCategoryFromTemplateName(templateDefinition.getTemplateType());
			
			logger.trace("Putting template id in ASL session: "+templateDefinition.getTemplateType());
			SessionUtil.setTemplateDefinition(getASLSession(), templateDefinition);
			
			return ConverterToTdTemplateModel.getTdTColumnCategoryFromTemplateCategory(tmc);
		}catch (Exception e) {
			
			throw new Exception("Sorry an error occurred when contacting service, Try again later");
		}
	}
	
	/*
	public List<TdTColumnCategory> getAllowedDataTypeByIds(String templateId, String categoryId) throws Exception{
		
		try{
			TemplateCategory tmc = ConverterToTemplateServiceModel.templateCategoryFromTemplateName(templateId);
			List<TdTColumnCategory> columns =  ConverterToTdTemplateModel.getTdTColumnCategoryFromTemplateCategory(tmc);
		}catch (Exception e) {
			
			throw new Exception("Sorry an error occurred when contacting service, Try again later");
		}
	}*/
	
	
	
	@Override
	public List<TdTTemplateType> getTemplateTypes(){
		return ConverterToTdTemplateModel.getTdTTemplateTypeFromTemplateCategoryValues();
	}
	
	@Override
	public List<String> getOnErrorValues(){
		return ConverterToTdTemplateModel.getOnErrorValues();
	}
	
	
	@Override
	public String getConstraintForTemplateType(TdTTemplateType type){
		
		return "";
	}
	
	
	@Override
	public boolean submitTemplate(List<TdColumnDefinition> listColumns) throws Exception{
		
		try{
			List<TemplateColumn<? extends DataType>> columns = new ArrayList<TemplateColumn<? extends DataType>>();
			
			for (TdColumnDefinition tdColumnDefinition : listColumns) {
				
				logger.trace("Found TdColumnDefinition: "+tdColumnDefinition +", converting");
				
				try{
					ColumnCategory columnType = ConverterToTemplateServiceModel.tdTdTColumnCategoryToColumnCategory(tdColumnDefinition.getCategory());
					Class<? extends DataType> valueType = ConverterToTemplateServiceModel.tdTdTDataTypeToDataType(tdColumnDefinition.getDataType());
			
					TemplateColumn<? extends DataType> col = TemplateService.createTemplateColumn(columnType, valueType);
					logger.trace("TemplateColumn created: "+col);
					columns.add(col);
					
				}catch (Exception e) {
					logger.warn("Conversion of TdColumnDefinition: "+tdColumnDefinition +", generated an exception, skypping");
				}
			}
			
			if(columns.size()>0){
				ASLSession session = getASLSession();
				TemplateDefinition templateDef = SessionUtil.getTemplateDefinition(session);
				
				logger.trace("Retrieve template defitnition from ASL session: "+templateDef);
				
				TemplateCategory tmc = ConverterToTemplateServiceModel.templateCategoryFromTemplateName(templateDef.getTemplateType());
				logger.trace("Converted in template category: "+tmc);
				
				
				// ON ROW ERROR ACTION
				OnRowErrorAction error = null;
				
				try{
					error = ConverterToTemplateServiceModel.onRowErrorAction(templateDef.getOnError());
				}catch (Exception e) {
					logger.warn("Conversion of Row Error action: "+templateDef.getOnError() +", generated an exception, skypping");
				}
				
				Template template = TemplateService.generateTemplate(tmc, columns,error);
				logger.trace("Template generated, saving ");
				TemplateId templateId = new TemplateService(session.getScope()).saveTemplate(templateDef.getTemplateName(), templateDef.getTemplateDescription(), templateDef.getAgency(), template);
				logger.trace("Template saved on server with id: "+templateId.getValue());
			}else{
				logger.warn("Column size is 0, skipping template creation");
				throw new Exception("Sorry an error occurred on Template definition, Try again later");
			}
			
			return true;
			
		}catch (Exception e) {
			throw new Exception("Sorry an error occurred on Template creation, Try again later");
		}
	}

	
}
