package org.gcube.portlets.user.tdtemplate.client.template.smart;


import org.gcube.portlets.user.tdtemplate.client.resources.TdTemplateAbstractImage;

import com.extjs.gxt.ui.client.widget.Composite;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;

/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Feb 4, 2014
 *
 */
public class SmartPanelButton extends Composite {

	private final static String BASE_STYLE = "smartButton";

	private boolean selected;
	
	private String caption;

	private HorizontalPanel myPanel = new HorizontalPanel();

	private HTML text = new HTML();

	private Command myCommand = null;

//	private SmartFolderPanel caller;
	
	private Image delete = new Image(TdTemplateAbstractImage.INSTANCE.getRemoveColumn());

	public SmartPanelButton(String caption, AbstractImagePrototype img) {
		super();
		selected = false;
		this.caption = caption;
//		this.caller = caller;
//		super.setWidth(300);
//		text.setPixelSize(300, 30);
		myPanel.setStyleName(BASE_STYLE);

		text.setHTML("<div style=\"width: 97%; text-align:center; padding: 2px;\">" +
				"<span style=\"display:inline-block; vertical-align:middle;\" >" + img.getHTML() + "</span>" +
				"<span style=\"padding-left: 5px; vertical-align:middle;\">"+ caption+"</span></div>");
	
		myPanel.add(text);


		initComponent(myPanel);

//		text.addClickHandler(new ClickHandler() {
//
//			@Override
//			public void onClick(ClickEvent event) {
//				selected = selected? false : true;
//				if (selected) {
//					myPanel.addStyleName(BASE_STYLE + "-selected");
//				} else {
//					myPanel.removeStyleName(BASE_STYLE + "-selected");
//				}
//				deselectOthers();
//				if (myCommand != null)
//					myCommand.execute();
//			}
//		});

	}

	private void deleteFolder() {
//		TdTemplateController.getInternalBus().fireEvent(event);
	}

	private void deselectOthers() {
//		caller.toggleOthers(this);
	}

	public void setCommand(Command cmd) {
		myCommand = cmd;
	}

	/**
	 * Returns true if the button is pressed.
	 * 
	 * @return the pressed state
	 */
	public boolean isSelected() {
		return selected;
	}

	/**
	 * Sets the current selected state.
	 * 
	 * @param state true to set selected state
	 */
	protected void toggle(boolean state) {
		this.selected = state;
		if (selected) {
			myPanel.addStyleName(BASE_STYLE + "-selected");
		} else {
			myPanel.removeStyleName(BASE_STYLE + "-selected");
		}
	}	
}

