/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.datasource.td;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.metadata.common.TableDescriptorMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrder;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrderDirection;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryPage;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.impl.TabularDataServiceFactory;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.RelationshipData;
import org.gcube.portlets.user.tdwx.datasource.td.filters.FiltersBuilder;
import org.gcube.portlets.user.tdwx.datasource.td.map.ColumnDefinitionBuilder;
import org.gcube.portlets.user.tdwx.datasource.td.trservice.TRService;
import org.gcube.portlets.user.tdwx.server.datasource.DataSourceX;
import org.gcube.portlets.user.tdwx.server.datasource.DataSourceXException;
import org.gcube.portlets.user.tdwx.server.datasource.Direction;
import org.gcube.portlets.user.tdwx.server.datasource.util.TableJSonBuilder;
import org.gcube.portlets.user.tdwx.shared.ColumnsReorderingConfig;
import org.gcube.portlets.user.tdwx.shared.FilterInformation;
import org.gcube.portlets.user.tdwx.shared.StaticFilterInformation;
import org.gcube.portlets.user.tdwx.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdwx.shared.model.ColumnType;
import org.gcube.portlets.user.tdwx.shared.model.TableDefinition;
import org.gcube.portlets.user.tdwx.shared.model.TableId;
import org.gcube.portlets.user.tdwx.shared.model.ValueType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDXDataSource
implements DataSourceX {
    private static final int PAGINGDIMENSION = 300;
    private static final String PRIMARY_KEY_COLUMN = "id";
    private static final String JSON_ROWS_FIELD = "ROWS";
    private static final String JSON_TOTAL_LENGTH_FIELD = "total";
    private static final String JSON_OFFSET_FIELD = "offset";
    private Logger logger = LoggerFactory.getLogger(TDXDataSource.class);
    private String dataSourceFactoryId;
    private String tableName;
    private TableDefinition tableDefinition;
    private int tableSize = -1;
    private TableJSonBuilder jsonBuilder;
    private TabularDataService service;
    private org.gcube.data.analysis.tabulardata.model.table.TableId serviceTableId;
    private Table serviceTable;
    private long serviceTabularResourceId;
    private TRService trService;
    private long tableId;

    public static TDXDataSource createTDDataSource(String dataSourceFactoryId, ASLSession aslSession, String tableName) throws DataSourceXException {
        TDXDataSource dataSource = new TDXDataSource(dataSourceFactoryId, aslSession, tableName);
        return dataSource;
    }

    public TDXDataSource(String dataSourceFactoryId, ASLSession aslSession, String tableIdentifier) throws DataSourceXException {
        if (dataSourceFactoryId == null) {
            this.logger.error("An error occurred, dataSourceFactoryId is null");
            throw new DataSourceXException("An error occurred, dataSourceFactoryId is null");
        }
        if (tableIdentifier == null) {
            this.logger.error("An error occurred, tableName is null");
            throw new DataSourceXException("An error occurred, tableName is null");
        }
        this.dataSourceFactoryId = dataSourceFactoryId;
        this.tableName = tableIdentifier;
        AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
        this.service = TabularDataServiceFactory.getService();
        try {
            this.tableId = Long.parseLong(tableIdentifier);
        }
        catch (NumberFormatException e) {
            this.logger.error("An error occurred, tableName is not a long", (Throwable)e);
            throw new DataSourceXException("An error occurred, no tableName is not a long", (Throwable)e);
        }
        this.serviceTableId = new org.gcube.data.analysis.tabulardata.model.table.TableId(this.tableId);
        try {
            this.serviceTable = this.service.getTable(this.serviceTableId);
        }
        catch (NoSuchTableException e) {
            this.logger.error("An error occurred, no such table", (Throwable)e);
            throw new DataSourceXException("An error occurred, no such table", (Throwable)e);
        }
        TableDescriptorMetadata tableDesc = null;
        if (this.serviceTable.contains(TableDescriptorMetadata.class)) {
            tableDesc = (TableDescriptorMetadata)this.serviceTable.getMetadata(TableDescriptorMetadata.class);
            if (tableDesc.getRefId() == 0L) {
                this.logger.error("Error refId=0 for Table:" + this.serviceTable);
                throw new DataSourceXException("Error no valid tabular resource associated with the table:" + this.serviceTable.getId());
            }
            this.logger.debug("Table " + this.serviceTable.getId() + " connect to tabular resource: " + tableDesc.getRefId());
            this.serviceTabularResourceId = tableDesc.getRefId();
        } else {
            this.logger.debug("No TableDescriptorMetadata found (Supposed Time Table):" + this.tableId);
        }
        this.trService = new TRService();
        this.trService.setService(this.service);
        TabularResourceId tabularResourceId = new TabularResourceId(this.serviceTabularResourceId);
        this.trService.setTabularResourceId(tabularResourceId);
    }

    public String getDataSourceFactoryId() {
        return this.dataSourceFactoryId;
    }

    public TableDefinition getTableDefinition() throws DataSourceXException {
        this.logger.debug("Retrieving table definition");
        this.tableDefinition = this.extractTableDefinition();
        return this.tableDefinition;
    }

    protected TableDefinition extractTableDefinition() throws DataSourceXException {
        List<ColumnDefinition> columns = this.getColumnDefinitions();
        this.logger.debug("Creating tableId...");
        TableId id = new TableId(this.dataSourceFactoryId, this.tableName);
        TableDefinition tableDefinition = new TableDefinition(id, this.tableName, JSON_ROWS_FIELD, JSON_TOTAL_LENGTH_FIELD, JSON_OFFSET_FIELD, columns);
        tableDefinition.setModelKeyColumnId(PRIMARY_KEY_COLUMN);
        this.logger.debug("TableDefinition Created");
        return tableDefinition;
    }

    protected List<ColumnDefinition> getColumnDefinitions() throws DataSourceXException {
        int i;
        this.logger.debug("Creating list of columns definition...");
        List serviceListColumn = this.serviceTable.getColumns();
        ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
        ArrayList<ColumnDefinition> dimensions = new ArrayList<ColumnDefinition>();
        for (i = 0; i < serviceListColumn.size(); ++i) {
            Column serviceColumn = (Column)serviceListColumn.get(i);
            ColumnDefinition column = this.getColumnDefinition(serviceColumn, i);
            columns.add(column);
            if (column.getType() != ColumnType.DIMENSION && column.getType() != ColumnType.TIMEDIMENSION) continue;
            dimensions.add(column);
        }
        block1: for (i = 0; i < dimensions.size(); ++i) {
            String cId;
            ColumnDefinition dim = (ColumnDefinition)dimensions.get(i);
            RelationshipData rel = dim.getRelationshipData();
            if (rel == null || (cId = rel.getTargetColumnId()) == null) continue;
            for (int j = 0; j < columns.size(); ++j) {
                ColumnDefinition c = columns.get(j);
                if (c.getColumnLocalId() == null || c.getType() != ColumnType.VIEWCOLUMN_OF_DIMENSION && c.getType() != ColumnType.VIEWCOLUMN_OF_TIMEDIMENSION || c.getColumnLocalId().compareTo(cId) != 0) continue;
                c.setVisible(true);
                columns.set(j, c);
                continue block1;
            }
        }
        this.logger.debug("List of columns definition created");
        return columns;
    }

    protected ColumnDefinition getColumnDefinition(Column serviceColumn, int ordinalPosition) throws DataSourceXException {
        ColumnDefinitionBuilder columnDefinitionBuilder = new ColumnDefinitionBuilder(this.service, this.serviceTable, serviceColumn, ordinalPosition);
        ColumnDefinition columnDefinition = columnDefinitionBuilder.build();
        return columnDefinition;
    }

    protected ColumnDefinition createPrimaryKeyColumn(List<ColumnDefinition> columns) {
        ArrayList<String> ids = new ArrayList<String>(columns.size());
        for (ColumnDefinition column : columns) {
            ids.add(column.getId());
        }
        String id = PRIMARY_KEY_COLUMN;
        int i = 0;
        while (ids.contains(id)) {
            id = PRIMARY_KEY_COLUMN + i++;
        }
        return new ColumnDefinition(id, id, id, ValueType.INTEGER, -1, false, false, ColumnType.SYSTEM);
    }

    protected void retrieveTableSize(int start, int limit, QueryFilter queryFilter) throws DataSourceXException {
        this.tableSize = 0;
        try {
            this.tableSize = this.service.getQueryLenght(this.serviceTableId, queryFilter);
        }
        catch (NoSuchTableException e) {
            this.logger.error("An error occurred, tableSize is not recovered", (Throwable)e);
            throw new DataSourceXException("An error occurred, tableSize is not recovered", (Throwable)e);
        }
        start = Math.max(0, start);
        start = Math.min(start, this.tableSize);
        if (start + limit > this.tableSize) {
            limit = this.tableSize - start;
        }
        this.logger.debug("checked bounds start: " + start + " limit: " + limit);
    }

    public String getDataAsJSon(int start, int limit, String sortingColumn, Direction direction, ArrayList<FilterInformation> filters, ArrayList<StaticFilterInformation> staticFilters) throws DataSourceXException {
        Column column;
        ColumnDefinition columnDefinition;
        this.logger.debug("getDataAsJSon start: " + start + " limit: " + limit + " sortingColumn: " + sortingColumn + " direction: " + direction + " filters:" + filters.size() + " staticFilters:" + staticFilters.size());
        TableDefinition tableDefinition = this.getTableDefinition();
        this.logger.debug("Creating queryOrder...");
        QueryOrder queryOrder = null;
        if (sortingColumn != null) {
            if (tableDefinition.getColumns().get(sortingColumn) == null) {
                this.logger.error("The specified sorting column \"" + sortingColumn + "\" don't exists");
                throw new DataSourceXException("The specified sorting column \"" + sortingColumn + "\" don't exists");
            }
            columnDefinition = (ColumnDefinition)tableDefinition.getColumns().get(sortingColumn);
            column = this.serviceTable.getColumnByName(columnDefinition.getId());
            switch (direction) {
                case ASC: {
                    queryOrder = new QueryOrder(column.getLocalId(), QueryOrderDirection.ASCENDING);
                    break;
                }
                case DESC: {
                    queryOrder = new QueryOrder(column.getLocalId(), QueryOrderDirection.DESCENDING);
                    break;
                }
            }
        } else if (tableDefinition.getColumns().get(PRIMARY_KEY_COLUMN) == null) {
            this.logger.error("The primary key column \"id\" don't exists");
        } else {
            columnDefinition = (ColumnDefinition)tableDefinition.getColumns().get(PRIMARY_KEY_COLUMN);
            column = this.serviceTable.getColumnByName(columnDefinition.getId());
            queryOrder = new QueryOrder(column.getLocalId(), QueryOrderDirection.ASCENDING);
        }
        QueryFilter queryFilter = null;
        if (filters != null && filters.size() > 0 || staticFilters != null && staticFilters.size() > 0) {
            FiltersBuilder filtersBuilder = new FiltersBuilder(filters, staticFilters, tableDefinition, this.serviceTable);
            queryFilter = filtersBuilder.createQueryFilter();
        }
        this.retrieveTableSize(start, limit, queryFilter);
        String json = this.getJSon(start, queryOrder, queryFilter);
        this.logger.trace("Returning json");
        return json;
    }

    protected ArrayList<ColumnDefinition> sort(Collection<ColumnDefinition> columns) {
        ArrayList<ColumnDefinition> lcolumns = new ArrayList<ColumnDefinition>();
        for (ColumnDefinition column : columns) {
            lcolumns.add(column);
        }
        Collections.sort(lcolumns, new Comparator<ColumnDefinition>(){

            @Override
            public int compare(ColumnDefinition cd1, ColumnDefinition cd2) {
                int comp = 0;
                comp = cd1.getPosition() == cd2.getPosition() ? 0 : (cd1.getPosition() > cd2.getPosition() ? 1 : -1);
                return comp;
            }
        });
        return lcolumns;
    }

    protected String getJSon(int start, QueryOrder queryOrder, QueryFilter queryFilter) throws DataSourceXException {
        this.logger.debug("Retrieving JSon");
        this.logger.debug("[" + queryOrder + ", " + queryFilter + "]");
        TableDefinition tableDefinition = this.getTableDefinition();
        this.logger.debug("Retrieved table definition");
        Collection<ColumnDefinition> columns = tableDefinition.getColumns().values();
        this.logger.debug("Retrieved Columns");
        ArrayList<ColumnDefinition> lcolumns = this.sort(columns);
        QueryPage queryPage = new QueryPage(start, 300);
        this.logger.debug("Created queryPage");
        String serviceJson = null;
        try {
            if (queryOrder == null && queryFilter == null) {
                serviceJson = this.service.queryAsJson(this.serviceTableId, queryPage);
            } else if (queryOrder == null && queryFilter != null) {
                serviceJson = this.service.queryAsJson(this.serviceTableId, queryPage, queryFilter);
            } else if (queryOrder != null && queryFilter == null) {
                serviceJson = this.service.queryAsJson(this.serviceTableId, queryPage, queryOrder);
            } else if (queryOrder != null && queryFilter != null) {
                this.logger.debug("Order & Filter: " + queryOrder + " " + queryFilter);
                serviceJson = this.service.queryAsJson(this.serviceTableId, queryPage, queryFilter, queryOrder);
            } else {
                this.logger.debug("No queryAsJson valid");
            }
        }
        catch (NoSuchTableException e) {
            this.logger.error("An error occurred, no such table", (Throwable)e);
            throw new DataSourceXException("An error occurred, no such table", (Throwable)e);
        }
        catch (Throwable e) {
            this.logger.error("An error occurred", e);
            throw new DataSourceXException("An error occurred", e);
        }
        this.logger.debug("Created serviceJson");
        return this.createJson(start, serviceJson, lcolumns);
    }

    protected String createJson(int start, String serviceJson, ArrayList<ColumnDefinition> lcolumns) throws DataSourceXException {
        TableJSonBuilder json = this.getBuilder();
        json.startRows();
        int id = start;
        JSONArray currentRow = null;
        int i = -1;
        int j = -1;
        int totalRows = -1;
        String s = null;
        try {
            JSONObject obj = new JSONObject(serviceJson);
            JSONArray rows = obj.getJSONArray("rows");
            totalRows = rows.length();
            this.logger.debug("Reading rows from json");
            for (i = 0; i < totalRows; ++i) {
                json.startRow();
                currentRow = rows.getJSONArray(i);
                j = 0;
                for (ColumnDefinition column : lcolumns) {
                    String columnId = column.getId();
                    if (currentRow.isNull(j)) {
                        json.addValue(columnId, "");
                    } else {
                        switch (column.getValueType()) {
                            case DATE: {
                                Long day = currentRow.getLong(j);
                                Date dd = new Date();
                                dd.setTime(day);
                                json.addValue(columnId, day);
                                break;
                            }
                            case BOOLEAN: {
                                Boolean b = currentRow.getBoolean(j);
                                json.addValue(columnId, b);
                                break;
                            }
                            case DOUBLE: {
                                Double d = currentRow.getDouble(j);
                                json.addValue(columnId, d);
                                break;
                            }
                            case INTEGER: {
                                int integ = currentRow.getInt(j);
                                json.addValue(columnId, Integer.valueOf(integ));
                                break;
                            }
                            case LONG: {
                                Long l = currentRow.getLong(j);
                                json.addValue(columnId, l);
                                break;
                            }
                            case STRING: {
                                s = currentRow.getString(j);
                                json.addValue(columnId, s);
                                break;
                            }
                            case GEOMETRY: {
                                s = currentRow.getString(j);
                                json.addValue(columnId, s);
                                break;
                            }
                            default: {
                                this.logger.warn("Unknow value type " + column.getValueType());
                            }
                        }
                    }
                    ++j;
                }
                json.endRow();
            }
            id += i;
        }
        catch (JSONException e) {
            this.logger.error("An error occurred while parsing json document\nAt Row " + i + ",Column " + j + "\nRow Content: " + currentRow + "\nLenght rows " + totalRows, (Throwable)e);
            throw new DataSourceXException("An error occurred,  while reading json of service", (Throwable)e);
        }
        json.endRows();
        json.setTotalLength(this.tableSize);
        json.setOffset(start);
        json.close();
        this.logger.trace("produced " + (id - start) + " rows");
        return json.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TableJSonBuilder getBuilder() throws DataSourceXException {
        try {
            if (this.jsonBuilder != null) {
                this.jsonBuilder.clean();
                return this.jsonBuilder;
            }
            TableDefinition tdef = this.getTableDefinition();
            this.logger.debug("Creating jsonBuilder...");
            if (tdef != null) {
                this.jsonBuilder = new TableJSonBuilder(tdef);
                return this.jsonBuilder;
            }
            this.logger.error("table definition is null");
            throw new DataSourceXException("table definition is null");
        }
        catch (Exception e) {
            this.logger.debug("Error Creating jsonBuilder: " + e.getMessage());
            throw new DataSourceXException("Error Creating jsonBuilder: " + e.getMessage());
        }
    }

    protected int getTableSize() throws DataSourceXException {
        return this.tableSize;
    }

    public void close() {
    }

    public TableDefinition setColumnReordering(ColumnsReorderingConfig columnsReorderingConfig) throws DataSourceXException {
        this.logger.debug("SetColumnReordering: " + columnsReorderingConfig);
        this.trService.startChangeSingleColumnPosition(columnsReorderingConfig);
        this.updateTableAfterOperation();
        this.logger.debug("Retrieving table definition");
        this.tableDefinition = this.extractTableDefinition();
        return this.tableDefinition;
    }

    protected void updateTableAfterOperation() throws DataSourceXException {
        this.serviceTableId = new org.gcube.data.analysis.tabulardata.model.table.TableId(this.tableId);
        try {
            this.serviceTable = this.service.getTable(this.serviceTableId);
        }
        catch (NoSuchTableException e) {
            this.logger.error("An error occurred, no such table", (Throwable)e);
            throw new DataSourceXException("An error occurred, no such table", (Throwable)e);
        }
        TableDescriptorMetadata tableDesc = null;
        if (this.serviceTable.contains(TableDescriptorMetadata.class)) {
            tableDesc = (TableDescriptorMetadata)this.serviceTable.getMetadata(TableDescriptorMetadata.class);
            if (tableDesc.getRefId() == 0L) {
                this.logger.debug("Error refId=0 for Table:" + this.serviceTable);
                throw new DataSourceXException("Error no valid tabular resource associated with the table:" + this.serviceTable.getId());
            }
            this.logger.debug("Table " + this.serviceTable.getId() + " connect to tabular resource: " + tableDesc.getRefId());
            this.serviceTabularResourceId = tableDesc.getRefId();
        } else {
            this.logger.debug("No TableDescriptorMetadata found (Supposed Time Table):" + this.tableId);
        }
        this.trService.setService(this.service);
        TabularResourceId tabularResourceId = new TabularResourceId(this.serviceTabularResourceId);
        this.trService.setTabularResourceId(tabularResourceId);
    }

    public String toString() {
        return "TDXDataSource [serviceTabularResourceId=" + this.serviceTabularResourceId + ", serviceTableId=" + this.serviceTableId + "]";
    }
}

