/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.datasource.td.filters;

import java.util.ArrayList;
import java.util.Date;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.GreaterThan;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.LessThan;
import org.gcube.data.analysis.tabulardata.expression.composite.text.TextContains;
import org.gcube.data.analysis.tabulardata.expression.logical.And;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDDate;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDInteger;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDNumeric;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.portlets.user.tdwx.datasource.td.TDXDataSource;
import org.gcube.portlets.user.tdwx.datasource.td.map.DataTypeMap;
import org.gcube.portlets.user.tdwx.server.datasource.DataSourceXException;
import org.gcube.portlets.user.tdwx.shared.FilterInformation;
import org.gcube.portlets.user.tdwx.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdwx.shared.model.TableDefinition;
import org.gcube.portlets.user.tdwx.shared.model.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiltersBuilder {
    protected ArrayList<FilterInformation> filters;
    protected TableDefinition tableDefinition;
    protected Table serviceTable;
    protected Logger logger = LoggerFactory.getLogger(TDXDataSource.class);

    public FiltersBuilder(ArrayList<FilterInformation> filters, TableDefinition tableDefinition, Table serviceTable) {
        this.filters = filters;
        this.tableDefinition = tableDefinition;
        this.serviceTable = serviceTable;
    }

    protected Expression createExpression() throws DataSourceXException {
        Expression exp = null;
        ArrayList<Object> andExp = new ArrayList<Object>();
        block12: for (FilterInformation filter : this.filters) {
            switch (filter.getFilterType()) {
                case "string": {
                    if (this.tableDefinition.getColumns().get(filter.getFilterField()) == null) {
                        this.logger.error("The specified filter column \"" + filter.getFilterField() + "\" don't exists");
                        throw new DataSourceXException("The specified filter column \"" + filter.getFilterField() + "\" don't exists");
                    }
                    ColumnDefinition columnDefinition = (ColumnDefinition)this.tableDefinition.getColumns().get(filter.getFilterField());
                    Column column = this.serviceTable.getColumnByName(columnDefinition.getId());
                    TextContains contains = new TextContains((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)new TDText(filter.getFilterValue()));
                    andExp.add(contains);
                    break;
                }
                case "numeric": {
                    if (this.tableDefinition.getColumns().get(filter.getFilterField()) == null) {
                        this.logger.error("The specified filter column \"" + filter.getFilterField() + "\" don't exists");
                        throw new DataSourceXException("The specified filter column \"" + filter.getFilterField() + "\" don't exists");
                    }
                    ColumnDefinition columnDefinition = (ColumnDefinition)this.tableDefinition.getColumns().get(filter.getFilterField());
                    Column column = this.serviceTable.getColumnByName(columnDefinition.getId());
                    Expression ex = this.getExpressionNumeric(column, filter);
                    if (ex == null) continue block12;
                    andExp.add(ex);
                    break;
                }
                case "boolean": {
                    if (this.tableDefinition.getColumns().get(filter.getFilterField()) == null) {
                        this.logger.error("The specified filter column \"" + filter.getFilterField() + "\" don't exists");
                        throw new DataSourceXException("The specified filter column \"" + filter.getFilterField() + "\" don't exists");
                    }
                    ColumnDefinition columnDefinition = (ColumnDefinition)this.tableDefinition.getColumns().get(filter.getFilterField());
                    Column column = this.serviceTable.getColumnByName(columnDefinition.getId());
                    TextContains contains = new Equals((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)new TDBoolean(new Boolean(filter.getFilterValue()).booleanValue()));
                    andExp.add(contains);
                    break;
                }
                case "date": {
                    if (this.tableDefinition.getColumns().get(filter.getFilterField()) == null) {
                        this.logger.error("The specified filter column \"" + filter.getFilterField() + "\" don't exists");
                        throw new DataSourceXException("The specified filter column \"" + filter.getFilterField() + "\" don't exists");
                    }
                    ColumnDefinition columnDefinition = (ColumnDefinition)this.tableDefinition.getColumns().get(filter.getFilterField());
                    Column column = this.serviceTable.getColumnByName(columnDefinition.getId());
                    Expression ex = this.getExpressionDate(column, filter);
                    if (ex == null) continue block12;
                    andExp.add(ex);
                    break;
                }
            }
        }
        if (andExp.size() > 0) {
            if (andExp.size() == 1) {
                exp = (Expression)andExp.get(0);
            } else {
                And andE = new And(andExp);
                exp = andE;
            }
        }
        return exp;
    }

    protected Expression getExpressionDate(Column column, FilterInformation filter) throws DataSourceXException {
        Equals exp = null;
        Date dd = new Date();
        Long day = null;
        try {
            day = new Long(filter.getFilterValue());
        }
        catch (NumberFormatException e) {
            this.logger.error("No valid filterValue for date: " + filter.getFilterValue());
            throw new DataSourceXException("No valid filter value");
        }
        dd.setTime(day);
        TDDate tdDate = new TDDate(dd);
        switch (filter.getFilterComparison()) {
            case "on": {
                exp = new Equals((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)tdDate);
                break;
            }
            case "after": {
                exp = new GreaterThan((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)tdDate);
                break;
            }
            case "before": {
                exp = new LessThan((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)tdDate);
                break;
            }
        }
        return exp;
    }

    protected Expression getExpressionNumeric(Column column, FilterInformation filter) {
        Equals exp = null;
        ValueType vt = DataTypeMap.getValueType(column.getDataType());
        switch (vt) {
            case FLOAT: {
                TDNumeric floatnum = new TDNumeric(new Float(filter.getFilterValue()));
                if (filter.getFilterComparison().compareTo("eq") == 0) {
                    exp = new Equals((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)floatnum);
                    break;
                }
                if (filter.getFilterComparison().compareTo("gt") == 0) {
                    exp = new GreaterThan((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)floatnum);
                    break;
                }
                if (filter.getFilterComparison().compareTo("lt") != 0) break;
                exp = new LessThan((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)floatnum);
                break;
            }
            case INTEGER: {
                TDInteger intnum = new TDInteger(new Integer(filter.getFilterValue()));
                if (filter.getFilterComparison().compareTo("eq") == 0) {
                    exp = new Equals((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)intnum);
                    break;
                }
                if (filter.getFilterComparison().compareTo("gt") == 0) {
                    exp = new GreaterThan((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)intnum);
                    break;
                }
                if (filter.getFilterComparison().compareTo("lt") != 0) break;
                exp = new LessThan((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)intnum);
                break;
            }
            case LONG: {
                TDInteger longnum = new TDInteger(new Integer(filter.getFilterValue()));
                if (filter.getFilterComparison().compareTo("eq") == 0) {
                    exp = new Equals((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)longnum);
                    break;
                }
                if (filter.getFilterComparison().compareTo("gt") == 0) {
                    exp = new GreaterThan((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)longnum);
                    break;
                }
                if (filter.getFilterComparison().compareTo("lt") != 0) break;
                exp = new LessThan((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)longnum);
                break;
            }
        }
        return exp;
    }

    public QueryFilter createQueryFilter() throws DataSourceXException {
        QueryFilter queryFilter = null;
        Expression exp = this.createExpression();
        if (exp != null) {
            queryFilter = new QueryFilter(exp);
        }
        return queryFilter;
    }
}

