/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdw.datasource.jdbc.dialect;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.gcube.portlets.user.tdw.datasource.jdbc.dialect.SQLDialect;
import org.gcube.portlets.user.tdw.server.datasource.Direction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSQLDialect
implements SQLDialect {
    protected Logger logger = LoggerFactory.getLogger(AbstractSQLDialect.class);

    @Override
    public void setDataPreparedStatementParameters(PreparedStatement preparedStatement, String tableName, String sortingColumn, Direction sortingDirection, int start, int limit) throws SQLException {
        preparedStatement.setMaxRows(start + limit);
        preparedStatement.setInt(1, start);
        preparedStatement.setInt(2, limit);
    }

    @Override
    public PreparedStatement createDataPreparedStatement(Connection connection, String tableName, String sortingColumn, Direction sortingDirection, int start, int limit) throws SQLException {
        String query = this.getDataQuery(tableName, sortingColumn, sortingDirection);
        this.logger.trace("query: " + query);
        return connection.prepareStatement(query);
    }

    public abstract String getDataQuery(String var1, String var2, Direction var3);
}

