/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdw.datasource.jdbc.dialect;

import org.gcube.portlets.user.tdw.datasource.jdbc.dialect.AbstractSQLDialect;
import org.gcube.portlets.user.tdw.server.datasource.Direction;

public class PostgresSQL_8_x_x_SQLDialect
extends AbstractSQLDialect {
    protected boolean useSizeEstimation = false;

    public PostgresSQL_8_x_x_SQLDialect() {
    }

    public PostgresSQL_8_x_x_SQLDialect(boolean useSizeEstimation) {
        this.useSizeEstimation = useSizeEstimation;
    }

    @Override
    public String getName() {
        return "PostgresSQL_8_x_x";
    }

    @Override
    public boolean supportDataBase(String databaseProductName, int databaseMajorVersion, int databaseMinorVersion) {
        if (!"postgresql".equalsIgnoreCase(databaseProductName)) {
            return false;
        }
        if (databaseMajorVersion == 8 && databaseMinorVersion < 4) {
            return false;
        }
        return databaseMajorVersion >= 8;
    }

    @Override
    public String getTableSizeQuery(String tableName) {
        if (!this.useSizeEstimation) {
            StringBuilder sql = new StringBuilder("SELECT count(*) FROM ");
            sql.append(tableName);
            return sql.toString();
        }
        StringBuilder sql = new StringBuilder("SELECT reltuples FROM pg_class WHERE relname = '");
        sql.append(tableName);
        sql.append("'");
        return sql.toString();
    }

    @Override
    public String getDataQuery(String tableName, String sortingColumn, Direction sortingDirection) {
        StringBuilder sql = new StringBuilder("SELECT * FROM ");
        sql.append(tableName);
        if (sortingColumn != null && sortingDirection != null) {
            sql.append(" ORDER BY ");
            sql.append(sortingColumn);
            sql.append(' ');
            sql.append(sortingDirection.toString());
        }
        sql.append(" OFFSET ? LIMIT ?");
        return sql.toString();
    }
}

