package org.gcube.portlets.user.td.widgetcommonevent.client.event;

import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class ChangeTableRequestEvent extends GwtEvent<ChangeTableRequestEvent.ChangeTableRequestEventHandler> {

	public static Type<ChangeTableRequestEventHandler> TYPE = new Type<ChangeTableRequestEventHandler>();
	private ChangeTableRequestType changeTableRequestType;
	private TRId trId;

	public interface ChangeTableRequestEventHandler extends EventHandler {
		void onChangeTableRequestEvent(ChangeTableRequestEvent event);
	}
	
	public interface HasChangeTableRequestEventHandler extends HasHandlers{
		public HandlerRegistration addChangeTableRequestEventHandler(ChangeTableRequestEventHandler handler);
	}
	
	public static void fire(HasHandlers source, ChangeTableRequestType operationCompleteType, TRId trId) {
		source.fireEvent(new ChangeTableRequestEvent(operationCompleteType,trId));
	}

	public ChangeTableRequestEvent(ChangeTableRequestType changeTableRequestType, TRId trId) {
		this.changeTableRequestType = changeTableRequestType;
		this.trId = trId;
	}

	public static Type<ChangeTableRequestEventHandler> getType() {
		return TYPE;
	}

	@Override
	protected void dispatch(ChangeTableRequestEventHandler handler) {
		handler.onChangeTableRequestEvent(this);
	}

	@Override
	public Type<ChangeTableRequestEventHandler> getAssociatedType() {
		return TYPE;
	}

	public ChangeTableRequestType getOperationCompleteType() {
		return changeTableRequestType;
	}

	public TRId getTrId() {
		return trId;
	}

	public void setTrId(TRId trId) {
		this.trId = trId;
	}

	@Override
	public String toString() {
		return "ChangeTableRequestEvent [changeTableRequestType="
				+ changeTableRequestType + ", trId=" + trId + "]";
	}
	
	
	
}
