package org.gcube.portlets.user.td.widgetcommonevent.shared;

import java.io.Serializable;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class TRId implements Serializable {

	private static final long serialVersionUID = 192846115142001630L;

	/**
	 * Tabular resource id
	 */
	String id;

	/**
	 * Last table id of tabular resource
	 */
	String tableId;

	/**
	 * Type of last table
	 */
	String tableType;

	public TRId() {

	}

	public TRId(String id) {
		this.id = id;
		this.tableId = null;
		this.tableType = null;
	}

	public TRId(String id, String tableId) {
		this.id = id;
		this.tableId = tableId;
		this.tableType = null;
	}

	public TRId(String id, String tableId, String tableType) {
		this.id = id;
		this.tableId = tableId;
		this.tableType = tableType;
	}

	public String getTableId() {
		return tableId;
	}

	public void setTableId(String tableId) {
		this.tableId = tableId;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getTableType() {
		return tableType;
	}

	public void setTableType(String tableType) {
		this.tableType = tableType;
	}

	public boolean equals(TRId equals) {
		boolean eq = false;
		if (id != null && tableId != null && equals != null
				&& equals.getId() != null && equals.getTableId() != null
				&& id.compareTo(equals.getId()) == 0
				&& tableId.compareTo(equals.getTableId()) == 0) {
			eq = true;
		}

		return eq;
	}

	@Override
	public String toString() {
		return "TRId [id=" + id + ", tableId=" + tableId + ", tableType="
				+ tableType + "]";
	}

}
