package org.gcube.portlets.user.td.toolboxwidget.client.help;

import java.util.HashMap;

import com.google.gwt.user.client.ui.HTML;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.form.FieldSet;

public class HelpPanel extends FramedPanel {
	
	protected String headingTitle;
	protected HashMap<String, String> tabularResourcePropertiesMap;
	protected VerticalLayoutContainer vl;
	protected EventBus eventBus;

	protected FieldSet contents;

	protected VerticalLayoutContainer layoutCaptions;

	public HelpPanel(String name, EventBus eventBus) {
		super();
		setId(name);
		this.eventBus = eventBus;
		forceLayoutOnResize = true;
		setBodyBorder(false);
		setBorders(false);

		vl = new VerticalLayoutContainer();
		initInformation();
		this.add(vl);

	}

	public void addContents() {
		HTML title = new HTML("<H2>Tabular Data Manager Help<H2>");
		vl.add(title, new VerticalLayoutData(-1, -1, new Margins(1, 1, 10, 1)));

		contents = new FieldSet();
		contents.setHeadingText("Contents");
		contents.setCollapsible(true);
		contents.setResize(true);

		layoutCaptions = new VerticalLayoutContainer();
		contents.add(layoutCaptions);
		HTML info = new HTML(
				"<p><em><b>Tabular Data Manager</b></em> offers facilities supporting the management of the entire life-cycle"
						+ "(creation, curation, manipulation and publication) of <em>Tabular Resources</em> such as datasets, codelist or generic table."
						+ " i.e. tabular data representing observations of a given event or phenomenon at different time intervals."
						+ " Tabular Resource are used in many domains ranging from statistics to signal processing and econometrics."
						+ " Tabular Data Manager offers a rich set of facilities ranging from those supporting the assessment"
						+ " of data correctness to those supporting the verification of the compliance of data with given code lists,"
						+ " the aggregation and filtering of data.</p>");

		layoutCaptions
				.add(info, new VerticalLayoutData(1, -1, new Margins(1)));

		

		vl.add(contents, new VerticalLayoutData(1, -1, new Margins(1)));

	}

	/*
	 * protected void getLastTable(TRId trId) { TDGWTServiceAsync.INSTANCE
	 * .getLastTable(trId,new AsyncCallback<TableData>() {
	 * 
	 * public void onSuccess(TableData result) { updateTable(result);
	 * Log.info("Retrived LastTable:" + result.getName());
	 * 
	 * }
	 * 
	 * public void onFailure(Throwable caught) { AlertMessageBox d = new
	 * AlertMessageBox("Error", "Error retrienving Last Table: " +
	 * caught.getLocalizedMessage()); d.addHideHandler(new HideHandler() {
	 * 
	 * public void onHide(HideEvent event) { //
	 * 
	 * }
	 * 
	 * }); d.show();
	 * 
	 * }
	 * 
	 * }); }
	 */

	public void initInformation() {
		addContents();

	}



}
