package org.gcube.portlets.user.td.toolboxwidget.client.help;

import java.util.HashMap;

import org.gcube.portlets.user.td.informationwidget.client.util.UtilsGXT3;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.HTML;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.core.client.dom.ScrollSupport.ScrollMode;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.FieldSet;

public class HelpPanel extends FramedPanel {
	protected static final String TDMLogsServlet = "TDLogsServlet";
	protected String headingTitle;
	protected HashMap<String, String> tabularResourcePropertiesMap;
	protected VerticalLayoutContainer vl;
	protected EventBus eventBus;

	protected FieldSet contents;

	protected VerticalLayoutContainer layoutCaptions;

	public HelpPanel(String name, EventBus eventBus) {
		super();
		setId(name);
		this.eventBus = eventBus;
		forceLayoutOnResize = true;
		setBodyBorder(false);
		setBorders(false);

		vl = new VerticalLayoutContainer();
		initInformation();
		this.add(vl);

	}

	public void addContents() {
		HTML title = new HTML("<H2>Tabular Data Manager Help<H2>");
		vl.add(title, new VerticalLayoutData(-1, -1, new Margins(1, 1, 10, 1)));

		contents = new FieldSet();
		contents.setHeadingText("Contents");
		contents.setCollapsible(true);
		contents.setResize(true);

		layoutCaptions = new VerticalLayoutContainer();
		contents.add(layoutCaptions);
		HTML info = new HTML(
				"<p><em><b>Tabular Data Manager</b></em> offers facilities supporting the management of the entire life-cycle"
						+ "(creation, curation, manipulation and publication) of <em>Tabular Resources</em> such as datasets, codelist or generic table."
						+ " i.e. tabular data representing observations of a given event or phenomenon at different time intervals."
						+ " Tabular Resource are used in many domains ranging from statistics to signal processing and econometrics."
						+ " Tabular Data Manager offers a rich set of facilities ranging from those supporting the assessment"
						+ " of data correctness to those supporting the verification of the compliance of data with given code lists,"
						+ " the aggregation and filtering of data.</p>");

		layoutCaptions
				.add(info, new VerticalLayoutData(-1, -1, new Margins(1)));

		TextButton showLogsBtn = new TextButton("Show Logs");
		// showLogsBtn.setIcon(ResourceBundle.INSTANCE.tableType());
		// showLogsBtn.setIconAlign(IconAlign.RIGHT);
		showLogsBtn.setTitle("Show Logs");

		showLogsBtn.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				callLogsServlet();
			}
		});

		layoutCaptions.add(showLogsBtn, new VerticalLayoutData(-1, -1,
				new Margins(1)));

		vl.add(contents, new VerticalLayoutData(-1, -1, new Margins(1)));

	}

	/*
	 * protected void getLastTable(TRId trId) { TDGWTServiceAsync.INSTANCE
	 * .getLastTable(trId,new AsyncCallback<TableData>() {
	 * 
	 * public void onSuccess(TableData result) { updateTable(result);
	 * Log.info("Retrived LastTable:" + result.getName());
	 * 
	 * }
	 * 
	 * public void onFailure(Throwable caught) { AlertMessageBox d = new
	 * AlertMessageBox("Error", "Error retrienving Last Table: " +
	 * caught.getLocalizedMessage()); d.addHideHandler(new HideHandler() {
	 * 
	 * public void onHide(HideEvent event) { //
	 * 
	 * }
	 * 
	 * }); d.show();
	 * 
	 * }
	 * 
	 * }); }
	 */

	public void initInformation() {
		addContents();

	}

	public void callLogsServlet() {
		String path = GWT.getModuleBaseURL() + TDMLogsServlet;
		Log.debug("TDMLogsServlet path:" + path);
		// use a http proxy to get the data
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, path);

		try {
			builder.sendRequest(null, new RequestCallback() {

				public void onError(Request request, Throwable exception) {
					Log.error("Error retrienving logs. "
							+ exception.getLocalizedMessage());
					exception.printStackTrace();
					UtilsGXT3.alert("Logs", "Error retrienving logs");
				}

				public void onResponseReceived(Request request,
						Response response) {
					if (Response.SC_OK == response.getStatusCode()) {
						createLogsWindow(response.getText());
					} else {
						if (408 == response.getStatusCode()) {
							Log.error("Error retrienving logs. Session expired.");
							UtilsGXT3.alert("Logs", "Error retrienving logs session expired");
						} else {
							Log.error("Error retrienving logs. Response StatusCode: "
									+ response.getStatusCode());
							UtilsGXT3.alert("Logs", "Error retrienving logs");
						}
					}
				}
			});
		} catch (RequestException e) {
			Log.error("Error retrienving logs. " + e.getLocalizedMessage());
			e.printStackTrace();
			UtilsGXT3.alert("Logs", "Error retrienving logs");

		}
	}

	public void createLogsWindow(String text) {
		Window logWindow = new Window();
		logWindow.setWidth("640px");
		logWindow.setHeight("480px");
		logWindow.setHeadingText("TDM Logs");
		logWindow.setBodyBorder(false);
		logWindow.setClosable(true);
		
		FramedPanel panel=new FramedPanel();
		panel.setBodyBorder(false);
		panel.setHeaderVisible(false);
		
		SafeHtmlBuilder builderLogs = new SafeHtmlBuilder();
		builderLogs.appendEscapedLines(text);
		SafeHtml safeLogs = builderLogs.toSafeHtml();
		HTML hLogs = new HTML(safeLogs);
		
		VerticalLayoutContainer c = new VerticalLayoutContainer();
		c.setScrollMode(ScrollMode.AUTO);
		c.getElement().getStyle().setBackgroundColor("white");
		c.add(hLogs, new VerticalLayoutData(-1,-1,new Margins(1)));
		panel.add(c);
		logWindow.add(panel);
		logWindow.show();
	}

}
