/**
 * 
 */
package org.gcube.portlets.user.td.taskswidget.client.panel.result;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.gcube.portlets.user.td.taskswidget.client.resources.ResourcesTD;
import org.gcube.portlets.user.td.taskswidget.client.util.GwtDataFormatter;
import org.gcube.portlets.user.td.taskswidget.shared.job.TdJobModel;
import org.gcube.portlets.user.td.taskswidget.shared.job.TdJobModel.ColumnConfigTdJobModel;
import org.gcube.portlets.user.td.taskswidget.shared.job.TdOperationModel;

import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.google.gwt.dom.client.Style.Cursor;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Image;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Nov 25, 2013
 *
 */
public class FlexTableJob extends FlexTable{
	
	
	private List<ColumnConfigTdJobModel> columsConfigs;
	
	private HashMap<String, Integer> rowIndexJob = new HashMap<String, Integer>();

	/**
	 * 
	 */
	public FlexTableJob(TdJobModel.ColumnConfigTdJobModel... columns) {
		
		if(columns==null)
			return;
		
		columsConfigs = Arrays.asList(columns);
		initTable();
	}

	/**
	 * 
	 */
	private void initTable() {
		setCellPadding(10);
		setCellSpacing(10);
		setStyleName("job-table");
		
		for (int i = 0; i < columsConfigs.size(); i++)
			setWidget(0, i, new Label(columsConfigs.get(i).getLabel()));
	}

	/**
	 * @param jobModel
	 * @param jobsBar
	 */
	public void updateStatus(TdJobModel jobModel) {
		
		if(jobModel==null)
			return;
		
//		System.out.println("Update Status for "+jobModel);
		Integer rowIndex = rowIndexJob.get(jobModel.getJobIdentifier());

		if(rowIndex==null){
			Integer index = new Integer(this.getRowCount());
			rowIndexJob.put(jobModel.getJobIdentifier(), index);
			update(index.intValue(), jobModel);
			
		}else{
			
			update(rowIndex.intValue(), jobModel);

		}
		
	}
	
	private void update(int rowIndex,TdJobModel jobModel){
		
		for (int i = 0; i < columsConfigs.size(); i++) {
//			setWidget(rowIndex, i, new Label(columsConfigs.get(i)+""));
			
			if(columsConfigs.get(i).equals(ColumnConfigTdJobModel.StatusIcon)){
				Image img = getProgressStatusView(jobModel);
				if(jobModel.getStatus()!=null & img!=null)
					img.setTitle(jobModel.getStatus().toString()); //set tooltip
				
				if(img!=null)
					setWidget(rowIndex, i, img);
//				getCellFormatter().setWidth(rowIndex, i, "100px");
			}
			else if(columsConfigs.get(i).equals(ColumnConfigTdJobModel.Time)){
				Image time = setTime(jobModel.getStartTime(), jobModel.getEndTime());
				setWidget(rowIndex, i,time);
			}
			else if(columsConfigs.get(i).equals(ColumnConfigTdJobModel.Progress)){
				float percentage = jobModel.getProgressPercentage();
				percentage = percentage*100;
				setWidget(rowIndex, i, new Label(GwtDataFormatter.fmtToInt(percentage)+"%"));
			}else if(columsConfigs.get(i).equals(ColumnConfigTdJobModel.Type)){
				if(jobModel.getOpdModel()!=null){
					TdOperationModel type = jobModel.getOpdModel();
					
					if(type!=null){
						Label lb = new Label(type.getName().toString());
						String descr = jobModel.getOpdModel().getDescription()!=null?jobModel.getOpdModel().getDescription():type.toString();
						lb.setToolTip(descr);
						setWidget(rowIndex, i, lb);
					}
				}
			}else if(columsConfigs.get(i).equals(ColumnConfigTdJobModel.OperationInfo)){
				
				if(jobModel.getOpdModel()!=null){
					TdOperationModel type = jobModel.getOpdModel();
					
					if(type!=null){
						String descr = "Name: "+type.getName();
						descr+="<br/>Description: "+type.getDescription();
//						descr+="<br/>Parameters: "+type.getParameters();
						setWidget(rowIndex, i, setMessageBoxJobDescription(type.getOperationId(), descr));
					}
				}
//				setWidget(rowIndex, i, new Label(jobModel.get(columsConfigs.get(i).getId())+""));
			}else
				setWidget(rowIndex, i, new Label(jobModel.get(columsConfigs.get(i).getId())+""));
			
		}
	}
	


	/**
	 * @param startTime
	 * @param endTime
	 */
	private Image setTime(final Date startTime, final Date endTime) {
		// TODO Auto-generated method stub
		final Image time = new Image(ResourcesTD.INSTANCE.clock());
		time.setTitle("Show job time");
		
		time.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				time.getElement().getStyle().setCursor(Cursor.POINTER); 
				
			}
		});
		
		time.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
			
				MessageBox.info("Job Time:", "Start Time: "+GwtDataFormatter.getDateFormat(startTime) +"<br/> End Time: "+GwtDataFormatter.getDateFormat(endTime), null);
			}
		});
		
		return time;
	}
	
	
	/**
	 * @param descr 
	 * @param startTime
	 * @param endTime
	 */
	private Image setMessageBoxJobDescription(final String operationId, String descr) {
		// TODO Auto-generated method stub
		final Image decrImage = new Image(ResourcesTD.INSTANCE.info());
		decrImage.setTitle("Show job information");
		
		final String decription = (descr==null || descr.isEmpty())?"Empty":descr;
		
		decrImage.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				decrImage.getElement().getStyle().setCursor(Cursor.POINTER); 
				
			}
		});
		
		decrImage.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {

				MessageBox.info("Job Id: "+operationId, decription, null);
			}
		});
		
		return decrImage;
	}
	
	public Image getProgressStatusView(TdJobModel jobModel){
		
		switch (jobModel.getStatus()) {
			case INITIALIZING:return new Image(ResourcesTD.INSTANCE.waiticon());
			case FALLBACK: return new Image(ResourcesTD.INSTANCE.attention());
			case COMPLETED: return new Image(ResourcesTD.INSTANCE.success());
			case RUNNING: return new Image(ResourcesTD.INSTANCE.working());
			case FAILED: return new Image(ResourcesTD.INSTANCE.failicon());
			case STATUS_UNKNOWN: return new Image(ResourcesTD.INSTANCE.unknown());
			default: return null;
		}
	}
	
	public void reset(){
		this.removeAllRows();
		initTable();
	}

}
