package org.gcube.portlets.user.td.tablewidget.client;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.clone.CloneTabularResourceSession;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.ChangeTableRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableWhy;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;

public class CloneTabularResource {
	protected TRId trId;
	protected EventBus eventBus;

	protected CloneTabularResourceSession cloneTabularResourceSession;

	public CloneTabularResource(TRId trId, EventBus eventBus) {
		this.trId = trId;
		this.eventBus = eventBus;
	}

	public void cloneTR() {
		cloneTabularResourceSession = new CloneTabularResourceSession(trId);
		onCloneTR();

	}

	protected void onCloneTR() {
		TDGWTServiceAsync.INSTANCE.startCloneTabularResource(
				cloneTabularResourceSession, new AsyncCallback<TRId>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.debug("Clone Error: "
									+ caught.getLocalizedMessage());
							UtilsGXT3.alert("Error Cloning Tabular Resource",
									"Error in clone operation!");
						}
					}

					public void onSuccess(TRId result) {
						Log.info("TR Clone:" + result);
						final ChangeTableRequestEvent event = new ChangeTableRequestEvent(
								ChangeTableRequestType.CLONETABULARRESOURCE,
								result, ChangeTableWhy.TABLEUPDATED);
						eventBus.fireEvent(event);
						UtilsGXT3
								.info("Clone", "Clone Tabular Resource Succed");
					}

				});

	}

}
