/**
 * 
 */
package org.gcube.portlets.user.td.tablewidget.client.progress;




import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.sencha.gxt.widget.core.client.ProgressBar;

/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class DeleteRowsProgressBarUpdater implements DeleteRowsProgressListener {
	
	protected ProgressBar progressBar;
	
	/**
	 * Creates a new {@link ProgressBar} updater.
	 * @param progressBar the {@link ProgressBar} to update.
	 */
	public DeleteRowsProgressBarUpdater(ProgressBar progressBar) {
		this.progressBar = progressBar;
	}

	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void operationComplete(TRId trId) {
		Log.info("Completed");
		progressBar.updateProgress(1, "Completed");	
		
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void operationFailed(Throwable caught, String reason, String failureDetails) {
		Log.info("Failed");
		progressBar.updateText("Failed");
	}
	
	@Override
	public void operationInitializing() {
		Log.info("Inizializing");
		progressBar.updateProgress(0, "Initializing...");
	}
	
	@Override
	public void operationUpdate(float elaborated) {
		Log.info("Elaborated: "+elaborated);
		if (elaborated == 0) progressBar.updateProgress(0, "Initializing...");
		if (elaborated>0 && elaborated<1) {
			Log.trace("progress "+elaborated);
			int elab=new Float(elaborated*100).intValue();
			progressBar.updateProgress(elaborated,elab+"% Progress...");
		}
		if (elaborated == 1) progressBar.updateProgress(1, "Completing...");
		
	}
	
	@Override
	public void operationValidate(float elaborated) {
		Log.info("Validation Elaborated: "+elaborated);
		if (elaborated == 0) progressBar.updateProgress(0, "Start Validation...");
		if (elaborated>0 && elaborated<1) {
			Log.trace("Validation progress "+elaborated);
			int elab=new Float(elaborated*100).intValue();
			progressBar.updateProgress(elaborated,elab+"% Validation Progress...");
		}
		if (elaborated == 1) progressBar.updateProgress(1, "Validation...");
	}

	@Override
	public void operationStopped(TRId trId,String reason, String details) {
		Log.debug("Operation Stopped: ["+trId.toString()+", "+reason+", "+details+"]");
		progressBar.updateText("Validations failed");
		
	}
	
	@Override
	public void operationGeneratingView() {
		Log.info("Generating View...");
		progressBar.updateText("Generating View...");
		
	}

}
