/**
 * 
 */
package org.gcube.portlets.user.td.tablewidget.client.progress;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateApplyMonitor;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class TemplateApplyProgressUpdater extends Timer {

	protected ArrayList<TemplateApplyProgressListener> listeners = new ArrayList<TemplateApplyProgressListener>();

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void run() {
		Log.debug("requesting operation progress");
		TDGWTServiceAsync.INSTANCE
				.getTemplateApplyMonitor(new AsyncCallback<TemplateApplyMonitor>() {

					
					public void onFailure(Throwable caught) {
						cancel();
						Log.error("Error retrieving the operation state",
								caught);
						String message = getStack(caught);
						fireOperationFailed(caught,
								"Failed getting operation updates", message);
					}

					public void onSuccess(TemplateApplyMonitor result) {
						Log.info("retrieved TemplateApplyMonitor: "
								+ result.getStatus());
						switch (result.getStatus()) {
						case INITIALIZING:
							Log.info("Initializing...");
							fireOperationInitializing();
							break;
						case ABORTED:
							cancel();
							Log.info("Template Apply Operation Aborted");
							break;
						case IN_PROGRESS:
							fireOperationUpdate(result.getProgress());
							break;
						case VALIDATING_RULES:
							fireOperationUpdate(result.getProgress());
							break;	
						case STOPPED:
							cancel();
							stopMessage(result);
							break;		
						case FAILED:
							cancel();
							errorMessage(result);
							break;
						case SUCCEDED:
							cancel();
							Log.info("Fisnish TableId :"
									+ result.getTrId());
							fireOperationComplete(result.getTrId());
							break;
						default:
							Log.info("Unknow State");
							break;
						}

					}

					

				});

	}

	protected void errorMessage(TemplateApplyMonitor result) {
		Log.info("Template Apply Failed");
		Throwable th = null;
		String failure = null;
		String details = null;
		if (result.getError() != null) {
			th = result.getError();
			failure = "Failed Client Library applying template";
			details = result.getError().getLocalizedMessage();
		} else {
			th = new Throwable("Failed");
			failure = "Failed Client Library applying template";
			details = "Template Apply failed";
		}
		
		fireOperationFailed(th, failure, details);
	}
	
	protected void stopMessage(TemplateApplyMonitor result) {
		Log.info("Template Apply Stopped");
		String failure = null;
		String details = null;
		if (result.getError() != null) {	
			failure = "Stopped applying template";
			details = result.getError().getLocalizedMessage();
		} else {
			failure = "Stopped applying template";
			details = "Apply template stopped";
		}
	
		fireOperationStopped(result.getTrId(),failure, details);
	}
	

	protected String getStack(Throwable e) {
		String message = e.getLocalizedMessage() + " -> <br>";
		Throwable c = e.getCause();
		if (c != null)
			message += getStack(c);
		return message;
	}

	protected void fireOperationInitializing() {
		for (TemplateApplyProgressListener listener : listeners)
			listener.operationInitializing();
	}

	protected void fireOperationUpdate(float elaborated) {
		for (TemplateApplyProgressListener listener : listeners)
			listener.operationUpdate(elaborated);
	}

	protected void fireOperationComplete(TRId trId) {
		for (TemplateApplyProgressListener listener : listeners)
			listener.operationComplete(trId);
	}

	protected void fireOperationFailed(Throwable caught, String failure,
			String failureDetails) {
		for (TemplateApplyProgressListener listener : listeners)
			listener.operationFailed(caught, failure, failureDetails);
	}

	protected void fireOperationStopped(TRId trId, String reason, String details) {
		for (TemplateApplyProgressListener listener : listeners)
			listener.operationStopped(trId,reason, details);
	}
	
	
	/**
	 * Add a new {@link TemplateApplyProgressListener} to this
	 * {@link TemplateApplyProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to add.
	 */
	public void addListener(TemplateApplyProgressListener listener) {
		listeners.add(listener);
	}

	/**
	 * Removes the specified {@link TemplateApplyProgressListener} from this
	 * {@link TemplateApplyProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to remove.
	 */
	public void removeListener(TemplateApplyProgressListener listener) {
		listeners.remove(listener);
	}
}
