package org.gcube.portlets.user.td.tablewidget.client.rows;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DeleteRowsSession;
import org.gcube.portlets.user.td.tablewidget.client.progress.DeleteRowsProgressDialog;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;

public class DeleteRows {
	protected TRId trId;
	protected EventBus eventBus;
	protected ArrayList<String> rows;
	protected DeleteRowsSession deleteRowsSession;
    protected DeleteRowsProgressDialog deleteRowsProgressDialog;
    
	public DeleteRows(TRId trId, ArrayList<String> rows,EventBus eventBus) {
		this.trId = trId;
		this.rows=rows;
		this.eventBus = eventBus;
	}
	
	public void delete(){
		deleteRowsSession =new DeleteRowsSession(trId, rows);
		onDelete();
	}
	
	protected void onDelete(){
			TDGWTServiceAsync.INSTANCE.startDeleteRows(
					deleteRowsSession, new AsyncCallback<Void>() {

						public void onFailure(Throwable caught) {
							Log.debug("Delete Rows Error: "
									+ caught.getLocalizedMessage());
							UtilsGXT3.alert("Error Deleting Rows",
									"Error in invocation Delete Rows operation!");

						}

						public void onSuccess(Void result) {
							deleteRowsProgressDialog= new DeleteRowsProgressDialog(deleteRowsSession, eventBus);
						}

					});

		
	}
	
	
}
