package org.gcube.portlets.user.td.rulewidget.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.gcube.portlets.user.td.expressionwidget.client.rpc.ExpressionServiceAsync;
import org.gcube.portlets.user.td.expressionwidget.shared.rule.RuleDescriptionDataProperties;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.rule.AppliedRulesResponseData;
import org.gcube.portlets.user.td.gwtservice.shared.rule.DetachTableRulesSession;
import org.gcube.portlets.user.td.gwtservice.shared.rule.description.RuleDescriptionData;
import org.gcube.portlets.user.td.rulewidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.wizardwidget.client.util.UtilsGXT3;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.DateCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.core.client.XTemplates;
import com.sencha.gxt.core.client.dom.ScrollSupport.ScrollMode;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.filters.GridFilters;
import com.sencha.gxt.widget.core.client.grid.filters.StringFilter;
import com.sencha.gxt.widget.core.client.menu.Item;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;

/**
 * 
 * @author giancarlo email: <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 *
 */
public class RuleActiveOnTablePanel extends FramedPanel {
	private static final String WIDTH = "760px";
	private static final String HEIGHT = "418px";
	private static final DateTimeFormat sdf=DateTimeFormat.getFormat("yyyy-MM-dd HH:mm");
	
	interface RuleActiveTemplates extends XTemplates {
		@XTemplate("<span title=\"{value}\">{value}</span>")
		SafeHtml format(String value);
	}

	private EventBus eventBus;
	private TRId trId;

	private AppliedRulesResponseData appliedRuleResponseData;
	
	private Grid<RuleDescriptionData> gridAppliedRules;
	private ListStore<RuleDescriptionData> storeAppliedRules;
	private VerticalLayoutContainer mainLayoutContainer;
	public RuleActiveOnTablePanel(TRId trId, EventBus eventBus) {
		super();
		this.trId = trId;
		this.eventBus = eventBus;
		Log.debug("RuleActiveOnTablePanel");
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setHeaderVisible(false);
		setBodyBorder(false);
		getActiveRules();

	}

	
	protected void create() {
		Log.debug("Create RuleActiveOnTablePanel(): " + trId);

		mainLayoutContainer = new VerticalLayoutContainer();
		mainLayoutContainer.setScrollMode(ScrollMode.AUTO);
		mainLayoutContainer.setAdjustForScroll(true);

	
		ArrayList<RuleDescriptionData> appliedTableRules=appliedRuleResponseData.getTableRules();
		if (appliedTableRules == null || appliedTableRules.size() <=0) {
			FieldLabel noRulesLabel = new FieldLabel(null, "No rules on table applied!");
			noRulesLabel.setLabelSeparator("");
			noRulesLabel.setLabelWidth(200);
			mainLayoutContainer.add(noRulesLabel, new VerticalLayoutData(
					1, -1, new Margins(0)));
			add(mainLayoutContainer);
			return;
		}
	
		//Grid

		RuleDescriptionDataProperties propsRules = GWT
				.create(RuleDescriptionDataProperties.class);

		ColumnConfig<RuleDescriptionData, String> nameCol = new ColumnConfig<RuleDescriptionData, String>(
				propsRules.name(), 120, "Name");

		nameCol.setCell(new AbstractCell<String>() {

			@Override
			public void render(Context context, String value, SafeHtmlBuilder sb) {
				RuleActiveTemplates ruleActiveTemplates = GWT
						.create(RuleActiveTemplates.class);
				sb.append(ruleActiveTemplates.format(value));
			}
		});

		ColumnConfig<RuleDescriptionData, String> descriptionCol = new ColumnConfig<RuleDescriptionData, String>(
				propsRules.description(), 120, "Description");
		descriptionCol.setCell(new AbstractCell<String>() {

			@Override
			public void render(Context context, String value, SafeHtmlBuilder sb) {
				RuleActiveTemplates ruleActiveTemplates = GWT
						.create(RuleActiveTemplates.class);
				sb.append(ruleActiveTemplates.format(value));
			}
		});

		ColumnConfig<RuleDescriptionData, String> ownerCol = new ColumnConfig<RuleDescriptionData, String>(
				propsRules.ownerLogin(), 70, "Owner");
		ownerCol.setCell(new AbstractCell<String>() {

			@Override
			public void render(Context context, String value, SafeHtmlBuilder sb) {
				RuleActiveTemplates ruleActiveTemplates = GWT
						.create(RuleActiveTemplates.class);
				sb.append(ruleActiveTemplates.format(value));
			}
		});

		ColumnConfig<RuleDescriptionData, Date> creationDateCol = new ColumnConfig<RuleDescriptionData, Date>(
				propsRules.creationDate(), 56, "Creation Date");
	
		creationDateCol.setCell(new DateCell(sdf));
		
		List<ColumnConfig<RuleDescriptionData, ?>> l = new ArrayList<ColumnConfig<RuleDescriptionData, ?>>();
		l.add(nameCol);
		l.add(descriptionCol);
		l.add(ownerCol);
		l.add(creationDateCol);

		ColumnModel<RuleDescriptionData> cm = new ColumnModel<RuleDescriptionData>(
				l);

		StringFilter<RuleDescriptionData> nameFilter = new StringFilter<RuleDescriptionData>(
				propsRules.name());
		StringFilter<RuleDescriptionData> descriptionFilter = new StringFilter<RuleDescriptionData>(
				propsRules.description());

		// Applies Rules
		storeAppliedRules = new ListStore<RuleDescriptionData>(
				propsRules.id());

	
		storeAppliedRules.addAll(appliedTableRules);
		

		gridAppliedRules = new Grid<RuleDescriptionData>(
				storeAppliedRules, cm);
		//gridAppliedRules.setHeight(RULES_GRID_HEIGHT);
		gridAppliedRules.getView().setStripeRows(true);
		gridAppliedRules.getView().setColumnLines(true);
		gridAppliedRules.getView().setAutoFill(true);
		gridAppliedRules.setBorders(false);
		gridAppliedRules.setLoadMask(true);
		gridAppliedRules.setColumnReordering(true);
		gridAppliedRules.setColumnResize(true);
		gridAppliedRules.getView().setAutoExpandColumn(descriptionCol);

		GridFilters<RuleDescriptionData> filtersAppliesRules = new GridFilters<RuleDescriptionData>();
		filtersAppliesRules.initPlugin(gridAppliedRules);
		filtersAppliesRules.setLocal(true);
		filtersAppliesRules.addFilter(nameFilter);
		filtersAppliesRules.addFilter(descriptionFilter);

		createContextMenu(gridAppliedRules);

		mainLayoutContainer.add(gridAppliedRules, new VerticalLayoutData(
				1, 1, new Margins(0)));
		add(mainLayoutContainer);
		return;
	}

	protected void getActiveRules() {

		ExpressionServiceAsync.INSTANCE.getActiveRulesByTabularResourceId(trId,
				new AsyncCallback<AppliedRulesResponseData>() {

					@Override
					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error(caught.getLocalizedMessage());
							UtilsGXT3.alert("Error retrieving active rules",
									caught.getLocalizedMessage());
						}

					}

					@Override
					public void onSuccess(AppliedRulesResponseData result) {
						Log.trace("AppliedRuleResponseData: " + result);
						appliedRuleResponseData = result;
						create();
					}
				});

	}

	protected void updateActiveRules() {

		ExpressionServiceAsync.INSTANCE.getActiveRulesByTabularResourceId(trId,
				new AsyncCallback<AppliedRulesResponseData>() {

					@Override
					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error(caught.getLocalizedMessage());
							UtilsGXT3.alert("Error retrieving applied rules",
									caught.getLocalizedMessage());
						}

					}

					@Override
					public void onSuccess(AppliedRulesResponseData result) {
						Log.trace("AppliedRuleResponseData: " + result);
						appliedRuleResponseData = result;
						recreate();
					}
				});

	}

	protected void requestInfo(RuleDescriptionData rule) {
		final RuleInfoDialog infoRuleDialog = new RuleInfoDialog(rule);
		infoRuleDialog.show();

	}

	protected void createContextMenu(final Grid<RuleDescriptionData> grid) {
		Menu contextMenu = new Menu();

		MenuItem infoItem = new MenuItem();
		infoItem.setText("Info");
		infoItem.setToolTip("Info");
		infoItem.setIcon(ResourceBundle.INSTANCE.information());
		infoItem.addSelectionHandler(new SelectionHandler<Item>() {

			@Override
			public void onSelection(SelectionEvent<Item> event) {
				RuleDescriptionData selected = grid.getSelectionModel()
						.getSelectedItem();
				Log.debug(selected.toString());
				requestInfo(selected);
			}
		});

		MenuItem detachItem = new MenuItem();
		detachItem.setText("Detach");
		detachItem.setToolTip("Detach rule");
		detachItem.setIcon(ResourceBundle.INSTANCE.ruleColumnDetach());
		detachItem.addSelectionHandler(new SelectionHandler<Item>() {

			@Override
			public void onSelection(SelectionEvent<Item> event) {
				RuleDescriptionData selected = grid.getSelectionModel()
						.getSelectedItem();
				Log.debug(selected.toString());
				requestDetach(selected, grid);
			}

		});

		contextMenu.add(infoItem);
		contextMenu.add(detachItem);

		grid.setContextMenu(contextMenu);

	}

	protected void requestDetach(RuleDescriptionData selected,
			final Grid<RuleDescriptionData> grid) {

		ArrayList<RuleDescriptionData> detachRules = new ArrayList<RuleDescriptionData>();
		detachRules.add(selected);

		DetachTableRulesSession detachTableRulesSession = new DetachTableRulesSession(
				trId, detachRules);

		ExpressionServiceAsync.INSTANCE.setDetachTableRules(
				detachTableRulesSession, new AsyncCallback<Void>() {

					@Override
					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error(caught.getLocalizedMessage());
							UtilsGXT3.alert("Error in detach rules",
									caught.getLocalizedMessage());
						}

					}

					@Override
					public void onSuccess(Void result) {
						updateActiveRules();
						Log.debug("The rule is detached!");
						UtilsGXT3.info("Detach Rule", "The rule is detached!");

					}
				});

	}

	protected void recreate() {
		remove(mainLayoutContainer);
		create();
		forceLayout();

	}

}
