/**
 * 
 */
package org.gcube.portlets.user.td.openwidget.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.gcube.portlets.user.td.wizardwidget.client.dataresource.ResourceBundle;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sencha.gxt.core.client.IdentityValueProvider;
import com.sencha.gxt.core.client.Style.SelectionMode;
import com.sencha.gxt.data.client.loader.RpcProxy;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.data.shared.Store;
import com.sencha.gxt.data.shared.Store.StoreFilter;
import com.sencha.gxt.data.shared.loader.ListLoadConfig;
import com.sencha.gxt.data.shared.loader.ListLoadResult;
import com.sencha.gxt.data.shared.loader.ListLoadResultBean;
import com.sencha.gxt.data.shared.loader.ListLoader;
import com.sencha.gxt.data.shared.loader.LoadResultListStoreBinding;
import com.sencha.gxt.widget.core.client.ContentPanel;
import com.sencha.gxt.widget.core.client.Resizable;
import com.sencha.gxt.widget.core.client.Resizable.Dir;
import com.sencha.gxt.widget.core.client.box.AlertMessageBox;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.HideEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.HideEvent.HideHandler;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.grid.CheckBoxSelectionModel;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.toolbar.LabelToolItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;

/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class TabResourcesSelectionPanel extends ContentPanel implements HasSelectionHandlers<TabResource> {

	
	private static final TabResourcesProperties properties = GWT.create(TabResourcesProperties.class);
	
	protected static final ColumnConfig<TabResource, String> nameColumn = new ColumnConfig<TabResource, String>(properties.name(), 90, "Name");
	protected static final ColumnConfig<TabResource, String> typeColumn = new ColumnConfig<TabResource, String>(properties.tabularResourceType(), 30, "Type");
	protected static final ColumnConfig<TabResource, String> agencyColumn = new ColumnConfig<TabResource, String>(properties.agency(), 60, "Agency");
	protected static final ColumnConfig<TabResource, String> dateColumn = new ColumnConfig<TabResource, String>(properties.date(), 40, "Date");
	
	
	
	protected Grid<TabResource> grid;
	protected ResourceBundle res;
	
	
	
	public TabResourcesSelectionPanel(ResourceBundle res)
	{
		this.res=res;
		setHeaderVisible(false);
		new Resizable(this, Dir.E, Dir.SE, Dir.S);
		buildPanel(properties.id(), Arrays.<ColumnConfig<TabResource, ?>>asList(nameColumn, typeColumn, agencyColumn, dateColumn), nameColumn);
	}
	
	
	protected void buildPanel(ModelKeyProvider<TabResource> keyProvider, List<ColumnConfig<TabResource, ?>> columns, ColumnConfig<TabResource, ?> autoexpandColumn)
	{

		ToolBar toolBar = new ToolBar();
		toolBar.add(new LabelToolItem("Search: "));
		final TextField searchField = new TextField();
		toolBar.add(searchField);
		
		TextButton btnReload = new TextButton();
		//btnReload.setText("Reload");
		btnReload.setIcon(res.refresh16());
		btnReload.setToolTip("Reload");
		toolBar.add(btnReload);
		
		
		IdentityValueProvider<TabResource> identity = new IdentityValueProvider<TabResource>();
		final CheckBoxSelectionModel<TabResource> sm = new CheckBoxSelectionModel<TabResource>(identity);
		
		ColumnModel<TabResource> cm = new ColumnModel<TabResource>(columns);

		final ExtendedListStore<TabResource> store = new ExtendedListStore<TabResource>(keyProvider);

		searchField.addKeyUpHandler(new KeyUpHandler() {

			public void onKeyUp(KeyUpEvent event) {
				Log.trace("searchTerm: "+searchField.getCurrentValue());
				store.applyFilters();				
			}
		});
		
		store.addFilter(new StoreFilter<TabResource>() {

			public boolean select(Store<TabResource> store, TabResource parent, TabResource item) {
				String searchTerm = searchField.getCurrentValue();
				if (searchTerm == null) return true;
				return TabResourcesSelectionPanel.this.select(item, searchTerm);
			}
		});

		store.setEnableFilters(true);

		RpcProxy<ListLoadConfig, ListLoadResult<TabResource>> proxy = new RpcProxy<ListLoadConfig,  ListLoadResult<TabResource>>() {

			
			public void load(ListLoadConfig loadConfig, final AsyncCallback<ListLoadResult<TabResource>> callback) {
				loadData(loadConfig, callback);
			}	
		};
		final ListLoader<ListLoadConfig, ListLoadResult<TabResource>> loader = new ListLoader<ListLoadConfig, ListLoadResult<TabResource>>(proxy);

		loader.setRemoteSort(false);
		loader.addLoadHandler(new LoadResultListStoreBinding<ListLoadConfig, TabResource, ListLoadResult<TabResource>>(store));

		grid = new Grid<TabResource>(store, cm){
			@Override
			protected void onAfterFirstAttach() {
				super.onAfterFirstAttach();
				Scheduler.get().scheduleDeferred(new ScheduledCommand() {
					public void execute() {
						loader.load();
					}
				});
			}
		};
		
		sm.setSelectionMode(SelectionMode.SINGLE);	
		grid.setLoader(loader);
		grid.setSelectionModel(sm);
		grid.getView().setAutoExpandColumn(autoexpandColumn);
		grid.getView().setStripeRows(true);
		grid.getView().setColumnLines(true);
		grid.getView().setAutoFill(true);
		grid.setBorders(false);
		grid.setLoadMask(true);
		grid.setColumnReordering(true);
		
		
		SelectHandler sh = new SelectHandler() {
			public void onSelect(SelectEvent event) {
				loader.load();
			}
		};
		
		btnReload.addSelectHandler(sh);
		
		VerticalLayoutContainer con = new VerticalLayoutContainer();
		con.add(toolBar, new VerticalLayoutData(1, -1));
		con.add(grid, new VerticalLayoutData(1, 1));
		setWidget(con);
	}
	
	
	
	protected boolean select(TabResource item, String searchTerm) {
		if (item.getName()!=null && item.getName().toLowerCase().contains(searchTerm.toLowerCase())) return true;
		if (item.getTabularResourceType()!=null &&item.getTabularResourceType().toLowerCase().contains(searchTerm.toLowerCase())) return true;
		if (item.getAgency()!=null &&item.getAgency().toLowerCase().contains(searchTerm.toLowerCase())) return true;
		if (item.getDate()!=null && item.getDate().toLowerCase().contains(searchTerm.toLowerCase())) return true;
		return false;
	}

	
	protected void loadData(ListLoadConfig loadConfig, final AsyncCallback<ListLoadResult<TabResource>> callback) {
		TDGWTServiceAsync.INSTANCE.getTabularResources(new  AsyncCallback<ArrayList<TabResource>>() {

			public void onFailure(Throwable caught) {
				Log.debug("Error retriving tabular resource: "+caught.getLocalizedMessage());
				callback.onFailure(caught);	
				AlertMessageBox d = new AlertMessageBox("Error!",
						"Error retrieving tabular resources on server!");
				d.addHideHandler(new HideHandler() {

					public void onHide(HideEvent event) {
						//
					}

				});
				d.show();
			}

			public void onSuccess(ArrayList<TabResource> result) {
				Log.debug("loaded "+result.size()+" TabularResources");
				/*for(TabResource tr:result){
					Log.debug("TR:"+tr);
				}*/
				callback.onSuccess(new ListLoadResultBean<TabResource>(result));
			}
		});
	}

	
	public HandlerRegistration addSelectionHandler(SelectionHandler<TabResource> handler) {
		return grid.getSelectionModel().addSelectionHandler(handler);
	}
	
	public TabResource getSelectedItem() {
		return grid.getSelectionModel().getSelectedItem();
	}
	
	protected class ExtendedListStore<M> extends ListStore<M> {

		public ExtendedListStore(ModelKeyProvider<? super M> keyProvider) {
			super(keyProvider);
		}

		public void applyFilters()
		{
			super.applyFilters();
		}

	}
	
	public void gridReload(){
		grid.getLoader().load();
	}
	
	

}
