/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.client.template;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.DateCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell;
import com.sencha.gxt.core.client.IdentityValueProvider;
import com.sencha.gxt.core.client.Style;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.core.client.resources.ThemeStyles;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.Store;
import com.sencha.gxt.data.shared.loader.DataProxy;
import com.sencha.gxt.data.shared.loader.ListLoadConfig;
import com.sencha.gxt.data.shared.loader.ListLoadResult;
import com.sencha.gxt.data.shared.loader.ListLoader;
import com.sencha.gxt.data.shared.loader.LoadHandler;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.grid.CheckBoxSelectionModel;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.GridSelectionModel;
import com.sencha.gxt.widget.core.client.toolbar.LabelToolItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import java.util.ArrayList;
import org.gcube.portlets.user.td.client.resource.TabularDataResources;
import org.gcube.portlets.user.td.client.template.TemplateDataProperties;
import org.gcube.portlets.user.td.client.template.TemplateShareDialog;
import org.gcube.portlets.user.td.client.template.TemplateSharePanel;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateData;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;

public class TemplateSharePanel
extends FramedPanel {
    private static final String WIDTH = "840px";
    private static final String HEIGHT = "520px";
    private static final DateTimeFormat sdf = DateTimeFormat.getFormat((String)"yyyy-MM-dd HH:mm");
    private EventBus eventBus;
    private TemplateShareDialog parent;
    private TextButton btnClose;
    private TextButton btnShare;
    private ListLoader<ListLoadConfig, ListLoadResult<TemplateData>> loader;
    private Grid<TemplateData> grid;
    private ExtendedListStore<TemplateData> store;

    public TemplateSharePanel(TemplateShareDialog parent, EventBus eventBus) {
        this.parent = parent;
        Log.debug((String)"TemplateSharePanel");
        this.setWidth(WIDTH);
        this.setHeight(HEIGHT);
        this.setHeaderVisible(false);
        this.setBodyBorder(false);
        this.eventBus = eventBus;
        this.create();
    }

    protected void create() {
        ToolBar toolBarHead = new ToolBar();
        toolBarHead.add((Widget)new LabelToolItem("Search: "));
        TextField searchField = new TextField();
        toolBarHead.add((Widget)searchField);
        TextButton btnReload = new TextButton();
        btnReload.setIcon(TabularDataResources.INSTANCE.refresh());
        btnReload.setToolTip("Reload");
        toolBarHead.add((Widget)btnReload);
        IdentityValueProvider identity = new IdentityValueProvider();
        CheckBoxSelectionModel sm = new CheckBoxSelectionModel((ValueProvider)identity);
        TemplateDataProperties props = (TemplateDataProperties)GWT.create(TemplateDataProperties.class);
        ColumnConfig nameCol = new ColumnConfig(props.name(), 120, "Name");
        ColumnConfig categoryCol = new ColumnConfig(props.category(), 50, "Category");
        ColumnConfig ownerCol = new ColumnConfig(props.ownerLogin(), 70, "Owner");
        ColumnConfig agencyCol = new ColumnConfig(props.agency(), 90, "Agency");
        ColumnConfig descriptionCol = new ColumnConfig(props.description(), 90, "Description");
        ColumnConfig creationDateCol = new ColumnConfig(props.creationDate(), 60, "Creation Date");
        creationDateCol.setCell((Cell)new DateCell((com.google.gwt.i18n.shared.DateTimeFormat)sdf));
        ArrayList<ColumnConfig> l = new ArrayList<ColumnConfig>();
        l.add(nameCol);
        l.add(categoryCol);
        l.add(ownerCol);
        l.add(agencyCol);
        l.add(descriptionCol);
        l.add(creationDateCol);
        ColumnModel cm = new ColumnModel(l);
        this.store = new ExtendedListStore(this, props.id());
        searchField.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.store.addFilter((Store.StoreFilter)new /* Unavailable Anonymous Inner Class!! */);
        this.store.setEnableFilters(true);
        3 proxy = new /* Unavailable Anonymous Inner Class!! */;
        this.loader = new ListLoader((DataProxy)proxy);
        this.loader.setRemoteSort(false);
        this.loader.addLoadHandler((LoadHandler)new /* Unavailable Anonymous Inner Class!! */);
        5 sh = new /* Unavailable Anonymous Inner Class!! */;
        btnReload.addSelectHandler((SelectEvent.SelectHandler)sh);
        this.grid = new /* Unavailable Anonymous Inner Class!! */;
        sm.setSelectionMode(Style.SelectionMode.SINGLE);
        this.grid.setLoader(this.loader);
        this.grid.setSelectionModel((GridSelectionModel)sm);
        this.grid.setHeight("384px");
        this.grid.getView().setStripeRows(true);
        this.grid.getView().setColumnLines(true);
        this.grid.getView().setAutoFill(true);
        this.grid.setBorders(false);
        this.grid.setLoadMask(true);
        this.grid.setColumnReordering(true);
        this.grid.setColumnResize(true);
        this.grid.getView().setAutoExpandColumn(descriptionCol);
        ToolBar toolBar = new ToolBar();
        toolBar.add((Widget)this.grid);
        toolBar.addStyleName(ThemeStyles.get().style().borderTop());
        toolBar.getElement().getStyle().setProperty("borderBottom", "none");
        this.btnClose = new TextButton("Close");
        this.btnClose.setIcon(TabularDataResources.INSTANCE.close());
        this.btnClose.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.btnClose.setToolTip("Close");
        this.btnClose.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.btnShare = new TextButton("Share");
        this.btnShare.setIcon(TabularDataResources.INSTANCE.templateShare());
        this.btnShare.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.btnShare.setToolTip("Share");
        this.btnShare.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        HBoxLayoutContainer flowButton = new HBoxLayoutContainer();
        flowButton.setHBoxLayoutAlign(HBoxLayoutContainer.HBoxLayoutAlign.MIDDLE);
        flowButton.setPack(BoxLayoutContainer.BoxLayoutPack.CENTER);
        BoxLayoutContainer.BoxLayoutData boxLayoutData = new BoxLayoutContainer.BoxLayoutData(new Margins(2, 4, 2, 4));
        flowButton.add((IsWidget)this.btnShare, boxLayoutData);
        flowButton.add((IsWidget)this.btnClose, boxLayoutData);
        VerticalLayoutContainer v = new VerticalLayoutContainer();
        v.add((IsWidget)toolBarHead, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        v.add((IsWidget)this.grid, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        v.add((IsWidget)toolBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, 25.0, new Margins(0)));
        v.add((IsWidget)flowButton, new VerticalLayoutContainer.VerticalLayoutData(1.0, 36.0, new Margins(5, 2, 5, 2)));
        this.add((Widget)v);
    }

    protected void loadData(ListLoadConfig loadConfig, AsyncCallback<ListLoadResult<TemplateData>> callback) {
        TDGWTServiceAsync.INSTANCE.getTemplates((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected ArrayList<TemplateData> getSelectedItem() {
        ArrayList<TemplateData> templates = new ArrayList<TemplateData>();
        for (TemplateData template : this.grid.getSelectionModel().getSelectedItems()) {
            templates.add(template);
        }
        return templates;
    }

    protected void share() {
        ArrayList templates = this.getSelectedItem();
        if (templates == null || templates.size() == 0) {
            UtilsGXT3.info((String)"Attention", (String)"Select the template");
        } else {
            TemplateData template = (TemplateData)templates.get(0);
            Log.debug((String)("templateShare: " + template));
            this.parent.templateShare(template);
        }
    }

    protected void close() {
        this.parent.close();
    }

    public void gridReload() {
        this.grid.getLoader().load();
    }

    protected boolean select(TemplateData item, String searchTerm) {
        if (item.getName() != null && item.getName().toLowerCase().contains(searchTerm.toLowerCase())) {
            return true;
        }
        if (item.getCategory() != null && item.getCategory().toLowerCase().contains(searchTerm.toLowerCase())) {
            return true;
        }
        if (item.getAgency() != null && item.getAgency().toLowerCase().contains(searchTerm.toLowerCase())) {
            return true;
        }
        return item.getDescription() != null && item.getDescription().toLowerCase().contains(searchTerm.toLowerCase());
    }

    static /* synthetic */ ExtendedListStore access$000(TemplateSharePanel x0) {
        return x0.store;
    }

    static /* synthetic */ ListLoader access$100(TemplateSharePanel x0) {
        return x0.loader;
    }

    static /* synthetic */ EventBus access$200(TemplateSharePanel x0) {
        return x0.eventBus;
    }
}

