package org.gcube.portlets.user.td.client.rule;

import org.gcube.portlets.user.td.client.resource.TabularDataResources;
import org.gcube.portlets.user.td.gwtservice.shared.rule.RuleDescriptionData;
import org.gcube.portlets.user.td.sharewidget.client.RuleShare;

import com.allen_sauer.gwt.log.client.Log;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 *
 */
public class RuleShareDialog extends Window {
	private static final String WIDTH = "720px";
	private static final String HEIGHT = "530px"; 
	
	private EventBus eventBus;

	public RuleShareDialog(EventBus eventBus) {
		this.eventBus = eventBus;
		initWindow();

		RuleSharePanel templateDeletePanel = new RuleSharePanel(this,
				eventBus);
		add(templateDeletePanel);
	}

	protected void initWindow() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);
		setHeadingText("Share Rule");
		setClosable(true);
		setModal(true);
		forceLayoutOnResize = true;
		getHeader().setIcon(TabularDataResources.INSTANCE.ruleShare());

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initTools() {
		super.initTools();

		closeBtn.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				close();
			}
		});

	}

	protected void close() {
		hide();
	}


	public void ruleShare(RuleDescriptionData ruleDescriptionData) {
		Log.debug("Share Window");
		@SuppressWarnings("unused")
		RuleShare ruleShare = new RuleShare(ruleDescriptionData, eventBus);
		close();

	}

}
