package org.gcube.portlets.user.td.client.rule;

import org.gcube.portlets.user.td.client.resource.TabularDataResources;
import org.gcube.portlets.user.td.expressionwidget.client.RuleEditDialog;
import org.gcube.portlets.user.td.expressionwidget.client.notification.RuleEditDialogNotification;
import org.gcube.portlets.user.td.expressionwidget.client.notification.RuleEditDialogNotification.RuleEditDialogNotificationListener;
import org.gcube.portlets.user.td.gwtservice.shared.rule.RuleDescriptionData;

import com.allen_sauer.gwt.log.client.Log;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 *
 */
public class RuleOpenDialog extends Window implements RuleEditDialogNotificationListener {
	private static final String WIDTH = "720px";
	private static final String HEIGHT = "530px";
	private RuleOpenPanel rulesOpenPanel;
	private EventBus eventBus;
	
	public RuleOpenDialog(EventBus eventBus) {
		this.eventBus=eventBus;
		initWindow();
		rulesOpenPanel= new RuleOpenPanel(this,
				eventBus);
		add(rulesOpenPanel);
	}

	protected void initWindow() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);
		setHeadingText("Open Rule");
		setClosable(true);
		setModal(true);
		forceLayoutOnResize = true;
		getHeader().setIcon(TabularDataResources.INSTANCE.ruleOpen());

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initTools() {
		super.initTools();

		closeBtn.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				close();
			}
		});

	}

	protected void close() {
		hide();
	}

	public void ruleEdit(RuleDescriptionData ruleDescriptionData) {
		openRuleDialog(ruleDescriptionData);

	}
	
	protected void openRuleDialog(RuleDescriptionData ruleDescriptionData) {
		Log.debug("Request Open New Rule Dialog");
		RuleEditDialog reDialog = new RuleEditDialog(ruleDescriptionData,eventBus);
		reDialog.addRuleEditDialogNotificationListener(this);
		reDialog.show();
	
		
		/*RuleDialog cfDialog = new RuleDialog(ruleDescriptionData,eventBus);
		cfDialog.addRuleDialogNotificationListener(this);
		cfDialog.show();*/
	

	}

	@Override
	public void onNotification(RuleEditDialogNotification ruleEditDialogNotification) {
		rulesOpenPanel.gridReload();
		
	}

	@Override
	public void aborted() {
		
	}

	@Override
	public void failed(Throwable throwable) {
		Log.debug("Error in edit rule: "+throwable.getLocalizedMessage());
		
	}

	
	
	
	


}
