/**
 * 
 */
package org.gcube.portlets.user.td.client.ribbon;

import org.gcube.portlets.user.td.client.resource.TabularDataResources;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.RibbonEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.UIStateEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.RibbonType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.UIStateType;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell.ButtonArrowAlign;
import com.sencha.gxt.cell.core.client.ButtonCell.ButtonScale;
import com.sencha.gxt.cell.core.client.ButtonCell.IconAlign;
import com.sencha.gxt.core.client.dom.XElement;
import com.sencha.gxt.widget.core.client.button.ButtonGroup;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;

/**
 * 
 * @author giancarlo email: <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 *
 */
public class ModifyToolBar {

	private EventBus eventBus;
	private ToolBar toolBar;

	// Table
	private TextButton unionButton;
	private TextButton groupbyButton;
	private TextButton timeAggregationButton;
	private TextButton replaceByExternalCol;
	private TextButton addRowButton;
	private TextButton deleteRowButton;
	private TextButton deleteDuplicateButton;

	// Geospatial
	private TextButton csquareButton;
	private TextButton oceanAreaButton;
	private TextButton pointButton;

	public ModifyToolBar(EventBus eventBus) {
		this.eventBus = eventBus;
		build();
	}

	public ToolBar getToolBar() {
		return toolBar;
	}

	protected void build() {
		toolBar = new ToolBar();
		toolBar.setSpacing(1);
		toolBar.setEnableOverflow(false);

		// Table Group
		ButtonGroup tableGroup = new ButtonGroup();
		tableGroup.setId("Table");
		tableGroup.setStyleName("ribbon");
		tableGroup.setHeadingText("Table");
		tableGroup.enable();
		toolBar.add(tableGroup);

		FlexTable tableLayout = new FlexTable();
		tableGroup.add(tableLayout);
		unionButton = new TextButton("Union",
				TabularDataResources.INSTANCE.union32());
		unionButton.disable();
		unionButton.setScale(ButtonScale.LARGE);
		unionButton.setIconAlign(IconAlign.TOP);
		unionButton.setToolTip("Merge tables data");
		unionButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		unionButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.TABLE_UNION));
			}
		});

		tableLayout.setWidget(0, 1, unionButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 1, 2);

		groupbyButton = new TextButton("Group By",
				TabularDataResources.INSTANCE.group32());
		groupbyButton.disable();
		groupbyButton.setScale(ButtonScale.LARGE);
		groupbyButton.setIconAlign(IconAlign.TOP);
		groupbyButton.setToolTip("Perform data grouping");
		groupbyButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		groupbyButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.TABLE_GROUPBY));
			}
		});

		tableLayout.setWidget(0, 2, groupbyButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 2, 2);

		timeAggregationButton = new TextButton("Time Aggregation",
				TabularDataResources.INSTANCE.timeAggregate32());
		timeAggregationButton.disable();
		timeAggregationButton.setScale(ButtonScale.LARGE);
		timeAggregationButton.setIconAlign(IconAlign.TOP);
		timeAggregationButton.setToolTip("Performs time aggregation");
		timeAggregationButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		timeAggregationButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(
						RibbonType.TABLE_TIME_AGGREGATE));
			}
		});

		tableLayout.setWidget(0, 3, timeAggregationButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 3, 2);

		replaceByExternalCol = new TextButton("Replace by External",
				TabularDataResources.INSTANCE.replaceByExternalCol32());
		replaceByExternalCol.disable();
		replaceByExternalCol.setScale(ButtonScale.LARGE);
		replaceByExternalCol.setIconAlign(IconAlign.TOP);
		replaceByExternalCol.setToolTip("Replace by external columns");
		replaceByExternalCol.setArrowAlign(ButtonArrowAlign.BOTTOM);
		replaceByExternalCol.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(
						RibbonType.TABLE_REPLACE_BY_EXTERNAL_COL));
			}
		});

		tableLayout.setWidget(0, 4, replaceByExternalCol);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 4, 2);

		addRowButton = new TextButton("Add Row",
				TabularDataResources.INSTANCE.rowInsert32());
		addRowButton.disable();
		addRowButton.setScale(ButtonScale.LARGE);
		addRowButton.setIconAlign(IconAlign.TOP);
		addRowButton.setToolTip("Add row");
		addRowButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		addRowButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.ROW_ADD));
			}
		});

		tableLayout.setWidget(0, 5, addRowButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 5, 2);

		deleteRowButton = new TextButton("Delete Row",
				TabularDataResources.INSTANCE.rowRemove32());
		deleteRowButton.disable();
		deleteRowButton.setScale(ButtonScale.LARGE);
		deleteRowButton.setIconAlign(IconAlign.TOP);
		deleteRowButton.setToolTip("Delete row");
		deleteRowButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		deleteRowButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.ROW_DELETE));
			}
		});

		tableLayout.setWidget(0, 6, deleteRowButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 6, 2);

		deleteDuplicateButton = new TextButton("Delete Duplicate",
				TabularDataResources.INSTANCE.tableDuplicateRowsRemove32());
		deleteDuplicateButton.disable();
		deleteDuplicateButton.setScale(ButtonScale.LARGE);
		deleteDuplicateButton.setIconAlign(IconAlign.TOP);
		deleteDuplicateButton.setToolTip("Delete duplicate row");
		deleteDuplicateButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		deleteDuplicateButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.DUPLICATE_DELETE));
			}
		});

		tableLayout.setWidget(0, 7, deleteDuplicateButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 7, 2);
		cleanCells(tableLayout.getElement());

		// Geospatial Group
		ButtonGroup geospatialGroup = new ButtonGroup();
		geospatialGroup.setId("Geospatial");
		geospatialGroup.setStyleName("ribbon");
		geospatialGroup.setHeadingText("Geospatial");
		geospatialGroup.enable();
		geospatialGroup.setVisible(true);
		toolBar.add(geospatialGroup);

		FlexTable geospatialLayout = new FlexTable();
		geospatialGroup.add(geospatialLayout);

		csquareButton = new TextButton("C-Square",
				TabularDataResources.INSTANCE.geospatialCSquare32());
		csquareButton.disable();
		csquareButton.setScale(ButtonScale.LARGE);
		csquareButton.setIconAlign(IconAlign.TOP);
		csquareButton.setToolTip("Create C-Square Coordinates");
		csquareButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		csquareButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(
						RibbonType.GEOSPATIAL_CSQUARE));
			}
		});

		geospatialLayout.setWidget(0, 0, csquareButton);
		geospatialLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);

		oceanAreaButton = new TextButton("Ocean Area",
				TabularDataResources.INSTANCE.geospatialOceanArea32());
		oceanAreaButton.disable();
		oceanAreaButton.setScale(ButtonScale.LARGE);
		oceanAreaButton.setIconAlign(IconAlign.TOP);
		oceanAreaButton.setToolTip("Create Ocean Area Coordinates");
		oceanAreaButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		oceanAreaButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(
						RibbonType.GEOSPATIAL_OCEAN_AREA));
			}
		});

		geospatialLayout.setWidget(0, 1, oceanAreaButton);
		geospatialLayout.getFlexCellFormatter().setRowSpan(0, 1, 2);

		cleanCells(geospatialLayout.getElement());

		// Geometry Group
		ButtonGroup geometryGroup = new ButtonGroup();
		geometryGroup.setId("Geometry");
		geometryGroup.setStyleName("ribbon");
		geometryGroup.setHeadingText("Geometry");
		geometryGroup.enable();
		geometryGroup.setVisible(true);
		toolBar.add(geometryGroup);

		FlexTable geometryLayout = new FlexTable();
		geometryGroup.add(geometryLayout);

		pointButton = new TextButton("Points",
				TabularDataResources.INSTANCE.geometryPoint32());
		pointButton.disable();
		pointButton.setScale(ButtonScale.LARGE);
		pointButton.setIconAlign(IconAlign.TOP);
		pointButton.setToolTip("Create Points");
		pointButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		pointButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.GEOMETRY_POINT));
			}
		});

		geometryLayout.setWidget(0, 0, pointButton);
		geometryLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);

		cleanCells(geospatialLayout.getElement());

		eventBus.addHandler(UIStateEvent.TYPE,
				new UIStateEvent.UIStateHandler() {

					public void onUIState(UIStateEvent event) {
						setUI(event);

					}
				});

	}

	protected void cleanCells(Element elem) {
		NodeList<Element> tds = elem.<XElement> cast().select("td");
		for (int i = 0; i < tds.getLength(); i++) {
			Element td = tds.getItem(i);

			if (!td.hasChildNodes() && td.getClassName().equals("")) {
				td.removeFromParent();
			}
		}
	}

	public void setUI(UIStateEvent event) {
		UIStateType uiStateType = event.getUIStateType();
		try {
			switch (uiStateType) {
			case START:
				// Table
				unionButton.disable();
				groupbyButton.disable();
				timeAggregationButton.disable();
				replaceByExternalCol.disable();
				addRowButton.disable();
				deleteRowButton.disable();
				deleteDuplicateButton.disable();
				// Geospatial
				csquareButton.disable();
				oceanAreaButton.disable();
				// Geometry
				pointButton.disable();
				break;
			case TR_CLOSE:
			case TR_READONLY:
				// Table
				unionButton.disable();
				groupbyButton.disable();
				timeAggregationButton.disable();
				replaceByExternalCol.disable();
				addRowButton.disable();
				deleteRowButton.disable();
				deleteDuplicateButton.disable();
				// Geospatial
				csquareButton.disable();
				oceanAreaButton.disable();
				// Geometry
				pointButton.disable();
				break;
			case TR_OPEN:
			case TABLEUPDATE:
			case TABLECURATION:
				// Table
				unionButton.enable();
				groupbyButton.enable();
				timeAggregationButton.enable();
				replaceByExternalCol.enable();
				addRowButton.enable();
				deleteRowButton.enable();
				deleteDuplicateButton.enable();
				// Geospatial
				csquareButton.enable();
				oceanAreaButton.enable();
				// Geometry
				pointButton.enable();
				break;
			case WIZARD_OPEN:
				// Table
				unionButton.disable();
				groupbyButton.disable();
				timeAggregationButton.disable();
				replaceByExternalCol.disable();
				addRowButton.disable();
				deleteRowButton.disable();
				deleteDuplicateButton.disable();
				// Geospatial
				csquareButton.disable();
				oceanAreaButton.disable();
				// Geometry
				pointButton.disable();
				break;
			default:
				break;
			}
		} catch (Exception e) {
			Log.error("setUI Error on Ribbon Curation: "
					+ e.getLocalizedMessage());
		}
	}

}
