/**
 * 
 */
package org.gcube.portlets.user.td.client.toolbar;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.core.client.dom.XElement;
import com.sencha.gxt.widget.core.client.button.ButtonGroup;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;

/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class EditingToolBar {

	protected EventBus eventBus;
	protected ToolBar toolBar;
	
	protected TextButton importButton;
	protected TextButton importCSVButton;
	protected TextButton importSDMXButton;
	
	protected TextButton validationButton;
	protected TextButton rulesButton;
	
	protected TextButton exportButton;
	protected TextButton exportCSVButton;
	protected TextButton exportSDMXButton;
	
	public EditingToolBar(EventBus eventBus)
	{
		this.eventBus = eventBus;
		toolBar = new ToolBar();
		build();
	}
	
	public ToolBar getToolBar()
	{
		return toolBar;
	}

	protected void build()
	{
		ButtonGroup importGroup = new ButtonGroup();
		importGroup.setHeadingText("Import");
		toolBar.add(importGroup);

		FlexTable importLayout = new FlexTable();
		importGroup.add(importLayout);
/*
		importButton = new TextButton("Import", TabularDataResources.INSTANCE.importTD());
		importButton.setScale(ButtonScale.LARGE);
		importButton.setIconAlign(IconAlign.TOP);
		importButton.setToolTip("Imports a new table");
		importButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		importButton.addSelectHandler(new SelectHandler() {
			
			@Override
			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new ImportTableEvent(ImportTableType.NONE));
			}
		});

		importLayout.setWidget(0, 0, importButton);
		importLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);

		importCSVButton = new TextButton("CSV", TabularDataResources.INSTANCE.csv());
		importCSVButton.setToolTip("Imports a new table from a CSV file");
		importLayout.setWidget(0, 2, importCSVButton);
		importCSVButton.addSelectHandler(new SelectHandler() {
			
			@Override
			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new ImportTableEvent(ImportTableType.CSV));
			}
		});

		importSDMXButton = new TextButton("SDMX", TabularDataResources.INSTANCE.sdmx());
		importSDMXButton.setToolTip("Imports a new table from a SDMX registry");
		importLayout.setWidget(1, 2, importSDMXButton);
		importSDMXButton.addSelectHandler(new SelectHandler() {
			
			@Override
			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new ImportTableEvent(ImportTableType.SDMX));
			}
		});

		cleanCells(importLayout.getElement());
		

		ButtonGroup validationGroup = new ButtonGroup();
		validationGroup.setHeadingText("Validation");
		toolBar.add(validationGroup);

		FlexTable validationLayout = new FlexTable();
		validationGroup.add(validationLayout);


		validationButton = new TextButton("Validate", TabularDataResources.INSTANCE.validation());
		validationLayout.setWidget(0, 0, validationButton);

		rulesButton = new TextButton("Rules", TabularDataResources.INSTANCE.rules());
		validationLayout.setWidget(1, 0, rulesButton);

		cleanCells(validationLayout.getElement());
		
		
		ButtonGroup exportGroup = new ButtonGroup();
		exportGroup.setHeadingText("Export");
		toolBar.add(exportGroup);

		FlexTable exportLayout = new FlexTable();
		exportGroup.add(exportLayout);

		exportButton = new TextButton("Export", TabularDataResources.INSTANCE.exportTD());
		exportButton.setScale(ButtonScale.LARGE);
		exportButton.setIconAlign(IconAlign.TOP);
		exportButton.setArrowAlign(ButtonArrowAlign.BOTTOM);

		exportLayout.setWidget(0, 0, exportButton);
		exportLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);

		exportCSVButton = new TextButton("CSV", TabularDataResources.INSTANCE.csv());
		exportLayout.setWidget(0, 2, exportCSVButton);

		exportSDMXButton = new TextButton("SDMX", TabularDataResources.INSTANCE.sdmx());
		exportLayout.setWidget(1, 2, exportSDMXButton);
		
		cleanCells(exportLayout.getElement());	
		*/
	}

	protected void cleanCells(Element elem) {
		NodeList<Element> tds = elem.<XElement> cast().select("td");
		for (int i = 0; i < tds.getLength(); i++) {
			Element td = tds.getItem(i);

			if (!td.hasChildNodes() && td.getClassName().equals("")) {
				td.removeFromParent();
			}
		}
	}

}
