/**
 * 
 */
package org.gcube.portlets.user.td.client.ribbon;

import org.gcube.portlets.user.td.client.resource.TabularDataResources;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.RibbonEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.UIStateEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.RibbonType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.UIStateType;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell.ButtonArrowAlign;
import com.sencha.gxt.cell.core.client.ButtonCell.ButtonScale;
import com.sencha.gxt.cell.core.client.ButtonCell.IconAlign;
import com.sencha.gxt.core.client.dom.XElement;
import com.sencha.gxt.widget.core.client.button.ButtonGroup;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 * 
 */
public class ModifyToolBar {

	protected EventBus eventBus;
	protected ToolBar toolBar;

	// Table
	//protected TextButton filterButton;
	protected TextButton unionButton;
	protected TextButton groupbyButton;
	//protected TextButton aggregateButton;
	protected TextButton timeAggregationButton;
	protected TextButton addRowButton;
	protected TextButton deleteRowButton;
	protected TextButton deleteDuplicateButton;
	//protected TextButton annotationButton;	

	// Column
	protected TextButton filterColumnButton;
	protected TextButton replaceValueBatchButton;
	

	public ModifyToolBar(EventBus eventBus) {
		this.eventBus = eventBus;
		build();
	}

	public ToolBar getToolBar() {
		return toolBar;
	}

	protected void build() {
		toolBar = new ToolBar();
		toolBar.setSpacing(1);
		toolBar.setEnableOverflow(false);

		// Table Group
		ButtonGroup tableGroup = new ButtonGroup();
		tableGroup.setId("Table");
		tableGroup.setStyleName("ribbon");
		tableGroup.setHeadingText("Table");
		tableGroup.enable();
		toolBar.add(tableGroup);

		FlexTable tableLayout = new FlexTable();
		tableGroup.add(tableLayout);
		/*
		filterButton = new TextButton("Filter",
				TabularDataResources.INSTANCE.filter32());
		filterButton.disable();
		filterButton.setScale(ButtonScale.LARGE);
		filterButton.setIconAlign(IconAlign.TOP);
		filterButton.setToolTip("Filter table data");
		filterButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		filterButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				//eventBus.fireEvent(new RibbonEvent(RibbonType.TABLEFILTER));
			}
		});

		tableLayout.setWidget(0, 0, filterButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);
		*/
		unionButton = new TextButton("Union",
				TabularDataResources.INSTANCE.union32());
		unionButton.disable();
		unionButton.setScale(ButtonScale.LARGE);
		unionButton.setIconAlign(IconAlign.TOP);
		unionButton.setToolTip("Merge tables data");
		unionButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		unionButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.TABLEUNION));
			}
		});

		tableLayout.setWidget(0, 1, unionButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 1, 2);

	
		groupbyButton = new TextButton("Group By",
				TabularDataResources.INSTANCE.group32());
		groupbyButton.disable();
		groupbyButton.setScale(ButtonScale.LARGE);
		groupbyButton.setIconAlign(IconAlign.TOP);
		groupbyButton.setToolTip("Perform data grouping");
		groupbyButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		groupbyButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.TABLEGROUPBY));
			}
		});

		tableLayout.setWidget(0, 2, groupbyButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 2, 2);
		
		/*
		aggregateButton = new TextButton("Aggregate",
				TabularDataResources.INSTANCE.aggregate32());
		aggregateButton.disable();
		aggregateButton.setScale(ButtonScale.LARGE);
		aggregateButton.setIconAlign(IconAlign.TOP);
		aggregateButton.setToolTip("Performs data aggregation");
		aggregateButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		aggregateButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.TABLEAGGREAGETE));
			}
		});

		tableLayout.setWidget(0, 3, aggregateButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 3, 2);
		*/
		
		timeAggregationButton = new TextButton("Time Aggregation",
				TabularDataResources.INSTANCE.timeAggregate32());
		timeAggregationButton.disable();
		timeAggregationButton.setScale(ButtonScale.LARGE);
		timeAggregationButton.setIconAlign(IconAlign.TOP);
		timeAggregationButton.setToolTip("Performs time aggregation");
		timeAggregationButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		timeAggregationButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.TABLETIMEAGGREGATE));
			}
		});

		tableLayout.setWidget(0, 3, timeAggregationButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 3, 2);
		
		
		addRowButton = new TextButton("Add Row",
				TabularDataResources.INSTANCE.rowInsert32());
		addRowButton.disable();
		addRowButton.setScale(ButtonScale.LARGE);
		addRowButton.setIconAlign(IconAlign.TOP);
		addRowButton.setToolTip("Add row");
		addRowButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		addRowButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.ROWADD));
			}
		});

		tableLayout.setWidget(0, 4, addRowButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 4, 2);
		
		deleteRowButton = new TextButton("Delete Row",
				TabularDataResources.INSTANCE.rowRemove32());
		deleteRowButton.disable();
		deleteRowButton.setScale(ButtonScale.LARGE);
		deleteRowButton.setIconAlign(IconAlign.TOP);
		deleteRowButton.setToolTip("Delete row");
		deleteRowButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		deleteRowButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.ROWDELETE));
			}
		});

		tableLayout.setWidget(0, 5, deleteRowButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 5, 2);
		
		deleteDuplicateButton = new TextButton("Delete Duplicate",
				TabularDataResources.INSTANCE.tableDuplicateRowsRemove32());
		deleteDuplicateButton.disable();
		deleteDuplicateButton.setScale(ButtonScale.LARGE);
		deleteDuplicateButton.setIconAlign(IconAlign.TOP);
		deleteDuplicateButton.setToolTip("Delete duplicate row");
		deleteDuplicateButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		deleteDuplicateButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.DUPLICATEDELETE));
			}
		});

		tableLayout.setWidget(0, 6, deleteDuplicateButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 6, 2);
		
		/*
		annotationButton = new TextButton("Annotation",
				TabularDataResources.INSTANCE.annotationAdd32());
		annotationButton.disable();
		annotationButton.setScale(ButtonScale.LARGE);
		annotationButton.setIconAlign(IconAlign.TOP);
		annotationButton.setToolTip("Add annotation column");
		annotationButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		annotationButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				//eventBus.fireEvent(new RibbonEvent(RibbonType.ANNOTATIONADD));
			}
		});

		tableLayout.setWidget(0, 7, annotationButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 7, 2);
		*/
		cleanCells(tableLayout.getElement());

		// Column Group
		ButtonGroup columnGroup = new ButtonGroup();
		columnGroup.setId("Column");
		columnGroup.setStyleName("ribbon");
		columnGroup.setHeadingText("Column");
		columnGroup.disable();
		columnGroup.setVisible(false);
		toolBar.add(columnGroup);

		FlexTable columnLayout = new FlexTable();
		columnGroup.add(columnLayout);

		
		filterColumnButton = new TextButton("Filter",
				TabularDataResources.INSTANCE.columnFilter32());
		filterColumnButton.disable();
		filterColumnButton.setScale(ButtonScale.LARGE);
		filterColumnButton.setIconAlign(IconAlign.TOP);
		filterColumnButton
				.setToolTip("Filter column values according to an condition");
		filterColumnButton
				.setArrowAlign(ButtonArrowAlign.BOTTOM);
		filterColumnButton
				.addSelectHandler(new SelectHandler() {

					public void onSelect(SelectEvent event) {
						eventBus.fireEvent(new RibbonEvent(RibbonType.COLUMNFILTER));
					}
				});

		columnLayout.setWidget(0, 0, filterColumnButton);
		columnLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);

		
		replaceValueBatchButton = new TextButton("Replace Batch",
				TabularDataResources.INSTANCE.columnReplaceBatch32());
		replaceValueBatchButton.disable();
		replaceValueBatchButton.setScale(ButtonScale.LARGE);
		replaceValueBatchButton.setIconAlign(IconAlign.TOP);
		replaceValueBatchButton
				.setToolTip("Replace column values in batch");
		replaceValueBatchButton
				.setArrowAlign(ButtonArrowAlign.BOTTOM);
		replaceValueBatchButton
				.addSelectHandler(new SelectHandler() {

					public void onSelect(SelectEvent event) {
						eventBus.fireEvent(new RibbonEvent(RibbonType.COLUMNBATCHREPLACE));
					}
				});

		columnLayout.setWidget(0, 1, replaceValueBatchButton);
		columnLayout.getFlexCellFormatter().setRowSpan(0, 1, 2);
	
		cleanCells(columnLayout.getElement());

		eventBus.addHandler(UIStateEvent.TYPE,
				new UIStateEvent.UIStateHandler() {

					public void onUIState(UIStateEvent event) {
						setUI(event);

					}
				});

	}

	protected void cleanCells(Element elem) {
		NodeList<Element> tds = elem.<XElement> cast().select("td");
		for (int i = 0; i < tds.getLength(); i++) {
			Element td = tds.getItem(i);

			if (!td.hasChildNodes() && td.getClassName().equals("")) {
				td.removeFromParent();
			}
		}
	}
	
	
	public void setUI(UIStateEvent event) {
		UIStateType uiStateType = event.getUIStateType();
		try {
			switch (uiStateType) {
			case START:
				// Table
				//filterButton.disable();
				unionButton.disable();
				groupbyButton.disable();
				timeAggregationButton.disable();
				//aggregateButton.disable();
				addRowButton.disable();
				deleteRowButton.disable();
				deleteDuplicateButton.disable();
				//annotationButton.disable();	
				// Column
				filterColumnButton.disable();
				replaceValueBatchButton.disable();
				break;
			case TR_CLOSE:
			case TR_READONLY:	
				// Table
				//filterButton.disable();
				unionButton.disable();
				groupbyButton.disable();
				timeAggregationButton.disable();
				//aggregateButton.disable();
				addRowButton.disable();
				deleteRowButton.disable();
				deleteDuplicateButton.disable();
				//annotationButton.disable();	
				// Column
				filterColumnButton.disable();
				replaceValueBatchButton.disable();
				break;
			case TR_OPEN:
			case TABLEUPDATE:
			case TABLECURATION:	
				// Table
				//filterButton.disable();
				unionButton.enable();
				groupbyButton.enable();
				timeAggregationButton.enable();
				//aggregateButton.disable();
				addRowButton.enable();
				deleteRowButton.enable();
				deleteDuplicateButton.enable();
				//annotationButton.disable();	
				// Column
				filterColumnButton.disable();
				replaceValueBatchButton.disable();
				break;
			case WIZARD_OPEN:
				// Table
				//filterButton.disable();
				unionButton.disable();
				groupbyButton.disable();
				timeAggregationButton.disable();
				//aggregateButton.disable();
				addRowButton.disable();
				deleteRowButton.disable();
				deleteDuplicateButton.disable();
				//annotationButton.disable();	
				// Column
				filterColumnButton.disable();
				replaceValueBatchButton.disable();
				break;
			default:
				break;
			}
		} catch (Exception e) {
			Log.error("setUI Error on Ribbon Curation: " + e.getLocalizedMessage());
		}
	}

}
