/**
 * 
 */
package org.gcube.portlets.user.td.client.ribbon;

import org.gcube.portlets.user.td.client.resource.TabularDataResources;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.RibbonEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.UIStateEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.RibbonType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.UIStateType;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell.ButtonArrowAlign;
import com.sencha.gxt.cell.core.client.ButtonCell.ButtonScale;
import com.sencha.gxt.cell.core.client.ButtonCell.IconAlign;
import com.sencha.gxt.core.client.dom.XElement;
import com.sencha.gxt.widget.core.client.button.ButtonGroup;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 * 
 */
public class AnalyseToolBar {

	protected EventBus eventBus;
	protected ToolBar toolBar;

	protected TextButton pieButton;
	protected TextButton barButton;
	protected TextButton curveButton;
	protected TextButton bullsButton;
	protected TextButton statisticalButton;
	protected TextButton rstudioButton;

	protected TextButton gisButton;
	protected TextButton spreadButton;
	protected TextButton filterButton;
	protected TextButton unionButton;
	protected TextButton groupbyButton;
	protected TextButton aggregateButton;
	protected TextButton addRowButton;
	protected TextButton deleteRowButton;
	protected TextButton deleteDuplicateButton;
	// protected TextButton annotationButton;
	protected TextButton filterColumnButton;
	protected TextButton replaceValueBatchButton;

	public AnalyseToolBar(EventBus eventBus) {
		this.eventBus = eventBus;
		build();
	}

	public ToolBar getToolBar() {
		return toolBar;
	}

	protected void build() {
		toolBar = new ToolBar();
		toolBar.setSpacing(1);
		toolBar.setEnableOverflow(false);

		// Table Group
		ButtonGroup tableGroup = new ButtonGroup();
		tableGroup.setId("Table");
		tableGroup.setStyleName("ribbon");
		tableGroup.setHeadingText("Table");
		tableGroup.disable();
		//toolBar.add(tableGroup);

		FlexTable tableLayout = new FlexTable();
		tableGroup.add(tableLayout);

		filterButton = new TextButton("Filter",
				TabularDataResources.INSTANCE.filter32());
		filterButton.setScale(ButtonScale.LARGE);
		filterButton.setIconAlign(IconAlign.TOP);
		filterButton.setToolTip("Filter table data");
		filterButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		filterButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				// eventBus.fireEvent(new
				// RibbonEvent(RibbonType.TABLEAGGREAGETE));
			}
		});

		tableLayout.setWidget(0, 0, filterButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);

		unionButton = new TextButton("Union",
				TabularDataResources.INSTANCE.union32());
		unionButton.setScale(ButtonScale.LARGE);
		unionButton.setIconAlign(IconAlign.TOP);
		unionButton.setToolTip("Merge tables data");
		unionButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		unionButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				// eventBus.fireEvent(new
				// RibbonEvent(RibbonType.TABLEAGGREAGETE));
			}
		});

		tableLayout.setWidget(0, 1, unionButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 1, 2);

		groupbyButton = new TextButton("Group By",
				TabularDataResources.INSTANCE.group32());
		groupbyButton.setScale(ButtonScale.LARGE);
		groupbyButton.setIconAlign(IconAlign.TOP);
		groupbyButton.setToolTip("Perform data grouping");
		groupbyButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		groupbyButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				// eventBus.fireEvent(new
				// RibbonEvent(RibbonType.TABLEAGGREAGETE));
			}
		});

		tableLayout.setWidget(0, 2, groupbyButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 2, 2);

		aggregateButton = new TextButton("Aggregate",
				TabularDataResources.INSTANCE.aggregate32());
		aggregateButton.setScale(ButtonScale.LARGE);
		aggregateButton.setIconAlign(IconAlign.TOP);
		aggregateButton.setToolTip("Performs data aggregation");
		aggregateButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		aggregateButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				// eventBus.fireEvent(new
				// RibbonEvent(RibbonType.TABLEAGGREAGETE));
			}
		});

		tableLayout.setWidget(0, 3, aggregateButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 3, 2);

		addRowButton = new TextButton("Add Row",
				TabularDataResources.INSTANCE.rowInsert32());
		addRowButton.setScale(ButtonScale.LARGE);
		addRowButton.setIconAlign(IconAlign.TOP);
		addRowButton.setToolTip("Add row");
		addRowButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		addRowButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				// eventBus.fireEvent(new
				// RibbonEvent(RibbonType.TABLEAGGREAGETE));
			}
		});

		tableLayout.setWidget(0, 4, addRowButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 4, 2);

		deleteRowButton = new TextButton("Delete Row",
				TabularDataResources.INSTANCE.rowRemove32());
		deleteRowButton.setScale(ButtonScale.LARGE);
		deleteRowButton.setIconAlign(IconAlign.TOP);
		deleteRowButton.setToolTip("Delete row");
		deleteRowButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		deleteRowButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				// eventBus.fireEvent(new
				// RibbonEvent(RibbonType.TABLEAGGREAGETE));
			}
		});

		tableLayout.setWidget(0, 5, deleteRowButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 5, 2);

		deleteDuplicateButton = new TextButton("Delete Duplicate",
				TabularDataResources.INSTANCE.tableDuplicateRowsRemove32());
		deleteDuplicateButton.setScale(ButtonScale.LARGE);
		deleteDuplicateButton.setIconAlign(IconAlign.TOP);
		deleteDuplicateButton.setToolTip("Delete duplicate row");
		deleteDuplicateButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		deleteDuplicateButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				// eventBus.fireEvent(new
				// RibbonEvent(RibbonType.TABLEAGGREAGETE));
			}
		});

		tableLayout.setWidget(0, 6, deleteDuplicateButton);
		tableLayout.getFlexCellFormatter().setRowSpan(0, 6, 2);
		cleanCells(tableLayout.getElement());

		// Column Group
		ButtonGroup columnGroup = new ButtonGroup();
		columnGroup.setId("Column");
		columnGroup.setStyleName("ribbon");
		columnGroup.setHeadingText("Column");
		columnGroup.disable();
		//toolBar.add(columnGroup);

		FlexTable columnLayout = new FlexTable();
		columnGroup.add(columnLayout);

		filterColumnButton = new TextButton("Filter",
				TabularDataResources.INSTANCE.columnFilter32());
		filterColumnButton.setScale(ButtonScale.LARGE);
		filterColumnButton.setIconAlign(IconAlign.TOP);
		filterColumnButton
				.setToolTip("Filter column values according to an condition");
		filterColumnButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		filterColumnButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				// eventBus.fireEvent(new
				// RibbonEvent(RibbonType.TABLEAGGREAGETE));
			}
		});

		columnLayout.setWidget(0, 0, filterColumnButton);
		columnLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);

		replaceValueBatchButton = new TextButton("Replace Batch",
				TabularDataResources.INSTANCE.columnReplaceBatch32());
		replaceValueBatchButton.setScale(ButtonScale.LARGE);
		replaceValueBatchButton.setIconAlign(IconAlign.TOP);
		replaceValueBatchButton.setToolTip("Replace column values in batch");
		replaceValueBatchButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		replaceValueBatchButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				// eventBus.fireEvent(new
				// RibbonEvent(RibbonType.TABLEAGGREAGETE));
			}
		});

		columnLayout.setWidget(0, 1, replaceValueBatchButton);
		columnLayout.getFlexCellFormatter().setRowSpan(0, 1, 2);

		cleanCells(columnLayout.getElement());

		// Charts Group
		ButtonGroup chartsGroup = new ButtonGroup();
		chartsGroup.setId("Charts");
		chartsGroup.setStyleName("ribbon");
		chartsGroup.setHeadingText("Charts");
		chartsGroup.disable();
		toolBar.add(chartsGroup);

		FlexTable basicLayout = new FlexTable();
		chartsGroup.add(basicLayout);

		pieButton = new TextButton("Pie",
				TabularDataResources.INSTANCE.chartPie32());
		pieButton.setScale(ButtonScale.LARGE);
		pieButton.setIconAlign(IconAlign.TOP);
		pieButton.setToolTip("Pie");
		pieButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		pieButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				// eventBus.fireEvent(new
				// RibbonEvent(RibbonType.TABLEAGGREAGETE));
			}
		});

		basicLayout.setWidget(0, 0, pieButton);
		basicLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);

		barButton = new TextButton("Bar",
				TabularDataResources.INSTANCE.chartBar32());
		barButton.setScale(ButtonScale.LARGE);
		barButton.setIconAlign(IconAlign.TOP);
		barButton.setToolTip("Bar");
		barButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		barButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				// eventBus.fireEvent(new
				// RibbonEvent(RibbonType.TABLEAGGREAGETE));
			}
		});

		basicLayout.setWidget(0, 1, barButton);
		basicLayout.getFlexCellFormatter().setRowSpan(0, 1, 2);

		curveButton = new TextButton("Curve",
				TabularDataResources.INSTANCE.chartCurve32());
		curveButton.setScale(ButtonScale.LARGE);
		curveButton.setIconAlign(IconAlign.TOP);
		curveButton.setToolTip("Curve");
		curveButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		curveButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				// eventBus.fireEvent(new
				// RibbonEvent(RibbonType.TABLEAGGREAGETE));
			}
		});

		basicLayout.setWidget(0, 2, curveButton);
		basicLayout.getFlexCellFormatter().setRowSpan(0, 2, 2);

		bullsButton = new TextButton("Bulls",
				TabularDataResources.INSTANCE.chartBulls32());
		bullsButton.setScale(ButtonScale.LARGE);
		bullsButton.setIconAlign(IconAlign.TOP);
		bullsButton.setToolTip("Bulls");
		bullsButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		bullsButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				// eventBus.fireEvent(new
				// RibbonEvent(RibbonType.TABLEAGGREAGETE));
			}
		});

		basicLayout.setWidget(0, 3, bullsButton);
		basicLayout.getFlexCellFormatter().setRowSpan(0, 3, 2);

		cleanCells(basicLayout.getElement());

		// Process
		ButtonGroup processGroup = new ButtonGroup();
		processGroup.setId("Process");
		processGroup.setStyleName("ribbon");
		processGroup.setHeadingText("Process");
		processGroup.enable();
		toolBar.add(processGroup);

		FlexTable processLayout = new FlexTable();
		processGroup.add(processLayout);

		rstudioButton = new TextButton("R Studio",
				TabularDataResources.INSTANCE.rstudio32());
		rstudioButton.disable();
		rstudioButton.setScale(ButtonScale.LARGE);
		rstudioButton.setIconAlign(IconAlign.TOP);
		rstudioButton.setToolTip("R Studio");
		rstudioButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		rstudioButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				// eventBus.fireEvent(new
				// RibbonEvent(RibbonType.TABLEAGGREAGETE));
			}
		});

		processLayout.setWidget(0, 0, rstudioButton);
		processLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);

		statisticalButton = new TextButton("Statistical",
				TabularDataResources.INSTANCE.statistical32());
		statisticalButton.disable();
		statisticalButton.setScale(ButtonScale.LARGE);
		statisticalButton.setIconAlign(IconAlign.TOP);
		statisticalButton.setToolTip("Statistical");
		statisticalButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		statisticalButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new
				RibbonEvent(RibbonType.STATISTICAL));
			}
		});

		processLayout.setWidget(0, 1, statisticalButton);
		processLayout.getFlexCellFormatter().setRowSpan(0, 1, 2);

		spreadButton = new TextButton("SPREAD",
				TabularDataResources.INSTANCE.cog32());
		spreadButton.disable();
		spreadButton.setScale(ButtonScale.LARGE);
		spreadButton.setIconAlign(IconAlign.TOP);
		spreadButton.setToolTip("SPREAD");
		spreadButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		spreadButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				// eventBus.fireEvent(new
				// RibbonEvent(RibbonType.TABLEAGGREAGETE));
			}
		});

		processLayout.setWidget(0, 2, spreadButton);
		processLayout.getFlexCellFormatter().setRowSpan(0, 2, 2);

		cleanCells(processLayout.getElement());

		// GIS
		ButtonGroup gisGroup = new ButtonGroup();
		gisGroup.setId("GIS");
		gisGroup.setStyleName("ribbon");
		gisGroup.setHeadingText("GIS");
		toolBar.add(gisGroup);

		FlexTable gisLayout = new FlexTable();
		gisGroup.add(gisLayout);

		gisButton = new TextButton("Create Map",
				TabularDataResources.INSTANCE.gis32());
		gisButton.setScale(ButtonScale.LARGE);
		gisButton.setIconAlign(IconAlign.TOP);
		gisButton.setToolTip("Create Map");
		gisButton.disable();
		gisButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		gisButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.CREATEGISMAP));
			}
		});

		gisLayout.setWidget(0, 0, gisButton);
		gisLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);
		cleanCells(gisLayout.getElement());

		eventBus.addHandler(UIStateEvent.TYPE,
				new UIStateEvent.UIStateHandler() {

					public void onUIState(UIStateEvent event) {
						setUI(event);

					}
				}
		);

	}

	protected void cleanCells(Element elem) {
		NodeList<Element> tds = elem.<XElement> cast().select("td");
		for (int i = 0; i < tds.getLength(); i++) {
			Element td = tds.getItem(i);

			if (!td.hasChildNodes() && td.getClassName().equals("")) {
				td.removeFromParent();
			}
		}
	}

	public void setUI(UIStateEvent event) {
		UIStateType uiStateType = event.getUIStateType();
		try {
			switch (uiStateType) {
			case START:
				gisButton.disable();
				statisticalButton.disable();
				break;
			case TR_CLOSE:
			case TR_READONLY:
				gisButton.disable();
				statisticalButton.disable();
				break;
			case TR_OPEN:
			case TABLEUPDATE:
			case TABLECURATION:
				gisButton.enable();
				statisticalButton.enable();
				break;
			case WIZARD_OPEN:
				gisButton.disable();
				statisticalButton.disable();
				break;
			default:
				break;
			}
		} catch (Exception e) {
			Log.error("setUI Error on Ribbon Curation: "
					+ e.getLocalizedMessage());
		}
	}

}
