package org.gcube.portlets.user.td.client;

import org.gcube.portlets.user.td.client.grid.GridContextMenu;
import org.gcube.portlets.user.td.client.grid.GridHeaderColumnMenu;
import org.gcube.portlets.user.td.client.ribbon.TabularDataRibbon;
import org.gcube.portlets.user.td.client.rpc.TabularDataService;
import org.gcube.portlets.user.td.client.rpc.TabularDataServiceAsync;
import org.gcube.portlets.user.td.toolboxwidget.client.ToolBoxPanel;
import org.gcube.portlets.user.tdwx.client.TabularDataX;
import org.gcube.portlets.user.tdwx.client.TabularDataXGridPanel;
import org.gcube.portlets.user.tdwx.client.event.FailureEvent;
import org.gcube.portlets.user.tdwx.client.event.FailureEventHandler;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.core.client.Style.SelectionMode;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.TabPanel;
import com.sencha.gxt.widget.core.client.container.BorderLayoutContainer;
import com.sencha.gxt.widget.core.client.container.BorderLayoutContainer.BorderLayoutData;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.Viewport;
import com.sencha.gxt.widget.core.client.info.Info;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class TabularDataPortlet implements EntryPoint {

	protected static final String JSP_TAG_ID = "tdp";

	/**
	 * 
	 */
	public static final int TOOLBOX_WIDTH = 300;
	/**
	 * 
	 */
	public static final int TOOLBOX_HEIGHT = 800;

	/**
	 * Create a remote service proxy to talk to the server-side Greeting
	 * service.
	 */
	@SuppressWarnings("unused")
	private final TabularDataServiceAsync greetingService = GWT
			.create(TabularDataService.class);

	// Main Panel
	private static BorderLayoutContainer mainPanelLayout;

	// Private TabularData
	private static TabularDataX tabularData;
	private static ToolBoxPanel toolBoxPanel;
	private static BorderLayoutData westData;

	/**
	 * {@inheritDoc}
	 */
	public void onModuleLoad() {

		/*
		 * Install an UncaughtExceptionHandler which will produce
		 * <code>FATAL</code> log messages
		 */
		Log.setUncaughtExceptionHandler();

		// use deferred command to catch initialization exceptions in
		// onModuleLoad2
		Scheduler.get().scheduleDeferred(new ScheduledCommand() {
			public void execute() {
				loadMainPanel();
			}
		});

	}

	protected void loadMainPanel() {

		TabularDataController controller = new TabularDataController();
		EventBus eventBus = controller.getEventBus();

		tabularData = new TabularDataX(Constants.TDX_DATASOURCE_FACTORY_ID);
		tabularData.addFailureHandler(new FailureEventHandler() {

			public void onFailure(FailureEvent event) {
				Info.display("Error: " + event.getMessage(), event.getCaught()
						.getMessage());

			}
		});

		controller.setTabularData(tabularData);

		// Layout
		mainPanelLayout = new BorderLayoutContainer();
		mainPanelLayout.setId("mainPanelLayout");
		mainPanelLayout.setBorders(true);

		// Ribbon Menu
		TabularDataRibbon tabularDataTooBar = new TabularDataRibbon(eventBus);
		TabPanel toolBarPanel = tabularDataTooBar.getContainer();

		BorderLayoutData toolBarData = new BorderLayoutData(109);
		toolBarData.setMargins(new Margins(5));
		toolBarData.setCollapsible(false);
		toolBarData.setSplit(false);

		mainPanelLayout.setNorthWidget(toolBarPanel, toolBarData);

		// Grid Panel
		final TabularDataXGridPanel gridPanel = tabularData.getGridPanel();
		gridPanel.setHeaderVisible(false);

		GridHeaderColumnMenu columnHeaderMenu = new GridHeaderColumnMenu();
		gridPanel.addGridHeaderContextMenuItems(columnHeaderMenu.getMenu(),
				eventBus);

		GridContextMenu gridContextMenu = new GridContextMenu(gridPanel,
				eventBus);
		gridPanel.setGridContextMenu(gridContextMenu.getMenu());

		gridPanel.setSelectionModel(SelectionMode.MULTI);

		MarginData gridData = new MarginData();
		mainPanelLayout.setCenterWidget(gridPanel, gridData);

		// ToolBox Panel
		toolBoxPanel = new ToolBoxPanel("ToolBoxPanel", eventBus);
		
		westData = new BorderLayoutData(310);
		westData.setCollapsible(true);
		westData.setSplit(false);
		westData.setFloatable(false);
		westData.setCollapseMini(true);
		westData.setMargins(new Margins(0, 5, 0, 5));
		westData.setCollapseHidden(true);
		
		
		mainPanelLayout.setWestWidget(toolBoxPanel, westData);
		toolBoxPanel.expand();
		toolBoxPanel.enable();

		controller.setToolBoxPanel(toolBoxPanel);
		controller.setWestData(westData);

		bind(mainPanelLayout);
		// menu(gridPanel);
		controller.restoreUISession();
	}

	protected void bind(BorderLayoutContainer mainWidget) {
		try {
			RootPanel root = RootPanel.get(JSP_TAG_ID);
			Log.info("Root Panel: " + root);
			if (root == null) {
				Log.info("Div with id " + JSP_TAG_ID
						+ " not found, starting in dev mode");
				Viewport viewport = new Viewport();
				viewport.setWidget(mainWidget);
				viewport.onResize();
				RootPanel.get().add(viewport);
			} else {
				Log.info("Application div with id " + JSP_TAG_ID
						+ " found, starting in portal mode");
				PortalViewport viewport = new PortalViewport();
				Log.info("Created Viewport");
				viewport.setEnableScroll(false);
				viewport.setWidget(mainWidget);
				Log.info("Set Widget");
				Log.info("getOffsetWidth(): " + viewport.getOffsetWidth());
				Log.info("getOffsetHeight(): " + viewport.getOffsetHeight());
				viewport.onResize();
				root.add(viewport);
				Log.info("Added viewport to root");
			}
		} catch (Exception e) {
			e.printStackTrace();
			Log.error("Error in attach viewport:" + e.getLocalizedMessage());
		}
	}

}
