/**
 * 
 */
package org.gcube.portlets.user.td.gwtservice.server;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpSession;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.Profile;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.utils.Licence;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TemplateDescription;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.ValidationDescriptor;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.metadata.Locales;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ViewColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.DescriptionsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.TableDescriptorMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.Validation;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ValidationsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.ExportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GenericMapMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.ImportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.VersionMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTemplateException;
import org.gcube.data.analysis.tabulardata.service.impl.TabularDataServiceFactory;
import org.gcube.data.analysis.tabulardata.service.operation.Job;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.TaskId;
import org.gcube.data.analysis.tabulardata.service.tabular.HistoryStep;
import org.gcube.data.analysis.tabulardata.service.tabular.HistoryStepId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.AgencyMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.DescriptionMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.LicenceMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.NameMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.RightsMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.TabularResourceMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.ValidSinceMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.ValidUntilMetadata;
import org.gcube.data.analysis.tabulardata.service.template.TemplateId;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryDescriptor;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryInterfaceType;
import org.gcube.datapublishing.sdmx.impl.model.GCubeSDMXRegistryDescriptor;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTService;
import org.gcube.portlets.user.td.gwtservice.server.file.CSVFileUploadSession;
import org.gcube.portlets.user.td.gwtservice.server.file.CodelistMappingFileUploadSession;
import org.gcube.portlets.user.td.gwtservice.server.file.FileUtil;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4AddColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ChangeColumnType;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ChangeTableType;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4Clone;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4CodelistMapping;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4DeleteColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4DeleteRows;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4Denormalization;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4Duplicates;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4EditRow;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ExtractCodelist;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4FilterColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4GroupBy;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4LabelColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4MergeColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4Normalization;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ReplaceBatch;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ReplaceColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4SplitColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4Union;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionDirector;
import org.gcube.portlets.user.td.gwtservice.server.storage.FilesStorage;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ExtractReferences;
import org.gcube.portlets.user.td.gwtservice.server.trservice.LicenceMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.QueryService;
import org.gcube.portlets.user.td.gwtservice.server.trservice.TDTypeValueMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.TaskStateMap;
import org.gcube.portlets.user.td.gwtservice.shared.Constants;
import org.gcube.portlets.user.td.gwtservice.shared.OperationsId;
import org.gcube.portlets.user.td.gwtservice.shared.UIOperationsId;
import org.gcube.portlets.user.td.gwtservice.shared.codelisthelper.CodelistMappingSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.AvailableCharsetList;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVFileUtil;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVParserConfiguration;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CheckCSVSession;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.extract.ExtractCodelistSession;
import org.gcube.portlets.user.td.gwtservice.shared.file.FileUploadMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.file.FileUploadState;
import org.gcube.portlets.user.td.gwtservice.shared.file.HeaderPresence;
import org.gcube.portlets.user.td.gwtservice.shared.history.OpHistory;
import org.gcube.portlets.user.td.gwtservice.shared.history.RollBackSession;
import org.gcube.portlets.user.td.gwtservice.shared.licenses.LicenceData;
import org.gcube.portlets.user.td.gwtservice.shared.monitor.OperationMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.monitor.OperationMonitorCreator;
import org.gcube.portlets.user.td.gwtservice.shared.monitor.OperationMonitorSession;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.share.Contacts;
import org.gcube.portlets.user.td.gwtservice.shared.share.ShareInfo;
import org.gcube.portlets.user.td.gwtservice.shared.source.SDMXRegistrySource;
import org.gcube.portlets.user.td.gwtservice.shared.source.SourceType;
import org.gcube.portlets.user.td.gwtservice.shared.task.InvocationS;
import org.gcube.portlets.user.td.gwtservice.shared.task.JobS;
import org.gcube.portlets.user.td.gwtservice.shared.task.State;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResubmitSession;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResumeSession;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskS;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskWrapper;
import org.gcube.portlets.user.td.gwtservice.shared.task.ValidationsTasksMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateApplySession;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateData;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateDeleteSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnViewData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ConditionCodeMap;
import org.gcube.portlets.user.td.gwtservice.shared.tr.DimensionRow;
import org.gcube.portlets.user.td.gwtservice.shared.tr.RefColumn;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TableData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.Occurrences;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.OccurrencesForReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.clone.CloneTabularResourceSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.AddColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.FilterColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.MergeColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.SplitColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.mapping.ColumnMappingData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.groupby.GroupBySession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRAgencyMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRDescriptionMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRLicenceMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRLocalizedText;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRNameMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRRightsMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRValidSinceMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRValidUntilMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.normalization.DenormalizationSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.normalization.NormalizationSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.open.TDOpenSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadConfig;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadResult;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.Direction;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.OrderInfo;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DeleteRowsSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DuplicatesSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.EditRowSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.Validations;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabDescriptionsMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabExportMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabGenericMapMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabImportMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabNamesMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabValidationsMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabVersionMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Agencies;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Codelist;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Dataset;
import org.gcube.portlets.user.td.gwtservice.shared.tr.union.UnionSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.RelationshipData;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class TDGWTServiceImpl extends RemoteServiceServlet implements
		TDGWTService {

	private static final long serialVersionUID = -5707400086333186368L;
	protected static Logger logger = LoggerFactory
			.getLogger(TDGWTServiceImpl.class);

	protected static SimpleDateFormat sdf = new SimpleDateFormat(
			"yyyy-MM-dd HH:mm");

	protected static SimpleDateFormat sdfDate = new SimpleDateFormat(
			"yyyy-MM-dd");

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public String hello() throws TDGWTServiceException {
		HttpSession session = this.getThreadLocalRequest().getSession();
		ASLSession aslSession = SessionUtil.getAslSession(session);
		String user = aslSession.getUsername();
		return user;
	}

	/**
	 * 
	 * {@inheritDoc}
	 */

	public void setTabResource(TabResource tabResource)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.getAslSession(session);

			if (tabResource == null) {
				logger.error("Error setting TabResource: null");
				throw new TDGWTServiceException(
						"Error setting TabResource: null");
			}

			SessionUtil.setTabResource(session, tabResource);
			SessionUtil.setTRId(session, tabResource.getTrId());
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.error(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public TRId getCurrentTRId() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.getAslSession(session);

			TabResource currentTR = SessionUtil.getTabResource(session);
			logger.debug("getCurrentTRId()");
			if (currentTR == null) {
				logger.error("CURRENT_TABULAR_RESOURCE is null");
				throw new TDGWTServiceException(
						"CURRENT_TABULAR_RESOURCE is null");
			}
			logger.debug("getCurrentTRId():" + currentTR.toString());

			if (currentTR.getTrId() == null) {
				logger.error("CURRENT_TABULAR_RESOURCE has TRId null");
				throw new TDGWTServiceException(
						"CURRENT_TABULAR_RESOURCE has TRId null");
			}
			logger.debug("getCurrentTRId():" + currentTR.getTrId());
			return currentTR.getTrId();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error("getCurrentTRID(): " + e.getLocalizedMessage(), e);
			throw new TDGWTServiceException("Error retrieving TR id: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public TabResource getTabResourceInformation() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();

			ASLSession aslSession = SessionUtil.getAslSession(session);

			TabResource currentTR = SessionUtil.getTabResource(session);
			if (currentTR == null) {
				logger.error("CURRENT_TABULAR_RESOURCE is null");
				throw new TDGWTServiceException(
						"CURRENT_TABULAR_RESOURCE is null");
			}
			logger.debug("GetTabResourceInformation():" + currentTR.toString());

			if (currentTR.getTrId() == null) {
				logger.error("CURRENT_TABULAR_RESOURCE has TRId null");
				throw new TDGWTServiceException(
						"CURRENT_TABULAR_RESOURCE has TRId null");
			}
			logger.debug("Current TRId: " + currentTR.getTrId());

			ArrayList<TRMetadata> trMetadatas = getTRMetadata(currentTR
					.getTrId());
			updateTabResourceInformation(currentTR, trMetadatas);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResource tr = service
					.getTabularResource(new TabularResourceId(Long
							.valueOf(currentTR.getTrId().getId())));

			currentTR.setDate(sdf.format(tr.getCreationDate().getTime()));
			currentTR.setValid(tr.isValid());
			currentTR.setFinalized(tr.isFinalized());
			currentTR.setLocked(tr.isLocked());
			Contacts owner = new Contacts("", tr.getOwner(), false);
			currentTR.setOwner(owner);
			SessionUtil.setTabResource(session, currentTR);
			logger.debug("GetTabResourceInformation() updated information:"
					+ currentTR.toString());
			return currentTR;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public TabResource getTabResourceInformation(TRId trId)
			throws TDGWTServiceException {
		try {

			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			if (trId == null) {
				logger.error("GetTabularREsourceInformation TRId is null");
				throw new TDGWTServiceException(
						"GetTabularREsourceInformation TRId is  null");
			}

			logger.debug("GetTabResourceInformation:" + trId);
			TabResource currentTR = new TabResource();
			currentTR.setTrId(trId);

			ArrayList<TRMetadata> trMetadatas = getTRMetadata(currentTR
					.getTrId());
			updateTabResourceInformation(currentTR, trMetadatas);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResource tr = service
					.getTabularResource(new TabularResourceId(Long
							.valueOf(currentTR.getTrId().getId())));
			logger.debug("GetTabResourceInformation() TR on service: " + tr);

			currentTR.setDate(sdf.format(tr.getCreationDate().getTime()));
			currentTR.setValid(tr.isValid());
			currentTR.setFinalized(tr.isFinalized());
			currentTR.setLocked(tr.isLocked());
			Contacts owner = new Contacts("", tr.getOwner(), false);
			currentTR.setOwner(owner);
			logger.debug("GetTabResourceInformation() updated information:"
					+ currentTR);
			return currentTR;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage());
		}
	}

	protected void updateTabResourceInformation(TabResource tabResource,
			ArrayList<TRMetadata> trMetadatas) {

		for (TRMetadata trMetadata : trMetadatas) {
			if (trMetadata instanceof TRDescriptionMetadata) {
				tabResource.setDescription(((TRDescriptionMetadata) trMetadata)
						.getValue());
			} else {
				if (trMetadata instanceof TRNameMetadata) {
					tabResource.setName(((TRNameMetadata) trMetadata)
							.getValue());
				} else {
					if (trMetadata instanceof TRAgencyMetadata) {
						tabResource.setAgency(((TRAgencyMetadata) trMetadata)
								.getValue());
					} else {
						if (trMetadata instanceof TRRightsMetadata) {
							tabResource
									.setRight(((TRRightsMetadata) trMetadata)
											.getValue());
						} else {
							if (trMetadata instanceof TRValidSinceMetadata) {
								tabResource
										.setValidFrom(((TRValidSinceMetadata) trMetadata)
												.getValue());
							} else {
								if (trMetadata instanceof TRValidUntilMetadata) {
									tabResource
											.setValidUntilTo(((TRValidUntilMetadata) trMetadata)
													.getValue());
								} else {
									if (trMetadata instanceof TRLicenceMetadata) {
										tabResource
												.setLicence(((TRLicenceMetadata) trMetadata)
														.getValue());
									} else {

									}
								}
							}
						}

					}
				}
			}
		}
	}

	/**
	 * Returns ArrayList<ColumnData> other than IdColumnType,
	 * ValidationColumnType and ViewColumn
	 * 
	 * {@inheritDoc}
	 */
	public ArrayList<ColumnData> getColumns() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			TabResource currentTR = SessionUtil.getTabResource(session);
			if (currentTR == null) {
				logger.error("CURRENT_TABULAR_RESOURCE is null");
				throw new TDGWTServiceException(
						"CURRENT_TABULAR_RESOURCE is null");
			}
			TRId trId = currentTR.getTrId();

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getLastTable(new TabularResourceId(Long
					.valueOf(trId.getId())));

			ArrayList<ColumnData> columns = new ArrayList<ColumnData>();

			List<Column> cols = table.getColumns();
			int i = 0;

			for (Column c : cols) {
				if (c.getColumnType() instanceof IdColumnType
						|| c.getColumnType() instanceof ValidationColumnType) {

				} else {
					if (c.contains(ViewColumnMetadata.class)) {

					} else {
						ColumnData cData = new ColumnData();

						cData.setId(Integer.toString(i));
						cData.setColumnId(c.getLocalId().getValue());
						cData.setName(c.getName());
						cData.setTypeCode(c.getColumnType().getCode());
						cData.setTypeName(c.getColumnType().getName());
						cData.setDataTypeName(c.getDataType().getName());
						ColumnRelationship rel = c.getRelationship();
						if (rel != null) {
							RelationshipData relData = new RelationshipData(rel
									.getTargetTableId().getValue(), rel
									.getTargetColumnId().getValue());
							cData.setRelationship(relData);

						}
						NamesMetadata labelsMetadata = null;
						try {
							labelsMetadata = c.getMetadata(NamesMetadata.class);
						} catch (NoSuchMetadataException e) {
							logger.debug("labelMetadata: NoSuchMetadataException "
									+ e.getLocalizedMessage());
						}

						if (labelsMetadata == null) {
							cData.setLabel("nolabel");
							logger.debug("LabelsMetadata no labels");
						} else {
							LocalizedText cl = null;
							cl = labelsMetadata.getTextWithLocale("en");
							if (cl == null) {
								cData.setLabel("nolabel");
								logger.debug("ColumnLabel no label in en");
							} else {
								if (cl.getValue() == null
										|| cl.getValue().isEmpty()) {
									cData.setLabel("nolabel");
									logger.debug("ColumnLabel no label in en");
								} else {
									cData.setLabel(cl.getValue());
									logger.debug("Column Set Label: "
											+ cl.getValue());
								}
							}
						}

						DataLocaleMetadata dataLocaleMetadata = null;
						try {
							dataLocaleMetadata = c
									.getMetadata(DataLocaleMetadata.class);
						} catch (NoSuchMetadataException e) {
							logger.debug("DataLocaleMetadata: NoSuchMetadataException "
									+ e.getLocalizedMessage());
						}

						if (dataLocaleMetadata == null) {
							logger.debug("No DataLocaleMetadata");
						} else {
							cData.setLocale(dataLocaleMetadata.getLocale());
						}

						cData.setTrId(trId);
						columns.add(cData);
						i++;
					}
				}
			}

			return columns;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error retrieving Columns: " + e.getLocalizedMessage(), e);
			throw new TDGWTServiceException("Error retrieving Columns: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * Returns ArrayList<ColumnData> other than IdColumnType,
	 * ValidationColumnType and ViewColumn
	 * 
	 * 
	 * {@inheritDoc}
	 */
	public ArrayList<ColumnData> getColumns(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			logger.debug("getColumns():" + trId.toString());

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));

			ArrayList<ColumnData> columns = new ArrayList<ColumnData>();

			List<Column> cols = table.getColumns();
			int i = 0;
			for (Column c : cols) {
				if (c.getColumnType() instanceof IdColumnType
						|| c.getColumnType() instanceof ValidationColumnType) {

				} else {
					if (c.contains(ViewColumnMetadata.class)) {

					} else {
						ColumnData cData = new ColumnData();
						cData.setId(Integer.toString(i));
						cData.setColumnId(c.getLocalId().getValue());
						cData.setName(c.getName());
						cData.setTypeCode(c.getColumnType().getCode());
						cData.setTypeName(c.getColumnType().getName());
						cData.setDataTypeName(c.getDataType().getName());
						ColumnRelationship rel = c.getRelationship();
						if (rel != null) {
							RelationshipData relData = new RelationshipData(rel
									.getTargetTableId().getValue(), rel
									.getTargetColumnId().getValue());
							cData.setRelationship(relData);

						}
						NamesMetadata labelsMetadata = null;
						try {
							labelsMetadata = c.getMetadata(NamesMetadata.class);
						} catch (NoSuchMetadataException e) {
							logger.debug("labelMetadata: NoSuchMetadataException "
									+ e.getLocalizedMessage());
						}

						if (labelsMetadata == null) {
							cData.setLabel("nolabel");
							logger.debug("LabelsMetadata no labels");
						} else {
							LocalizedText cl = null;
							cl = labelsMetadata.getTextWithLocale("en");
							if (cl == null) {
								cData.setLabel("nolabel");
								logger.debug("ColumnLabel no label in en");
							} else {
								if (cl.getValue() == null
										|| cl.getValue().isEmpty()) {
									cData.setLabel("nolabel");
									logger.debug("ColumnLabel no label in en");
								} else {
									cData.setLabel(cl.getValue());
									logger.debug("Column Set Label: "
											+ cl.getValue());
								}
							}
						}

						DataLocaleMetadata dataLocaleMetadata = null;
						try {
							dataLocaleMetadata = c
									.getMetadata(DataLocaleMetadata.class);
						} catch (NoSuchMetadataException e) {
							logger.debug("DataLocaleMetadata: NoSuchMetadataException "
									+ e.getLocalizedMessage());
						}

						if (dataLocaleMetadata == null) {
							logger.debug("No DataLocaleMetadata");
						} else {
							cData.setLocale(dataLocaleMetadata.getLocale());
						}

						cData.setTrId(trId);
						columns.add(cData);
						i++;

					}
				}
			}

			return columns;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error retrieving Columns: " + e.getLocalizedMessage(), e);
			throw new TDGWTServiceException("Error retrieving Columns: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public ColumnData getColumn(String columnLocalId, TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));

			ColumnData cData = new ColumnData();
			ColumnLocalId columnId = new ColumnLocalId(columnLocalId);
			Column c = table.getColumnById(columnId);
			if (c.getColumnType() instanceof IdColumnType) {

			} else {
				cData.setId(Integer.toString(0));
				cData.setColumnId(c.getLocalId().getValue());
				cData.setName(c.getName());

				if (c.contains(ViewColumnMetadata.class)) {
					ViewColumnMetadata viewMetadata = c
							.getMetadata(ViewColumnMetadata.class);
					logger.debug("ViewColumnMetadata: "
							+ viewMetadata.toString());

					String sourceTableDimensionColumnId = viewMetadata
							.getSourceTableDimensionColumnId().getValue();
					String targetTableColumnId = viewMetadata
							.getTargetTableColumnId().getValue();
					long targetTableId = viewMetadata.getTargetTableId()
							.getValue();
					ColumnViewData columnViewData = new ColumnViewData(
							sourceTableDimensionColumnId, targetTableColumnId,
							targetTableId);
					cData.setColumnViewData(columnViewData);
					cData.setViewColumn(true);

				} else {
					cData.setViewColumn(false);
				}
				cData.setTypeCode(c.getColumnType().getCode());
				cData.setTypeName(c.getColumnType().getName());
				cData.setDataTypeName(c.getDataType().getName());
				ColumnRelationship rel = c.getRelationship();
				if (rel != null) {
					RelationshipData relData = new RelationshipData(rel
							.getTargetTableId().getValue(), rel
							.getTargetColumnId().getValue());
					cData.setRelationship(relData);

				}
				NamesMetadata labelsMetadata = null;
				try {
					labelsMetadata = c.getMetadata(NamesMetadata.class);
				} catch (NoSuchMetadataException e) {
					logger.debug("labelMetadata: NoSuchMetadataException "
							+ e.getLocalizedMessage());
				}

				if (labelsMetadata == null) {
					cData.setLabel("nolabel");
					logger.debug("LabelsMetadata no labels");
				} else {
					LocalizedText cl = null;
					cl = labelsMetadata.getTextWithLocale("en");
					if (cl == null) {
						cData.setLabel("nolabel");
						logger.debug("ColumnLabel no label in en");
					} else {
						if (cl.getValue() == null || cl.getValue().isEmpty()) {
							cData.setLabel("nolabel");
							logger.debug("ColumnLabel no label in en");
						} else {
							cData.setLabel(cl.getValue());
							logger.debug("Column Set Label: " + cl.getValue());
						}
					}
				}

				DataLocaleMetadata dataLocaleMetadata = null;
				try {
					dataLocaleMetadata = c
							.getMetadata(DataLocaleMetadata.class);
				} catch (NoSuchMetadataException e) {
					logger.debug("DataLocaleMetadata: NoSuchMetadataException "
							+ e.getLocalizedMessage());
				}

				if (dataLocaleMetadata == null) {
					logger.debug("No DataLocaleMetadata");
				} else {
					cData.setLocale(dataLocaleMetadata.getLocale());
				}

				cData.setTrId(trId);

			}

			return cData;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error("Error retrieving Column: " + e.getLocalizedMessage(),
					e);
			throw new TDGWTServiceException("Error retrieving Column: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public ColumnData getColumn(TRId trId, String columnName)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));

			ColumnData cData = new ColumnData();

			Column c = table.getColumnByName(columnName);
			if (c.getColumnType() instanceof IdColumnType) {

			} else {
				cData.setId(Integer.toString(0));
				cData.setColumnId(c.getLocalId().getValue());
				cData.setName(c.getName());

				if (c.contains(ViewColumnMetadata.class)) {
					ViewColumnMetadata viewMetadata = c
							.getMetadata(ViewColumnMetadata.class);
					logger.debug("ViewColumnMetadata: "
							+ viewMetadata.toString());

					String sourceTableDimensionColumnId = viewMetadata
							.getSourceTableDimensionColumnId().getValue();
					String targetTableColumnId = viewMetadata
							.getTargetTableColumnId().getValue();
					long targetTableId = viewMetadata.getTargetTableId()
							.getValue();
					ColumnViewData columnViewData = new ColumnViewData(
							sourceTableDimensionColumnId, targetTableColumnId,
							targetTableId);
					cData.setColumnViewData(columnViewData);
					cData.setViewColumn(true);

				} else {
					cData.setViewColumn(false);
				}
				cData.setTypeCode(c.getColumnType().getCode());
				cData.setTypeName(c.getColumnType().getName());
				cData.setDataTypeName(c.getDataType().getName());
				ColumnRelationship rel = c.getRelationship();
				if (rel != null) {
					RelationshipData relData = new RelationshipData(rel
							.getTargetTableId().getValue(), rel
							.getTargetColumnId().getValue());
					cData.setRelationship(relData);

				}
				NamesMetadata labelsMetadata = null;
				try {
					labelsMetadata = c.getMetadata(NamesMetadata.class);
				} catch (NoSuchMetadataException e) {
					logger.debug("labelMetadata: NoSuchMetadataException "
							+ e.getLocalizedMessage());
				}

				if (labelsMetadata == null) {
					cData.setLabel("nolabel");
					logger.debug("LabelsMetadata no labels");
				} else {
					LocalizedText cl = null;
					cl = labelsMetadata.getTextWithLocale("en");
					if (cl == null) {
						cData.setLabel("nolabel");
						logger.debug("ColumnLabel no label in en");
					} else {
						if (cl.getValue() == null || cl.getValue().isEmpty()) {
							cData.setLabel("nolabel");
							logger.debug("ColumnLabel no label in en");
						} else {
							cData.setLabel(cl.getValue());
							logger.debug("Column Set Label: " + cl.getValue());
						}
					}
				}

				DataLocaleMetadata dataLocaleMetadata = null;
				try {
					dataLocaleMetadata = c
							.getMetadata(DataLocaleMetadata.class);
				} catch (NoSuchMetadataException e) {
					logger.debug("DataLocaleMetadata: NoSuchMetadataException "
							+ e.getLocalizedMessage());
				}

				if (dataLocaleMetadata == null) {
					logger.debug("No DataLocaleMetadata");
				} else {
					cData.setLocale(dataLocaleMetadata.getLocale());
				}

				cData.setTrId(trId);

			}

			return cData;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error("Error retrieving Column: " + e.getLocalizedMessage(),
					e);
			throw new TDGWTServiceException("Error retrieving Column: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public ArrayList<ColumnData> getValidationColumns(TRId trId,
			String columnName) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			logger.debug("getValidationColumns():[" + trId.toString()
					+ " columnName: " + columnName + "]");

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));
			logger.debug("getValidationColumns() on Table: " + table.toString());

			Column columnSource = table.getColumnByName(columnName);
			if (columnSource == null) {
				logger.error("Column not present on table");
				throw new TDGWTServiceException("Column not present on table");
			}

			logger.debug("getValidationColumns(): columnSource "
					+ columnSource.getLocalId());
			String columnSourceId = columnSource.getLocalId().getValue();

			ArrayList<ColumnData> columns = new ArrayList<ColumnData>();

			List<Column> cols = table.getColumns();
			int i = 0;
			for (Column c : cols) {
				if (c.getColumnType() instanceof ValidationColumnType) {
					logger.debug("ValidationColumn present: ["
							+ c.getColumnType() + " " + c.getLocalId() + "]");
					if (c.contains(ValidationReferencesMetadata.class)) {
						logger.debug("ValidationReferencesMetadata present");
						ValidationReferencesMetadata validationReferenceMetadata = c
								.getMetadata(ValidationReferencesMetadata.class);
						List<ColumnLocalId> valColumnList = validationReferenceMetadata
								.getValidationReferenceColumn();
						for (ColumnLocalId columnLocalId : valColumnList) {
							if (columnLocalId.getValue().compareTo(
									columnSourceId) == 0) {
								ColumnData cData = new ColumnData();
								cData.setId(Integer.toString(i));
								cData.setColumnId(c.getLocalId().getValue());
								cData.setName(c.getName());
								cData.setTypeCode(c.getColumnType().getCode());
								cData.setTypeName(c.getColumnType().getName());
								cData.setDataTypeName(c.getDataType().getName());
								NamesMetadata labelsMetadata = null;
								try {
									labelsMetadata = c
											.getMetadata(NamesMetadata.class);
								} catch (NoSuchMetadataException e) {
									logger.debug("labelMetadata: NoSuchMetadataException "
											+ e.getLocalizedMessage());
								}

								if (labelsMetadata == null) {
									cData.setLabel("nolabel");
									logger.debug("LabelsMetadata no labels");
								} else {
									LocalizedText cl = null;
									cl = labelsMetadata.getTextWithLocale("en");
									if (cl == null) {
										cData.setLabel("nolabel");
										logger.debug("ColumnLabel no label in en");
									} else {
										cData.setLabel(cl.getValue());
										logger.debug("Column Set Label: "
												+ cl.getValue());
									}
								}
								cData.setTrId(trId);
								cData.setValidationColumn(true);
								ArrayList<String> validatedColumnReferences = new ArrayList<String>();
								for (ColumnLocalId cLocalId : valColumnList) {
									validatedColumnReferences.add(cLocalId
											.getValue());
								}
								cData.setValidatedColumns(validatedColumnReferences);
								columns.add(cData);
								i++;
								break;
							}
						}

					}
				}

			}
			logger.debug("Validation Column: " + columns.size());
			return columns;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error retrieving Validation Columns: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error retrieving Validation Columns: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public TableData getLastTable(TRId trId) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("getLastTable: " + trId);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getLastTable(new TabularResourceId(Long
					.valueOf(trId.getId())));
			logger.debug("Table retrieved: " + table);

			Table viewTable = null;

			if (table.contains(DatasetViewTableMetadata.class)) {
				DatasetViewTableMetadata dwm = table
						.getMetadata(DatasetViewTableMetadata.class);
				logger.debug("DatasetViewTableMetadata: " + dwm);
				try {
					viewTable = service.getTable(dwm
							.getTargetDatasetViewTableId());
				} catch (Exception e) {
					logger.error("View table not found: "
							+ e.getLocalizedMessage());
				}
			} else {
				logger.debug("Table not contains DataseViewTableMetadata");
			}

			TableData tData = new TableData();
			TRId newTRId;

			if (viewTable == null) {
				logger.debug("ViewTable is null");
				newTRId = new TRId(trId.getId());
				newTRId.setTabularResourceType(trId.getTabularResourceType());
				newTRId.setTableId(String.valueOf(table.getId().getValue()));
				newTRId.setTableType(table.getTableType().getName());
				newTRId.setViewTable(false);
				logger.debug("NewTRId: " + newTRId);
				tData.setTrId(newTRId);

				tData.setName(table.getName());
				tData.setTypeName(table.getTableType().getName());
				tData.setTypeCode(table.getTableType().getCode());
				Collection<TableMetadata> cMeta = table.getAllMetadata();

				tData.setMetaData(cMeta.toString());

				ArrayList<ColumnData> lColumnData = new ArrayList<ColumnData>();
				for (Column column : table.getColumns()) {
					ColumnData colData = new ColumnData();
					colData.setColumnId(column.getLocalId().getValue());
					colData.setName(column.getName());
					colData.setTypeName(column.getColumnType().getName());
					colData.setTypeCode(column.getColumnType().getCode());
					colData.setDataTypeName(column.getDataType().getName());
					colData.setTrId(newTRId);
					ColumnRelationship rel = column.getRelationship();
					if (rel != null) {
						RelationshipData relData = new RelationshipData(rel
								.getTargetTableId().getValue(), rel
								.getTargetColumnId().getValue());
						colData.setRelationship(relData);

					}
					if (column.contains(ViewColumnMetadata.class)) {
						ViewColumnMetadata viewMetadata = column
								.getMetadata(ViewColumnMetadata.class);
						logger.debug("ViewColumnMetadata: "
								+ viewMetadata.toString());

						String sourceTableDimensionColumnId = viewMetadata
								.getSourceTableDimensionColumnId().getValue();
						String targetTableColumnId = viewMetadata
								.getTargetTableColumnId().getValue();
						long targetTableId = viewMetadata.getTargetTableId()
								.getValue();
						ColumnViewData columnViewData = new ColumnViewData(
								sourceTableDimensionColumnId,
								targetTableColumnId, targetTableId);
						colData.setColumnViewData(columnViewData);
						colData.setViewColumn(true);

					} else {
						colData.setViewColumn(false);
					}

					lColumnData.add(colData);
				}

				tData.setListColumnData(lColumnData);

			} else {
				logger.debug("ViewTable is not null");
				newTRId = new TRId(trId.getId());
				newTRId.setTabularResourceType(trId.getTabularResourceType());
				newTRId.setTableId(String.valueOf(viewTable.getId().getValue()));
				newTRId.setTableType(viewTable.getTableType().getName());
				newTRId.setReferenceTargetTableId(String.valueOf(table.getId()
						.getValue()));
				newTRId.setViewTable(true);
				logger.debug("NewTRId: " + newTRId);
				tData.setTrId(newTRId);

				tData.setName(viewTable.getName());
				tData.setTypeName(viewTable.getTableType().getName());
				tData.setTypeCode(viewTable.getTableType().getCode());
				Collection<TableMetadata> cMeta = viewTable.getAllMetadata();

				tData.setMetaData(cMeta.toString());

				ArrayList<ColumnData> lColumnData = new ArrayList<ColumnData>();
				for (Column column : viewTable.getColumns()) {
					ColumnData colData = new ColumnData();
					colData.setColumnId(column.getLocalId().getValue());
					colData.setName(column.getName());
					colData.setTypeName(column.getColumnType().getName());
					colData.setTypeCode(column.getColumnType().getCode());
					colData.setDataTypeName(column.getDataType().getName());
					colData.setTrId(newTRId);
					ColumnRelationship rel = column.getRelationship();
					if (rel != null) {
						RelationshipData relData = new RelationshipData(rel
								.getTargetTableId().getValue(), rel
								.getTargetColumnId().getValue());
						colData.setRelationship(relData);
					}
					if (column.contains(ViewColumnMetadata.class)) {
						ViewColumnMetadata viewMetadata = column
								.getMetadata(ViewColumnMetadata.class);
						logger.debug("ViewColumnMetadata: "
								+ viewMetadata.toString());

						String sourceTableDimensionColumnId = viewMetadata
								.getSourceTableDimensionColumnId().getValue();
						String targetTableColumnId = viewMetadata
								.getTargetTableColumnId().getValue();
						long targetTableId = viewMetadata.getTargetTableId()
								.getValue();
						ColumnViewData columnViewData = new ColumnViewData(
								sourceTableDimensionColumnId,
								targetTableColumnId, targetTableId);
						colData.setColumnViewData(columnViewData);
						colData.setViewColumn(true);

					} else {
						colData.setViewColumn(false);
					}

					lColumnData.add(colData);
				}

				tData.setListColumnData(lColumnData);

			}

			logger.debug("getLastTable: " + tData);
			return tData;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error("Error in getLastTable(): " + e.getLocalizedMessage(),
					e);
			throw new TDGWTServiceException("Error in getLastTable(): "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public TableData getTable(TRId trId) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("getTable(): " + trId);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));

			Table viewTable = null;

			if (table.contains(DatasetViewTableMetadata.class)) {
				DatasetViewTableMetadata dwm = table
						.getMetadata(DatasetViewTableMetadata.class);
				try {
					viewTable = service.getTable(dwm
							.getTargetDatasetViewTableId());
				} catch (Exception e) {
					logger.error("view table not found");
				}
			}

			TableData tData = new TableData();

			if (viewTable == null) {
				logger.debug("ViewTable is null");
				TRId newTRId = new TRId(trId.getId());
				newTRId.setTabularResourceType(trId.getTabularResourceType());
				newTRId.setTableId(String.valueOf(table.getId().getValue()));
				newTRId.setTableType(table.getTableType().getName());
				newTRId.setViewTable(false);
				logger.debug("NewTRId: " + newTRId);
				tData.setTrId(newTRId);

				tData.setName(table.getName());
				tData.setTypeName(table.getTableType().getName());
				tData.setTypeCode(table.getTableType().getCode());
				Collection<TableMetadata> cMeta = table.getAllMetadata();

				tData.setMetaData(cMeta.toString());

				ArrayList<ColumnData> lColumnData = new ArrayList<ColumnData>();
				for (Column column : table.getColumns()) {
					ColumnData colData = new ColumnData();
					colData.setColumnId(column.getLocalId().getValue());
					colData.setName(column.getName());
					colData.setTypeName(column.getColumnType().getName());
					colData.setTypeCode(column.getColumnType().getCode());
					colData.setDataTypeName(column.getDataType().getName());
					colData.setTrId(newTRId);
					ColumnRelationship rel = column.getRelationship();
					if (rel != null) {
						RelationshipData relData = new RelationshipData(rel
								.getTargetTableId().getValue(), rel
								.getTargetColumnId().getValue());
						colData.setRelationship(relData);

					}
					if (column.contains(ViewColumnMetadata.class)) {
						ViewColumnMetadata viewMetadata = column
								.getMetadata(ViewColumnMetadata.class);
						logger.debug("ViewColumnMetadata: "
								+ viewMetadata.toString());

						String sourceTableDimensionColumnId = viewMetadata
								.getSourceTableDimensionColumnId().getValue();
						String targetTableColumnId = viewMetadata
								.getTargetTableColumnId().getValue();
						long targetTableId = viewMetadata.getTargetTableId()
								.getValue();
						ColumnViewData columnViewData = new ColumnViewData(
								sourceTableDimensionColumnId,
								targetTableColumnId, targetTableId);
						colData.setColumnViewData(columnViewData);
						colData.setViewColumn(true);

					} else {
						colData.setViewColumn(false);
					}

					lColumnData.add(colData);
				}

				tData.setListColumnData(lColumnData);

			} else {
				logger.debug("ViewTable is not null");
				TRId newTRId = new TRId(trId.getId());
				newTRId.setTabularResourceType(trId.getTabularResourceType());
				newTRId.setTableId(String.valueOf(viewTable.getId().getValue()));
				newTRId.setTableType(viewTable.getTableType().getName());
				newTRId.setReferenceTargetTableId(String.valueOf(table.getId()
						.getValue()));
				newTRId.setViewTable(true);
				logger.debug("NewTRId: " + newTRId);
				tData.setTrId(newTRId);

				tData.setName(viewTable.getName());
				tData.setTypeName(viewTable.getTableType().getName());
				tData.setTypeCode(viewTable.getTableType().getCode());
				Collection<TableMetadata> cMeta = viewTable.getAllMetadata();

				tData.setMetaData(cMeta.toString());

				ArrayList<ColumnData> lColumnData = new ArrayList<ColumnData>();
				for (Column column : viewTable.getColumns()) {
					ColumnData colData = new ColumnData();
					colData.setColumnId(column.getLocalId().getValue());
					colData.setName(column.getName());
					colData.setTypeName(column.getColumnType().getName());
					colData.setTypeCode(column.getColumnType().getCode());
					colData.setDataTypeName(column.getDataType().getName());
					colData.setTrId(newTRId);
					ColumnRelationship rel = column.getRelationship();
					if (rel != null) {
						RelationshipData relData = new RelationshipData(rel
								.getTargetTableId().getValue(), rel
								.getTargetColumnId().getValue());
						colData.setRelationship(relData);

					}
					if (column.contains(ViewColumnMetadata.class)) {
						ViewColumnMetadata viewMetadata = column
								.getMetadata(ViewColumnMetadata.class);
						logger.debug("ViewColumnMetadata: "
								+ viewMetadata.toString());

						String sourceTableDimensionColumnId = viewMetadata
								.getSourceTableDimensionColumnId().getValue();
						String targetTableColumnId = viewMetadata
								.getTargetTableColumnId().getValue();
						long targetTableId = viewMetadata.getTargetTableId()
								.getValue();
						ColumnViewData columnViewData = new ColumnViewData(
								sourceTableDimensionColumnId,
								targetTableColumnId, targetTableId);
						colData.setColumnViewData(columnViewData);
						colData.setViewColumn(true);

					} else {
						colData.setViewColumn(false);
					}

					lColumnData.add(colData);
				}

				tData.setListColumnData(lColumnData);

			}

			logger.debug("getTable: " + tData);
			return tData;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error("Error in getTable(): " + e.getLocalizedMessage(), e);
			throw new TDGWTServiceException("Error in getTable(): "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * Not used now, but it will be necessary in the future to retrieve task
	 * pending
	 * 
	 * {@inheritDoc}
	 */
	public void tdOpen(TDOpenSession s) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.getAslSession(session);
			SessionUtil.setTDOpenSession(session, s);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.error("Error setting TDOpenSession parameter: "
					+ e.getLocalizedMessage());
			throw new TDGWTServiceException(
					"Error setting TDOpenSession parameter: "
							+ e.getLocalizedMessage());
		}
	}

	// TODO
	/**
	 * 
	 * 
	 * @param tr
	 * @param tabResource
	 */
	protected void syncTRMetaData(TabularResource tr, TabResource tabResource) {

		logger.debug("TRservice [id:" + tr.getId() + " ,creationDate:"
				+ tr.getCreationDate() + "]");
		logger.debug("TabResource [name:" + tabResource.getName()
				+ " ,description:" + tabResource.getDescription() + " ,agency:"
				+ tabResource.getAgency() + " ,rights:"
				+ tabResource.getRight() + "]");
		tabResource.setDate(sdf.format(tr.getCreationDate().getTime()));
		tabResource.setValid(tr.isValid());
		tabResource.setFinalized(tr.isFinalized());
		tabResource.setLocked(tr.isLocked());
		tr.setMetadata(new NameMetadata(tabResource.getName()));
		tr.setMetadata(new DescriptionMetadata(tabResource.getDescription()));
		// tr.setMetadata(new CreationDateMetadata(date));
		if (tabResource.getAgency() != null
				&& !tabResource.getAgency().isEmpty()) {
			tr.setMetadata(new AgencyMetadata(tabResource.getAgency()));
		}
		tr.setMetadata(new RightsMetadata(tabResource.getRight()));

		if (tabResource.getValidFrom() != null
				&& !tabResource.getValidFrom().isEmpty()) {
			try {
				Date dateF = sdfDate.parse(tabResource.getValidFrom());
				GregorianCalendar validFromC = new GregorianCalendar();
				validFromC.setTime(dateF);
				ValidSinceMetadata validSince = new ValidSinceMetadata();
				validSince.setValue(validFromC);
				tr.setMetadata(validSince);
			} catch (ParseException e) {
				logger.info("ValidFromMetadata is not set, no valid calendar present");
			}
		}

		if (tabResource.getValidUntilTo() != null
				&& !tabResource.getValidUntilTo().isEmpty()) {
			try {
				Date dateU = sdfDate.parse(tabResource.getValidUntilTo());
				GregorianCalendar validUntilToC = new GregorianCalendar();
				validUntilToC.setTime(dateU);
				ValidUntilMetadata validUntil = new ValidUntilMetadata();
				validUntil.setValue(validUntilToC);
				tr.setMetadata(validUntil);
			} catch (ParseException e) {
				logger.info("ValidUntilMetadata is not set, no valid calendar present");
			}
		}

		if (tabResource.getLicence() != null
				&& !tabResource.getLicence().isEmpty()) {
			LicenceMetadata licenceMetadata = new LicenceMetadata();
			Licence licence = LicenceMap.map(tabResource.getLicence());
			if (licence != null) {
				licenceMetadata.setValue(licence);
				tr.setMetadata(licenceMetadata);
			} else {
				logger.error("Licence type not found: "
						+ tabResource.getLicence());
			}

		}

	}

	/**
	 * 
	 * @param tr
	 * @throws TDGWTServiceException
	 */
	protected void retrieveTRMetadataFromServiceAndLastTable(
			TabularDataService service, TabularResource tr)
			throws TDGWTServiceException {
		retrieveTRMetadataFromServiceAndLastTable(service, tr, 0);
	}

	/**
	 * Retrieves the informations for a specific Tabular Resource from service
	 * 
	 * @param tr
	 *            TabularResource on service
	 * @param i
	 *            Index on Grid
	 * @return TabResource for Grid
	 * @throws TDGWTServiceException
	 */
	protected TabResource retrieveTRMetadataFromService(
			TabularDataService service, TabularResource tr, int i)
			throws TDGWTServiceException {
		try {
			TabResource t = new TabResource();
			TRId trId = new TRId(String.valueOf(tr.getId().getValue()));
			trId.setTabularResourceType(tr.getTableType());
			t.setId(String.valueOf(i));
			t.setTrId(trId);
			t.setValid(tr.isValid());
			t.setFinalized(tr.isFinalized());
			t.setLocked(tr.isLocked());
			Contacts owner = new Contacts("", tr.getOwner(), false);
			t.setOwner(owner);

			if (tr.contains(NameMetadata.class)) {
				NameMetadata nameMeta = tr.getMetadata(NameMetadata.class);
				if (nameMeta != null && nameMeta.getValue() != null) {
					t.setName(nameMeta.getValue());
				} else {
					t.setName("Unknown_" + trId.getId());
				}
			} else {
				t.setName("Unknown_" + trId.getId());
			}
			if (tr.contains(AgencyMetadata.class)) {
				AgencyMetadata agencyMeta = tr
						.getMetadata(AgencyMetadata.class);
				if (agencyMeta != null && agencyMeta.getValue() != null) {
					t.setAgency(agencyMeta.getValue());
				} else {
					t.setAgency("");
				}
			} else {
				t.setAgency("");
			}
			t.setDate(sdf.format(tr.getCreationDate().getTime()));

			if (tr.contains(ValidSinceMetadata.class)) {
				ValidSinceMetadata validSinceMeta = tr
						.getMetadata(ValidSinceMetadata.class);
				if (validSinceMeta != null && validSinceMeta.getValue() != null) {
					Calendar validSinceC = validSinceMeta.getValue();
					t.setValidFrom(sdfDate.format(validSinceC.getTime()));
				} else {

				}
			} else {

			}

			if (tr.contains(ValidUntilMetadata.class)) {
				ValidUntilMetadata validUntilMeta = tr
						.getMetadata(ValidUntilMetadata.class);
				if (validUntilMeta != null && validUntilMeta.getValue() != null) {
					Calendar validUntilC = validUntilMeta.getValue();
					t.setValidUntilTo(sdfDate.format(validUntilC.getTime()));
				} else {

				}
			} else {

			}

			if (tr.contains(LicenceMetadata.class)) {
				LicenceMetadata licenceMeta = tr
						.getMetadata(LicenceMetadata.class);
				if (licenceMeta != null && licenceMeta.getValue() != null) {
					t.setLicence(licenceMeta.getValue().toString());
				} else {

				}
			} else {

			}

			// logger.debug("TabResource: "+t);
			return t;

		} catch (Throwable e) {
			logger.error("Error retrieving tabular resources metadata in retrieveTRMetadataFromService(): "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error retrieving tabular resources metadata in retrieveTRMetadataFromService() on server");
		}
	}

	/**
	 * Retrieves the informations for a specific Tabular Resource and the Last
	 * Table from service
	 * 
	 * @param tr
	 *            TabularResource on service
	 * @param i
	 *            Index on Grid
	 * @return TabResource for Grid
	 * @throws TDGWTServiceException
	 */
	protected TabResource retrieveTRMetadataFromServiceAndLastTable(
			TabularDataService service, TabularResource tr, int i)
			throws TDGWTServiceException {
		Table table = null;
		try {
			table = service.getLastTable(tr.getId());
		} catch (Throwable e) {
			logger.error("Error retrieving last table: " + e.getMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving last table: "
					+ e.getMessage());
		}

		TableId tableId = null;
		Table viewTable = null;
		TRId trId;
		TabResource t;

		if (table == null) {
			logger.info("Tabular resource " + tr.getId() + " has no table.");
			t = new TabResource();
			t.setTrId(null);
		} else {
			tableId = table.getId();
			if (tableId == null) {
				logger.info("Tabular Resource " + tr.getId()
						+ " has last table with id null.");
				t = new TabResource();
				t.setTrId(null);
			} else {
				if (table.contains(DatasetViewTableMetadata.class)) {
					DatasetViewTableMetadata dwm = table
							.getMetadata(DatasetViewTableMetadata.class);
					try {
						viewTable = service.getTable(dwm
								.getTargetDatasetViewTableId());
					} catch (Exception e) {
						logger.error("view table not found");
					}
				}

				if (viewTable == null) {
					trId = new TRId(String.valueOf(tr.getId().getValue()),
							tr.getTableType(), String.valueOf(tableId
									.getValue()), table.getTableType()
									.getName());
				} else {
					trId = new TRId(String.valueOf(tr.getId().getValue()),
							tr.getTableType(), String.valueOf(viewTable.getId()
									.getValue()), viewTable.getTableType()
									.getName(), String.valueOf(tableId
									.getValue()), true);

				}
				t = getTabResourceInformation(trId);

			}

		}

		t.setId(String.valueOf(i));

		return t;
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public void setCodelistsPagingLoader() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			CodelistTableType codType = new CodelistTableType();

			List<TabularResource> trs = service
					.getTabularResourcesByType(codType.getName());
			SessionUtil.setTabularResources(session, trs);

			ArrayList<TabResource> ltr = new ArrayList<TabResource>();

			int i;
			for (i = 0; i < trs.size(); i++) {
				TabularResource tr = trs.get(i);
				try {
					TabResource t = retrieveTRMetadataFromService(service, tr,
							i);
					if (t.getTrId() != null && t.isValid() && t.isFinalized()) {
						ltr.add(t);

					}
				} catch (Throwable e) {
					logger.error("TabResource discarded: " + tr + " cause: "
							+ e.getMessage());
				}

			}

			logger.debug("Codelists retrived: " + ltr);
			SessionUtil.setCodelistsPagingLoaded(session, ltr);

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			logger.error("Error retrieving Codelist in setCodelistsPagingLoader(): "
					+ e.getLocalizedMessage());
			throw new TDGWTServiceException("Error retrieving Codelist: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public CodelistPagingLoadResult getCodelistsPagingLoader(
			CodelistPagingLoadConfig plc) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();

			logger.debug(plc.toString());

			ArrayList<TabResource> ltr = SessionUtil
					.getCodelistsPagingLoaded(session);

			if (ltr == null) {
				logger.error("Error no codelist present in session");
				throw new TDGWTServiceException(
						"Error no codelist present in session");
			}

			ArrayList<TabResource> ltrTemp = new ArrayList<TabResource>();

			if (ltr.size() != 0) {
				ArrayList<TabResource> ltrCopy = filterPagingRow(plc, ltr,
						session);
				ltrCopy = OrderPagingRow(plc, ltrCopy, session);
				if (ltrCopy.size() != 0) {
					if (plc.getOffset() < 0
							|| plc.getOffset() >= ltrCopy.size()) {
						logger.error("Error CodelistPagingLoadConfig no valid range request, listsize: "
								+ ltrCopy.size());
						throw new TDGWTServiceException(
								"Error CodelistPagingLoadConfig no valid range request");
					}

					int request_end = plc.getOffset() + plc.getLimit();
					if (request_end > ltrCopy.size()) {
						request_end = ltrCopy.size();
					}

					for (int i = plc.getOffset(); i < request_end; i++) {
						try {
							// ltrCopy.get(i);
							ltrTemp.add(ltrCopy.get(i));

						} catch (IndexOutOfBoundsException e) {
							logger.debug("OutOfBounds in getCodelistsPagingLoader() size:"
									+ ltrCopy.size()
									+ " index: "
									+ i
									+ " Error:" + e.getMessage() + "\n");
						}
					}
				}

			}

			CodelistPagingLoadResult codelistPagingLoadResult = new CodelistPagingLoadResult();
			codelistPagingLoadResult.setFilter(plc.getFilter());
			codelistPagingLoadResult.setListOrderInfo(plc.getListOrderInfo());
			codelistPagingLoadResult.setLimit(plc.getLimit());
			codelistPagingLoadResult.setOffset(plc.getOffset());
			codelistPagingLoadResult.setTotalLenght(ltrTemp.size());
			codelistPagingLoadResult.setLtr(ltrTemp);

			logger.debug("Codelists retrieved: " + ltrTemp);
			return codelistPagingLoadResult;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			logger.error("Error retrieving Codelist in getCodelistsPagingLoader(): "
					+ e.getLocalizedMessage());
			throw new TDGWTServiceException("Error retrieving Codelist: "
					+ e.getLocalizedMessage());
		}

	}

	protected ArrayList<TabResource> filterPagingRow(
			CodelistPagingLoadConfig plc, ArrayList<TabResource> ltr,
			HttpSession session) {
		String filter = SessionUtil.getCodelistsPagingLoadedFilter(session);
		ArrayList<TabResource> ltrCopy = new ArrayList<TabResource>();
		SessionUtil.setCodelistsPagingLoadedFilter(session, plc.getFilter());
		if (filter == null) {
			logger.debug("No filter filter present in session");
			logger.debug("New Filter: " + plc.getFilter());
			if (plc.getFilter() == null || plc.getFilter().isEmpty()) {

				SessionUtil.setCodelistsPagingLoadedFilteredCopy(session, ltr);
				return ltr;
			} else {
				for (TabResource tr : ltr) {
					if (tr.getName() != null && !tr.getName().isEmpty()
							&& tr.getName().contains(plc.getFilter())) {
						ltrCopy.add(tr);
						continue;
					} else {
						if (tr.getAgency() != null && !tr.getAgency().isEmpty()
								&& tr.getAgency().contains(plc.getFilter())) {
							ltrCopy.add(tr);
							continue;
						} else {

						}

					}
				}
				SessionUtil.setCodelistsPagingLoadedFilteredCopy(session,
						ltrCopy);
				return ltrCopy;
			}

		} else {

			logger.debug("Old Filter:" + filter);
			logger.debug("New Filter: " + plc.getFilter());

			if (plc.getFilter() == null || plc.getFilter().isEmpty()) {
				SessionUtil.setCodelistsPagingLoadedFilteredCopy(session, ltr);
				return ltr;
			} else {
				if (filter.compareTo(plc.getFilter()) == 0) {
					ArrayList<TabResource> ltrFilteredCopy = SessionUtil
							.getCodelistsPagingLoadedFilteredCopy(session);
					return ltrFilteredCopy;
				} else {
					for (TabResource tr : ltr) {
						if (tr.getName() != null && !tr.getName().isEmpty()
								&& tr.getName().contains(plc.getFilter())) {
							ltrCopy.add(tr);
							continue;
						} else {
							if (tr.getAgency() != null
									&& !tr.getAgency().isEmpty()
									&& tr.getAgency().contains(plc.getFilter())) {
								ltrCopy.add(tr);
								continue;
							} else {

							}

						}
					}
					SessionUtil.setCodelistsPagingLoadedFilteredCopy(session,
							ltrCopy);
					return ltrCopy;
				}
			}

		}

	}

	protected ArrayList<TabResource> OrderPagingRow(
			CodelistPagingLoadConfig plc, ArrayList<TabResource> ltrCopy,
			HttpSession session) {

		ArrayList<OrderInfo> orders = plc.getListOrderInfo();
		for (OrderInfo order : orders) {
			if (order.getField().compareTo("name") == 0) {
				Direction direction = order.getDirection();
				if (direction == Direction.ASC) {
					Collections.sort(ltrCopy, new Comparator<TabResource>() {
						@Override
						public int compare(TabResource tr1, TabResource tr2) {
							int comp = 0;
							if (tr1.getName() == null) {
								comp = -1;
							} else {
								if (tr2.getName() == null) {
									comp = 1;
								} else {
									comp = tr1.getName().compareTo(
											tr2.getName());
								}
							}
							return comp;
						}
					});
				} else {
					Collections.sort(ltrCopy, new Comparator<TabResource>() {
						@Override
						public int compare(TabResource tr1, TabResource tr2) {
							int comp = 0;
							if (tr1.getName() == null) {
								comp = -1;
							} else {
								if (tr2.getName() == null) {
									comp = 1;
								} else {
									comp = tr1.getName().compareTo(
											tr2.getName());
								}
							}
							return -comp;
						}
					});
				}

				logger.debug("LTR Ordered by name;");

			} else {
				if (order.getField().compareTo("agency") == 0) {
					Direction direction = order.getDirection();
					if (direction == Direction.ASC) {
						Collections.sort(ltrCopy,
								new Comparator<TabResource>() {
									@Override
									public int compare(TabResource tr1,
											TabResource tr2) {
										int comp = 0;
										if (tr1.getAgency() == null) {
											comp = -1;
										} else {
											if (tr2.getAgency() == null) {
												comp = 1;
											} else {
												comp = tr1
														.getAgency()
														.compareTo(
																tr2.getAgency());
											}
										}
										return comp;
									}
								});
					} else {
						Collections.sort(ltrCopy,
								new Comparator<TabResource>() {
									@Override
									public int compare(TabResource tr1,
											TabResource tr2) {
										int comp = 0;
										if (tr1.getAgency() == null) {
											comp = -1;
										} else {
											if (tr2.getAgency() == null) {
												comp = 1;
											} else {
												comp = tr1
														.getAgency()
														.compareTo(
																tr2.getAgency());
											}
										}
										return -comp;
									}
								});
					}
					logger.debug("LTR Ordered by agency;");
				} else {
					if (order.getField().compareTo("date") == 0) {
						Direction direction = order.getDirection();
						if (direction == Direction.ASC) {
							Collections.sort(ltrCopy,
									new Comparator<TabResource>() {
										@Override
										public int compare(TabResource tr1,
												TabResource tr2) {
											int comp = 0;
											if (tr1.getDate() == null) {
												comp = -1;
											} else {
												if (tr2.getDate() == null) {
													comp = 1;
												} else {
													comp = tr1
															.getDate()
															.compareTo(
																	tr2.getDate());
												}
											}

											return comp;
										}
									});
						} else {
							Collections.sort(ltrCopy,
									new Comparator<TabResource>() {
										@Override
										public int compare(TabResource tr1,
												TabResource tr2) {
											int comp = 0;
											if (tr1.getDate() == null) {
												comp = -1;
											} else {
												if (tr2.getDate() == null) {
													comp = 1;
												} else {
													comp = tr1
															.getDate()
															.compareTo(
																	tr2.getDate());
												}
											}

											return -comp;
										}
									});
						}
						logger.debug("LTR Ordered by date;");
					} else {
					}
				}

			}

		}
		return ltrCopy;

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<TabResource> getTabularResourcesAndLastTables()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("GetTabularResources");
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			List<TabularResource> trs = service.getTabularResources();
			SessionUtil.setTabularResources(session, trs);

			ArrayList<TabResource> ltr = new ArrayList<TabResource>();

			int i;
			for (i = 0; i < trs.size(); i++) {
				TabularResource tr = trs.get(i);
				logger.debug("GetTabularResources RetrieveMetadataAndLastTables");
				try {
					TabResource t = retrieveTRMetadataFromServiceAndLastTable(
							service, tr, i);

					if (t.getTrId() != null) {
						ltr.add(t);
					}
				} catch (Throwable e) {
					logger.error("TabResource discarded: " + tr + " cause: "
							+ e.getMessage());
				}
			}

			logger.debug("Tabular Resources retrived: " + ltr);
			return ltr;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			logger.error("Error retrieving TabularResources: "
					+ e.getLocalizedMessage());
			throw new TDGWTServiceException(
					"Error retrieving TabularResources: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<TabResource> getTabularResources()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("GetTabularResources");
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			List<TabularResource> trs = service.getTabularResources();
			SessionUtil.setTabularResources(session, trs);

			ArrayList<TabResource> ltr = new ArrayList<TabResource>();

			int i;
			for (i = 0; i < trs.size(); i++) {
				TabularResource tr = trs.get(i);
				// logger.debug("GetTabularResources RetrieveMetadata");
				try {
					TabResource t = retrieveTRMetadataFromService(service, tr,
							i);

					if (t.getTrId() != null) {
						ltr.add(t);
					}
				} catch (Throwable e) {
					logger.error("TabResource discarded: " + tr + " cause: "
							+ e.getMessage());
				}
			}

			logger.debug("Tabular Resources retrieved: " + ltr);
			return ltr;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			logger.error("Error retrieving TabularResources: "
					+ e.getLocalizedMessage());
			throw new TDGWTServiceException(
					"Error retrieving TabularResources: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * @param tabResource
	 * @throws TDGWTServiceException
	 */
	public void removeTabularResource(TRId trId) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			if (trId == null) {
				logger.error("Error removing TabularResource: trId is null");
				throw new TDGWTServiceException(
						"Error removing TabularResource no parameters set");
			}
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId id = new TabularResourceId(Long.valueOf(trId
					.getId()));
			TabularResource tr = service.getTabularResource(id);
			if (tr.isLocked()) {
				throw new TDGWTServiceException("Tabular Resource Is Locked");
			}

			String owner = tr.getOwner();
			if (owner != null && owner.compareTo(aslSession.getUsername()) == 0) {
				service.removeTabularResource(id);
			} else {
				throw new TDGWTServiceException(
						"You are not the owner of this tabular resource (owner: "
								+ owner + ")");
			}
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error deleting the tabular resource: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error deleting the tabular resource: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public TabResource createTabularResource(TabResource tabResource)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			if (tabResource == null) {
				logger.error("Error creating new TabularResource: tabResource is null");
				throw new TDGWTServiceException(
						"Error creating new TabularResource no parameters set");
			}

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResource serviceTR = service.createTabularResource();
			Table table = service.getLastTable(serviceTR.getId());
			syncTRMetaData(serviceTR, tabResource);

			TRId trId = new TRId(String.valueOf(serviceTR.getId().getValue()),
					serviceTR.getTableType(), String.valueOf(table.getId()
							.getValue()), table.getTableType().getName());
			tabResource.setTrId(trId);

			return tabResource;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error creating new TabularResource: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error creating new TabularResource: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public ArrayList<Codelist> getCodelists() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			return SessionUtil.retrieveCodelists(session);

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving codelists: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public ArrayList<Dataset> getDatasets() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			return SessionUtil.retrieveDatasets(session);

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving datasets: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public ArrayList<Agencies> getAgencies() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			return SessionUtil.retrieveAgencies(session);

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving datasets: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * @param sdmxImportSession
	 * @return
	 */
	protected Map<String, Object> retrieveOperationParameters(
			SDMXImportSession sdmxImportSession) {

		Map<String, Object> map = new HashMap<String, Object>();

		Codelist codelist = sdmxImportSession.getSelectedCodelist();

		map.put(Constants.PARAMETER_AGENCY, codelist.getAgencyId());
		map.put(Constants.PARAMETER_ID, codelist.getId());
		map.put(Constants.PARAMETER_VERSION, codelist.getVersion());

		// TODO-GP: Get registry url from client

		SDMXRegistryDescriptor descriptor = new GCubeSDMXRegistryDescriptor();
		map.put(Constants.PARAMETER_REGISTRYBASEURL,
				descriptor.getUrl(SDMXRegistryInterfaceType.RESTV2_1));

		return map;

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String startSDMXImport(SDMXImportSession sdmxImportSession)
			throws TDGWTServiceException {

		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setSDMXImportSession(session, sdmxImportSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			// Import SDMX Codelist takes id 200
			OperationDefinition importSDMXCodelistOperation = OperationDefinitionMap
					.map(OperationsId.SDMXCodelistImport.toString(), service);

			TabResource sdmxImportTabResource = sdmxImportSession
					.getTabResource();

			TabularResource serviceTR = service.createTabularResource();

			syncTRMetaData(serviceTR, sdmxImportTabResource);

			TRId trId = new TRId(String.valueOf(serviceTR.getId().getValue()));
			sdmxImportTabResource.setTrId(trId);
			logger.debug(sdmxImportTabResource.toString());

			SessionUtil
					.setSDMXImportTabResource(session, sdmxImportTabResource);

			Map<String, Object> parameterInstance = retrieveOperationParameters(sdmxImportSession);

			OperationExecution invocation = new OperationExecution(
					importSDMXCodelistOperation.getOperationId(),
					parameterInstance);

			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR.getId());
			logger.debug("Start Task on service: TaskId " + trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.SDMXImport, trId);
			SessionUtil.setTaskStarted(session, taskWrapper);
			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in Client Library Request: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * Retrieve and set Tabular Resource Type
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	protected TRId retrieveTabularResourceBasicData(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			TabularResourceId tabularResourceId = new TabularResourceId(
					new Long(trId.getId()));

			TabularResource tr = service.getTabularResource(tabularResourceId);
			Table table = service.getLastTable(tabularResourceId);

			Table viewTable = null;

			if (table.contains(DatasetViewTableMetadata.class)) {
				DatasetViewTableMetadata dwm = table
						.getMetadata(DatasetViewTableMetadata.class);
				try {
					viewTable = service.getTable(dwm
							.getTargetDatasetViewTableId());
				} catch (Exception e) {
					logger.error("view table not found");
				}
			}

			TRId newTRId;
			if (viewTable == null) {
				newTRId = new TRId(String.valueOf(tr.getId().getValue()),
						tr.getTableType(), String.valueOf(table.getId()
								.getValue()), table.getTableType().getName());

			} else {
				newTRId = new TRId(String.valueOf(tr.getId().getValue()),
						tr.getTableType(), String.valueOf(viewTable.getId()
								.getValue()), viewTable.getTableType()
								.getName(), String.valueOf(table.getId()
								.getValue()), true);

			}

			logger.debug("Retrieved TRId basic info:" + newTRId.toString());
			return newTRId;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in Client Library Request: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setSDMXRegistrySource(SDMXRegistrySource sdmxRegistrySource)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setSDMXRegistrySource(session, sdmxRegistrySource);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;

		} catch (Throwable e) {
			logger.error(
					"Error setting SDMXRegistrySource parameter: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error setting SDMXRegistrySource parameter: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public void setCSVSession(CSVImportSession importSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setCSVImportSession(session, importSession);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.error(
					"Error setting SDMXImportSession parameter: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error setting SDMXImportSession parameter: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public FileUploadMonitor getFileUploadMonitor()
			throws TDGWTServiceException {

		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}

		FileUploadMonitor fileUploadMonitor = SessionUtil
				.getFileUploadMonitor(session);
		if (fileUploadMonitor == null) {
			throw new TDGWTServiceException(
					"Error retrieving the fileUploadMonitor: null");
		}

		logger.debug("FileUploadMonitor: " + fileUploadMonitor);

		return fileUploadMonitor;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public AvailableCharsetList getAvailableCharset()
			throws TDGWTServiceException {
		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}
		logger.info("Session:" + session.getId());
		String defaultEncoding = Charset.defaultCharset().displayName();
		ArrayList<String> charsetList = new ArrayList<String>(Charset
				.availableCharsets().keySet());
		return new AvailableCharsetList(charsetList, defaultEncoding);
	}

	@Override
	public ArrayList<String> configureCSVParser(String encoding,
			HeaderPresence headerPresence, char delimiter, char comment)
			throws TDGWTServiceException {
		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}
		logger.debug("Session:" + session.getId());
		logger.debug("configureCSVParser  encoding: " + encoding
				+ " headerPresence: " + headerPresence + " delimiter: "
				+ delimiter + " comment: " + comment);

		CSVFileUploadSession fileUploadSession = SessionUtil
				.getCSVFileUploadSession(session);
		if (fileUploadSession == null) {
			throw new TDGWTServiceException(
					"Error retrieving the fileUploadSession: null");
		}
		CSVParserConfiguration parserConfiguration = fileUploadSession
				.getParserConfiguration();
		if (parserConfiguration == null) {
			parserConfiguration = new CSVParserConfiguration(
					Charset.forName(encoding), delimiter, comment,
					headerPresence);
			fileUploadSession.setParserConfiguration(parserConfiguration);
		} else {
			parserConfiguration.update(encoding, delimiter, comment,
					headerPresence);
		}
		SessionUtil.setCSVFileUploadSession(session, fileUploadSession);
		try {
			return CSVFileUtil.getHeader(fileUploadSession.getCsvFile(),
					fileUploadSession.getParserConfiguration());
		} catch (Throwable e) {
			logger.error("Error retrieving the CSV header", e);
			throw new TDGWTServiceException(
					"Error calculating the CSV header: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public CheckCSVSession checkCSV(long errorsLimit)
			throws TDGWTServiceException {

		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}
		logger.debug("Session:" + session.getId());
		CSVFileUploadSession fileUploadSession = SessionUtil
				.getCSVFileUploadSession(session);
		if (fileUploadSession == null) {
			throw new TDGWTServiceException(
					"Error retrieving the fileUploadSession: null");
		}

		try {
			return CSVFileUtil.checkCSV(fileUploadSession.getCsvFile(),
					fileUploadSession.getParserConfiguration(), errorsLimit);
		} catch (Throwable e) {
			logger.error("Error checking the CSV file", e);
			throw new TDGWTServiceException("Error checking the CSV file: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String startCSVImport(CSVImportSession csvImportSession)
			throws TDGWTServiceException {
		try {

			HttpSession session = this.getThreadLocalRequest().getSession();
			if (session == null) {
				throw new TDGWTServiceException(
						"Error retrieving the session: null");
			}
			logger.debug("Session:" + session.getId());

			ASLSession aslSession = SessionUtil.getAslSession(session);
			String user = aslSession.getUsername();
			logger.debug("Session User:" + user);

			logger.debug("StartCSVImport: " + csvImportSession.toString());

			CSVFileUploadSession fileUploadSession = SessionUtil
					.getCSVFileUploadSession(session);
			if (fileUploadSession == null) {
				throw new TDGWTServiceException(
						"Error retrieving the fileUploadSession: null");
			}

			String taskId = importCSVFileOnService(session, aslSession, user,
					fileUploadSession, csvImportSession);

			return taskId;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in CSVImport: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * @param fileUrlOnStorage
	 * @param fileUploadSession
	 * @param csvImportSession
	 * @return
	 */
	protected Map<String, Object> csvImportFileParameter(
			String fileUrlOnStorage, CSVFileUploadSession fileUploadSession,
			CSVImportSession csvImportSession) {
		Map<String, Object> parameterInstances = new HashMap<String, Object>();
		parameterInstances.put(Constants.PARAMETER_URL, fileUrlOnStorage);
		parameterInstances.put(Constants.PARAMETER_SEPARATOR, String
				.valueOf(fileUploadSession.getParserConfiguration()
						.getDelimiter()));// ','
		parameterInstances.put(Constants.PARAMETER_ENCODING, fileUploadSession
				.getParserConfiguration().getCharset().name());// "UTF-8"
		boolean hasHeader = true;
		if (fileUploadSession.getParserConfiguration().getHeaderPresence() == HeaderPresence.NONE) {
			hasHeader = false;
		}

		parameterInstances.put(Constants.PARAMETER_HASHEADER, hasHeader);// true
		parameterInstances.put(Constants.PARAMETER_FIELDMASK,
				csvImportSession.getColumnToImportMask());// Column Mask
		parameterInstances.put(Constants.PARAMETER_SKIPERROR,
				csvImportSession.isSkipInvalidLines());
		return parameterInstances;
	}

	/**
	 * 
	 * @param user
	 * @param fileUploadSession
	 * @param csvImportSession
	 * @throws TDGWTServiceException
	 */
	protected String importCSVFileOnService(HttpSession session,
			ASLSession aslSession, String user,
			CSVFileUploadSession fileUploadSession,
			CSVImportSession csvImportSession) throws TDGWTServiceException {

		logger.debug("File Storage Access");

		logger.debug("CSVImportSession skip:"
				+ csvImportSession.isSkipInvalidLines());
		/*
		 * if (csvImportSession.isSkipInvalidLines()) { try {
		 * fileUploadSession.setCsvFile(CSVFileUtil.skipError(
		 * fileUploadSession.getCsvFile(),
		 * fileUploadSession.getParserConfiguration())); } catch (ParseException
		 * e) { logger.debug("Error parsing file for skip:" + e.getMessage());
		 * throw new TDGWTServiceException("Error parsing file for skip: " +
		 * e.getMessage());
		 * 
		 * } catch (IOException e) {
		 * logger.debug("Error IOException skipping file error: " +
		 * e.getMessage()); throw new TDGWTServiceException(
		 * "Error IOException skipping file error: " + e.getMessage());
		 * 
		 * } }
		 */

		FilesStorage filesStorage = new FilesStorage();

		String fileUrlOnStorage = filesStorage.storageCSVTempFile(user,
				fileUploadSession.getCsvFile());
		logger.debug("File Url On Storage:" + fileUrlOnStorage);
		fileUploadSession.getCsvFile().delete();

		if (fileUrlOnStorage == null || fileUrlOnStorage.isEmpty()) {
			throw new TDGWTServiceException(
					"Tabular Data Service error loading file on storage");
		}

		Map<String, Object> parameterInstance = csvImportFileParameter(
				fileUrlOnStorage, fileUploadSession, csvImportSession);

		logger.debug("Tabular Data Service");

		AuthorizationProvider.instance.set(new AuthorizationToken(aslSession
				.getUsername(), aslSession.getScope()));
		TabularDataService service = TabularDataServiceFactory.getService();

		// Import CSV file

		OperationDefinition importCSVFileOperation = OperationDefinitionMap
				.map(OperationsId.CSVImport.toString(), service);

		OperationExecution invocation = new OperationExecution(
				importCSVFileOperation.getOperationId(), parameterInstance);

		logger.debug("OperationInvocation: \n" + invocation.toString());
		TabularResource tabularResource = service.createTabularResource();
		TabResource csvImportTabResource = csvImportSession.getTabResource();
		syncTRMetaData(tabularResource, csvImportTabResource);
		TRId trId = new TRId(String.valueOf(tabularResource.getId().getValue()));
		csvImportTabResource.setTrId(trId);
		logger.debug(csvImportTabResource.toString());
		SessionUtil.setCSVImportTabResource(session, csvImportTabResource);
		Task trTask;
		try {
			trTask = service.execute(invocation, tabularResource.getId());
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Tabular Data Service error creating TabularResource: "
							+ e.getLocalizedMessage());
		}

		logger.debug("Start Task on service: TaskId " + trTask.getId());
		TaskWrapper taskWrapper = new TaskWrapper(trTask,
				UIOperationsId.CSVImport, trId);
		SessionUtil.setTaskStarted(session, taskWrapper);

		return trTask.getId().getValue();
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public void getFileFromWorkspace(CSVImportSession csvImportSession)
			throws TDGWTServiceException {
		HttpSession session = this.getThreadLocalRequest().getSession();
		ASLSession aslSession = SessionUtil.getAslSession(session);
		Workspace w = null;
		WorkspaceItem wi = null;

		try {
			HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();

			HomeManager manager = factory.getHomeManager();

			Home home = manager.getHome(aslSession.getUsername());

			w = home.getWorkspace();
			wi = w.getItem(csvImportSession.getItemId());
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in importCSV getFileFromWorkspace accessing the workspace: "
							+ e.getLocalizedMessage(), e);
		}

		if (wi == null) {
			logger.error("Error retrieving the item on workspace"
					+ csvImportSession.getItemId());
			throw new TDGWTServiceException(
					"Error retrieving the item on workspace"
							+ csvImportSession.getItemId());
		}

		try {
			logger.debug("WorkspaceItem [id:" + wi.getId() + " name:"
					+ wi.getName() + " remotePath:" + wi.getRemotePath() + "]");
		} catch (InternalErrorException e1) {
			e1.printStackTrace();
			throw new TDGWTServiceException(
					"Error retrieving the item on workspace" + wi);
		}

		CSVFileUploadSession fileUploadSession = new CSVFileUploadSession();
		// CSVImportMonitor csvImportMonitor = new CSVImportMonitor();
		FileUploadMonitor fileUploadMonitor = new FileUploadMonitor();

		SessionUtil.setFileUploadMonitor(session, fileUploadMonitor);

		fileUploadSession.setId(session.getId());
		fileUploadSession.setFileUploadState(FileUploadState.STARTED);
		// fileUploadSession.setCsvImportMonitor(csvImportMonitor);

		SessionUtil.setCSVFileUploadSession(session, fileUploadSession);

		try {
			FilesStorage filesStorage = new FilesStorage();
			InputStream is = filesStorage.retriveImputStream(
					aslSession.getUsername(), wi);

			FileUtil.setImportFileCSV(fileUploadSession, is, wi.getName(),
					Constants.FILE_CSV_MIMETYPE);
		} catch (Throwable e) {
			FileUploadMonitor fum = SessionUtil.getFileUploadMonitor(session);
			fum.setFailed("An error occured elaborating the file",
					FileUtil.exceptionDetailMessage(e));
			SessionUtil.setFileUploadMonitor(session, fum);
			fileUploadSession.setFileUploadState(FileUploadState.FAILED);
			SessionUtil.setCSVFileUploadSession(session, fileUploadSession);
			logger.error("Error elaborating the input stream", e);
			throw new TDGWTServiceException(
					"Error in importCSV getFileFromWorkspace: "
							+ e.getLocalizedMessage(), e);
		}

		logger.trace("changing state");
		FileUploadMonitor fum = SessionUtil.getFileUploadMonitor(session);
		fum.setState(FileUploadState.COMPLETED);
		SessionUtil.setFileUploadMonitor(session, fum);
		SessionUtil.setCSVFileUploadSession(session, fileUploadSession);
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public String getTRCreationDate(TRId trId) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("GetTRMetadata on " + trId.toString());

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResource tr = service
					.getTabularResource(new TabularResourceId(Long.valueOf(trId
							.getId())));

			return sdf.format(tr.getCreationDate().getTime());

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.error(
					"Error in getTRCreationDate(): " + e.getLocalizedMessage(),
					e);
			throw new TDGWTServiceException("Error in getTRCreationDate(): "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public Boolean isTabularResourceValid(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("IsTabularResourceValid: " + trId.toString());

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResource tr = service
					.getTabularResource(new TabularResourceId(Long.valueOf(trId
							.getId())));
			logger.debug("IsTabularResourceValid: " + tr.isValid());
			return tr.isValid();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error("Error checking if it is a valid tabular resource: "
					+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error checking if it is a valid tabular resource: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * Check finalized status of a tabular resource
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public Boolean isTabularResourceFinalized(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("IsTabularResourceFinalized: " + trId.toString());

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResource tr = service
					.getTabularResource(new TabularResourceId(Long.valueOf(trId
							.getId())));
			logger.debug("IsTabularResourceFinalized: " + tr.isFinalized());
			return tr.isFinalized();
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error checking if it is a finalized tabular resource: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error checking if it is a finalized tabular resource: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * Check locked status of a tabular resource
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public Boolean isTabularResourceLocked(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("IsTabularResourceLocked: " + trId);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResource tr = service
					.getTabularResource(new TabularResourceId(Long.valueOf(trId
							.getId())));
			logger.debug("IsTabularResourceLocked: " + tr.isLocked());
			return tr.isLocked();
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error("Error checking if it is a locked tabular resource: "
					+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error checking if it is a locked tabular resource: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public ArrayList<TRMetadata> getTRMetadata(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("GetTRMetadata on " + trId);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResource tr = service
					.getTabularResource(new TabularResourceId(Long.valueOf(trId
							.getId())));

			Collection<TabularResourceMetadata<?>> trMetas = tr
					.getAllMetadata();

			logger.debug("GetTRMetadata size: " + trMetas.size());
			ArrayList<TRMetadata> listTRMetadata = new ArrayList<TRMetadata>();

			for (TabularResourceMetadata<?> trMetadata : trMetas) {
				if (trMetadata instanceof org.gcube.data.analysis.tabulardata.service.tabular.metadata.DescriptionMetadata) {
					TRDescriptionMetadata trDescriptionMetadata = new TRDescriptionMetadata();
					trDescriptionMetadata
							.setValue(((org.gcube.data.analysis.tabulardata.service.tabular.metadata.DescriptionMetadata) trMetadata)
									.getValue());
					listTRMetadata.add(trDescriptionMetadata);
				} else {
					if (trMetadata instanceof org.gcube.data.analysis.tabulardata.service.tabular.metadata.NameMetadata) {
						TRNameMetadata trNameMetadata = new TRNameMetadata();
						trNameMetadata
								.setValue(((org.gcube.data.analysis.tabulardata.service.tabular.metadata.NameMetadata) trMetadata)
										.getValue());
						listTRMetadata.add(trNameMetadata);
					} else {
						if (trMetadata instanceof AgencyMetadata) {
							TRAgencyMetadata trAgencyMetadata = new TRAgencyMetadata();
							trAgencyMetadata
									.setValue(((AgencyMetadata) trMetadata)
											.getValue());
							listTRMetadata.add(trAgencyMetadata);
						} else {
							if (trMetadata instanceof RightsMetadata) {
								TRRightsMetadata trRightsMetadata = new TRRightsMetadata();
								trRightsMetadata
										.setValue(((RightsMetadata) trMetadata)
												.getValue());
								listTRMetadata.add(trRightsMetadata);
							} else {
								if (trMetadata instanceof ValidSinceMetadata) {
									TRValidSinceMetadata validSinceMetadata = new TRValidSinceMetadata();
									Calendar cal = ((ValidSinceMetadata) trMetadata)
											.getValue();
									validSinceMetadata.setValue(sdfDate
											.format(cal.getTime()));
									listTRMetadata.add(validSinceMetadata);
								} else {
									if (trMetadata instanceof ValidUntilMetadata) {
										TRValidUntilMetadata validUntilMetadata = new TRValidUntilMetadata();
										Calendar cal = ((ValidUntilMetadata) trMetadata)
												.getValue();
										validUntilMetadata.setValue(sdfDate
												.format(cal.getTime()));
										listTRMetadata.add(validUntilMetadata);
									} else {
										if (trMetadata instanceof LicenceMetadata) {
											TRLicenceMetadata licenceMetadata = new TRLicenceMetadata();
											licenceMetadata
													.setValue(((LicenceMetadata) trMetadata)
															.getValue()
															.toString());
											listTRMetadata.add(licenceMetadata);
										} else {

										}
									}
								}
							}

						}
					}
				}
			}

			logger.debug("GetTRMetadata retrived: " + listTRMetadata.size());
			logger.debug("GetTRMetadata: [" + listTRMetadata + "]");
			return listTRMetadata;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error in getTRMetadata(): " + e.getLocalizedMessage(), e);
			throw new TDGWTServiceException("Error in getTRMetadata(): "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TabValidationsMetadata getTableValidationsMetadata(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("GetTableValidationsMetadata on " + trId.toString());
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));
			TabValidationsMetadata tabValidationsMetadata = new TabValidationsMetadata();
			if (table.contains(ValidationsMetadata.class)) {
				ValidationsMetadata validationsMetadata = table
						.getMetadata(ValidationsMetadata.class);
				if (validationsMetadata != null) {
					List<Validation> vals = validationsMetadata
							.getValidations();
					if (vals != null && vals.size() > 0) {
						Validations valid = null;
						ArrayList<Validations> vList = new ArrayList<Validations>();
						int i = 0;
						for (Validation v : vals) {
							valid = new Validations(String.valueOf(i),
									v.getDescription(), v.isValid(), null, null);
							vList.add(valid);
							i++;
						}
						tabValidationsMetadata.setValidations(vList);
					}
				}
			}

			logger.debug("TabValidationsMetadata: " + tabValidationsMetadata);
			return tabValidationsMetadata;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error in getTableValidationMetadata(): "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error in getTableValidationMetadata: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public ArrayList<TabMetadata> getTableMetadata(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("GetTableMetadata on " + trId.toString());
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));

			Collection<TableMetadata> cMeta = table.getAllMetadata();

			ArrayList<TabMetadata> listTabMetadata = new ArrayList<TabMetadata>();
			logger.debug("Metadata size:" + cMeta.size());
			for (TableMetadata tMetadata : cMeta) {
				if (tMetadata instanceof DescriptionsMetadata) {
					TabDescriptionsMetadata trDescriptionsMetadata = new TabDescriptionsMetadata();
					ArrayList<TRLocalizedText> listTRLocalizedText = new ArrayList<TRLocalizedText>();
					List<LocalizedText> lLocalizedText = ((DescriptionsMetadata) tMetadata)
							.getTexts();
					int i = 0;
					for (LocalizedText lt : lLocalizedText) {
						TRLocalizedText trLocalizedText = new TRLocalizedText();
						trLocalizedText.setId(i);
						trLocalizedText.setValue(lt.getValue());
						trLocalizedText.setLocaleCode(lt.getLocale());
						listTRLocalizedText.add(trLocalizedText);
						i++;
					}
					trDescriptionsMetadata
							.setListTRLocalizedText(listTRLocalizedText);
					listTabMetadata.add(trDescriptionsMetadata);

				} else {
					if (tMetadata instanceof NamesMetadata) {
						TabNamesMetadata trNamesMetadata = new TabNamesMetadata();
						ArrayList<TRLocalizedText> listTRLocalizedText = new ArrayList<TRLocalizedText>();
						List<LocalizedText> lLocalizedText = ((NamesMetadata) tMetadata)
								.getTexts();
						int i = 0;
						for (LocalizedText lt : lLocalizedText) {
							TRLocalizedText trLocalizedText = new TRLocalizedText();
							trLocalizedText.setId(i);
							trLocalizedText.setValue(lt.getValue());
							trLocalizedText.setLocaleCode(lt.getLocale());
							listTRLocalizedText.add(trLocalizedText);
							i++;
						}
						trNamesMetadata
								.setListTRLocalizedText(listTRLocalizedText);
						listTabMetadata.add(trNamesMetadata);

					} else {
						if (tMetadata instanceof VersionMetadata) {
							TabVersionMetadata trVersionMetadata = new TabVersionMetadata();
							trVersionMetadata
									.setVersion(((VersionMetadata) tMetadata)
											.getVersion());
							listTabMetadata.add(trVersionMetadata);
						} else {
							if (tMetadata instanceof ExportMetadata) {
								TabExportMetadata trExportMetadata = new TabExportMetadata();
								trExportMetadata
										.setDestinationType(((ExportMetadata) tMetadata)
												.getDestinationType());
								trExportMetadata.setExportDate(sdf
										.format(((ExportMetadata) tMetadata)
												.getExportDate()));
								trExportMetadata
										.setUrl(((ExportMetadata) tMetadata)
												.getUri());
								listTabMetadata.add(trExportMetadata);
							} else {
								if (tMetadata instanceof ImportMetadata) {
									TabImportMetadata trImportMetadata = new TabImportMetadata();
									trImportMetadata
											.setSourceType(((ImportMetadata) tMetadata)
													.getSourceType());
									trImportMetadata
											.setImportDate(sdf
													.format(((ImportMetadata) tMetadata)
															.getImportDate()));
									trImportMetadata
											.setUrl(((ImportMetadata) tMetadata)
													.getUri());
									listTabMetadata.add(trImportMetadata);
								} else {
									if (tMetadata instanceof GenericMapMetadata) {
										TabGenericMapMetadata trGenericMapMetadata = new TabGenericMapMetadata();
										trGenericMapMetadata
												.setMetadataMap((HashMap<String, String>) ((GenericMapMetadata) tMetadata)
														.getMetadataMap());
										listTabMetadata
												.add(trGenericMapMetadata);
									} else {

									}

								}
							}
						}
					}
				}
			}

			return listTabMetadata;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.error(
					"Error in getTableMetadata(): " + e.getLocalizedMessage(),
					e);
			throw new TDGWTServiceException("Error in getTableMetadata(): "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * @param exportSession
	 * @return
	 */
	protected Map<String, Object> csvExportFileParameter(
			CSVExportSession exportSession) {
		Map<String, Object> parameterInstances = new HashMap<String, Object>();
		parameterInstances.put(Constants.PARAMETER_ENCODING,
				exportSession.getEncoding());
		parameterInstances.put(Constants.PARAMETER_SEPARATOR,
				exportSession.getSeparator());
		parameterInstances.put(Constants.PARAMETER_COLUMNS,
				exportSession.getColumnsAsString());
		return parameterInstances;
	}

	/**
	 * 
	 * @param exportSession
	 * @return
	 */
	protected Map<String, Object> sdmxExportParameter(
			SDMXExportSession exportSession) throws TDGWTServiceException {
		boolean internalRegistry = false;
		String destination = null;// Es:
									// http://pc-fortunati.isti.cnr.it:8080/FusionRegistry/ws/rest/

		if (exportSession != null) {
			if (exportSession.getRegistryBaseUrl() != null
					&& !exportSession.getRegistryBaseUrl().isEmpty()) {
				destination = exportSession.getRegistryBaseUrl();
			} else {
				internalRegistry = true;
			}
		} else {
			internalRegistry = true;
		}

		if (internalRegistry) {
			SimpleQuery query = queryFor(ServiceEndpoint.class);
			query.addCondition("$resource/Profile/Category/text() eq 'SDMX'")
					.addCondition(
							"$resource/Profile/Name/text() eq 'SDMXRegistry'");
			DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
			List<ServiceEndpoint> listService = client.submit(query);
			if (listService.size() > 0) {
				ServiceEndpoint serviceEnd = listService.get(0);
				if (serviceEnd != null) {
					Profile prof = serviceEnd.profile();
					Group<AccessPoint> groupA = prof.accessPoints();
					for (AccessPoint acc : groupA) {
						if (acc.description().compareTo("REST Interface v2.1") == 0) {
							destination = acc.address();
							break;
						}
					}
				} else {

				}
			} else {

			}
		}
		if (destination == null) {
			logger.debug("Destination: " + destination);
			throw new TDGWTServiceException("SDMX Service not discovered");
		}

		Map<String, Object> parameterInstances = new HashMap<String, Object>();
		parameterInstances
				.put(Constants.PARAMETER_REGISTRYBASEURL, destination);
		parameterInstances.put(Constants.PARAMETER_AGENCY, "SDMX");
		parameterInstances.put(Constants.PARAMETER_ID, "NEW_CL_DIVISION");
		parameterInstances.put(Constants.PARAMETER_VERSION, "2.0");
		return parameterInstances;
	}

	/**
	 * 
	 * @param service
	 * @param trId
	 * @throws TDGWTServiceException
	 */
	protected void checkTabularResourceLocked(TabularDataService service,
			TRId trId) throws TDGWTServiceException {
		try {
			if (trId == null) {
				logger.error("TRId is null");
				new TDGWTServiceException(
						"No valid tabular resource id present");
			}

			if (trId.getId() == null || trId.getId().isEmpty()) {
				logger.error("TRId not valid: " + trId);
				new TDGWTServiceException(
						"No valid tabular resource id present");
			}

			TabularResourceId tabularResourceId = new TabularResourceId(
					Long.valueOf(trId.getId()));
			TabularResource tabularResource = service
					.getTabularResource(tabularResourceId);

			if (tabularResource.isLocked()) {
				throw new TDGWTServiceException("Tabular Resource Is Locked");
			}

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * @param exportSession
	 * @return
	 */
	public String startSDMXExport(SDMXExportSession exportSession)
			throws TDGWTServiceException {
		try {

			logger.debug("Start SDMX Export");
			HttpSession session = this.getThreadLocalRequest().getSession();
			if (session == null) {
				throw new TDGWTServiceException(
						"Error retrieving the session: null");
			}
			logger.debug("Session:" + session.getId());

			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("Session User:" + aslSession.getUsername());

			TRId trId = SessionUtil.getTRId(session);
			if (trId == null) {
				throw new TDGWTServiceException(
						"Error no tabular resource in session");
			}

			if (trId.getTableId() == null) {
				throw new TDGWTServiceException(
						"Error no table present in session");
			}

			SessionUtil.setSDMXExportSession(session, exportSession);

			Map<String, Object> parameterInstance = sdmxExportParameter(exportSession);

			logger.debug("Tabular Data Service");

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			checkTabularResourceLocked(service, trId);

			// Export SDMX Codelist
			OperationDefinition exportSDMXOperation = OperationDefinitionMap
					.map(OperationsId.SDMXCodelistExport.toString(), service);

			OperationExecution invocation = new OperationExecution(
					exportSDMXOperation.getOperationId(), parameterInstance);

			logger.debug("OperationInvocation: \n" + invocation.toString());

			Task trTask = service.execute(invocation, new TabularResourceId(
					Long.valueOf(trId.getId())));
			logger.debug("Start Task on service: TaskId " + trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.SDMXExport, trId);
			SessionUtil.setTaskStarted(session, taskWrapper);

			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in CSVExport: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public String startCSVExport(CSVExportSession exportSession)
			throws TDGWTServiceException {
		try {

			logger.debug("Start CSV Export");
			HttpSession session = this.getThreadLocalRequest().getSession();
			if (session == null) {
				throw new TDGWTServiceException(
						"Error retrieving the session: null");
			}
			logger.debug("Session:" + session.getId());

			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("Session User:" + aslSession.getUsername());

			TRId trId = SessionUtil.getTRId(session);
			if (trId == null) {
				throw new TDGWTServiceException(
						"Error no tabular resource in session");
			}

			if (trId.getTableId() == null) {
				throw new TDGWTServiceException(
						"Error no table present in session");
			}

			SessionUtil.setCSVExportSession(session, exportSession);

			Map<String, Object> parameterInstance = csvExportFileParameter(exportSession);

			logger.debug("Tabular Data Service");

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, trId);

			// Export CSV file
			OperationDefinition exportCSVFileOperation = OperationDefinitionMap
					.map(OperationsId.CSVExport.toString(), service);

			OperationExecution invocation = new OperationExecution(
					exportCSVFileOperation.getOperationId(), parameterInstance);

			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, new TabularResourceId(
					Long.valueOf(trId.getId())));
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			SessionUtil.setCSVExportEnd(session, false);

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.CSVExport, trId);
			SessionUtil.setTaskStarted(session, taskWrapper);

			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in CSVExport: "
					+ e.getLocalizedMessage());
		}

	}

	// TODO UpThis Monitor not updated

	/**
	 * 
	 * {@inheritDoc}
	 */
	public String startChangeColumnType(
			ChangeColumnTypeSession changeColumnTypeSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setChangeColumnTypeSession(session,
					changeColumnTypeSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, changeColumnTypeSession
					.getColumnData().getTrId());

			OpExecution4ChangeColumnType opEx = new OpExecution4ChangeColumnType(
					service, changeColumnTypeSession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();

			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error in ChangeColumnType: Operation not supported for now!");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(changeColumnTypeSession.getColumnData()
							.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.ChangeColumnType, changeColumnTypeSession
							.getColumnData().getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);

			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in ChangeColumnType: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public String startAddColumn(AddColumnSession addColumnSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setAddColumnSession(session, addColumnSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, addColumnSession.getTrId());

			OpExecution4AddColumn opEx = new OpExecution4AddColumn(service,
					addColumnSession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();

			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error Add Column: Operation not supported for now!");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(addColumnSession.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.AddColumn, addColumnSession.getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);

			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in AddColumn: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public String startDeleteColumn(DeleteColumnSession deleteColumnSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setDeleteColumnSession(session, deleteColumnSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, deleteColumnSession.getTrId());

			OpExecution4DeleteColumn opEx = new OpExecution4DeleteColumn(
					service, deleteColumnSession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();

			ArrayList<OperationExecution> invocation = director
					.getListOperationExecution();

			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error Delete Column: Operation not supported for now!");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(deleteColumnSession.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.executeBatch(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.DeleteColumn, deleteColumnSession.getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);

			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in DeleteColumn: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * Start Filter Column
	 * 
	 * @param filterColumnSession
	 * @param expression
	 * @param session
	 * @return
	 * @throws TDGWTServiceException
	 */
	public String startFilterColumn(FilterColumnSession filterColumnSession,
			Expression expression, HttpSession session)
			throws TDGWTServiceException {
		try {
			// HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setFilterColumnSession(session, filterColumnSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);
			if (filterColumnSession == null) {
				logger.error("FilterColumnSession is null");
				throw new TDGWTServiceException(
						"Error in filter column: FilterColumnSession is null");
			}

			logger.debug("StartFilterColumn: " + filterColumnSession);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, filterColumnSession.getColumn()
					.getTrId());

			OpExecution4FilterColumn opEx = new OpExecution4FilterColumn(
					service, filterColumnSession, expression);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			ArrayList<OperationExecution> invocations = director
					.getListOperationExecution();

			if (invocations == null) {
				throw new TDGWTServiceException(
						"Error in invocation: Operation not supported");
			}
			Long id = Long.valueOf(filterColumnSession.getColumn().getTrId()
					.getId());

			TabularResourceId serviceTR = new TabularResourceId(id);
			logger.debug("OperationInvocation: \n" + invocations.toString());
			Task trTask = service.executeBatch(invocations, serviceTR);
			logger.debug("Filter Column on service: TaskId " + trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.FilterColumn, filterColumnSession
							.getColumn().getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);
			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in filter column: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public String startLabelColumn(LabelColumnSession labelColumnSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setLabelColumnSession(session, labelColumnSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug(labelColumnSession.toString());

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, labelColumnSession.getTrId());

			OpExecution4LabelColumn opEx = new OpExecution4LabelColumn(service,
					labelColumnSession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			List<OperationExecution> invocations = director
					.getListOperationExecution();

			if (invocations == null) {
				throw new TDGWTServiceException("Operation not supported");
			}
			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(labelColumnSession.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocations);
			Task trTask = service.executeBatch(invocations, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.ChangeColumnLabel,
					labelColumnSession.getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);

			return trTask.getId().getValue();
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error Changing The Column Label: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public String startChangeTableType(
			ChangeTableTypeSession changeTableTypeSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setChangeTableTypeSession(session,
					changeTableTypeSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service,
					changeTableTypeSession.getTrId());

			OpExecution4ChangeTableType opEx = new OpExecution4ChangeTableType(
					service, changeTableTypeSession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();

			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error Change Table Type invocation: Operation not supported");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(changeTableTypeSession.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.ChangeTableType,
					changeTableTypeSession.getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);

			return trTask.getId().getValue();
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error Changing Table Type: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * Returns only CodeColumnType, CodeNameColumnType,
	 * CodeDescriptionColumnType and AnnotationColumnType
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<ColumnData> getColumnsForDimension(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			logger.debug("getColumnsForDimension():" + trId.toString());

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));

			ArrayList<ColumnData> columns = new ArrayList<ColumnData>();

			List<Column> cols = table.getColumns();
			int i = 0;
			for (Column c : cols) {
				ColumnType ctype = c.getColumnType();
				if (c.getColumnType() instanceof IdColumnType
						|| c.getColumnType() instanceof ValidationColumnType
						|| c.getColumnType() instanceof DimensionColumnType
						|| c.getColumnType() instanceof TimeDimensionColumnType) {

				} else {
					if (c.contains(ViewColumnMetadata.class)) {

					} else {
						if (ctype instanceof CodeColumnType
								|| ctype instanceof CodeNameColumnType
								|| ctype instanceof CodeDescriptionColumnType
								|| ctype instanceof AnnotationColumnType) {

							ColumnData cData = new ColumnData();
							cData.setId(Integer.toString(i));
							cData.setColumnId(c.getLocalId().getValue());
							cData.setName(c.getName());
							cData.setTypeCode(c.getColumnType().getCode());
							cData.setTypeName(c.getColumnType().getName());
							cData.setDataTypeName(c.getDataType().getName());
							NamesMetadata labelsMetadata = null;
							try {
								labelsMetadata = c
										.getMetadata(NamesMetadata.class);
							} catch (NoSuchMetadataException e) {
								logger.debug("labelMetadata: NoSuchMetadataException "
										+ e.getLocalizedMessage());
							}

							if (labelsMetadata == null) {
								cData.setLabel("nolabel");
								logger.debug("LabelsMetadata no labels");
							} else {
								LocalizedText cl = null;
								cl = labelsMetadata.getTextWithLocale("en");
								if (cl == null) {
									cData.setLabel("nolabel");
									logger.debug("ColumnLabel no label in en");
								} else {
									if (cl.getValue() == null
											|| cl.getValue().isEmpty()) {
										cData.setLabel("nolabel");
										logger.debug("ColumnLabel no label in en");
									} else {
										cData.setLabel(cl.getValue());
										logger.debug("Column Set Label: "
												+ cl.getValue());
									}
								}
							}

							DataLocaleMetadata dataLocaleMetadata = null;
							try {
								dataLocaleMetadata = c
										.getMetadata(DataLocaleMetadata.class);
							} catch (NoSuchMetadataException e) {
								logger.debug("DataLocaleMetadata: NoSuchMetadataException "
										+ e.getLocalizedMessage());
							}

							if (dataLocaleMetadata == null) {
								logger.debug("No DataLocaleMetadata");
							} else {
								cData.setLocale(dataLocaleMetadata.getLocale());
							}

							cData.setTrId(trId);
							columns.add(cData);
							i++;
						}
					}
				}
			}
			return columns;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error in getColumnsForDimension() retrieving Columns: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException("Error retrieving Columns: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public String startDeleteRows(DeleteRowsSession deleteRowsSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setDeleteRowsSession(session, deleteRowsSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, deleteRowsSession.getTrId());

			OpExecution4DeleteRows opEx = new OpExecution4DeleteRows(service,
					deleteRowsSession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();

			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error Delete Rows invocation: Operation not supported");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(deleteRowsSession.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.DeleteRow, deleteRowsSession.getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);

			return trTask.getId().getValue();
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error Deleting Rows: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */

	@Override
	public String startCloneTabularResource(
			CloneTabularResourceSession cloneTabularResourceSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();

			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			logger.debug("CloneTabularResourceSession: "
					+ cloneTabularResourceSession);

			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service,
					cloneTabularResourceSession.getTrId());

			OpExecution4Clone opEx = new OpExecution4Clone(service,
					cloneTabularResourceSession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();

			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error in invocation: Operation not supported");
			}
			Long id = Long.valueOf(cloneTabularResourceSession.getTrId()
					.getId());

			TabularResourceId serviceTRId = new TabularResourceId(id);
			TabularResource serviceTR = service.getTabularResource(serviceTRId);

			TabularResource cloneTR = service.createTabularResource();
			cloneTR.setAllMetadata(serviceTR.getAllMetadata());
			NameMetadata nameMetadata = cloneTR.getMetadata(NameMetadata.class);
			String name;
			if (nameMetadata != null) {
				name = nameMetadata.getValue();
				if (name != null) {
					name = name + "_cloned";
				} else {
					name = "cloned";
				}
				nameMetadata.setValue(name);
			} else {
				name = "cloned";
				nameMetadata = new NameMetadata("cloned");
			}
			cloneTR.setMetadata(nameMetadata);
			TRId trIdClone = new TRId(
					String.valueOf(cloneTR.getId().getValue()));

			cloneTabularResourceSession.setTrIdClone(trIdClone);
			SessionUtil.setCloneTabularResourceSession(session,
					cloneTabularResourceSession);

			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, cloneTR.getId());
			logger.debug("Start Task on service: TaskId " + trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.Clone, trIdClone);
			SessionUtil.setTaskStarted(session, taskWrapper);

			return trTask.getId().getValue();
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error Cloning: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public String startDuplicates(DuplicatesSession duplicatesSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setDuplicatesSession(session, duplicatesSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, duplicatesSession.getTrId());

			OpExecution4Duplicates opEx = new OpExecution4Duplicates(service,
					duplicatesSession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();

			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error Delete Rows invocation: Operation not supported");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(duplicatesSession.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.DuplicateTuples, duplicatesSession.getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);

			return trTask.getId().getValue();
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in operation for duplicates: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ShareInfo getShareInfo(TRId trId) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			TabResource tabResource = getTabResourceInformation(trId);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(tabResource.getTrId().getId()));

			TabularResource tr = service.getTabularResource(serviceTR);
			ArrayList<Contacts> contacts = new ArrayList<Contacts>();
			List<String> sharedWithUsers = tr.getSharedWithUsers();
			logger.debug("Shared with Users: " + sharedWithUsers);
			if (sharedWithUsers != null) {
				for (String user : sharedWithUsers) {
					Contacts cont = new Contacts(user, user, false);
					contacts.add(cont);
				}
			}

			List<String> sharedWithGroups = tr.getSharedWithGroup();
			logger.debug("Shared with Groups: " + sharedWithUsers);
			if (sharedWithGroups != null) {
				for (String group : sharedWithGroups) {
					Contacts cont = new Contacts(group, group, true);
					contacts.add(cont);
				}
			}

			ShareInfo shareInfo = new ShareInfo(tabResource, contacts);
			return shareInfo;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in getShareInfo: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void setShare(ShareInfo shareInfo) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("ShareInfo: " + shareInfo);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, shareInfo.getTabResource()
					.getTrId());

			TabularResourceId tabularResourceId = new TabularResourceId(
					Long.valueOf(shareInfo.getTabResource().getTrId().getId()));

			List<AuthorizationToken> users = new ArrayList<AuthorizationToken>();
			for (Contacts cont : shareInfo.getContacts()) {
				AuthorizationToken at;
				if (cont.isGroup()) {
					at = new AuthorizationToken(null, cont.getLogin());
				} else {
					at = new AuthorizationToken(cont.getLogin());
				}
				users.add(at);
			}
			AuthorizationToken[] usersArray = users
					.toArray(new AuthorizationToken[0]);

			logger.debug("Share with Users: " + users);
			service.share(tabularResourceId, usersArray);

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error on service");
		}
	}

	public boolean checkTabularResourceNotFinal(TRId trId)
			throws TDGWTServiceException {
		try {

			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("checkTabularResourceNotFinal: " + trId);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId tabularResourceId = new TabularResourceId(
					new Long(trId.getId()));
			TabularResource tr = service.getTabularResource(tabularResourceId);

			return tr.isFinalized();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("Error in checkTabularResourceNotFinal: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in checkTabularResourceNotFinal: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void setTabResourceInformation(TabResource tabResource)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("SetTabResourceInformation: " + tabResource);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, tabResource.getTrId());

			TabularResourceId tabularResourceId = new TabularResourceId(
					new Long(tabResource.getTrId().getId()));

			TabularResource tr = service.getTabularResource(tabularResourceId);
			logger.debug("setTabResourceInformation - old information:" + tr);

			if (tabResource.getName() != null) {
				NameMetadata name = new NameMetadata(tabResource.getName());
				tr.setMetadata(name);
			}

			if (tabResource.getDescription() != null) {
				DescriptionMetadata description = new DescriptionMetadata(
						tabResource.getDescription());
				tr.setMetadata(description);
			}

			if (tabResource.getAgency() != null) {
				AgencyMetadata agency = new AgencyMetadata(
						tabResource.getAgency());
				tr.setMetadata(agency);
			}

			if (tabResource.getRight() != null) {
				RightsMetadata rights = new RightsMetadata(
						tabResource.getRight());
				tr.setMetadata(rights);
			}

			if (tabResource.getValidFrom() != null
					&& !tabResource.getValidFrom().isEmpty()) {
				try {
					Date dateF = sdfDate.parse(tabResource.getValidFrom());
					GregorianCalendar validFromC = new GregorianCalendar();
					validFromC.setTime(dateF);
					ValidSinceMetadata validSince = new ValidSinceMetadata();
					validSince.setValue(validFromC);
					tr.setMetadata(validSince);
				} catch (ParseException e) {
					logger.info("ValidFromMetadata is not set, no valid calendar present");
				}
			}

			if (tabResource.getValidUntilTo() != null
					&& !tabResource.getValidUntilTo().isEmpty()) {
				try {
					Date dateU = sdfDate.parse(tabResource.getValidUntilTo());
					GregorianCalendar validUntilToC = new GregorianCalendar();
					validUntilToC.setTime(dateU);
					ValidUntilMetadata validUntil = new ValidUntilMetadata();
					validUntil.setValue(validUntilToC);
					tr.setMetadata(validUntil);
				} catch (ParseException e) {
					logger.info("ValidUntilMetadata is not set, no valid calendar present");
				}
			}

			if (tabResource.getLicence() != null
					&& !tabResource.getLicence().isEmpty()) {
				LicenceMetadata licenceMetadata = new LicenceMetadata();
				Licence licence = LicenceMap.map(tabResource.getLicence());
				if (licence != null) {
					licenceMetadata.setValue(licence);
					tr.setMetadata(licenceMetadata);
				} else {
					logger.error("Licence type not found: "
							+ tabResource.getLicence());
				}

			}

			if (tabResource.isFinalized()) {
				if (tr.isValid()) {
					if (!tr.isFinalized()) {
						tr.finalize();
					}
				} else {
					throw new TDGWTServiceException(
							"Only valid tabular resource can be finalized!");
				}
			}
			logger.debug("setTabResourceInformation - new information:" + tr);

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("Error in setTabResourceInformation: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in setTabResourceInformation: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<Occurrences> getOccurrencesForBatchReplace(
			OccurrencesForReplaceBatchColumnSession occurrencesForReplaceBatchColumnSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("GetOccurencesForBatchReplace: "
					+ occurrencesForReplaceBatchColumnSession.toString());
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			ArrayList<Occurrences> occurences = QueryService.queryOccurences(
					service, occurrencesForReplaceBatchColumnSession,
					Direction.ASC);

			logger.debug("Retrieved Occurences");
			return occurences;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("Error in GetOccurencesForBatchReplace: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in GetOccurencesForBatchReplace: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<TemplateData> getTemplates() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("GetTemplates");
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			List<TemplateDescription> templateDescriptorList = service
					.getTemplates();
			ArrayList<TemplateData> templateDataList = new ArrayList<TemplateData>();
			TemplateData templateData;
			for (TemplateDescription desc : templateDescriptorList) {
				templateData = new TemplateData();
				templateData.setId(desc.getId());
				templateData.setName(desc.getName());
				templateData.setDescription(desc.getDescription());
				templateData.setAgency(desc.getAgency());
				switch (desc.getTemplate().getCategory()) {
				case CODELIST:
					templateData.setCategory("Codelist");
					break;
				case DATASET:
					templateData.setCategory("Dataset");
					break;
				case GENERIC:
					templateData.setCategory("Generic");
					break;
				default:
					break;

				}
				;

				templateDataList.add(templateData);
			}
			logger.debug("Retrieved TemplateData List");

			return templateDataList;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("Error in GetTemplates: " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in GetOccurencesForBatchReplace: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public String startTemplateApply(TemplateApplySession templateApplySession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("startTemplateApply: " + templateApplySession);
			SessionUtil.setTemplateApplySession(session, templateApplySession);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, templateApplySession.getTrId());

			TemplateId templateId = new TemplateId(templateApplySession
					.getTemplateData().getId());
			TabularResourceId tabularResourceId = new TabularResourceId(
					new Long(templateApplySession.getTrId().getId()));
			Task trTask = service.applyTemplate(templateId, tabularResourceId);
			logger.debug("startTemplateApply task start");

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.ApplyTemplate,
					templateApplySession.getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);

			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("Error StartTemplateApply: " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error StartTemplateApply: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void templateDelete(TemplateDeleteSession templateDeleteSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("startTemplateDelete: " + templateDeleteSession);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TemplateId templateId;
			for (TemplateData template : templateDeleteSession.getTemplates()) {
				templateId = new TemplateId(template.getId());
				service.remove(templateId);
			}

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (NoSuchTemplateException e) {
			logger.debug("Error StartTemplateDelete: No such Template");
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error StartTemplateDelete: No such Template");
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("Error StartTemplateDelete: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error StartTemplateDelete: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public String startReplaceColumn(ReplaceColumnSession replaceColumnSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setReplaceColumnSession(session, replaceColumnSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, replaceColumnSession.getTrId());

			OpExecution4ReplaceColumn opEx = new OpExecution4ReplaceColumn(
					service, replaceColumnSession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();

			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error Replace Column Value invocation: Operation not supported");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(replaceColumnSession.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.ReplaceValue, replaceColumnSession
							.getColumnData().getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);

			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in operation for replace column value: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public String startReplaceBatchColumn(
			ReplaceBatchColumnSession replaceBatchColumnSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setReplaceBatchColumnSession(session,
					replaceBatchColumnSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service,
					replaceBatchColumnSession.getTrId());

			OpExecution4ReplaceBatch opEx = new OpExecution4ReplaceBatch(
					service, replaceBatchColumnSession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();

			List<OperationExecution> invocations = director
					.getListOperationExecution();

			if (invocations == null) {
				throw new TDGWTServiceException("Operation not supported");
			}
			TabularResourceId serviceTRId = new TabularResourceId(
					Long.valueOf(replaceBatchColumnSession.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocations.toString());
			Task trTask = service.executeBatch(invocations, serviceTRId);
			if (trTask == null) {
				logger.error("Error on service Task null");
				throw new TDGWTServiceException("Task not started");
			}
			logger.debug("Start Task on service: TaskId " + trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.ReplaceBatch,
					replaceBatchColumnSession.getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);

			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in operation for batch replace on column: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<String> getLocales() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			@SuppressWarnings("unused")
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("getLocales()");
			List<String> listLocales = Arrays.asList(Locales.ALLOWED_LOCALES);
			ArrayList<String> locales = new ArrayList<String>();
			locales.addAll(listLocales);

			logger.debug("locales :" + locales);
			return locales;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.debug("getLocales(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving locales: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public OpHistory getLastOperationInfo() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("getLastOperationInfo()");
			TabResource currentTR = SessionUtil.getTabResource(session);
			if (currentTR == null) {
				logger.error("CURRENT_TABULAR_RESOURCE is null");
				throw new TDGWTServiceException(
						"CURRENT_TABULAR_RESOURCE is null");
			}
			TRId trId = currentTR.getTrId();

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId tabularResourceId = new TabularResourceId(
					Long.valueOf(trId.getId()));
			TabularResource tabularResource = service
					.getTabularResource(tabularResourceId);
			List<HistoryStep> history = tabularResource.getHistory();
			long historyId = 0;
			String opDesc = null, opName = null;
			HistoryStep lastStep = null;
			OpHistory op = null;

			if (history != null && history.size() > 0) {
				lastStep = history.get(0);
				if (lastStep != null) {
					opDesc = lastStep.getOperationDescription();
					opName = opDesc;
					historyId = lastStep.getId().getValue();
					op = new OpHistory(historyId, opName, opDesc,
							sdf.format(lastStep.getExecutionDate().getTime()));
				}

			}

			logger.debug("Last Operation Info :" + op);
			return op;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("getLastOperationInfo(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error retrieving last operation info: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 * 
	 */
	@Override
	public OpHistory getLastOperationInfo(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("getLastOperationInfo: " + trId);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId tabularResourceId = new TabularResourceId(
					Long.valueOf(trId.getId()));
			TabularResource tabularResource = service
					.getTabularResource(tabularResourceId);

			List<HistoryStep> history = tabularResource.getHistory();
			long historyId = 0;
			String opDesc = null, opName = null;
			HistoryStep lastStep = null;
			OpHistory op = null;

			if (history != null && history.size() > 0) {
				lastStep = history.get(0);
				if (lastStep != null) {
					opDesc = lastStep.getOperationDescription();
					opName = opDesc;
					historyId = lastStep.getId().getValue();
					op = new OpHistory(historyId, opName, opDesc,
							sdf.format(lastStep.getExecutionDate().getTime()));
				}

			}
			logger.debug("Last Operation Info :" + op);
			return op;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("getLastOperationInfo(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error retrieving last operation info: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<OpHistory> getHistory() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("getHistory()");
			TabResource currentTR = SessionUtil.getTabResource(session);
			if (currentTR == null) {
				logger.error("CURRENT_TABULAR_RESOURCE is null");
				throw new TDGWTServiceException(
						"CURRENT_TABULAR_RESOURCE is null");
			}
			TRId trId = currentTR.getTrId();

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId tabularResourceId = new TabularResourceId(
					Long.valueOf(trId.getId()));
			TabularResource tabularResource = service
					.getTabularResource(tabularResourceId);
			List<HistoryStep> history = tabularResource.getHistory();

			ArrayList<OpHistory> opHistoryList = new ArrayList<OpHistory>();

			long historyId = 0;
			String opDesc = null, opName = null;
			OpHistory op = null;

			for (HistoryStep step : history) {
				if (step != null) {
					historyId = step.getId().getValue();
					opDesc = step.getOperationDescription();
					opName = step.getOperationDescription();
					op = new OpHistory(historyId, opName, opDesc,
							sdf.format(step.getExecutionDate().getTime()));
					opHistoryList.add(op);
				}
			}

			logger.debug("History :" + opHistoryList);
			return opHistoryList;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("getHistory(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving history: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<OpHistory> getHistory(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("getHistory(): " + trId);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId tabularResourceId = new TabularResourceId(
					Long.valueOf(trId.getId()));
			TabularResource tabularResource = service
					.getTabularResource(tabularResourceId);
			List<HistoryStep> history = tabularResource.getHistory();

			ArrayList<OpHistory> opHistoryList = new ArrayList<OpHistory>();

			long historyId = 0;
			String opDesc = null, opName = null;
			OpHistory op = null;

			for (HistoryStep step : history) {
				if (step != null) {
					historyId = step.getId().getValue();
					opDesc = step.getOperationDescription();
					opName = step.getOperationDescription();
					op = new OpHistory(historyId, opName, opDesc,
							sdf.format(step.getExecutionDate().getTime()));
					opHistoryList.add(op);
				}
			}

			logger.debug("History :" + opHistoryList);
			return opHistoryList;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("getHistory(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving history: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public String startDiscard(TRId trId) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("discard(): " + trId);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, trId);

			TabularResourceId tabularResourceId = new TabularResourceId(
					Long.valueOf(trId.getId()));
			TabularResource tabularResource = service
					.getTabularResource(tabularResourceId);
			List<HistoryStep> history = tabularResource.getHistory();

			long historyId = 0;
			String opDesc = null, opName = null;
			OpHistory op = null;
			RollBackSession rollBackSession = null;
			String taskId = null;
			if (history != null) {
				if (history.size() > 1) {
					HistoryStep step = history.get(history.size() - 2);
					if (step != null) {
						historyId = step.getId().getValue();
						opDesc = step.getOperationDescription();
						opName = opDesc;
						op = new OpHistory(historyId, opName, opDesc,
								sdf.format(step.getExecutionDate().getTime()));
						logger.debug("Discard :" + op);
						rollBackSession = new RollBackSession(trId, historyId);
						taskId = startRollBack(rollBackSession);

					} else {
						logger.debug("Discard : step null");
					}
				} else {
					logger.debug("Discard : no previous step exist");
				}

			} else {
				logger.debug("Discard : not present");
			}

			return taskId;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("discard(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Discard: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public String startRollBack(RollBackSession rollBackSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("rollBack(): " + rollBackSession);
			SessionUtil.setRollBackSession(session, rollBackSession);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, rollBackSession.getTrId());

			TabularResourceId tabularResourceId = new TabularResourceId(
					Long.valueOf(rollBackSession.getTrId().getId()));
			HistoryStepId historyStepId = new HistoryStepId(
					rollBackSession.getHistoryId());

			Task trTask = service.rollbackTo(tabularResourceId, historyStepId);
			if (trTask == null) {
				logger.error("Error on service Task null");
				throw new TDGWTServiceException("Task not started");
			}
			logger.debug("Start Task on service: " + trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.RollBack, rollBackSession.getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);

			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("rollBack(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("RollBack: "
					+ e.getLocalizedMessage());
		}
	}

	@Override
	public ValidationsTasksMetadata getValidationsTasksMetadata(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("GetTableValidationsMetadata on " + trId.toString());
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			TabularResourceId tabularResourceId = new TabularResourceId(
					new Long(trId.getId()));

			ArrayList<TaskS> taskSList = new ArrayList<TaskS>();
			List<Task> tasks = service.getTasks(tabularResourceId);
			if(tasks.size()>0) {
				Task task=tasks.get(0);
				ArrayList<JobS> jobSList = new ArrayList<JobS>();
				int j = 1;
				for (Job job : task.getTaskJobs()) {
					int i = 1;
					ArrayList<Validations> validations = new ArrayList<Validations>();
					for (ValidationDescriptor val : job.getValidations()) {
						Validations validation = new Validations(
								String.valueOf(i), val.getDescription(),
								val.isValid(),
								ConditionCodeMap.mapConditionCode(val
										.getConditionCode()),
								val.getValidationColumn());
						validations.add(validation);
						i++;
					}

					InvocationS invocationS = null;
					if (job.getInvocation() != null) {
						OperationExecution operationExecution = job
								.getInvocation();
						HashMap<String, Object> mapSent = new HashMap<String, Object>();
						Map<String, Object> map = operationExecution
								.getParameters();
						Set<String> keys = map.keySet();
						Iterator<String> iterator = keys.iterator();
						while (iterator.hasNext()) {
							String key = iterator.next();
							Object o = map.get(key);
							mapSent.put(key, o.toString());
						}

						RefColumn refColumn = ExtractReferences
								.extract(operationExecution);

						invocationS = new InvocationS(j,
								operationExecution.getColumnId(),
								operationExecution.getIdentifier(),
								operationExecution.getOperationId(), mapSent,
								task.getId().getValue(), refColumn);
					}
					JobS jobS = new JobS(String.valueOf(j), job.getProgress(),
							job.getHumaReadableStatus(), job.getDescription(),
							validations, invocationS);
					jobSList.add(jobS);
					j++;

				}
				State state = TaskStateMap.map(task.getStatus());
				TaskS taskS = new TaskS(task.getId().getValue(),
						task.getProgress(), state, task.getErrorCause(),
						task.getSubmitter(), task.getStartTime(),
						task.getEndTime(), jobSList);
				taskSList.add(taskS);
			}

			ValidationsTasksMetadata validationsTasksMetadata = new ValidationsTasksMetadata(
					taskSList);

			logger.debug("ValidationsTasksMetadata: "
					+ validationsTasksMetadata);
			return validationsTasksMetadata;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error in  getValidationsTasksMetadata(): "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error in  getValidationsTasksMetadata: "
							+ e.getLocalizedMessage());
		}
	}

	@Override
	public String startEditRow(EditRowSession editRowSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setEditRowSession(session, editRowSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, editRowSession.getTrId());

			OpExecution4EditRow opEx = new OpExecution4EditRow(service,
					editRowSession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();

			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error in invocation: Operation not supported");
			}
			Long id = Long.valueOf(editRowSession.getTrId().getId());

			TabularResourceId serviceTR = new TabularResourceId(id);
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.EditRow, editRowSession.getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);

			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in operation: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ColumnData getConnection(RefColumn refColumn)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("GetConnection on " + refColumn.toString());
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			TableId tableId = new TableId(new Long(refColumn.getTableId()));

			Table table = service.getTable(tableId);
			TableDescriptorMetadata tableDesc = table
					.getMetadata(TableDescriptorMetadata.class);
			if (tableDesc == null) {
				logger.error("Error in getConnection(): No TableDescriptorMetadata found for table "
						+ table);
				throw new TDGWTServiceException(
						"Error in getConnection(): No TableDescriptorMetadata found for table "
								+ table);
			}
			if (tableDesc.getRefId() == 0) {
				logger.error("Error refId=0 for Table:" + table.toString());
				throw new TDGWTServiceException("Error refId=0 for Table:"
						+ table.toString());
			}
			logger.debug("Table connect to tabular resource: "
					+ tableDesc.getRefId());
			TRId tId = new TRId(String.valueOf(tableDesc.getRefId()));
			TRId trId = retrieveTabularResourceBasicData(tId);
			ColumnData columnData = getColumn(refColumn.getColumnId(), trId);

			return columnData;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.debug("Error in getConnection(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error: " + e.getLocalizedMessage());

		}
	}

	@Override
	public String startTaskResubmit(TaskResubmitSession taskResubmitSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setTaskResubmitSession(session, taskResubmitSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("StartTaskResubmit: " + taskResubmitSession);
			if (taskResubmitSession == null) {
				logger.error("TaskResubmitSession is null");
				throw new TDGWTServiceException(
						"Error in resubmit task: TaskResubmitSession is null");
			}
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, taskResubmitSession.getTrId());

			if (taskResubmitSession.getTaskId() == null
					|| taskResubmitSession.getTaskId().isEmpty()) {
				logger.error("Task Id is: " + taskResubmitSession.getTaskId());
				throw new TDGWTServiceException(
						"Error in resubmit task, Task Id is: "
								+ taskResubmitSession.getTaskId());
			}

			TaskId taskId = new TaskId(taskResubmitSession.getTaskId());

			Task trTask = service.resubmit(taskId);
			logger.debug("Resubmit Task on service: TaskId " + trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.ResubmitTask, taskResubmitSession.getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);
			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in resubmit task: "
					+ e.getLocalizedMessage());
		}

	}

	@Override
	public String startTaskResume(TaskResumeSession taskResumeSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setTaskResumeSession(session, taskResumeSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("StartTaskResume: " + taskResumeSession);
			if (taskResumeSession == null) {
				logger.error("TaskResumeSession is null");
				throw new TDGWTServiceException(
						"Error in resume: TaskResumeSession is null");
			}
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, taskResumeSession.getTrId());

			if (taskResumeSession.getTaskId() == null
					|| taskResumeSession.getTaskId().isEmpty()) {
				logger.error("Task Id is: " + taskResumeSession.getTaskId());
				throw new TDGWTServiceException(
						"Error in resume task, Task Id is: "
								+ taskResumeSession.getTaskId());
			}

			TaskId taskId = new TaskId(taskResumeSession.getTaskId());

			Map<String, Object> map = new HashMap<String, Object>();
			ArrayList<ColumnMappingData> columnMapping = taskResumeSession
					.getColumnMapping();

			Task trTask;
			if (columnMapping != null && columnMapping.size() > 0) {
				HashMap<TDTypeValue, Long> mapping = new HashMap<TDTypeValue, Long>();
				logger.debug("New Mapping");
				for (ColumnMappingData columnMappingData : columnMapping) {
					if (columnMappingData.getSourceArg() != null
							&& columnMappingData.getTargetArg() != null) {
						DimensionRow source = columnMappingData.getSourceArg();
						DimensionRow target = columnMappingData.getTargetArg();

						TDTypeValue tdValue = TDTypeValueMap
								.map(taskResumeSession.getColumn()
										.getDataTypeName(), source.getValue());
						logger.debug("Key = " + tdValue + " - "
								+ new Long(target.getRowId()));
						mapping.put(tdValue, new Long(target.getRowId()));

					}

				}

				InvocationS invocationS = taskResumeSession.getInvocationS();

				if (invocationS != null) {
					if (invocationS.getJobNumber() != null) {
						if (invocationS.getTaskId() != null) {
							Integer jobNumber = invocationS.getJobNumber();
							TaskId previousTaskId = new TaskId(
									invocationS.getTaskId());
							Task previousTask = service.getTask(previousTaskId);
							List<Job> previousJobs = previousTask.getTaskJobs();
							if (previousJobs != null) {
								Job previousJob = previousJobs
										.get(jobNumber - 1);
								if (previousJob != null) {
									Map<String, Object> mapParameters = previousJob
											.getInvocation().getParameters();
									if (mapParameters != null) {
										@SuppressWarnings("unchecked")
										Map<TDTypeValue, Long> mappingPrevious = (Map<TDTypeValue, Long>) mapParameters
												.get(Constants.PARAMETER_COLUMN_MAPPING);
										logger.debug("Previous Mapping");
										if (mappingPrevious != null) {
											for (TDTypeValue key : mappingPrevious
													.keySet()) {
												logger.debug("Key = "
														+ key
														+ " - "
														+ mappingPrevious
																.get(key));
												mapping.put(key,
														mappingPrevious
																.get(key));
											}
										} else {
											logger.debug("Previous Mapping is null");
										}
									} else {
										logger.debug("Parameters is null");
									}
								} else {
									logger.debug("PreviousJob is null");
								}
							} else {
								logger.debug("PreviousJobs is null");
							}
						} else {
							logger.debug("TaskId is null");
						}
					} else {
						logger.debug("JobNumber is null");
					}
				} else {
					logger.debug("InvocationS is null");
				}

				map.put(Constants.PARAMETER_COLUMN_MAPPING, mapping);
				trTask = service.resume(taskId, map);
				logger.debug("Resume Task on service: [TaskId:"
						+ trTask.getId() + ", Map:" + map + "]");
			} else {
				trTask = service.resume(taskId);
				logger.debug("Resume Task on service: [TaskId:"
						+ trTask.getId() + "]");

			}

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.ResumeTask, taskResumeSession.getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);

			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in resume task: "
					+ e.getLocalizedMessage());
		}

	}

	@Override
	public String startExtractCodelist(
			ExtractCodelistSession extractCodelistSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setExtractCodelistSession(session,
					extractCodelistSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("StartExtractCodelist: " + extractCodelistSession);
			if (extractCodelistSession == null) {
				logger.error("ExtractCodelistSession is null");
				throw new TDGWTServiceException(
						"Error in extract codelist: ExtractCodelistSession is null");
			}
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service,
					extractCodelistSession.getTrId());

			OpExecution4ExtractCodelist opEx = new OpExecution4ExtractCodelist(
					service, extractCodelistSession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();

			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error in invocation: Operation not supported");
			}
			Long id = Long.valueOf(extractCodelistSession.getTrId().getId());

			TabularResourceId serviceTR = new TabularResourceId(id);
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Extract Codelist on service: TaskId "
					+ trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.ExtractCodelist,
					extractCodelistSession.getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);
			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in extract codelist: "
					+ e.getLocalizedMessage());
		}

	}

	public String startSplitColumn(SplitColumnSession splitColumnSession,
			HttpSession session) throws TDGWTServiceException {
		try {
			// HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setSplitColumnSession(session, splitColumnSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);
			if (splitColumnSession == null) {
				logger.error("SplitColumnSession is null");
				throw new TDGWTServiceException(
						"Error in split column: SplitColumnSession is null");
			}

			logger.debug("StartSplitColumn: " + splitColumnSession);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, splitColumnSession
					.getColumnData().getTrId());

			OpExecution4SplitColumn opEx = new OpExecution4SplitColumn(service,
					splitColumnSession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			ArrayList<OperationExecution> invocations = director
					.getListOperationExecution();

			if (invocations == null) {
				throw new TDGWTServiceException(
						"Error in invocation: Operation not supported");
			}
			Long id = Long.valueOf(splitColumnSession.getColumnData().getTrId()
					.getId());

			TabularResourceId serviceTR = new TabularResourceId(id);
			logger.debug("OperationInvocation: \n" + invocations.toString());
			Task trTask = service.executeBatch(invocations, serviceTR);
			logger.debug("Split Column on service: TaskId " + trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.SplitColumn, splitColumnSession
							.getColumnData().getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);
			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in split column: "
					+ e.getLocalizedMessage());
		}

	}

	// TODO
	public String startMergeColumn(MergeColumnSession mergeColumnSession,
			HttpSession session) throws TDGWTServiceException {
		try {
			// HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setMergeColumnSession(session, mergeColumnSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);
			if (mergeColumnSession == null) {
				logger.error("MergeColumnSession is null");
				throw new TDGWTServiceException(
						"Error in split column: MergeColumnSession is null");
			}

			logger.debug("StartMergeColumn: " + mergeColumnSession);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, mergeColumnSession
					.getColumnDataSource1().getTrId());

			OpExecution4MergeColumn opEx = new OpExecution4MergeColumn(service,
					mergeColumnSession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			ArrayList<OperationExecution> invocations = director
					.getListOperationExecution();

			if (invocations == null) {
				throw new TDGWTServiceException(
						"Error in invocation: Operation not supported");
			}

			Long id = Long.valueOf(mergeColumnSession.getColumnDataSource1()
					.getTrId().getId());

			TabularResourceId serviceTR = new TabularResourceId(id);
			logger.debug("OperationInvocation: \n" + invocations.toString());
			Task trTask = service.executeBatch(invocations, serviceTR);
			logger.debug("Merge Column on service: TaskId " + trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.MergeColumn, mergeColumnSession
							.getColumnDataSource1().getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);
			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in split column: "
					+ e.getLocalizedMessage());
		}

	}

	@Override
	public void setCodelistMappingSession(
			CodelistMappingSession codelistMappingSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setCodelistMappingSession(session,
					codelistMappingSession);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.error(
					"Error setting CodelistMappingSession parameter: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error setting CodelistMappingSession parameter: "
							+ e.getLocalizedMessage());
		}

	}

	@Override
	public void getFileFromWorkspace(
			CodelistMappingSession codelistMappingSession)
			throws TDGWTServiceException {
		HttpSession session = this.getThreadLocalRequest().getSession();
		ASLSession aslSession = SessionUtil.getAslSession(session);
		Workspace w = null;
		WorkspaceItem wi = null;

		try {
			HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();

			HomeManager manager = factory.getHomeManager();

			Home home = manager.getHome(aslSession.getUsername());

			w = home.getWorkspace();
			wi = w.getItem(codelistMappingSession.getItemId());
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in import Codelist Mapping getFileFromWorkspace accessing the workspace: "
							+ e.getLocalizedMessage(), e);
		}

		if (wi == null) {
			logger.error("Error retrieving the item on workspace"
					+ codelistMappingSession.getItemId());
			throw new TDGWTServiceException(
					"Error retrieving the item on workspace"
							+ codelistMappingSession.getItemId());
		}

		try {
			logger.debug("WorkspaceItem [id:" + wi.getId() + " name:"
					+ wi.getName() + " remotePath:" + wi.getRemotePath() + "]");
		} catch (InternalErrorException e1) {
			e1.printStackTrace();
			throw new TDGWTServiceException(
					"Error retrieving the item on workspace" + wi);
		}

		CodelistMappingFileUploadSession fileUploadSession = new CodelistMappingFileUploadSession();
		// CodelistMappingMonitor codelistMappingMonitor = new
		// CodelistMappingMonitor();
		FileUploadMonitor fileUploadMonitor = new FileUploadMonitor();

		fileUploadSession.setId(session.getId());
		fileUploadSession.setFileUploadState(FileUploadState.STARTED);
		// fileUploadSession.setCodelistMappingMonitor(codelistMappingMonitor);

		SessionUtil.setFileUploadMonitor(session, fileUploadMonitor);
		SessionUtil.setCodelistMappingFileUploadSession(session,
				fileUploadSession);

		try {
			FilesStorage filesStorage = new FilesStorage();
			InputStream is = filesStorage.retriveImputStream(
					aslSession.getUsername(), wi);

			FileUtil.setImportFileCodelistMapping(fileUploadSession, is,
					wi.getName(), Constants.FILE_XML_MIMETYPE);
		} catch (Throwable e) {
			FileUploadMonitor fum = SessionUtil.getFileUploadMonitor(session);
			fum.setFailed("An error occured elaborating the file",
					FileUtil.exceptionDetailMessage(e));
			SessionUtil.setFileUploadMonitor(session, fum);
			fileUploadSession.setFileUploadState(FileUploadState.FAILED);
			SessionUtil.setCodelistMappingFileUploadSession(session,
					fileUploadSession);
			logger.error("Error elaborating the input stream", e);
			throw new TDGWTServiceException(
					"Error in import Codelist Mapping getFileFromWorkspace: "
							+ e.getLocalizedMessage(), e);
		}

		logger.trace("changing state");
		FileUploadMonitor fum = SessionUtil.getFileUploadMonitor(session);
		fum.setState(FileUploadState.COMPLETED);
		SessionUtil.setFileUploadMonitor(session, fum);

		SessionUtil.setCodelistMappingFileUploadSession(session,
				fileUploadSession);

	}

	@Override
	public String startCodelistMappingImport(
			CodelistMappingSession codelistMappingSession)
			throws TDGWTServiceException {
		try {

			HttpSession session = this.getThreadLocalRequest().getSession();
			if (session == null) {
				throw new TDGWTServiceException("Session is null");
			}
			logger.debug("Session:" + session.getId());

			ASLSession aslSession = SessionUtil.getAslSession(session);

			String user = aslSession.getUsername();
			logger.debug("Session User:" + user);

			if (codelistMappingSession == null) {
				throw new TDGWTServiceException(
						"CodelistMappingSession is null");
			}

			logger.debug("StartCodelistMappingImport: "
					+ codelistMappingSession);

			SessionUtil.setCodelistMappingSession(session,
					codelistMappingSession);

			String taskId = importCodelistMappingFileOnService(session,
					aslSession, user, codelistMappingSession);
			return taskId;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in Codelist Mapping import: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * @param user
	 * @param codelistMappingFileUploadSession
	 * @param codelistMappingSession
	 * @throws TDGWTServiceException
	 */
	protected String importCodelistMappingFileOnService(HttpSession session,
			ASLSession aslSession, String user,
			CodelistMappingSession codelistMappingSession) throws Throwable {

		String importUrl = null;

		if (codelistMappingSession.getSource().getId()
				.compareTo(SourceType.URL.toString()) == 0) {
			importUrl = codelistMappingSession.getUrl();
		} else {
			CodelistMappingFileUploadSession codelistMappingFileUploadSession = SessionUtil
					.getCodelistMappingFileUploadSession(session);
			if (codelistMappingFileUploadSession == null) {
				throw new TDGWTServiceException(
						"Error retrieving the codelistMappingFileUploadSession: null");
			}
			logger.debug("File Storage Access");
			FilesStorage filesStorage = new FilesStorage();
			String fileUrlOnStorage = filesStorage
					.storageCodelistMappingTempFile(user,
							codelistMappingFileUploadSession
									.getCodelistMappingFile());
			logger.debug("File Url On Storage:" + fileUrlOnStorage);
			codelistMappingFileUploadSession.getCodelistMappingFile().delete();

			if (fileUrlOnStorage == null || fileUrlOnStorage.isEmpty()) {
				throw new TDGWTServiceException(
						"Tabular Data Service error loading file on storage");
			}
			importUrl = fileUrlOnStorage;
		}

		AuthorizationProvider.instance.set(new AuthorizationToken(aslSession
				.getUsername(), aslSession.getScope()));
		TabularDataService service = TabularDataServiceFactory.getService();
		checkTabularResourceLocked(service, codelistMappingSession.getTrId());

		OpExecution4CodelistMapping opEx = new OpExecution4CodelistMapping(
				service, codelistMappingSession, importUrl);
		OpExecutionDirector director = new OpExecutionDirector();
		director.setOperationExecutionBuilder(opEx);
		director.constructOperationExecution();
		OperationExecution invocation = director.getOperationExecution();

		if (invocation == null) {
			throw new TDGWTServiceException(
					"Error in invocation: Operation not supported");
		}
		Long id = Long.valueOf(codelistMappingSession.getTrId().getId());

		TabularResourceId serviceTR = new TabularResourceId(id);
		logger.debug("OperationInvocation: \n" + invocation.toString());
		Task trTask = service.execute(invocation, serviceTR);
		logger.debug("Codelist Mapping Import on service: TaskId "
				+ trTask.getId());
		TaskWrapper taskWrapper = new TaskWrapper(trTask,
				UIOperationsId.CodelistMappingImport,
				codelistMappingSession.getTrId());
		SessionUtil.setTaskStarted(session, taskWrapper);
		return trTask.getId().getValue();

	}

	// TODO
	public String startGroupBy(GroupBySession groupBySession,
			HttpSession session) throws TDGWTServiceException {
		try {
			// HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setGroupBySession(session, groupBySession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("StartGroupBy: " + groupBySession);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, groupBySession.getTrId());
			
			OpExecution4GroupBy opEx = new OpExecution4GroupBy(service,
					groupBySession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();

			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error in invocation: Operation not supported");
			}
			Long id = Long.valueOf(groupBySession.getTrId().getId());

			TabularResourceId serviceTR = new TabularResourceId(id);
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("GroupBy start on service: TaskId " + trTask.getId());
			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.GroupBy, groupBySession.getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);
			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in start group by: "
					+ e.getLocalizedMessage());
		}
	}

	@Override
	public String startNormalization(NormalizationSession normalizationSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setNormalizationSession(session, normalizationSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);
			if (normalizationSession == null) {
				logger.error("NormalizationSession is null");
				throw new TDGWTServiceException(
						"Error in normalization : NormalizationSession is null");
			}

			logger.debug("StartNormalization: " + normalizationSession);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, normalizationSession.getTrId());
			
			OpExecution4Normalization opEx = new OpExecution4Normalization(
					service, normalizationSession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();

			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error in invocation: Operation not supported");
			}
			Long id = Long.valueOf(normalizationSession.getTrId().getId());

			TabularResourceId serviceTR = new TabularResourceId(id);
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Normalization start on service: TaskId "
					+ trTask.getId());

			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.Normalize, normalizationSession.getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);
			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in start normalization: "
					+ e.getLocalizedMessage());
		}

	}

	@Override
	public String startDenormalization(
			DenormalizationSession denormalizationSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setDenormalizationSession(session,
					denormalizationSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);
			if (denormalizationSession == null) {
				logger.error("DenormalizationSession is null");
				throw new TDGWTServiceException(
						"Error in normalization : DenormalizationSession is null");
			}

			logger.debug("StartDenormalization: " + denormalizationSession);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, denormalizationSession.getTrId());
			
			OpExecution4Denormalization opEx = new OpExecution4Denormalization(
					service, denormalizationSession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();

			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error in invocation: Operation not supported");
			}
			Long id = Long.valueOf(denormalizationSession.getTrId().getId());

			TabularResourceId serviceTR = new TabularResourceId(id);
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Denormalization start on service: TaskId "
					+ trTask.getId());
			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.Denormalize,
					denormalizationSession.getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);
			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in start denormalization: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public String startUnion(UnionSession unionSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setUnionSession(session, unionSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			checkTabularResourceLocked(service, unionSession.getTrId());
			
			OpExecution4Union opEx = new OpExecution4Union(service,
					unionSession);
			OpExecutionDirector director = new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();

			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error Union invocation: Operation not supported");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(unionSession.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			TaskWrapper taskWrapper = new TaskWrapper(trTask,
					UIOperationsId.Union, unionSession.getTrId());
			SessionUtil.setTaskStarted(session, taskWrapper);
			return trTask.getId().getValue();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in union: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public OperationMonitor getOperationMonitor(
			OperationMonitorSession operationMonitorSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			TaskWrapper taskWrapper = SessionUtil.getTaskStarted(session,
					operationMonitorSession.getTaskId());

			OperationMonitorCreator operationMonitorCreator = new OperationMonitorCreator(
					session, aslSession, taskWrapper, operationMonitorSession);
			OperationMonitor operationMonitor = operationMonitorCreator
					.create();

			logger.debug("OperationMonitor(): " + operationMonitor);
			return operationMonitor;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (TDGWTServiceException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in Operation Monitor: "
					+ e.getLocalizedMessage());

		}
	}

	/**
	 * 
	 */
	@Override
	public ArrayList<LicenceData> getLicences() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.getAslSession(session);

			ArrayList<LicenceData> licences = new ArrayList<LicenceData>();
			Licence[] licencesArray = Licence.values();
			Licence licence;
			LicenceData licenceData;
			for (int i = 0; i < licencesArray.length; i++) {
				licence = licencesArray[i];
				licenceData = new LicenceData(i, licence.toString());
				licences.add(licenceData);
			}

			logger.debug("Licences: " + licences.size());
			return licences;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in get Licences: "
					+ e.getLocalizedMessage());
		}

	}

}
