package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.HashMap;
import java.util.Map;

import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.Constants;
import org.gcube.portlets.user.td.gwtservice.shared.OperationsId;
import org.gcube.portlets.user.td.gwtservice.shared.codelisthelper.CodelistMappingSession;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Operation Execution for codelist mapping
 * 
 * @author "Giancarlo Panichi" email: <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class OpExecution4CodelistMapping extends OpExecutionBuilder {
	protected static Logger logger = LoggerFactory
			.getLogger(OpExecution4CodelistMapping.class);

	private TabularDataService service;
	private CodelistMappingSession codelistMappingSession;
	private String importUrl;

	public OpExecution4CodelistMapping(
			TabularDataService service,
			CodelistMappingSession codelistMappingSession, String importUrl) {
		this.service = service;
		this.codelistMappingSession = codelistMappingSession;
		this.importUrl=importUrl;
	}

	@Override
	public void buildOpEx() throws TDGWTServiceException {
		OperationExecution invocation = null;

		logger.debug(codelistMappingSession.toString());
		OperationDefinition operationDefinition;
		Map<String, Object> map = new HashMap<String, Object>();

		operationDefinition = OperationDefinitionMap.map(
				OperationsId.CodelistMappingImport.toString(), service);
		map.put(Constants.PARAMETER_URL, importUrl);

		invocation = new OperationExecution(
				operationDefinition.getOperationId(), map);
		
		operationExecutionSpec.setOp(invocation);

	}

}
