/**
 * 
 */
package org.gcube.portlets.user.td.gwtservice.server;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpSession;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.Profile;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TemplateDescription;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.ValidationDescriptor;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.Locales;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ViewColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.DescriptionsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.TableDescriptorMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.Validation;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ValidationsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.ExportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GenericMapMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.ImportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.VersionMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTemplateException;
import org.gcube.data.analysis.tabulardata.service.impl.TabularDataServiceFactory;
import org.gcube.data.analysis.tabulardata.service.operation.Job;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.TaskId;
import org.gcube.data.analysis.tabulardata.service.tabular.HistoryStep;
import org.gcube.data.analysis.tabulardata.service.tabular.HistoryStepId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.AgencyMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.DescriptionMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.NameMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.RightsMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.TabularResourceMetadata;
import org.gcube.data.analysis.tabulardata.service.template.TemplateId;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryDescriptor;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryInterfaceType;
import org.gcube.datapublishing.sdmx.impl.model.GCubeSDMXRegistryDescriptor;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTService;
import org.gcube.portlets.user.td.gwtservice.server.file.CSVFileUploadSession;
import org.gcube.portlets.user.td.gwtservice.server.file.CodelistMappingFileUploadSession;
import org.gcube.portlets.user.td.gwtservice.server.file.FileUtil;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4AddColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ChangeColumnType;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ChangeTableType;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4CodelistMapping;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4DeleteColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4DeleteRows;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4Duplicates;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4EditRow;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ExtractCodelist;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4GroupBy;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4LabelColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4MergeColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ReplaceBatch;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ReplaceColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4SplitColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionDirector;
import org.gcube.portlets.user.td.gwtservice.server.storage.FilesStorage;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ExtractReferences;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.QueryService;
import org.gcube.portlets.user.td.gwtservice.server.trservice.TaskStateMap;
import org.gcube.portlets.user.td.gwtservice.shared.Constants;
import org.gcube.portlets.user.td.gwtservice.shared.OperationsId;
import org.gcube.portlets.user.td.gwtservice.shared.codelisthelper.CodelistMappingMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.codelisthelper.CodelistMappingSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.AvailableCharsetList;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVFileUtil;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVParserConfiguration;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVRowError;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.extract.ExtractCodelistMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.extract.ExtractCodelistSession;
import org.gcube.portlets.user.td.gwtservice.shared.file.FileUploadMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.file.FileUploadState;
import org.gcube.portlets.user.td.gwtservice.shared.file.HeaderPresence;
import org.gcube.portlets.user.td.gwtservice.shared.history.OpHistory;
import org.gcube.portlets.user.td.gwtservice.shared.history.RollBackSession;
import org.gcube.portlets.user.td.gwtservice.shared.history.RollBackSessionMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXExportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.share.Contacts;
import org.gcube.portlets.user.td.gwtservice.shared.share.ShareInfo;
import org.gcube.portlets.user.td.gwtservice.shared.source.SDMXRegistrySource;
import org.gcube.portlets.user.td.gwtservice.shared.source.SourceType;
import org.gcube.portlets.user.td.gwtservice.shared.task.InvocationS;
import org.gcube.portlets.user.td.gwtservice.shared.task.JobS;
import org.gcube.portlets.user.td.gwtservice.shared.task.State;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResubmitMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResubmitSession;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResumeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResumeSession;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskS;
import org.gcube.portlets.user.td.gwtservice.shared.task.ValidationsTasksMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateApplyMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateApplySession;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateData;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateDeleteSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnViewData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.RefColumn;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TableData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.Occurrences;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.OccurrencesForReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceBatchColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.clone.CloneTabularResourceSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.AddColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.AddColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.MergeColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.MergeColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.SplitColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.SplitColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.groupby.GroupByMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.groupby.GroupBySession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRAgencyMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRDescriptionMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRLocalizedText;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRNameMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRRightsMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.open.TDOpenSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadConfig;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadResult;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.Direction;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.OrderInfo;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DeleteRowsMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DeleteRowsSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DuplicatesMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DuplicatesSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.EditRowMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.EditRowSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.Validations;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabDescriptionsMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabExportMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabGenericMapMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabImportMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabNamesMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabValidationsMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabVersionMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Agencies;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Codelist;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Dataset;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.RelationshipData;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class TDGWTServiceImpl extends RemoteServiceServlet implements
		TDGWTService {

	private static final long serialVersionUID = -5707400086333186368L;
	protected static Logger logger = LoggerFactory
			.getLogger(TDGWTServiceImpl.class);

	protected static SimpleDateFormat sdf = new SimpleDateFormat(
			"yyyy/MM/dd HH:mm");

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public String hello() throws TDGWTServiceException {
		HttpSession session = this.getThreadLocalRequest().getSession();
		ASLSession aslSession = SessionUtil.getAslSession(session);
		String user = aslSession.getUsername();
		return user;
	}

	/**
	 * 
	 * {@inheritDoc}
	 */

	public void setTabResource(TabResource tabResource)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			if (tabResource == null) {
				logger.error("Error setting TabResource: null");
				throw new TDGWTServiceException(
						"Error setting TabResource: null");
			}

			SessionUtil.setTabResource(session, tabResource);
			SessionUtil.setTRId(session, tabResource.getTrId());
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;

		} catch (Throwable e) {
			logger.error(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public TRId getCurrentTRId() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();

			TabResource currentTR = SessionUtil.getTabResource(session);
			logger.debug("getCurrentTRId()");
			if (currentTR == null) {
				logger.error("CURRENT_TABULAR_RESOURCE is null");
				throw new TDGWTServiceException(
						"CURRENT_TABULAR_RESOURCE is null");
			}
			logger.debug("getCurrentTRId():" + currentTR.toString());

			if (currentTR.getTrId() == null) {
				logger.error("CURRENT_TABULAR_RESOURCE has TRId null");
				throw new TDGWTServiceException(
						"CURRENT_TABULAR_RESOURCE has TRId null");
			}
			logger.debug("getCurrentTRId():" + currentTR.getTrId());
			return currentTR.getTrId();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error("getCurrentTRID(): " + e.getLocalizedMessage(), e);
			throw new TDGWTServiceException("Error retrieving TR id: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public TabResource getTabResourceInformation() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();

			ASLSession aslSession = SessionUtil.getAslSession(session);

			TabResource currentTR = SessionUtil.getTabResource(session);
			if (currentTR == null) {
				logger.error("CURRENT_TABULAR_RESOURCE is null");
				throw new TDGWTServiceException(
						"CURRENT_TABULAR_RESOURCE is null");
			}
			logger.debug("GetTabResourceInformation():" + currentTR.toString());

			if (currentTR.getTrId() == null) {
				logger.error("CURRENT_TABULAR_RESOURCE has TRId null");
				throw new TDGWTServiceException(
						"CURRENT_TABULAR_RESOURCE has TRId null");
			}
			logger.debug("Current TRId: " + currentTR.getTrId());

			ArrayList<TRMetadata> trMetadatas = getTRMetadata(currentTR
					.getTrId());
			updateTabResourceInformation(currentTR, trMetadatas);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResource tr = service
					.getTabularResource(new TabularResourceId(Long
							.valueOf(currentTR.getTrId().getId())));

			currentTR.setDate(sdf.format(tr.getCreationDate().getTime()));
			currentTR.setValid(tr.isValid());
			currentTR.setFinalized(tr.isFinalized());
			Contacts owner = new Contacts("", tr.getOwner(), false);
			currentTR.setOwner(owner);
			SessionUtil.setTabResource(session, currentTR);
			logger.debug("GetTabResourceInformation() updated information:"
					+ currentTR.toString());
			return currentTR;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public TabResource getTabResourceInformation(TRId trId)
			throws TDGWTServiceException {
		try {

			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			if (trId == null) {
				logger.error("GetTabularREsourceInformation TRId is null");
				throw new TDGWTServiceException(
						"GetTabularREsourceInformation TRId is  null");
			}

			logger.debug("GetTabResourceInformation:" + trId.toString());
			TabResource currentTR = new TabResource();
			currentTR.setTrId(trId);

			ArrayList<TRMetadata> trMetadatas = getTRMetadata(currentTR
					.getTrId());
			updateTabResourceInformation(currentTR, trMetadatas);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResource tr = service
					.getTabularResource(new TabularResourceId(Long
							.valueOf(currentTR.getTrId().getId())));

			currentTR.setDate(sdf.format(tr.getCreationDate().getTime()));
			currentTR.setValid(tr.isValid());
			currentTR.setFinalized(tr.isFinalized());
			Contacts owner = new Contacts("", tr.getOwner(), false);
			currentTR.setOwner(owner);

			logger.debug("GetTabResourceInformation() updated information:"
					+ currentTR.toString());
			return currentTR;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage());
		}
	}

	protected void updateTabResourceInformation(TabResource tabResource,
			ArrayList<TRMetadata> trMetadatas) {
		for (TRMetadata trMetadata : trMetadatas) {
			if (trMetadata instanceof TRDescriptionMetadata) {
				tabResource.setDescription(((TRDescriptionMetadata) trMetadata)
						.getValue());
			} else {
				if (trMetadata instanceof TRNameMetadata) {
					tabResource.setName(((TRNameMetadata) trMetadata)
							.getValue());
				} else {
					if (trMetadata instanceof TRAgencyMetadata) {
						tabResource.setAgency(((TRAgencyMetadata) trMetadata)
								.getValue());
					} else {
						if (trMetadata instanceof TRRightsMetadata) {
							tabResource
									.setRight(((TRRightsMetadata) trMetadata)
											.getValue());
						} else {

						}

					}
				}
			}
		}
	}

	/**
	 * Returns ArrayList<ColumnData> other than IdColumnType and
	 * ValidationColumnType
	 * 
	 * {@inheritDoc}
	 */
	public ArrayList<ColumnData> getColumns() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			TabResource currentTR = SessionUtil.getTabResource(session);
			if (currentTR == null) {
				logger.error("CURRENT_TABULAR_RESOURCE is null");
				throw new TDGWTServiceException(
						"CURRENT_TABULAR_RESOURCE is null");
			}
			TRId trId = currentTR.getTrId();

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getLastTable(new TabularResourceId(Long
					.valueOf(trId.getId())));

			ArrayList<ColumnData> columns = new ArrayList<ColumnData>();

			List<Column> cols = table.getColumns();
			int i = 0;
			// || c.getColumnType() instanceof DimensionColumnType
			// || c.getColumnType() instanceof TimeDimensionColumnType
			for (Column c : cols) {
				if (c.getColumnType() instanceof IdColumnType
						|| c.getColumnType() instanceof ValidationColumnType) {

				} else {
					if (c.contains(ViewColumnMetadata.class)) {

					} else {
						ColumnData cData = new ColumnData();

						cData.setId(Integer.toString(i));
						cData.setColumnId(c.getLocalId().getValue());
						cData.setName(c.getName());
						cData.setTypeCode(c.getColumnType().getCode());
						cData.setTypeName(c.getColumnType().getName());
						cData.setDataTypeName(c.getDataType().getName());
						ColumnRelationship rel = c.getRelationship();
						if (rel != null) {
							RelationshipData relData = new RelationshipData(rel
									.getTargetTableId().getValue(), rel
									.getTargetColumnId().getValue());
							cData.setRelationship(relData);

						}
						NamesMetadata labelsMetadata = null;
						try {
							labelsMetadata = c.getMetadata(NamesMetadata.class);
						} catch (NoSuchMetadataException e) {
							logger.debug("labelMetadata: NoSuchMetadataException "
									+ e.getLocalizedMessage());
						}

						if (labelsMetadata == null) {
							cData.setLabel("nolabel");
							logger.debug("LabelsMetadata no labels");
						} else {
							LocalizedText cl = null;
							cl = labelsMetadata.getTextWithLocale("en");
							if (cl == null) {
								cData.setLabel("nolabel");
								logger.debug("ColumnLabel no label in en");
							} else {
								if (cl.getValue() == null
										|| cl.getValue().isEmpty()) {
									cData.setLabel("nolabel");
									logger.debug("ColumnLabel no label in en");
								} else {
									cData.setLabel(cl.getValue());
									logger.debug("Column Set Label: "
											+ cl.getValue());
								}
							}
						}

						DataLocaleMetadata dataLocaleMetadata = null;
						try {
							dataLocaleMetadata = c
									.getMetadata(DataLocaleMetadata.class);
						} catch (NoSuchMetadataException e) {
							logger.debug("DataLocaleMetadata: NoSuchMetadataException "
									+ e.getLocalizedMessage());
						}

						if (dataLocaleMetadata == null) {
							logger.debug("No DataLocaleMetadata");
						} else {
							cData.setLocale(dataLocaleMetadata.getLocale());
						}

						cData.setTrId(trId);
						columns.add(cData);
						i++;
					}
				}
			}

			return columns;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error retrieving Columns: " + e.getLocalizedMessage(), e);
			throw new TDGWTServiceException("Error retrieving Columns: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * Returns ArrayList<ColumnData> other than IdColumnType,
	 * ValidationColumnType, DimensionColumnType and TimeDimensionColumnType
	 * 
	 * 
	 * {@inheritDoc}
	 */
	public ArrayList<ColumnData> getColumns(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			logger.debug("getColumns():" + trId.toString());

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));

			ArrayList<ColumnData> columns = new ArrayList<ColumnData>();

			List<Column> cols = table.getColumns();
			int i = 0;
			for (Column c : cols) {
				if (c.getColumnType() instanceof IdColumnType
						|| c.getColumnType() instanceof ValidationColumnType) {

				} else {
					if (c.contains(ViewColumnMetadata.class)) {

					} else {
						ColumnData cData = new ColumnData();
						cData.setId(Integer.toString(i));
						cData.setColumnId(c.getLocalId().getValue());
						cData.setName(c.getName());
						cData.setTypeCode(c.getColumnType().getCode());
						cData.setTypeName(c.getColumnType().getName());
						cData.setDataTypeName(c.getDataType().getName());
						ColumnRelationship rel = c.getRelationship();
						if (rel != null) {
							RelationshipData relData = new RelationshipData(rel
									.getTargetTableId().getValue(), rel
									.getTargetColumnId().getValue());
							cData.setRelationship(relData);

						}
						NamesMetadata labelsMetadata = null;
						try {
							labelsMetadata = c.getMetadata(NamesMetadata.class);
						} catch (NoSuchMetadataException e) {
							logger.debug("labelMetadata: NoSuchMetadataException "
									+ e.getLocalizedMessage());
						}

						if (labelsMetadata == null) {
							cData.setLabel("nolabel");
							logger.debug("LabelsMetadata no labels");
						} else {
							LocalizedText cl = null;
							cl = labelsMetadata.getTextWithLocale("en");
							if (cl == null) {
								cData.setLabel("nolabel");
								logger.debug("ColumnLabel no label in en");
							} else {
								if (cl.getValue() == null
										|| cl.getValue().isEmpty()) {
									cData.setLabel("nolabel");
									logger.debug("ColumnLabel no label in en");
								} else {
									cData.setLabel(cl.getValue());
									logger.debug("Column Set Label: "
											+ cl.getValue());
								}
							}
						}

						DataLocaleMetadata dataLocaleMetadata = null;
						try {
							dataLocaleMetadata = c
									.getMetadata(DataLocaleMetadata.class);
						} catch (NoSuchMetadataException e) {
							logger.debug("DataLocaleMetadata: NoSuchMetadataException "
									+ e.getLocalizedMessage());
						}

						if (dataLocaleMetadata == null) {
							logger.debug("No DataLocaleMetadata");
						} else {
							cData.setLocale(dataLocaleMetadata.getLocale());
						}

						cData.setTrId(trId);
						columns.add(cData);
						i++;

					}
				}
			}

			return columns;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error retrieving Columns: " + e.getLocalizedMessage(), e);
			throw new TDGWTServiceException("Error retrieving Columns: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public ColumnData getColumn(String columnLocalId, TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));

			ColumnData cData = new ColumnData();
			ColumnLocalId columnId = new ColumnLocalId(columnLocalId);
			Column c = table.getColumnById(columnId);
			if (c.getColumnType() instanceof IdColumnType) {

			} else {
				cData.setId(Integer.toString(0));
				cData.setColumnId(c.getLocalId().getValue());
				cData.setName(c.getName());

				if (c.contains(ViewColumnMetadata.class)) {
					ViewColumnMetadata viewMetadata = c
							.getMetadata(ViewColumnMetadata.class);
					logger.debug("ViewColumnMetadata: "
							+ viewMetadata.toString());

					String sourceTableDimensionColumnId = viewMetadata
							.getSourceTableDimensionColumnId().getValue();
					String targetTableColumnId = viewMetadata
							.getTargetTableColumnId().getValue();
					long targetTableId = viewMetadata.getTargetTableId()
							.getValue();
					ColumnViewData columnViewData = new ColumnViewData(
							sourceTableDimensionColumnId, targetTableColumnId,
							targetTableId);
					cData.setColumnViewData(columnViewData);
					cData.setViewColumn(true);

				} else {
					cData.setViewColumn(false);
				}
				cData.setTypeCode(c.getColumnType().getCode());
				cData.setTypeName(c.getColumnType().getName());
				cData.setDataTypeName(c.getDataType().getName());
				ColumnRelationship rel = c.getRelationship();
				if (rel != null) {
					RelationshipData relData = new RelationshipData(rel
							.getTargetTableId().getValue(), rel
							.getTargetColumnId().getValue());
					cData.setRelationship(relData);

				}
				NamesMetadata labelsMetadata = null;
				try {
					labelsMetadata = c.getMetadata(NamesMetadata.class);
				} catch (NoSuchMetadataException e) {
					logger.debug("labelMetadata: NoSuchMetadataException "
							+ e.getLocalizedMessage());
				}

				if (labelsMetadata == null) {
					cData.setLabel("nolabel");
					logger.debug("LabelsMetadata no labels");
				} else {
					LocalizedText cl = null;
					cl = labelsMetadata.getTextWithLocale("en");
					if (cl == null) {
						cData.setLabel("nolabel");
						logger.debug("ColumnLabel no label in en");
					} else {
						if (cl.getValue() == null || cl.getValue().isEmpty()) {
							cData.setLabel("nolabel");
							logger.debug("ColumnLabel no label in en");
						} else {
							cData.setLabel(cl.getValue());
							logger.debug("Column Set Label: " + cl.getValue());
						}
					}
				}

				DataLocaleMetadata dataLocaleMetadata = null;
				try {
					dataLocaleMetadata = c
							.getMetadata(DataLocaleMetadata.class);
				} catch (NoSuchMetadataException e) {
					logger.debug("DataLocaleMetadata: NoSuchMetadataException "
							+ e.getLocalizedMessage());
				}

				if (dataLocaleMetadata == null) {
					logger.debug("No DataLocaleMetadata");
				} else {
					cData.setLocale(dataLocaleMetadata.getLocale());
				}

				cData.setTrId(trId);

			}

			return cData;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error("Error retrieving Column: " + e.getLocalizedMessage(),
					e);
			throw new TDGWTServiceException("Error retrieving Column: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public ColumnData getColumn(TRId trId, String columnName)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));

			ColumnData cData = new ColumnData();

			Column c = table.getColumnByName(columnName);
			if (c.getColumnType() instanceof IdColumnType) {

			} else {
				cData.setId(Integer.toString(0));
				cData.setColumnId(c.getLocalId().getValue());
				cData.setName(c.getName());

				if (c.contains(ViewColumnMetadata.class)) {
					ViewColumnMetadata viewMetadata = c
							.getMetadata(ViewColumnMetadata.class);
					logger.debug("ViewColumnMetadata: "
							+ viewMetadata.toString());

					String sourceTableDimensionColumnId = viewMetadata
							.getSourceTableDimensionColumnId().getValue();
					String targetTableColumnId = viewMetadata
							.getTargetTableColumnId().getValue();
					long targetTableId = viewMetadata.getTargetTableId()
							.getValue();
					ColumnViewData columnViewData = new ColumnViewData(
							sourceTableDimensionColumnId, targetTableColumnId,
							targetTableId);
					cData.setColumnViewData(columnViewData);
					cData.setViewColumn(true);

				} else {
					cData.setViewColumn(false);
				}
				cData.setTypeCode(c.getColumnType().getCode());
				cData.setTypeName(c.getColumnType().getName());
				cData.setDataTypeName(c.getDataType().getName());
				ColumnRelationship rel = c.getRelationship();
				if (rel != null) {
					RelationshipData relData = new RelationshipData(rel
							.getTargetTableId().getValue(), rel
							.getTargetColumnId().getValue());
					cData.setRelationship(relData);

				}
				NamesMetadata labelsMetadata = null;
				try {
					labelsMetadata = c.getMetadata(NamesMetadata.class);
				} catch (NoSuchMetadataException e) {
					logger.debug("labelMetadata: NoSuchMetadataException "
							+ e.getLocalizedMessage());
				}

				if (labelsMetadata == null) {
					cData.setLabel("nolabel");
					logger.debug("LabelsMetadata no labels");
				} else {
					LocalizedText cl = null;
					cl = labelsMetadata.getTextWithLocale("en");
					if (cl == null) {
						cData.setLabel("nolabel");
						logger.debug("ColumnLabel no label in en");
					} else {
						if (cl.getValue() == null || cl.getValue().isEmpty()) {
							cData.setLabel("nolabel");
							logger.debug("ColumnLabel no label in en");
						} else {
							cData.setLabel(cl.getValue());
							logger.debug("Column Set Label: " + cl.getValue());
						}
					}
				}

				DataLocaleMetadata dataLocaleMetadata = null;
				try {
					dataLocaleMetadata = c
							.getMetadata(DataLocaleMetadata.class);
				} catch (NoSuchMetadataException e) {
					logger.debug("DataLocaleMetadata: NoSuchMetadataException "
							+ e.getLocalizedMessage());
				}

				if (dataLocaleMetadata == null) {
					logger.debug("No DataLocaleMetadata");
				} else {
					cData.setLocale(dataLocaleMetadata.getLocale());
				}

				cData.setTrId(trId);

			}

			return cData;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error("Error retrieving Column: " + e.getLocalizedMessage(),
					e);
			throw new TDGWTServiceException("Error retrieving Column: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public ArrayList<ColumnData> getValidationColumns(TRId trId,
			String columnName) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			logger.debug("getValidationColumns():[" + trId.toString()
					+ " columnName: " + columnName + "]");

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));

			Column columnSource = table.getColumnByName(columnName);
			if (columnSource == null) {
				logger.error("Column not present on table");
				throw new TDGWTServiceException("Column not present on table");
			}

			logger.debug("getValidationColumns(): columnSource "
					+ columnSource.getLocalId());
			String columnSourceId = columnSource.getLocalId().getValue();

			ArrayList<ColumnData> columns = new ArrayList<ColumnData>();

			List<Column> cols = table.getColumns();
			int i = 0;
			for (Column c : cols) {
				if (c.getColumnType() instanceof ValidationColumnType) {
					logger.debug("ValidationColumn present: " + c.getLocalId());
					if (c.contains(ValidationReferencesMetadata.class)) {
						logger.debug("ValidationReferencesMetadata present");
						ValidationReferencesMetadata validationReferenceMetadata = c
								.getMetadata(ValidationReferencesMetadata.class);
						List<ColumnLocalId> valColumnList = validationReferenceMetadata
								.getValidationReferenceColumn();
						for (ColumnLocalId columnLocalId : valColumnList) {
							if (columnLocalId.getValue().compareTo(
									columnSourceId) == 0) {
								ColumnData cData = new ColumnData();
								cData.setId(Integer.toString(i));
								cData.setColumnId(c.getLocalId().getValue());
								cData.setName(c.getName());
								cData.setTypeCode(c.getColumnType().getCode());
								cData.setTypeName(c.getColumnType().getName());
								cData.setDataTypeName(c.getDataType().getName());
								NamesMetadata labelsMetadata = null;
								try {
									labelsMetadata = c
											.getMetadata(NamesMetadata.class);
								} catch (NoSuchMetadataException e) {
									logger.debug("labelMetadata: NoSuchMetadataException "
											+ e.getLocalizedMessage());
								}

								if (labelsMetadata == null) {
									cData.setLabel("nolabel");
									logger.debug("LabelsMetadata no labels");
								} else {
									LocalizedText cl = null;
									cl = labelsMetadata.getTextWithLocale("en");
									if (cl == null) {
										cData.setLabel("nolabel");
										logger.debug("ColumnLabel no label in en");
									} else {
										cData.setLabel(cl.getValue());
										logger.debug("Column Set Label: "
												+ cl.getValue());
									}
								}
								cData.setTrId(trId);
								cData.setValidationColumn(true);
								ArrayList<String> validatedColumnReferences = new ArrayList<String>();
								for (ColumnLocalId cLocalId : valColumnList) {
									validatedColumnReferences.add(cLocalId
											.getValue());
								}
								cData.setValidatedColumns(validatedColumnReferences);
								columns.add(cData);
								i++;
								break;
							}
						}

					}
				}

			}
			logger.debug("Validation Column: " + columns.size());
			return columns;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error retrieving Validation Columns: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error retrieving Validation Columns: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public TableData getLastTable(TRId trId) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("getLastTable: " + trId);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getLastTable(new TabularResourceId(Long
					.valueOf(trId.getId())));

			Table viewTable = null;

			if (table.contains(DatasetViewTableMetadata.class)) {
				DatasetViewTableMetadata dwm = table
						.getMetadata(DatasetViewTableMetadata.class);
				try {
					viewTable = service.getTable(dwm
							.getTargetDatasetViewTableId());
				} catch (Exception e) {
					logger.error("view table not found");
				}
			}

			TableData tData = new TableData();

			if (viewTable == null) {
				TRId newTRId = new TRId();
				newTRId.setId(trId.getId());
				newTRId.setTabularResourceType(trId.getTabularResourceType());
				newTRId.setTableId(String.valueOf(table.getId().getValue()));
				newTRId.setTableType(table.getTableType().getName());
				newTRId.setViewTable(false);
				tData.setTrId(newTRId);

				tData.setName(table.getName());
				tData.setTypeName(table.getTableType().getName());
				tData.setTypeCode(table.getTableType().getCode());
				Collection<TableMetadata> cMeta = table.getAllMetadata();

				tData.setMetaData(cMeta.toString());

				ArrayList<ColumnData> lColumnData = new ArrayList<ColumnData>();
				for (Column column : table.getColumns()) {
					ColumnData colData = new ColumnData();
					colData.setColumnId(column.getLocalId().getValue());
					colData.setName(column.getName());
					colData.setTypeName(column.getColumnType().getName());
					colData.setTypeCode(column.getColumnType().getCode());
					colData.setDataTypeName(column.getDataType().getName());
					colData.setTrId(newTRId);
					ColumnRelationship rel = column.getRelationship();
					if (rel != null) {
						RelationshipData relData = new RelationshipData(rel
								.getTargetTableId().getValue(), rel
								.getTargetColumnId().getValue());
						colData.setRelationship(relData);

					}
					if (column.contains(ViewColumnMetadata.class)) {
						ViewColumnMetadata viewMetadata = column
								.getMetadata(ViewColumnMetadata.class);
						logger.debug("ViewColumnMetadata: "
								+ viewMetadata.toString());

						String sourceTableDimensionColumnId = viewMetadata
								.getSourceTableDimensionColumnId().getValue();
						String targetTableColumnId = viewMetadata
								.getTargetTableColumnId().getValue();
						long targetTableId = viewMetadata.getTargetTableId()
								.getValue();
						ColumnViewData columnViewData = new ColumnViewData(
								sourceTableDimensionColumnId,
								targetTableColumnId, targetTableId);
						colData.setColumnViewData(columnViewData);
						colData.setViewColumn(true);

					} else {
						colData.setViewColumn(false);
					}

					lColumnData.add(colData);
				}

				tData.setListColumnData(lColumnData);

			} else {
				TRId newTRId = new TRId();
				newTRId.setId(trId.getId());
				newTRId.setTabularResourceType(trId.getTabularResourceType());
				newTRId.setTableId(String.valueOf(viewTable.getId().getValue()));
				newTRId.setTableType(viewTable.getTableType().getName());
				newTRId.setReferenceTargetTableId(String.valueOf(table.getId()
						.getValue()));
				newTRId.setViewTable(true);
				tData.setTrId(newTRId);

				tData.setName(viewTable.getName());
				tData.setTypeName(viewTable.getTableType().getName());
				tData.setTypeCode(viewTable.getTableType().getCode());
				Collection<TableMetadata> cMeta = viewTable.getAllMetadata();

				tData.setMetaData(cMeta.toString());

				ArrayList<ColumnData> lColumnData = new ArrayList<ColumnData>();
				for (Column column : viewTable.getColumns()) {
					ColumnData colData = new ColumnData();
					colData.setColumnId(column.getLocalId().getValue());
					colData.setName(column.getName());
					colData.setTypeName(column.getColumnType().getName());
					colData.setTypeCode(column.getColumnType().getCode());
					colData.setDataTypeName(column.getDataType().getName());
					colData.setTrId(newTRId);
					ColumnRelationship rel = column.getRelationship();
					if (rel != null) {
						RelationshipData relData = new RelationshipData(rel
								.getTargetTableId().getValue(), rel
								.getTargetColumnId().getValue());
						colData.setRelationship(relData);
					}
					if (column.contains(ViewColumnMetadata.class)) {
						ViewColumnMetadata viewMetadata = column
								.getMetadata(ViewColumnMetadata.class);
						logger.debug("ViewColumnMetadata: "
								+ viewMetadata.toString());

						String sourceTableDimensionColumnId = viewMetadata
								.getSourceTableDimensionColumnId().getValue();
						String targetTableColumnId = viewMetadata
								.getTargetTableColumnId().getValue();
						long targetTableId = viewMetadata.getTargetTableId()
								.getValue();
						ColumnViewData columnViewData = new ColumnViewData(
								sourceTableDimensionColumnId,
								targetTableColumnId, targetTableId);
						colData.setColumnViewData(columnViewData);
						colData.setViewColumn(true);

					} else {
						colData.setViewColumn(false);
					}

					lColumnData.add(colData);
				}

				tData.setListColumnData(lColumnData);

			}

			logger.debug("getLastTable: " + tData);
			return tData;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error("Error in getLastTable(): " + e.getLocalizedMessage(),
					e);
			throw new TDGWTServiceException("Error in getLastTable(): "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public TableData getTable(TRId trId) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));

			Table viewTable = null;

			if (table.contains(DatasetViewTableMetadata.class)) {
				DatasetViewTableMetadata dwm = table
						.getMetadata(DatasetViewTableMetadata.class);
				try {
					viewTable = service.getTable(dwm
							.getTargetDatasetViewTableId());
				} catch (Exception e) {
					logger.error("view table not found");
				}
			}

			TableData tData = new TableData();

			if (viewTable == null) {
				TRId newTRId = new TRId();
				newTRId.setId(trId.getId());
				newTRId.setTabularResourceType(trId.getTabularResourceType());
				newTRId.setTableId(String.valueOf(table.getId().getValue()));
				newTRId.setTableType(table.getTableType().getName());
				newTRId.setViewTable(false);
				tData.setTrId(newTRId);

				tData.setName(table.getName());
				tData.setTypeName(table.getTableType().getName());
				tData.setTypeCode(table.getTableType().getCode());
				Collection<TableMetadata> cMeta = table.getAllMetadata();

				tData.setMetaData(cMeta.toString());

				ArrayList<ColumnData> lColumnData = new ArrayList<ColumnData>();
				for (Column column : table.getColumns()) {
					ColumnData colData = new ColumnData();
					colData.setColumnId(column.getLocalId().getValue());
					colData.setName(column.getName());
					colData.setTypeName(column.getColumnType().getName());
					colData.setTypeCode(column.getColumnType().getCode());
					colData.setDataTypeName(column.getDataType().getName());
					colData.setTrId(newTRId);
					ColumnRelationship rel = column.getRelationship();
					if (rel != null) {
						RelationshipData relData = new RelationshipData(rel
								.getTargetTableId().getValue(), rel
								.getTargetColumnId().getValue());
						colData.setRelationship(relData);

					}
					if (column.contains(ViewColumnMetadata.class)) {
						ViewColumnMetadata viewMetadata = column
								.getMetadata(ViewColumnMetadata.class);
						logger.debug("ViewColumnMetadata: "
								+ viewMetadata.toString());

						String sourceTableDimensionColumnId = viewMetadata
								.getSourceTableDimensionColumnId().getValue();
						String targetTableColumnId = viewMetadata
								.getTargetTableColumnId().getValue();
						long targetTableId = viewMetadata.getTargetTableId()
								.getValue();
						ColumnViewData columnViewData = new ColumnViewData(
								sourceTableDimensionColumnId,
								targetTableColumnId, targetTableId);
						colData.setColumnViewData(columnViewData);
						colData.setViewColumn(true);

					} else {
						colData.setViewColumn(false);
					}

					lColumnData.add(colData);
				}

				tData.setListColumnData(lColumnData);

			} else {

				TRId newTRId = new TRId();
				newTRId.setId(trId.getId());
				newTRId.setTabularResourceType(trId.getTabularResourceType());
				newTRId.setTableId(String.valueOf(viewTable.getId().getValue()));
				newTRId.setTableType(viewTable.getTableType().getName());
				newTRId.setReferenceTargetTableId(String.valueOf(table.getId()
						.getValue()));
				newTRId.setViewTable(true);
				tData.setTrId(newTRId);

				tData.setName(viewTable.getName());
				tData.setTypeName(viewTable.getTableType().getName());
				tData.setTypeCode(viewTable.getTableType().getCode());
				Collection<TableMetadata> cMeta = viewTable.getAllMetadata();

				tData.setMetaData(cMeta.toString());

				ArrayList<ColumnData> lColumnData = new ArrayList<ColumnData>();
				for (Column column : viewTable.getColumns()) {
					ColumnData colData = new ColumnData();
					colData.setColumnId(column.getLocalId().getValue());
					colData.setName(column.getName());
					colData.setTypeName(column.getColumnType().getName());
					colData.setTypeCode(column.getColumnType().getCode());
					colData.setDataTypeName(column.getDataType().getName());
					colData.setTrId(newTRId);
					ColumnRelationship rel = column.getRelationship();
					if (rel != null) {
						RelationshipData relData = new RelationshipData(rel
								.getTargetTableId().getValue(), rel
								.getTargetColumnId().getValue());
						colData.setRelationship(relData);

					}
					if (column.contains(ViewColumnMetadata.class)) {
						ViewColumnMetadata viewMetadata = column
								.getMetadata(ViewColumnMetadata.class);
						logger.debug("ViewColumnMetadata: "
								+ viewMetadata.toString());

						String sourceTableDimensionColumnId = viewMetadata
								.getSourceTableDimensionColumnId().getValue();
						String targetTableColumnId = viewMetadata
								.getTargetTableColumnId().getValue();
						long targetTableId = viewMetadata.getTargetTableId()
								.getValue();
						ColumnViewData columnViewData = new ColumnViewData(
								sourceTableDimensionColumnId,
								targetTableColumnId, targetTableId);
						colData.setColumnViewData(columnViewData);
						colData.setViewColumn(true);

					} else {
						colData.setViewColumn(false);
					}

					lColumnData.add(colData);
				}

				tData.setListColumnData(lColumnData);

			}

			logger.debug("getTable: " + tData);
			return tData;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error("Error in getTable(): " + e.getLocalizedMessage(), e);
			throw new TDGWTServiceException("Error in getTable(): "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * Not used now, but it will be necessary in the future to retrieve task
	 * pending
	 * 
	 * {@inheritDoc}
	 */
	public void startTDOpen(TDOpenSession s) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setTDOpenSession(session, s);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.error("Error setting TDOpenSession parameter: "
					+ e.getLocalizedMessage());
			throw new TDGWTServiceException(
					"Error setting TDOpenSession parameter: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * 
	 * @param tr
	 * @param tabResource
	 */
	protected void syncTRMetaData(TabularResource tr, TabResource tabResource) {
		// Date date = Calendar.getInstance().getTime();
		logger.debug("TRservice [id:" + tr.getId() + " ,creationDate:"
				+ tr.getCreationDate() + "]");
		logger.debug("TabResource [name:" + tabResource.getName()
				+ " ,description:" + tabResource.getDescription() + " ,agency:"
				+ tabResource.getAgency() + " ,rights:"
				+ tabResource.getRight() + "]");
		tabResource.setDate(sdf.format(tr.getCreationDate().getTime()));
		tabResource.setValid(tr.isValid());
		tr.setMetadata(new NameMetadata(tabResource.getName()));
		tr.setMetadata(new DescriptionMetadata(tabResource.getDescription()));
		// tr.setMetadata(new CreationDateMetadata(date));
		if (tabResource.getAgency() != null
				&& !tabResource.getAgency().isEmpty()) {
			tr.setMetadata(new AgencyMetadata(tabResource.getAgency()));
		}
		tr.setMetadata(new RightsMetadata(tabResource.getRight()));

	}

	/**
	 * 
	 * @param tr
	 * @throws TDGWTServiceException
	 */
	protected void retrieveTRMetadataFromServiceAndLastTable(
			TabularDataService service, TabularResource tr)
			throws TDGWTServiceException {
		retrieveTRMetadataFromServiceAndLastTable(service, tr, 0);
	}

	/**
	 * Retrieves the informations for a specific Tabular Resource from service
	 * 
	 * @param tr
	 *            TabularResource on service
	 * @param i
	 *            Index on Grid
	 * @return TabResource for Grid
	 * @throws TDGWTServiceException
	 */
	protected TabResource retrieveTRMetadataFromService(
			TabularDataService service, TabularResource tr, int i)
			throws TDGWTServiceException {
		try {
			TabResource t = new TabResource();
			TRId trId = new TRId(String.valueOf(tr.getId().getValue()));
			trId.setTabularResourceType(tr.getTableType());
			t.setId(String.valueOf(i));
			t.setTrId(trId);
			t.setValid(tr.isValid());
			t.setFinalized(tr.isFinalized());
			Contacts owner = new Contacts("", tr.getOwner(), false);
			t.setOwner(owner);

			if (tr.contains(NameMetadata.class)) {
				NameMetadata nameMeta = tr.getMetadata(NameMetadata.class);
				if (nameMeta != null && nameMeta.getValue() != null) {
					t.setName(nameMeta.getValue());
				} else {
					t.setName("Unknown_" + trId.getId());
				}
			} else {
				t.setName("Unknown_" + trId.getId());
			}
			if (tr.contains(AgencyMetadata.class)) {
				AgencyMetadata agencyMeta = tr
						.getMetadata(AgencyMetadata.class);
				if (agencyMeta != null && agencyMeta.getValue() != null) {
					t.setAgency(agencyMeta.getValue());
				} else {
					t.setAgency("");
				}
			} else {
				t.setAgency("");
			}
			t.setDate(sdf.format(tr.getCreationDate().getTime()));
			// logger.debug("TabResource: "+t);
			return t;

		} catch (Throwable e) {
			logger.error("Error retrieving tabular resources metadata in retrieveTRMetadataFromService(): "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error retrieving tabular resources metadata in retrieveTRMetadataFromService() on server");
		}
	}

	/**
	 * Retrieves the informations for a specific Tabular Resource and the Last
	 * Table from service
	 * 
	 * @param tr
	 *            TabularResource on service
	 * @param i
	 *            Index on Grid
	 * @return TabResource for Grid
	 * @throws TDGWTServiceException
	 */
	protected TabResource retrieveTRMetadataFromServiceAndLastTable(
			TabularDataService service, TabularResource tr, int i)
			throws TDGWTServiceException {
		Table table = null;
		try {
			table = service.getLastTable(tr.getId());
		} catch (Throwable e) {
			logger.error("Error retrieving last table: " + e.getMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving last table: "
					+ e.getMessage());
		}

		TableId tableId = null;
		Table viewTable = null;
		TRId trId;
		TabResource t;

		if (table == null) {
			logger.info("Tabular resource " + tr.getId() + " has no table.");
			t = new TabResource();
			t.setTrId(null);
		} else {
			tableId = table.getId();
			if (tableId == null) {
				logger.info("Tabular Resource " + tr.getId()
						+ " has last table with id null.");
				t = new TabResource();
				t.setTrId(null);
			} else {
				if (table.contains(DatasetViewTableMetadata.class)) {
					DatasetViewTableMetadata dwm = table
							.getMetadata(DatasetViewTableMetadata.class);
					try {
						viewTable = service.getTable(dwm
								.getTargetDatasetViewTableId());
					} catch (Exception e) {
						logger.error("view table not found");
					}
				}

				if (viewTable == null) {
					trId = new TRId(String.valueOf(tr.getId().getValue()),
							tr.getTableType(), String.valueOf(tableId
									.getValue()), table.getTableType()
									.getName());
				} else {
					trId = new TRId(String.valueOf(tr.getId().getValue()),
							tr.getTableType(), String.valueOf(viewTable.getId()
									.getValue()), viewTable.getTableType()
									.getName(), String.valueOf(tableId
									.getValue()), true);

				}
				t = getTabResourceInformation(trId);

			}

		}

		t.setId(String.valueOf(i));

		return t;
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public void setCodelistsPagingLoader() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			CodelistTableType codType = new CodelistTableType();

			List<TabularResource> trs = service
					.getTabularResourcesByType(codType.getName());
			SessionUtil.setTabularResources(session, trs);

			ArrayList<TabResource> ltr = new ArrayList<TabResource>();

			int i;
			for (i = 0; i < trs.size(); i++) {
				TabularResource tr = trs.get(i);
				try {
					TabResource t = retrieveTRMetadataFromService(service, tr,
							i);
					if (t.getTrId() != null && t.isValid() && t.isFinalized()) {
						ltr.add(t);

					}
				} catch (Throwable e) {
					logger.error("TabResource discarded: " + tr + " cause: "
							+ e.getMessage());
				}

			}

			logger.debug("Codelists retrived: " + ltr);
			SessionUtil.setCodelistsPagingLoaded(session, ltr);

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			logger.error("Error retrieving Codelist in setCodelistsPagingLoader(): "
					+ e.getLocalizedMessage());
			throw new TDGWTServiceException("Error retrieving Codelist: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public CodelistPagingLoadResult getCodelistsPagingLoader(
			CodelistPagingLoadConfig plc) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();

			logger.debug(plc.toString());

			ArrayList<TabResource> ltr = SessionUtil
					.getCodelistsPagingLoaded(session);

			if (ltr == null) {
				logger.error("Error no codelist present in session");
				throw new TDGWTServiceException(
						"Error no codelist present in session");
			}

			ArrayList<TabResource> ltrTemp = new ArrayList<TabResource>();

			if (ltr.size() != 0) {
				ArrayList<TabResource> ltrCopy = filterPagingRow(plc, ltr,
						session);
				ltrCopy = OrderPagingRow(plc, ltrCopy, session);
				if (ltrCopy.size() != 0) {
					if (plc.getOffset() < 0
							|| plc.getOffset() >= ltrCopy.size()) {
						logger.error("Error CodelistPagingLoadConfig no valid range request, listsize: "
								+ ltrCopy.size());
						throw new TDGWTServiceException(
								"Error CodelistPagingLoadConfig no valid range request");
					}

					int request_end = plc.getOffset() + plc.getLimit();
					if (request_end > ltrCopy.size()) {
						request_end = ltrCopy.size();
					}

					for (int i = plc.getOffset(); i < request_end; i++) {
						try {
							// ltrCopy.get(i);
							ltrTemp.add(ltrCopy.get(i));

						} catch (IndexOutOfBoundsException e) {
							logger.debug("OutOfBounds in getCodelistsPagingLoader() size:"
									+ ltrCopy.size()
									+ " index: "
									+ i
									+ " Error:" + e.getMessage() + "\n");
						}
					}
				}

			}

			CodelistPagingLoadResult codelistPagingLoadResult = new CodelistPagingLoadResult();
			codelistPagingLoadResult.setFilter(plc.getFilter());
			codelistPagingLoadResult.setListOrderInfo(plc.getListOrderInfo());
			codelistPagingLoadResult.setLimit(plc.getLimit());
			codelistPagingLoadResult.setOffset(plc.getOffset());
			codelistPagingLoadResult.setTotalLenght(ltrTemp.size());
			codelistPagingLoadResult.setLtr(ltrTemp);

			logger.debug("Codelists retrieved: " + ltrTemp);
			return codelistPagingLoadResult;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			logger.error("Error retrieving Codelist in getCodelistsPagingLoader(): "
					+ e.getLocalizedMessage());
			throw new TDGWTServiceException("Error retrieving Codelist: "
					+ e.getLocalizedMessage());
		}

	}

	protected ArrayList<TabResource> filterPagingRow(
			CodelistPagingLoadConfig plc, ArrayList<TabResource> ltr,
			HttpSession session) {
		String filter = SessionUtil.getCodelistsPagingLoadedFilter(session);
		ArrayList<TabResource> ltrCopy = new ArrayList<TabResource>();
		SessionUtil.setCodelistsPagingLoadedFilter(session, plc.getFilter());
		if (filter == null) {
			logger.debug("No filter filter present in session");
			logger.debug("New Filter: " + plc.getFilter());
			if (plc.getFilter() == null || plc.getFilter().isEmpty()) {

				SessionUtil.setCodelistsPagingLoadedFilteredCopy(session, ltr);
				return ltr;
			} else {
				for (TabResource tr : ltr) {
					if (tr.getName() != null && !tr.getName().isEmpty()
							&& tr.getName().contains(plc.getFilter())) {
						ltrCopy.add(tr);
						continue;
					} else {
						if (tr.getAgency() != null && !tr.getAgency().isEmpty()
								&& tr.getAgency().contains(plc.getFilter())) {
							ltrCopy.add(tr);
							continue;
						} else {

						}

					}
				}
				SessionUtil.setCodelistsPagingLoadedFilteredCopy(session,
						ltrCopy);
				return ltrCopy;
			}

		} else {

			logger.debug("Old Filter:" + filter);
			logger.debug("New Filter: " + plc.getFilter());

			if (plc.getFilter() == null || plc.getFilter().isEmpty()) {
				SessionUtil.setCodelistsPagingLoadedFilteredCopy(session, ltr);
				return ltr;
			} else {
				if (filter.compareTo(plc.getFilter()) == 0) {
					ArrayList<TabResource> ltrFilteredCopy = SessionUtil
							.getCodelistsPagingLoadedFilteredCopy(session);
					return ltrFilteredCopy;
				} else {
					for (TabResource tr : ltr) {
						if (tr.getName() != null && !tr.getName().isEmpty()
								&& tr.getName().contains(plc.getFilter())) {
							ltrCopy.add(tr);
							continue;
						} else {
							if (tr.getAgency() != null
									&& !tr.getAgency().isEmpty()
									&& tr.getAgency().contains(plc.getFilter())) {
								ltrCopy.add(tr);
								continue;
							} else {

							}

						}
					}
					SessionUtil.setCodelistsPagingLoadedFilteredCopy(session,
							ltrCopy);
					return ltrCopy;
				}
			}

		}

	}

	protected ArrayList<TabResource> OrderPagingRow(
			CodelistPagingLoadConfig plc, ArrayList<TabResource> ltrCopy,
			HttpSession session) {

		ArrayList<OrderInfo> orders = plc.getListOrderInfo();
		for (OrderInfo order : orders) {
			if (order.getField().compareTo("name") == 0) {
				Direction direction = order.getDirection();
				if (direction == Direction.ASC) {
					Collections.sort(ltrCopy, new Comparator<TabResource>() {
						@Override
						public int compare(TabResource tr1, TabResource tr2) {
							int comp = 0;
							if (tr1.getName() == null) {
								comp = -1;
							} else {
								if (tr2.getName() == null) {
									comp = 1;
								} else {
									comp = tr1.getName().compareTo(
											tr2.getName());
								}
							}
							return comp;
						}
					});
				} else {
					Collections.sort(ltrCopy, new Comparator<TabResource>() {
						@Override
						public int compare(TabResource tr1, TabResource tr2) {
							int comp = 0;
							if (tr1.getName() == null) {
								comp = -1;
							} else {
								if (tr2.getName() == null) {
									comp = 1;
								} else {
									comp = tr1.getName().compareTo(
											tr2.getName());
								}
							}
							return -comp;
						}
					});
				}

				logger.debug("LTR Ordered by name;");

			} else {
				if (order.getField().compareTo("agency") == 0) {
					Direction direction = order.getDirection();
					if (direction == Direction.ASC) {
						Collections.sort(ltrCopy,
								new Comparator<TabResource>() {
									@Override
									public int compare(TabResource tr1,
											TabResource tr2) {
										int comp = 0;
										if (tr1.getAgency() == null) {
											comp = -1;
										} else {
											if (tr2.getAgency() == null) {
												comp = 1;
											} else {
												comp = tr1
														.getAgency()
														.compareTo(
																tr2.getAgency());
											}
										}
										return comp;
									}
								});
					} else {
						Collections.sort(ltrCopy,
								new Comparator<TabResource>() {
									@Override
									public int compare(TabResource tr1,
											TabResource tr2) {
										int comp = 0;
										if (tr1.getAgency() == null) {
											comp = -1;
										} else {
											if (tr2.getAgency() == null) {
												comp = 1;
											} else {
												comp = tr1
														.getAgency()
														.compareTo(
																tr2.getAgency());
											}
										}
										return -comp;
									}
								});
					}
					logger.debug("LTR Ordered by agency;");
				} else {
					if (order.getField().compareTo("date") == 0) {
						Direction direction = order.getDirection();
						if (direction == Direction.ASC) {
							Collections.sort(ltrCopy,
									new Comparator<TabResource>() {
										@Override
										public int compare(TabResource tr1,
												TabResource tr2) {
											int comp = 0;
											if (tr1.getDate() == null) {
												comp = -1;
											} else {
												if (tr2.getDate() == null) {
													comp = 1;
												} else {
													comp = tr1
															.getDate()
															.compareTo(
																	tr2.getDate());
												}
											}

											return comp;
										}
									});
						} else {
							Collections.sort(ltrCopy,
									new Comparator<TabResource>() {
										@Override
										public int compare(TabResource tr1,
												TabResource tr2) {
											int comp = 0;
											if (tr1.getDate() == null) {
												comp = -1;
											} else {
												if (tr2.getDate() == null) {
													comp = 1;
												} else {
													comp = tr1
															.getDate()
															.compareTo(
																	tr2.getDate());
												}
											}

											return -comp;
										}
									});
						}
						logger.debug("LTR Ordered by date;");
					} else {
					}
				}

			}

		}
		return ltrCopy;

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<TabResource> getTabularResourcesAndLastTables()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("GetTabularResources");
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			List<TabularResource> trs = service.getTabularResources();
			SessionUtil.setTabularResources(session, trs);

			ArrayList<TabResource> ltr = new ArrayList<TabResource>();

			int i;
			for (i = 0; i < trs.size(); i++) {
				TabularResource tr = trs.get(i);
				logger.debug("GetTabularResources RetrieveMetadataAndLastTables");
				try {
					TabResource t = retrieveTRMetadataFromServiceAndLastTable(
							service, tr, i);

					if (t.getTrId() != null) {
						ltr.add(t);
					}
				} catch (Throwable e) {
					logger.error("TabResource discarded: " + tr + " cause: "
							+ e.getMessage());
				}
			}

			logger.debug("Tabular Resources retrived: " + ltr);
			return ltr;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			logger.error("Error retrieving TabularResources: "
					+ e.getLocalizedMessage());
			throw new TDGWTServiceException(
					"Error retrieving TabularResources: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<TabResource> getTabularResources()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("GetTabularResources");
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			List<TabularResource> trs = service.getTabularResources();
			SessionUtil.setTabularResources(session, trs);

			ArrayList<TabResource> ltr = new ArrayList<TabResource>();

			int i;
			for (i = 0; i < trs.size(); i++) {
				TabularResource tr = trs.get(i);
				// logger.debug("GetTabularResources RetrieveMetadata");
				try {
					TabResource t = retrieveTRMetadataFromService(service, tr,
							i);

					if (t.getTrId() != null) {
						ltr.add(t);
					}
				} catch (Throwable e) {
					logger.error("TabResource discarded: " + tr + " cause: "
							+ e.getMessage());
				}
			}

			logger.debug("Tabular Resources retrieved: " + ltr);
			return ltr;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			logger.error("Error retrieving TabularResources: "
					+ e.getLocalizedMessage());
			throw new TDGWTServiceException(
					"Error retrieving TabularResources: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * @param tabResource
	 * @throws TDGWTServiceException
	 */
	public void removeTabularResource(TRId trId) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			if (trId == null) {
				logger.error("Error removing TabularResource: trId is null");
				throw new TDGWTServiceException(
						"Error removing TabularResource no parameters set");
			}
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId id = new TabularResourceId(Long.valueOf(trId
					.getId()));
			TabularResource tr = service.getTabularResource(id);
			String owner = tr.getOwner();
			if (owner != null && owner.compareTo(aslSession.getUsername()) == 0) {
				service.removeTabularResource(id);
			} else {
				throw new TDGWTServiceException(
						"You are not the owner of this tabular resource (owner: "
								+ owner + ")");
			}
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error deleting the tabular resource: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error deleting the tabular resource: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public TabResource createTabularResource(TabResource tabResource)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			if (tabResource == null) {
				logger.error("Error creating new TabularResource: tabResource is null");
				throw new TDGWTServiceException(
						"Error creating new TabularResource no parameters set");
			}

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResource serviceTR = service.createTabularResource();
			Table table = service.getLastTable(serviceTR.getId());
			syncTRMetaData(serviceTR, tabResource);

			TRId trId = new TRId(String.valueOf(serviceTR.getId().getValue()),
					serviceTR.getTableType(), String.valueOf(table.getId()
							.getValue()), table.getTableType().getName());
			tabResource.setTrId(trId);
			tabResource.setValid(serviceTR.isValid());
			tabResource.setFinalized(serviceTR.isFinalized());
			return tabResource;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error creating new TabularResource: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error creating new TabularResource: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public ArrayList<Codelist> getCodelists() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			return SessionUtil.retrieveCodelists(session);

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving codelists: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public ArrayList<Dataset> getDatasets() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			return SessionUtil.retrieveDatasets(session);

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving datasets: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public ArrayList<Agencies> getAgencies() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			return SessionUtil.retrieveAgencies(session);

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving datasets: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * @param sdmxImportSession
	 * @return
	 */
	protected Map<String, Object> retrieveOperationParameters(
			SDMXImportSession sdmxImportSession) {

		Map<String, Object> map = new HashMap<String, Object>();

		Codelist codelist = sdmxImportSession.getSelectedCodelist();

		map.put(Constants.PARAMETER_AGENCY, codelist.getAgencyId());
		map.put(Constants.PARAMETER_ID, codelist.getId());
		map.put(Constants.PARAMETER_VERSION, codelist.getVersion());

		// TODO-GP: Get registry url from client

		SDMXRegistryDescriptor descriptor = new GCubeSDMXRegistryDescriptor();
		map.put(Constants.PARAMETER_REGISTRYBASEURL,
				descriptor.getUrl(SDMXRegistryInterfaceType.RESTV2_1));

		return map;

	}

	/**
	 * {@inheritDoc}
	 */
	public void startSDMXImport(SDMXImportSession sdmxImportSession)
			throws TDGWTServiceException {

		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setSDMXImportSession(session, sdmxImportSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			// Import SDMX Codelist takes id 200
			OperationDefinition importSDMXCodelistOperation = OperationDefinitionMap
					.map(OperationsId.SDMXCodelistImport.toString(), service);

			TabResource sdmxImportTabResource = sdmxImportSession
					.getTabResource();

			TabularResource serviceTR = service.createTabularResource();

			syncTRMetaData(serviceTR, sdmxImportTabResource);

			TRId trId = new TRId(String.valueOf(serviceTR.getId().getValue()));
			sdmxImportTabResource.setTrId(trId);
			logger.debug(sdmxImportTabResource.toString());

			SessionUtil
					.setSDMXImportTabResource(session, sdmxImportTabResource);

			Map<String, Object> parameterInstance = retrieveOperationParameters(sdmxImportSession);

			OperationExecution invocation = new OperationExecution(
					importSDMXCodelistOperation.getOperationId(),
					parameterInstance);

			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR.getId());
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			SessionUtil.setSDMXImportTask(session, trTask);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in Client Library Request: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * Retrieve and set Tabular Resource Type
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	protected TRId retrieveTabularResourceBasicData(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();
			TabularResourceId tabularResourceId = new TabularResourceId(
					new Long(trId.getId()));

			TabularResource tr = service.getTabularResource(tabularResourceId);
			Table table = service.getLastTable(tabularResourceId);

			Table viewTable = null;

			if (table.contains(DatasetViewTableMetadata.class)) {
				DatasetViewTableMetadata dwm = table
						.getMetadata(DatasetViewTableMetadata.class);
				try {
					viewTable = service.getTable(dwm
							.getTargetDatasetViewTableId());
				} catch (Exception e) {
					logger.error("view table not found");
				}
			}

			TRId newTRId;
			if (viewTable == null) {
				newTRId = new TRId(String.valueOf(tr.getId().getValue()),
						tr.getTableType(), String.valueOf(table.getId()
								.getValue()), table.getTableType().getName());

			} else {
				newTRId = new TRId(String.valueOf(tr.getId().getValue()),
						tr.getTableType(), String.valueOf(viewTable.getId()
								.getValue()), viewTable.getTableType()
								.getName(), String.valueOf(table.getId()
								.getValue()), true);

			}

			logger.debug("Retrieved TRId basic info:" + newTRId.toString());
			return newTRId;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in Client Library Request: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public SDMXImportMonitor getSDMXImportMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			// ASLSession aslSession = SessionUtil.getAslSession(session);
			Task task = SessionUtil.getSDMXImportTask(session);
			TabResource sdmxImportTabResource = SessionUtil
					.getSDMXImportTabResource(session);
			TRId trId = sdmxImportTabResource.getTrId();

			SDMXImportMonitor importMonitor = new SDMXImportMonitor();
			if (trId == null) {
				throw new TDGWTServiceException(
						"Error in importSDMX TabularResource Id null");
			} else {
				if (task == null) {
					throw new TDGWTServiceException(
							"Error in importSDMX task null");
				} else {
					logger.debug("Service task: " + task.toString());
					TaskStatus status = task.getStatus();
					if (status == null) {
						throw new TDGWTServiceException(
								"Error in importSDMX Status null");
					} else {
						logger.debug("Service Task.getStatus(): "
								+ task.getStatus());

						importMonitor.setStatus(TaskStateMap.map(task
								.getStatus()));
						// Table table;
						switch (importMonitor.getStatus()) {
						case SUCCEDED:
							importMonitor.setProgress(task.getProgress());
							logger.debug("Task Result: " + task.getResult());

							trId = retrieveTabularResourceBasicData(trId);

							sdmxImportTabResource.setTrId(trId);
							SessionUtil.setSDMXImportTabResource(session,
									sdmxImportTabResource);
							SessionUtil.setTabResource(session,
									sdmxImportTabResource);

							SessionUtil.setTRId(session, trId);
							break;
						case FAILED:
							if (task.getResult() != null) {
								logger.debug("Task exception:"
										+ task.getErrorCause());
								task.getErrorCause().printStackTrace();
								importMonitor.setError(task.getErrorCause());
							} else {
								logger.debug("Task exception: Error In Import");
								importMonitor.setError(new Throwable(
										"Error In Import"));
							}
							importMonitor.setProgress(task.getProgress());
							break;
						case STOPPED:
							importMonitor.setProgress(task.getProgress());
							logger.debug("Task Result: " + task.getResult());
							trId = retrieveTabularResourceBasicData(trId);

							sdmxImportTabResource.setTrId(trId);
							SessionUtil.setSDMXImportTabResource(session,
									sdmxImportTabResource);
							SessionUtil.setTabResource(session,
									sdmxImportTabResource);

							SessionUtil.setTRId(session, trId);

							break;
						case ABORTED:
							break;
						case IN_PROGRESS:
							importMonitor.setProgress(task.getProgress());
							break;
						case VALIDATING_RULES:
							importMonitor.setProgress(task.getProgress());
							break;
						case GENERATING_VIEW:
							break;
						case INITIALIZING:
							break;
						default:
							break;
						}
					}
					SessionUtil.setSDMXImportTask(session, task);
				}

				importMonitor.setTrId(trId);
			}
			logger.debug("getSDMXImportMonitor(): " + importMonitor);
			return importMonitor;

		} catch (TDGWTSessionExpiredException e) {
			throw e;

		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in importSDMX ImportMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	/**
	 * {@inheritDoc}
	 */
	public void setSDMXRegistrySource(SDMXRegistrySource sdmxRegistrySource)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setSDMXRegistrySource(session, sdmxRegistrySource);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;

		} catch (Throwable e) {
			logger.error(
					"Error setting SDMXRegistrySource parameter: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error setting SDMXRegistrySource parameter: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public void setCSVSession(CSVImportSession importSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setCSVImportSession(session, importSession);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.error(
					"Error setting SDMXImportSession parameter: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error setting SDMXImportSession parameter: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public FileUploadMonitor getFileUploadMonitor()
			throws TDGWTServiceException {

		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}

		FileUploadMonitor fileUploadMonitor = SessionUtil
				.getFileUploadMonitor(session);
		if (fileUploadMonitor == null) {
			throw new TDGWTServiceException(
					"Error retrieving the fileUploadMonitor: null");
		}

		logger.debug("FileUploadMonitor: " + fileUploadMonitor);

		return fileUploadMonitor;
	}

	/**
	 * {@inheritDoc}
	 */
	public AvailableCharsetList getAvailableCharset()
			throws TDGWTServiceException {
		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}
		logger.info("Session:" + session.getId());
		String defaultEncoding = Charset.defaultCharset().displayName();
		ArrayList<String> charsetList = new ArrayList<String>(Charset
				.availableCharsets().keySet());
		return new AvailableCharsetList(charsetList, defaultEncoding);
	}

	public ArrayList<String> configureCSVParser(String encoding,
			HeaderPresence headerPresence, char delimiter, char comment)
			throws TDGWTServiceException {
		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}
		logger.debug("Session:" + session.getId());
		logger.debug("configureCSVParser  encoding: " + encoding
				+ " headerPresence: " + headerPresence + " delimiter: "
				+ delimiter + " comment: " + comment);

		CSVFileUploadSession fileUploadSession = SessionUtil
				.getCSVFileUploadSession(session);
		if (fileUploadSession == null) {
			throw new TDGWTServiceException(
					"Error retrieving the fileUploadSession: null");
		}
		CSVParserConfiguration parserConfiguration = fileUploadSession
				.getParserConfiguration();
		if (parserConfiguration == null) {
			parserConfiguration = new CSVParserConfiguration(
					Charset.forName(encoding), delimiter, comment,
					headerPresence);
			fileUploadSession.setParserConfiguration(parserConfiguration);
		} else {
			parserConfiguration.update(encoding, delimiter, comment,
					headerPresence);
		}
		SessionUtil.setCSVFileUploadSession(session, fileUploadSession);
		try {
			return CSVFileUtil.getHeader(fileUploadSession.getCsvFile(),
					fileUploadSession.getParserConfiguration());
		} catch (Throwable e) {
			logger.error("Error retrieving the CSV header", e);
			throw new TDGWTServiceException(
					"Error calculating the CSV header: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public ArrayList<CSVRowError> checkCSV(long errorsLimit)
			throws TDGWTServiceException {

		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}
		logger.debug("Session:" + session.getId());
		CSVFileUploadSession fileUploadSession = SessionUtil
				.getCSVFileUploadSession(session);
		if (fileUploadSession == null) {
			throw new TDGWTServiceException(
					"Error retrieving the fileUploadSession: null");
		}

		try {
			return CSVFileUtil.checkCSV(fileUploadSession.getCsvFile(),
					fileUploadSession.getParserConfiguration(), errorsLimit);
		} catch (Throwable e) {
			logger.error("Error checking the CSV file", e);
			throw new TDGWTServiceException("Error checking the CSV file: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public void startCSVImport(CSVImportSession csvImportSession)
			throws TDGWTServiceException {
		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}
		logger.debug("Session:" + session.getId());

		ASLSession aslSession = SessionUtil.getAslSession(session);
		if (aslSession == null) {
			throw new TDGWTServiceException(
					"Error retrieving the asl session: null");
		}
		String user = aslSession.getUsername();
		logger.debug("Session User:" + user);

		logger.debug("StartCSVImport: " + csvImportSession.toString());

		CSVFileUploadSession fileUploadSession = SessionUtil
				.getCSVFileUploadSession(session);
		if (fileUploadSession == null) {
			throw new TDGWTServiceException(
					"Error retrieving the fileUploadSession: null");
		}

		importCSVFileOnService(session, aslSession, user, fileUploadSession,
				csvImportSession);

	}

	/**
	 * 
	 * @param fileUrlOnStorage
	 * @param fileUploadSession
	 * @param csvImportSession
	 * @return
	 */
	protected Map<String, Object> csvImportFileParameter(
			String fileUrlOnStorage, CSVFileUploadSession fileUploadSession,
			CSVImportSession csvImportSession) {
		Map<String, Object> parameterInstances = new HashMap<String, Object>();
		parameterInstances.put(Constants.PARAMETER_URL, fileUrlOnStorage);
		parameterInstances.put(Constants.PARAMETER_SEPARATOR, String
				.valueOf(fileUploadSession.getParserConfiguration()
						.getDelimiter()));// ','
		parameterInstances.put(Constants.PARAMETER_ENCODING, fileUploadSession
				.getParserConfiguration().getCharset().name());// "UTF-8"
		boolean hasHeader = true;
		if (fileUploadSession.getParserConfiguration().getHeaderPresence() == HeaderPresence.NONE) {
			hasHeader = false;
		}

		parameterInstances.put(Constants.PARAMETER_HASHEADER, hasHeader);// true
		parameterInstances.put(Constants.PARAMETER_FIELDMASK,
				csvImportSession.getColumnToImportMask());// Column Mask
		parameterInstances.put(Constants.PARAMETER_SKIPERROR,
				csvImportSession.isSkipInvalidLines());
		return parameterInstances;
	}

	/**
	 * 
	 * @param user
	 * @param fileUploadSession
	 * @param csvImportSession
	 * @throws TDGWTServiceException
	 */
	protected void importCSVFileOnService(HttpSession session,
			ASLSession aslSession, String user,
			CSVFileUploadSession fileUploadSession,
			CSVImportSession csvImportSession) throws TDGWTServiceException {

		logger.debug("File Storage Access");

		logger.debug("CSVImportSession skip:"
				+ csvImportSession.isSkipInvalidLines());
		/*
		 * if (csvImportSession.isSkipInvalidLines()) { try {
		 * fileUploadSession.setCsvFile(CSVFileUtil.skipError(
		 * fileUploadSession.getCsvFile(),
		 * fileUploadSession.getParserConfiguration())); } catch (ParseException
		 * e) { logger.debug("Error parsing file for skip:" + e.getMessage());
		 * throw new TDGWTServiceException("Error parsing file for skip: " +
		 * e.getMessage());
		 * 
		 * } catch (IOException e) {
		 * logger.debug("Error IOException skipping file error: " +
		 * e.getMessage()); throw new TDGWTServiceException(
		 * "Error IOException skipping file error: " + e.getMessage());
		 * 
		 * } }
		 */

		FilesStorage filesStorage = new FilesStorage();

		String fileUrlOnStorage = filesStorage.storageCSVTempFile(user,
				fileUploadSession.getCsvFile());
		logger.debug("File Url On Storage:" + fileUrlOnStorage);
		fileUploadSession.getCsvFile().delete();

		if (fileUrlOnStorage == null || fileUrlOnStorage.isEmpty()) {
			throw new TDGWTServiceException(
					"Tabular Data Service error loading file on storage");
		}

		Map<String, Object> parameterInstance = csvImportFileParameter(
				fileUrlOnStorage, fileUploadSession, csvImportSession);

		logger.debug("Tabular Data Service");

		AuthorizationProvider.instance.set(new AuthorizationToken(aslSession
				.getUsername()));
		TabularDataService service = TabularDataServiceFactory.getService();

		// Import CSV file

		OperationDefinition importCSVFileOperation = OperationDefinitionMap
				.map(OperationsId.CSVImport.toString(), service);

		OperationExecution invocation = new OperationExecution(
				importCSVFileOperation.getOperationId(), parameterInstance);

		logger.debug("OperationInvocation: \n" + invocation.toString());
		TabularResource tabularResource = service.createTabularResource();
		TabResource csvImportTabResource = csvImportSession.getTabResource();
		syncTRMetaData(tabularResource, csvImportTabResource);
		TRId trId = new TRId(String.valueOf(tabularResource.getId().getValue()));
		csvImportTabResource.setTrId(trId);
		logger.debug(csvImportTabResource.toString());
		SessionUtil.setCSVImportTabResource(session, csvImportTabResource);
		Task trTask;
		try {
			trTask = service.execute(invocation, tabularResource.getId());
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Tabular Data Service error creating TabularResource: "
							+ e.getLocalizedMessage());
		}

		logger.debug("Start Task on service: TaskId " + trTask.getId());
		SessionUtil.setCSVImportFileTask(session, trTask);

	}

	/**
	 * {@inheritDoc}
	 */
	public CSVImportMonitor getCSVImportMonitor() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			Task task = SessionUtil.getCSVImportFileTask(session);
			TabResource csvImportTabResource = SessionUtil
					.getCSVImportTabResource(session);
			TRId trId = csvImportTabResource.getTrId();

			CSVImportMonitor importMonitor = new CSVImportMonitor();
			if (trId == null) {
				throw new TDGWTServiceException(
						"Error in importCSV TabularResource Id null");
			} else {
				if (task == null) {
					logger.debug("Task null");
					throw new TDGWTServiceException(
							"Error in importCSV task null");
				} else {
					TaskStatus status = task.getStatus();
					if (status == null) {
						throw new TDGWTServiceException(
								"Error in importCSV Status null");
					} else {
						logger.debug("Status: " + task.getStatus());

						importMonitor.setStatus(TaskStateMap.map(task
								.getStatus()));

						switch (importMonitor.getStatus()) {
						case FAILED:
							if (task.getResult() != null) {
								logger.debug("Task exception:"
										+ task.getErrorCause());
								task.getErrorCause().printStackTrace();
								importMonitor.setError(task.getErrorCause());
							} else {
								logger.debug("Task exception: Error In Import");
								importMonitor.setError(new Throwable(
										"Error In Import"));
							}
							importMonitor.setProgress(task.getProgress());
							break;
						case SUCCEDED:
							logger.debug("Task Result: " + task.getResult());
							importMonitor.setProgress(task.getProgress());
							trId = retrieveTabularResourceBasicData(trId);

							csvImportTabResource.setTrId(trId);
							SessionUtil.setCSVImportTabResource(session,
									csvImportTabResource);
							logger.debug("Import CSV Succeded TabResource Set:"
									+ csvImportTabResource);
							SessionUtil.setTabResource(session,
									csvImportTabResource);
							SessionUtil.setTRId(session, trId);
							break;
						case STOPPED:
							logger.debug("Task Result: " + task.getResult());
							importMonitor.setProgress(task.getProgress());
							trId = retrieveTabularResourceBasicData(trId);

							csvImportTabResource.setTrId(trId);
							SessionUtil.setCSVImportTabResource(session,
									csvImportTabResource);
							logger.debug("Import CSV Succeded TabResource Set:"
									+ csvImportTabResource);
							SessionUtil.setTabResource(session,
									csvImportTabResource);
							SessionUtil.setTRId(session, trId);

							break;
						case IN_PROGRESS:
							importMonitor.setProgress(task.getProgress());
							break;
						case VALIDATING_RULES:
							importMonitor.setProgress(task.getProgress());
							break;
						case GENERATING_VIEW:
							break;
						case ABORTED:
							break;
						case INITIALIZING:
							break;
						default:
							break;
						}
					}
					SessionUtil.setCSVImportFileTask(session, task);
				}

				importMonitor.setTrId(trId);
			}
			logger.debug("getImportMonitor(): " + importMonitor);
			return importMonitor;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in importCSV CSVImportMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public void getFileFromWorkspace(CSVImportSession csvImportSession)
			throws TDGWTServiceException {
		HttpSession session = this.getThreadLocalRequest().getSession();
		ASLSession aslSession = SessionUtil.getAslSession(session);
		Workspace w = null;
		WorkspaceItem wi = null;

		try {
			HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();

			HomeManager manager = factory.getHomeManager();

			Home home = manager.getHome(aslSession.getUsername());

			w = home.getWorkspace();
			wi = w.getItem(csvImportSession.getItemId());
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in importCSV getFileFromWorkspace accessing the workspace: "
							+ e.getLocalizedMessage(), e);
		}

		if (wi == null) {
			logger.error("Error retrieving the item on workspace"
					+ csvImportSession.getItemId());
			throw new TDGWTServiceException(
					"Error retrieving the item on workspace"
							+ csvImportSession.getItemId());
		}

		try {
			logger.debug("WorkspaceItem [id:" + wi.getId() + " name:"
					+ wi.getName() + " remotePath:" + wi.getRemotePath() + "]");
		} catch (InternalErrorException e1) {
			e1.printStackTrace();
			throw new TDGWTServiceException(
					"Error retrieving the item on workspace" + wi);
		}

		CSVFileUploadSession fileUploadSession = new CSVFileUploadSession();
		CSVImportMonitor csvImportMonitor = new CSVImportMonitor();
		FileUploadMonitor fileUploadMonitor = new FileUploadMonitor();

		SessionUtil.setFileUploadMonitor(session, fileUploadMonitor);

		fileUploadSession.setId(session.getId());
		fileUploadSession.setFileUploadState(FileUploadState.STARTED);
		fileUploadSession.setCsvImportMonitor(csvImportMonitor);

		SessionUtil.setCSVFileUploadSession(session, fileUploadSession);

		try {
			FilesStorage filesStorage = new FilesStorage();
			InputStream is = filesStorage.retriveImputStream(
					aslSession.getUsername(), wi);

			FileUtil.setImportFileCSV(fileUploadSession, is, wi.getName(),
					Constants.FILE_CSV_MIMETYPE);
		} catch (Throwable e) {
			FileUploadMonitor fum = SessionUtil.getFileUploadMonitor(session);
			fum.setFailed("An error occured elaborating the file",
					FileUtil.exceptionDetailMessage(e));
			SessionUtil.setFileUploadMonitor(session, fum);
			fileUploadSession.setFileUploadState(FileUploadState.FAILED);
			SessionUtil.setCSVFileUploadSession(session, fileUploadSession);
			logger.error("Error elaborating the input stream", e);
			throw new TDGWTServiceException(
					"Error in importCSV getFileFromWorkspace: "
							+ e.getLocalizedMessage(), e);
		}

		logger.trace("changing state");
		FileUploadMonitor fum = SessionUtil.getFileUploadMonitor(session);
		fum.setState(FileUploadState.COMPLETED);
		SessionUtil.setFileUploadMonitor(session, fum);
		SessionUtil.setCSVFileUploadSession(session, fileUploadSession);
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public String getTRCreationDate(TRId trId) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("GetTRMetadata on " + trId.toString());

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResource tr = service
					.getTabularResource(new TabularResourceId(Long.valueOf(trId
							.getId())));

			return sdf.format(tr.getCreationDate().getTime());

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.error(
					"Error in getTRCreationDate(): " + e.getLocalizedMessage(),
					e);
			throw new TDGWTServiceException("Error in getTRCreationDate(): "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public Boolean isTabularResourceValid(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("IsTabularResourceValid: " + trId.toString());

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResource tr = service
					.getTabularResource(new TabularResourceId(Long.valueOf(trId
							.getId())));
			logger.debug("IsTabularResourceValid: " + tr.isValid());
			return tr.isValid();

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error("Error checking if it is a valid tabular resource: "
					+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error checking if it is a valid tabular resource: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * Check finalized status of a tabular resource
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public Boolean isTabularResourceFinalized(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("IsTabularResourceFinalized: " + trId.toString());

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResource tr = service
					.getTabularResource(new TabularResourceId(Long.valueOf(trId
							.getId())));
			logger.debug("IsTabularResourceFinalized: " + tr.isFinalized());
			return tr.isFinalized();
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error checking if it is a finalized tabular resource: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error checking if it is a finalized tabular resource: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public ArrayList<TRMetadata> getTRMetadata(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("GetTRMetadata on " + trId);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();
			// TODO
			TabularResource tr = service
					.getTabularResource(new TabularResourceId(Long.valueOf(trId
							.getId())));

			Collection<TabularResourceMetadata> trMetas = tr.getAllMetadata();

			logger.debug("GetTRMetadata size: " + trMetas.size());
			ArrayList<TRMetadata> listTRMetadata = new ArrayList<TRMetadata>();

			for (TabularResourceMetadata trMetadata : trMetas) {
				if (trMetadata instanceof org.gcube.data.analysis.tabulardata.service.tabular.metadata.DescriptionMetadata) {
					TRDescriptionMetadata trDescriptionMetadata = new TRDescriptionMetadata();
					trDescriptionMetadata
							.setValue(((org.gcube.data.analysis.tabulardata.service.tabular.metadata.DescriptionMetadata) trMetadata)
									.getValue());
					listTRMetadata.add(trDescriptionMetadata);
				} else {
					if (trMetadata instanceof org.gcube.data.analysis.tabulardata.service.tabular.metadata.NameMetadata) {
						TRNameMetadata trNameMetadata = new TRNameMetadata();
						trNameMetadata
								.setValue(((org.gcube.data.analysis.tabulardata.service.tabular.metadata.NameMetadata) trMetadata)
										.getValue());
						listTRMetadata.add(trNameMetadata);
					} else {
						if (trMetadata instanceof AgencyMetadata) {
							TRAgencyMetadata trAgencyMetadata = new TRAgencyMetadata();
							trAgencyMetadata
									.setValue(((AgencyMetadata) trMetadata)
											.getValue());
							listTRMetadata.add(trAgencyMetadata);
						} else {
							if (trMetadata instanceof RightsMetadata) {
								TRRightsMetadata trRightsMetadata = new TRRightsMetadata();
								trRightsMetadata
										.setValue(((RightsMetadata) trMetadata)
												.getValue());
								listTRMetadata.add(trRightsMetadata);
							} else {

							}

						}
					}
				}
			}

			logger.debug("GetTRMetadata retrived: " + listTRMetadata.size());
			return listTRMetadata;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error in getTRMetadata(): " + e.getLocalizedMessage(), e);
			throw new TDGWTServiceException("Error in getTRMetadata(): "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TabValidationsMetadata getTableValidationsMetadata(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("GetTableValidationsMetadata on " + trId.toString());
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));
			TabValidationsMetadata tabValidationsMetadata = new TabValidationsMetadata();
			if (table.contains(ValidationsMetadata.class)) {
				ValidationsMetadata validationsMetadata = table
						.getMetadata(ValidationsMetadata.class);
				if (validationsMetadata != null) {
					List<Validation> vals = validationsMetadata
							.getValidations();
					if (vals != null && vals.size() > 0) {
						Validations valid = null;
						ArrayList<Validations> vList = new ArrayList<Validations>();
						int i = 0;
						for (Validation v : vals) {
							valid = new Validations(String.valueOf(i),
									v.getDescription(), v.isValid());
							vList.add(valid);
							i++;
						}
						tabValidationsMetadata.setValidations(vList);
					}
				}
			}

			logger.debug("TabValidationsMetadata: " + tabValidationsMetadata);
			return tabValidationsMetadata;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error in getTableValidationMetadata(): "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error in getTableValidationMetadata: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public ArrayList<TabMetadata> getTableMetadata(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("GetTableMetadata on " + trId.toString());
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));

			Collection<TableMetadata> cMeta = table.getAllMetadata();

			ArrayList<TabMetadata> listTabMetadata = new ArrayList<TabMetadata>();
			logger.debug("Metadata size:" + cMeta.size());
			for (TableMetadata tMetadata : cMeta) {
				if (tMetadata instanceof DescriptionsMetadata) {
					TabDescriptionsMetadata trDescriptionsMetadata = new TabDescriptionsMetadata();
					ArrayList<TRLocalizedText> listTRLocalizedText = new ArrayList<TRLocalizedText>();
					List<LocalizedText> lLocalizedText = ((DescriptionsMetadata) tMetadata)
							.getTexts();
					int i = 0;
					for (LocalizedText lt : lLocalizedText) {
						TRLocalizedText trLocalizedText = new TRLocalizedText();
						trLocalizedText.setId(i);
						trLocalizedText.setValue(lt.getValue());
						trLocalizedText.setLocaleCode(lt.getLocale());
						listTRLocalizedText.add(trLocalizedText);
						i++;
					}
					trDescriptionsMetadata
							.setListTRLocalizedText(listTRLocalizedText);
					listTabMetadata.add(trDescriptionsMetadata);

				} else {
					if (tMetadata instanceof NamesMetadata) {
						TabNamesMetadata trNamesMetadata = new TabNamesMetadata();
						ArrayList<TRLocalizedText> listTRLocalizedText = new ArrayList<TRLocalizedText>();
						List<LocalizedText> lLocalizedText = ((NamesMetadata) tMetadata)
								.getTexts();
						int i = 0;
						for (LocalizedText lt : lLocalizedText) {
							TRLocalizedText trLocalizedText = new TRLocalizedText();
							trLocalizedText.setId(i);
							trLocalizedText.setValue(lt.getValue());
							trLocalizedText.setLocaleCode(lt.getLocale());
							listTRLocalizedText.add(trLocalizedText);
							i++;
						}
						trNamesMetadata
								.setListTRLocalizedText(listTRLocalizedText);
						listTabMetadata.add(trNamesMetadata);

					} else {
						if (tMetadata instanceof VersionMetadata) {
							TabVersionMetadata trVersionMetadata = new TabVersionMetadata();
							trVersionMetadata
									.setVersion(((VersionMetadata) tMetadata)
											.getVersion());
							listTabMetadata.add(trVersionMetadata);
						} else {
							if (tMetadata instanceof ExportMetadata) {
								TabExportMetadata trExportMetadata = new TabExportMetadata();
								trExportMetadata
										.setDestinationType(((ExportMetadata) tMetadata)
												.getDestinationType());
								trExportMetadata.setExportDate(sdf
										.format(((ExportMetadata) tMetadata)
												.getExportDate()));
								trExportMetadata
										.setUrl(((ExportMetadata) tMetadata)
												.getUri());
								listTabMetadata.add(trExportMetadata);
							} else {
								if (tMetadata instanceof ImportMetadata) {
									TabImportMetadata trImportMetadata = new TabImportMetadata();
									trImportMetadata
											.setSourceType(((ImportMetadata) tMetadata)
													.getSourceType());
									trImportMetadata
											.setImportDate(sdf
													.format(((ImportMetadata) tMetadata)
															.getImportDate()));
									trImportMetadata
											.setUrl(((ImportMetadata) tMetadata)
													.getUri());
									listTabMetadata.add(trImportMetadata);
								} else {
									if (tMetadata instanceof GenericMapMetadata) {
										TabGenericMapMetadata trGenericMapMetadata = new TabGenericMapMetadata();
										trGenericMapMetadata
												.setMetadataMap((HashMap<String, String>) ((GenericMapMetadata) tMetadata)
														.getMetadataMap());
										listTabMetadata
												.add(trGenericMapMetadata);
									} else {

									}

								}
							}
						}
					}
				}
			}

			return listTabMetadata;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.error(
					"Error in getTableMetadata(): " + e.getLocalizedMessage(),
					e);
			throw new TDGWTServiceException("Error in getTableMetadata(): "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * @param exportSession
	 * @return
	 */
	protected Map<String, Object> csvExportFileParameter(
			CSVExportSession exportSession) {
		Map<String, Object> parameterInstances = new HashMap<String, Object>();
		parameterInstances.put(Constants.PARAMETER_ENCODING,
				exportSession.getEncoding());
		parameterInstances.put(Constants.PARAMETER_SEPARATOR,
				exportSession.getSeparator());
		parameterInstances.put(Constants.PARAMETER_COLUMNS,
				exportSession.getColumnsAsString());
		return parameterInstances;
	}

	/**
	 * 
	 * @param exportSession
	 * @return
	 */
	protected Map<String, Object> sdmxExportParameter(
			SDMXExportSession exportSession) throws TDGWTServiceException {
		boolean internalRegistry = false;
		String destination = null;// Es:
									// http://pc-fortunati.isti.cnr.it:8080/FusionRegistry/ws/rest/

		if (exportSession != null) {
			if (exportSession.getRegistryBaseUrl() != null
					&& !exportSession.getRegistryBaseUrl().isEmpty()) {
				destination = exportSession.getRegistryBaseUrl();
			} else {
				internalRegistry = true;
			}
		} else {
			internalRegistry = true;
		}

		if (internalRegistry) {
			SimpleQuery query = queryFor(ServiceEndpoint.class);
			query.addCondition("$resource/Profile/Category/text() eq 'SDMX'")
					.addCondition(
							"$resource/Profile/Name/text() eq 'SDMXRegistry'");
			DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
			List<ServiceEndpoint> listService = client.submit(query);
			if (listService.size() > 0) {
				ServiceEndpoint serviceEnd = listService.get(0);
				if (serviceEnd != null) {
					Profile prof = serviceEnd.profile();
					Group<AccessPoint> groupA = prof.accessPoints();
					for (AccessPoint acc : groupA) {
						if (acc.description().compareTo("REST Interface v2.1") == 0) {
							destination = acc.address();
							break;
						}
					}
				} else {

				}
			} else {

			}
		}
		if (destination == null) {
			logger.debug("Destination: " + destination);
			throw new TDGWTServiceException("SDMX Service not discovered");
		}

		Map<String, Object> parameterInstances = new HashMap<String, Object>();
		parameterInstances
				.put(Constants.PARAMETER_REGISTRYBASEURL, destination);
		parameterInstances.put(Constants.PARAMETER_AGENCY, "SDMX");
		parameterInstances.put(Constants.PARAMETER_ID, "NEW_CL_DIVISION");
		parameterInstances.put(Constants.PARAMETER_VERSION, "2.0");
		return parameterInstances;
	}

	/**
	 * 
	 * @param exportSession
	 * @return
	 */
	public void startSDMXExport(SDMXExportSession exportSession)
			throws TDGWTServiceException {
		logger.debug("Start SDMX Export");
		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}
		logger.debug("Session:" + session.getId());

		ASLSession aslSession = SessionUtil.getAslSession(session);
		if (aslSession == null) {
			throw new TDGWTServiceException(
					"Error retrieving the asl session: null");
		}
		String user = aslSession.getUsername();
		logger.debug("Session User:" + user);

		TRId trId = SessionUtil.getTRId(session);
		if (trId == null) {
			throw new TDGWTServiceException(
					"Error no tabular resource in session");
		}

		if (trId.getTableId() == null) {
			throw new TDGWTServiceException("Error no table present in session");
		}

		SessionUtil.setSDMXExportSession(session, exportSession);

		Map<String, Object> parameterInstance = sdmxExportParameter(exportSession);

		logger.debug("Tabular Data Service");

		AuthorizationProvider.instance.set(new AuthorizationToken(aslSession
				.getUsername()));
		TabularDataService service = TabularDataServiceFactory.getService();

		// Export SDMX Codelist
		OperationDefinition exportSDMXOperation = OperationDefinitionMap.map(
				OperationsId.SDMXCodelistExport.toString(), service);

		OperationExecution invocation = new OperationExecution(
				exportSDMXOperation.getOperationId(), parameterInstance);

		logger.debug("OperationInvocation: \n" + invocation.toString());

		Task trTask;
		try {
			trTask = service.execute(invocation,
					new TabularResourceId(Long.valueOf(trId.getId())));
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Tabular Data Service error exporting TabularResource: "
							+ e.getLocalizedMessage());
		}

		logger.debug("Start Task on service: TaskId " + trTask.getId());
		SessionUtil.setSDMXExportTask(session, trTask);
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public SDMXExportMonitor getSDMXExportMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			// ASLSession aslSession = SessionUtil.getAslSession(session);
			Task task = SessionUtil.getSDMXExportTask(session);
			SDMXExportMonitor exportMonitor = new SDMXExportMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException("Error in exportSDMX task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					throw new TDGWTServiceException(
							"Error in exportSDMX Status null");
				} else {
					logger.debug("Status: " + task.getStatus());

					exportMonitor.setStatus(TaskStateMap.map(task.getStatus()));
					Table table;
					ExportMetadata exportMetadata;
					TabExportMetadata tabExportMetadata;
					switch (exportMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							exportMonitor.setError(task.getErrorCause());
						} else {
							logger.debug("Task exception: Error In Export");
							exportMonitor.setError(new Throwable(
									"Error In Export"));
						}
						exportMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						exportMonitor.setProgress(task.getProgress());

						table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						exportMetadata = table
								.getMetadata(ExportMetadata.class);
						logger.debug("ExportMetadata: " + exportMetadata);

						exportMonitor.setTrId(SessionUtil.getTRId(session));
						tabExportMetadata = new TabExportMetadata();
						tabExportMetadata.setUrl(exportMetadata.getUri());
						tabExportMetadata.setDestinationType(exportMetadata
								.getDestinationType());
						tabExportMetadata.setExportDate(sdf
								.format(exportMetadata.getExportDate()));
						exportMonitor.setTabExportMetadata(tabExportMetadata);
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						exportMonitor.setProgress(task.getProgress());
						table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						exportMetadata = table
								.getMetadata(ExportMetadata.class);
						logger.debug("ExportMetadata: " + exportMetadata);

						exportMonitor.setTrId(SessionUtil.getTRId(session));
						tabExportMetadata = new TabExportMetadata();
						tabExportMetadata.setUrl(exportMetadata.getUri());
						tabExportMetadata.setDestinationType(exportMetadata
								.getDestinationType());
						tabExportMetadata.setExportDate(sdf
								.format(exportMetadata.getExportDate()));
						exportMonitor.setTabExportMetadata(tabExportMetadata);
						break;
					case IN_PROGRESS:
						exportMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						exportMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setSDMXExportTask(session, task);
			}

			logger.debug("getExportMonitor(): " + exportMonitor);
			return exportMonitor;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in exportSDMX SDMXExportMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public void startCSVExport(CSVExportSession exportSession)
			throws TDGWTServiceException {
		logger.debug("Start CSV Export");
		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}
		logger.debug("Session:" + session.getId());

		ASLSession aslSession = SessionUtil.getAslSession(session);
		if (aslSession == null) {
			throw new TDGWTServiceException(
					"Error retrieving the asl session: null");
		}
		String user = aslSession.getUsername();
		logger.debug("Session User:" + user);

		TRId trId = SessionUtil.getTRId(session);
		if (trId == null) {
			throw new TDGWTServiceException(
					"Error no tabular resource in session");
		}

		if (trId.getTableId() == null) {
			throw new TDGWTServiceException("Error no table present in session");
		}

		SessionUtil.setCSVExportSession(session, exportSession);

		Map<String, Object> parameterInstance = csvExportFileParameter(exportSession);

		logger.debug("Tabular Data Service");

		AuthorizationProvider.instance.set(new AuthorizationToken(aslSession
				.getUsername()));
		TabularDataService service = TabularDataServiceFactory.getService();

		// Export CSV file
		OperationDefinition exportCSVFileOperation = OperationDefinitionMap
				.map(OperationsId.CSVExport.toString(), service);

		OperationExecution invocation = new OperationExecution(
				exportCSVFileOperation.getOperationId(), parameterInstance);

		logger.debug("OperationInvocation: \n" + invocation.toString());

		Task trTask;
		try {
			trTask = service.execute(invocation,
					new TabularResourceId(Long.valueOf(trId.getId())));
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Tabular Data Service error exporting TabularResource: "
							+ e.getLocalizedMessage());
		}

		logger.debug("Start Task on service: TaskId " + trTask.getId());
		SessionUtil.setCSVExportEnd(session, false);
		SessionUtil.setCSVExportTask(session, trTask);

	}

	/**
	 * {@inheritDoc}
	 */
	public CSVExportMonitor getCSVExportMonitor() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			CSVExportSession exportSession = SessionUtil
					.getCSVExportSession(session);
			Task task = SessionUtil.getCSVExportTask(session);
			CSVExportMonitor exportMonitor = new CSVExportMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException("Error in exportCSV task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in exportCSV Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					exportMonitor.setStatus(TaskStateMap.map(task.getStatus()));
					Table table;
					ExportMetadata exportMetadata;
					TabExportMetadata trExportMetadata;
					switch (exportMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							exportMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In Export");
							exportMonitor.setError(new Throwable(
									"Error In Export"));
						}
						exportMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						exportMonitor.setProgress(task.getProgress());
						table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						exportMetadata = table
								.getMetadata(ExportMetadata.class);
						logger.debug("ExportMetadata: " + exportMetadata);

						exportMonitor.setTrId(SessionUtil.getTRId(session));
						trExportMetadata = new TabExportMetadata();
						trExportMetadata.setUrl(exportMetadata.getUri());
						trExportMetadata.setDestinationType(exportMetadata
								.getDestinationType());
						trExportMetadata.setExportDate(sdf
								.format(exportMetadata.getExportDate()));
						exportMonitor.setTrExportMetadata(trExportMetadata);
						saveInDestination(session, aslSession.getUsername(),
								exportMetadata, exportSession);

						break;
					case IN_PROGRESS:
						exportMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						exportMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						exportMonitor.setProgress(task.getProgress());
						table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						exportMetadata = table
								.getMetadata(ExportMetadata.class);
						logger.debug("ExportMetadata: " + exportMetadata);

						exportMonitor.setTrId(SessionUtil.getTRId(session));
						trExportMetadata = new TabExportMetadata();
						trExportMetadata.setUrl(exportMetadata.getUri());
						trExportMetadata.setDestinationType(exportMetadata
								.getDestinationType());
						trExportMetadata.setExportDate(sdf
								.format(exportMetadata.getExportDate()));
						exportMonitor.setTrExportMetadata(trExportMetadata);
						saveInDestination(session, aslSession.getUsername(),
								exportMetadata, exportSession);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setCSVExportTask(session, task);
			}

			logger.debug("getExportMonitor(): " + exportMonitor);
			return exportMonitor;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in exportCSV CSVExportMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	/**
	 * Save export data on Workspace
	 * 
	 * @param session
	 * @param user
	 * @param exportMetadata
	 * @param exportSession
	 * @throws TDGWTServiceException
	 */
	protected void saveInDestination(HttpSession session, String user,
			ExportMetadata exportMetadata, CSVExportSession exportSession)
			throws TDGWTServiceException {
		logger.debug("Save Export In Destination");
		logger.debug("Destination: " + exportSession.getDestination().getId());
		if (exportSession.getDestination().getId().compareTo("Workspace") == 0) {
			logger.debug("Save on Workspace");
			boolean end = SessionUtil.getCSVExportEnd(session);
			if (end == false) {
				SessionUtil.setCSVExportEnd(session, true);
				FilesStorage storage = new FilesStorage();
				logger.debug("Create Item On Workspace: [ uri: "
						+ exportMetadata.getUri() + " ,user: " + user
						+ " ,fileName: " + exportSession.getFileName()
						+ " ,fileDescription: "
						+ exportSession.getFileDescription()
						+ " ,mimetype: text/csv" + " ,folder: "
						+ exportSession.getItemId() + "]");
				storage.createItemOnWorkspace(exportMetadata.getUri(), user,
						exportSession.getFileName(),
						exportSession.getFileDescription(), "text/csv",
						exportSession.getItemId());

			} else {
				logger.debug("getCSVExportEnd(): true");
			}
		} else {
			logger.error("Destination No Present");
			throw new TDGWTServiceException(
					"Error in exportCSV CSVExportMonitor: no destination present");
		}
	}

	
	/**
	 * 
	 * {@inheritDoc}
	 */
	public void startChangeColumnType(
			ChangeColumnTypeSession changeColumnTypeSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setChangeColumnTypeSession(session,
					changeColumnTypeSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();
			
			OpExecution4ChangeColumnType opEx=new OpExecution4ChangeColumnType(service,changeColumnTypeSession);
			OpExecutionDirector director=new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();
			
			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error in ChangeColumnType: Operation not supported for now!");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(changeColumnTypeSession.getColumnData()
							.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			SessionUtil.setChangeColumnTypeTask(session, trTask);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in ChangeColumnType: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public ChangeColumnTypeMonitor getChangeColumnTypeMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ChangeColumnTypeSession changeColumnTypeSession = SessionUtil
					.getChangeColumnTypeSession(session);

			Task task = SessionUtil.getChangeColumnTypeTask(session);
			ChangeColumnTypeMonitor changeColumnTypeMonitor = new ChangeColumnTypeMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in ChangeColumnType task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in ChangeColumnType Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					changeColumnTypeMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));
					Table table;
					TRId trId;
					TabResource tabResource;
					switch (changeColumnTypeMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception: "
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							changeColumnTypeMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In ChangeColumnType");
							changeColumnTypeMonitor.setError(new Throwable(
									"Error In ChangeColumnType"));
						}
						changeColumnTypeMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						changeColumnTypeMonitor.setProgress(task.getProgress());
						table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						trId = new TRId();
						trId.setId(changeColumnTypeSession.getColumnData()
								.getTrId().getId());
						trId = retrieveTabularResourceBasicData(trId);

						changeColumnTypeMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						changeColumnTypeMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						changeColumnTypeMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						trId = new TRId();
						trId.setId(changeColumnTypeSession.getColumnData()
								.getTrId().getId());

						trId = retrieveTabularResourceBasicData(trId);

						changeColumnTypeMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setChangeColumnTypeTask(session, task);
			}

			logger.debug("ChangeColumnTypeMonitor(): "
					+ changeColumnTypeMonitor);
			return changeColumnTypeMonitor;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in change column type ChangeColumnTypeMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public void startAddColumn(AddColumnSession addColumnSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setAddColumnSession(session, addColumnSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();
			
			OpExecution4AddColumn opEx=new OpExecution4AddColumn(service, addColumnSession);
			OpExecutionDirector director=new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();
			
			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error Add Column: Operation not supported for now!");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(addColumnSession.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			SessionUtil.setAddColumnTask(session, trTask);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in AddColumn: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public AddColumnMonitor getAddColumnMonitor() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			AddColumnSession addColumnSession = SessionUtil
					.getAddColumnSession(session);

			Task task = SessionUtil.getAddColumnTask(session);
			AddColumnMonitor addColumnMonitor = new AddColumnMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in AddColumnMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in AddColumnMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					addColumnMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));
					Table table;
					TRId trId;
					TabResource tabResource;
					switch (addColumnMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							addColumnMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In AddColumnMonitor");
							addColumnMonitor.setError(new Throwable(
									"Error Add Column"));
						}
						addColumnMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						addColumnMonitor.setProgress(task.getProgress());
						table = task.getResult().getPrimaryTable();
						logger.debug("Table retrieved: " + table.toString());
						trId = new TRId();
						trId.setId(addColumnSession.getTrId().getId());
						trId = retrieveTabularResourceBasicData(trId);

						addColumnMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						addColumnMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						addColumnMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						addColumnMonitor.setProgress(task.getProgress());
						table = task.getResult().getPrimaryTable();
						logger.debug("Table retrieved: " + table.toString());
						trId = new TRId();
						trId.setId(addColumnSession.getTrId().getId());
						trId = retrieveTabularResourceBasicData(trId);

						addColumnMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setAddColumnTask(session, task);
			}

			logger.debug("AddColumnMonitor(): " + addColumnMonitor);
			return addColumnMonitor;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in add column monitor AddColumnMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public void startDeleteColumn(DeleteColumnSession deleteColumnSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setDeleteColumnSession(session, deleteColumnSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			OpExecution4DeleteColumn opEx=new OpExecution4DeleteColumn(service, deleteColumnSession);
			OpExecutionDirector director=new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
		
			ArrayList<OperationExecution> invocation = director.getListOperationExecution();
			
			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error Delete Column: Operation not supported for now!");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(deleteColumnSession.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.executeBatch(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			SessionUtil.setDeleteColumnTask(session, trTask);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in DeleteColumn: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public DeleteColumnMonitor getDeleteColumnMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			DeleteColumnSession deleteColumnSession = SessionUtil
					.getDeleteColumnSession(session);

			Task task = SessionUtil.getDeleteColumnTask(session);
			DeleteColumnMonitor deleteColumnMonitor = new DeleteColumnMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in DeleteColumnMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in DeleteColumnMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					deleteColumnMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));
					Table table;
					TRId trId;
					TabResource tabResource;
					switch (deleteColumnMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							deleteColumnMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In DeleteColumnMonitor");
							deleteColumnMonitor.setError(new Throwable(
									"Error Deleting Column"));
						}
						deleteColumnMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						deleteColumnMonitor.setProgress(task.getProgress());
						table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						trId = new TRId();
						trId.setId(deleteColumnSession.getTrId().getId());
						trId = retrieveTabularResourceBasicData(trId);

						deleteColumnMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						deleteColumnMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						deleteColumnMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						deleteColumnMonitor.setProgress(task.getProgress());
						table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						trId = new TRId();
						trId.setId(deleteColumnSession.getTrId().getId());
						trId = retrieveTabularResourceBasicData(trId);

						deleteColumnMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setDeleteColumnTask(session, task);
			}

			logger.debug("DeleteColumnMonitor(): " + deleteColumnMonitor);
			return deleteColumnMonitor;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in delete column monitor DeleteColumnMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public void startLabelColumn(LabelColumnSession labelColumnSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setLabelColumnSession(session, labelColumnSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug(labelColumnSession.toString());

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();
			
			OpExecution4LabelColumn opEx=new OpExecution4LabelColumn(service, labelColumnSession);
			OpExecutionDirector director=new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();
			
			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error Changing the Column Label: Operation not supported for now!");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(labelColumnSession.getColumnData().getTrId()
							.getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			SessionUtil.setLabelColumnTask(session, trTask);
			return;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error Changing The Column Label: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public LabelColumnMonitor getLabelColumnMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			LabelColumnSession labelColumnSession = SessionUtil
					.getLabelColumnSession(session);

			Task task = SessionUtil.getLabelColumnTask(session);
			LabelColumnMonitor labelColumnMonitor = new LabelColumnMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in LabelColumnMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in LabelColumnMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					labelColumnMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));

					TRId trId;
					TabResource tabResource;
					switch (labelColumnMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							labelColumnMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In LabelColumnMonitor");
							labelColumnMonitor.setError(new Throwable(
									"Error Changing the Column Label"));
						}
						labelColumnMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						labelColumnMonitor.setProgress(task.getProgress());
						trId = new TRId();
						trId.setId(labelColumnSession.getColumnData().getTrId()
								.getId());
						trId = retrieveTabularResourceBasicData(trId);

						labelColumnMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						labelColumnMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						labelColumnMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						labelColumnMonitor.setProgress(task.getProgress());
						trId = new TRId();
						trId.setId(labelColumnSession.getColumnData().getTrId()
								.getId());
						trId = retrieveTabularResourceBasicData(trId);

						labelColumnMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setLabelColumnTask(session, task);
			}

			logger.debug("LabelColumnMonitor(): " + labelColumnMonitor);
			return labelColumnMonitor;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in delete column monitor LabelColumnMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void startChangeTableType(
			ChangeTableTypeSession changeTableTypeSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setChangeTableTypeSession(session,
					changeTableTypeSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();
			
			OpExecution4ChangeTableType opEx=new OpExecution4ChangeTableType(service, changeTableTypeSession);
			OpExecutionDirector director=new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();
			
			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error Change Table Type invocation: Operation not supported");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(changeTableTypeSession.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			SessionUtil.setChangeTableTypeTask(session, trTask);
			return;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error Changing Table Type: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ChangeTableTypeMonitor getChangeTableTypeMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ChangeTableTypeSession changeTableTypeSession = SessionUtil
					.getChangeTableTypeSession(session);

			Task task = SessionUtil.getChangeTableTypeTask(session);
			ChangeTableTypeMonitor changeTableTypeMonitor = new ChangeTableTypeMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in ChangeTableTypeMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in ChangeTableTypeMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					changeTableTypeMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));
					Table table;
					TRId trId;
					TabResource tabResource;
					switch (changeTableTypeMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							changeTableTypeMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In ChangeTableTypeMonitor");
							changeTableTypeMonitor.setError(new Throwable(
									"Error Changing the Table Type"));
						}
						changeTableTypeMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						changeTableTypeMonitor.setProgress(task.getProgress());
						table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						trId = new TRId();
						trId.setId(changeTableTypeSession.getTrId().getId());

						trId = retrieveTabularResourceBasicData(trId);

						changeTableTypeMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						changeTableTypeMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						changeTableTypeMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						changeTableTypeMonitor.setProgress(task.getProgress());
						table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						trId = new TRId();
						trId.setId(changeTableTypeSession.getTrId().getId());

						trId = retrieveTabularResourceBasicData(trId);

						changeTableTypeMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setChangeTableTypeTask(session, task);
			}

			logger.debug("ChangeTableTypeMonitor(): " + changeTableTypeMonitor);
			return changeTableTypeMonitor;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in change table type monitor ChangeTableTypeMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<ColumnData> getColumnsForDimension(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			logger.debug("getColumnsForDimension():" + trId.toString());

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));

			ArrayList<ColumnData> columns = new ArrayList<ColumnData>();

			List<Column> cols = table.getColumns();
			int i = 0;
			for (Column c : cols) {
				ColumnType ctype = c.getColumnType();
				if (c.getColumnType() instanceof IdColumnType
						|| c.getColumnType() instanceof ValidationColumnType
						|| c.getColumnType() instanceof DimensionColumnType
						|| c.getColumnType() instanceof TimeDimensionColumnType) {

				} else {
					if (c.contains(ViewColumnMetadata.class)) {

					} else {
						if (ctype instanceof CodeColumnType
								|| ctype instanceof CodeNameColumnType
								|| ctype instanceof CodeDescriptionColumnType
								|| ctype instanceof AnnotationColumnType) {

							ColumnData cData = new ColumnData();
							cData.setId(Integer.toString(i));
							cData.setColumnId(c.getLocalId().getValue());
							cData.setName(c.getName());
							cData.setTypeCode(c.getColumnType().getCode());
							cData.setTypeName(c.getColumnType().getName());
							cData.setDataTypeName(c.getDataType().getName());
							NamesMetadata labelsMetadata = null;
							try {
								labelsMetadata = c
										.getMetadata(NamesMetadata.class);
							} catch (NoSuchMetadataException e) {
								logger.debug("labelMetadata: NoSuchMetadataException "
										+ e.getLocalizedMessage());
							}

							if (labelsMetadata == null) {
								cData.setLabel("nolabel");
								logger.debug("LabelsMetadata no labels");
							} else {
								LocalizedText cl = null;
								cl = labelsMetadata.getTextWithLocale("en");
								if (cl == null) {
									cData.setLabel("nolabel");
									logger.debug("ColumnLabel no label in en");
								} else {
									if (cl.getValue() == null
											|| cl.getValue().isEmpty()) {
										cData.setLabel("nolabel");
										logger.debug("ColumnLabel no label in en");
									} else {
										cData.setLabel(cl.getValue());
										logger.debug("Column Set Label: "
												+ cl.getValue());
									}
								}
							}

							DataLocaleMetadata dataLocaleMetadata = null;
							try {
								dataLocaleMetadata = c
										.getMetadata(DataLocaleMetadata.class);
							} catch (NoSuchMetadataException e) {
								logger.debug("DataLocaleMetadata: NoSuchMetadataException "
										+ e.getLocalizedMessage());
							}

							if (dataLocaleMetadata == null) {
								logger.debug("No DataLocaleMetadata");
							} else {
								cData.setLocale(dataLocaleMetadata.getLocale());
							}

							cData.setTrId(trId);
							columns.add(cData);
							i++;
						}
					}
				}
			}
			return columns;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error in getColumnsForDimension() retrieving Columns: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException("Error retrieving Columns: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void startDeleteRows(DeleteRowsSession deleteRowsSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setDeleteRowsSession(session, deleteRowsSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();
			
			OpExecution4DeleteRows opEx=new OpExecution4DeleteRows(service, deleteRowsSession);
			OpExecutionDirector director=new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();
			
			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error Delete Rows invocation: Operation not supported");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(deleteRowsSession.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			SessionUtil.setDeleteRowsTask(session, trTask);
			return;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error Deleting Rows: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public DeleteRowsMonitor getDeleteRowsMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			DeleteRowsSession deleteRowsSession = SessionUtil
					.getDeleteRowsSession(session);

			Task task = SessionUtil.getDeleteRowsTask(session);
			DeleteRowsMonitor deleteRowsMonitor = new DeleteRowsMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in DeleteRowsMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in DeleteRowsMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					deleteRowsMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));
					// Table table;
					TRId trId;
					TabResource tabResource;
					switch (deleteRowsMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception: "
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							deleteRowsMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In DeleteRowsMonitor");
							deleteRowsMonitor.setError(new Throwable(
									"Error deleting rows"));
						}
						deleteRowsMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						deleteRowsMonitor.setProgress(task.getProgress());
						trId = new TRId();
						trId.setId(deleteRowsSession.getTrId().getId());

						trId = retrieveTabularResourceBasicData(trId);

						deleteRowsMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						deleteRowsMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						deleteRowsMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						deleteRowsMonitor.setProgress(task.getProgress());
						trId = new TRId();
						trId.setId(deleteRowsSession.getTrId().getId());
						trId = retrieveTabularResourceBasicData(trId);

						deleteRowsMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setDeleteRowsTask(session, task);
			}

			logger.debug("DeleteRowsMonitor(): " + deleteRowsMonitor);
			return deleteRowsMonitor;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in monitor DeleteRowsMonitor: "
							+ e.getLocalizedMessage());

		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public TRId startCloneTabularResource(
			CloneTabularResourceSession cloneTabularResourceSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setCloneTabularResourceSession(session,
					cloneTabularResourceSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			logger.debug("CloneTabularResourceSession: "
					+ cloneTabularResourceSession);

			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(cloneTabularResourceSession.getTrId().getId()));

			TabularResource cloned = service.cloneTabularResource(serviceTR);
			logger.debug("Clone: " + cloned.toString());
			Table table = service.getLastTable(cloned.getId());

			Table viewTable = null;

			if (table.contains(DatasetViewTableMetadata.class)) {
				DatasetViewTableMetadata dwm = table
						.getMetadata(DatasetViewTableMetadata.class);
				try {
					viewTable = service.getTable(dwm
							.getTargetDatasetViewTableId());
				} catch (Exception e) {
					logger.error("view table not found");
				}
			}

			TRId trId;
			if (viewTable == null) {
				trId = new TRId(new Long(cloned.getId().getValue()).toString(),
						cloned.getTableType(), new Long(table.getId()
								.getValue()).toString(), table.getTableType()
								.getName());

			} else {
				trId = new TRId(new Long(cloned.getId().getValue()).toString(),
						cloned.getTableType(), String.valueOf(viewTable.getId()
								.getValue()), viewTable.getTableType()
								.getName(), String.valueOf(table.getId()
								.getValue()), true);
			}

			TabResource tabResource = new TabResource();
			tabResource.setTrId(trId);
			SessionUtil.setTabResource(session, tabResource);
			SessionUtil.setTRId(session, trId);

			return trId;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error Cloning: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void startDuplicates(DuplicatesSession duplicatesSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setDuplicatesSession(session, duplicatesSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();
		
			OpExecution4Duplicates opEx=new OpExecution4Duplicates(service, duplicatesSession);
			OpExecutionDirector director=new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();
			
			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error Delete Rows invocation: Operation not supported");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(duplicatesSession.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			SessionUtil.setDuplicatesTask(session, trTask);
			return;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in operation for duplicates: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public DuplicatesMonitor getDuplicatesMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			DuplicatesSession duplicatesSession = SessionUtil
					.getDuplicatesSession(session);

			Task task = SessionUtil.getDuplicatesTask(session);
			DuplicatesMonitor duplicatesMonitor = new DuplicatesMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in DuplicatesMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in DuplicatesMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					duplicatesMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));
					Table table;
					TRId trId;
					TabResource tabResource;
					switch (duplicatesMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							duplicatesMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In DuplicatesMonitor");
							duplicatesMonitor.setError(new Throwable(
									"Error in operation for duplicates"));
						}
						duplicatesMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						duplicatesMonitor.setProgress(task.getProgress());
						table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						trId = new TRId();
						trId.setId(duplicatesSession.getTrId().getId());
						trId = retrieveTabularResourceBasicData(trId);

						duplicatesMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						duplicatesMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						duplicatesMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						duplicatesMonitor.setProgress(task.getProgress());
						table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						trId = new TRId();
						trId.setId(duplicatesSession.getTrId().getId());

						trId = retrieveTabularResourceBasicData(trId);

						duplicatesMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setDuplicatesTask(session, task);
			}

			logger.debug("DuplicatesMonitor(): " + duplicatesMonitor);
			return duplicatesMonitor;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in monitor DuplicatesMonitor: "
							+ e.getLocalizedMessage());

		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ShareInfo getShareInfo(TRId trId) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			TabResource tabResource = getTabResourceInformation(trId);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(tabResource.getTrId().getId()));

			TabularResource tr = service.getTabularResource(serviceTR);
			List<String> sharedWith = tr.getSharedWithUsers();
			logger.debug("Shared with Users: " + sharedWith);
			ArrayList<Contacts> contacts = new ArrayList<Contacts>();
			for (String user : sharedWith) {
				Contacts cont = new Contacts(null, user, false);
				contacts.add(cont);
			}

			ShareInfo shareInfo = new ShareInfo(tabResource, contacts);
			return shareInfo;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in getShareInfo: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void setShare(ShareInfo shareInfo) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("ShareInfo: " + shareInfo);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(shareInfo.getTabResource().getTrId().getId()));

			List<String> users = new ArrayList<String>();
			for (Contacts cont : shareInfo.getContacts()) {
				String user = cont.getLogin();
				users.add(user);
			}
			String[] usersArray = users.toArray(new String[0]);
			logger.debug("Share with Users: " + users);
			service.share(serviceTR, usersArray);

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error on service");
		}
	}

	public boolean checkTabularResourceNotFinal(TRId trId)
			throws TDGWTServiceException {
		try {
			
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("checkTabularResourceNotFinal: " + trId);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();
			
			TabularResourceId tabularResourceId = new TabularResourceId(
					new Long(trId.getId()));
			TabularResource tr = service.getTabularResource(tabularResourceId);
			
			return tr.isFinalized();
		
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("Error in checkTabularResourceNotFinal: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in checkTabularResourceNotFinal: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void setTabResourceInformation(TabResource tabResource)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("SetTabResourceInformation: " + tabResource);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId tabularResourceId = new TabularResourceId(
					new Long(tabResource.getTrId().getId()));

			TabularResource tr = service.getTabularResource(tabularResourceId);
			
			
			
			if (tabResource.getName() != null) {
				NameMetadata name = new NameMetadata(tabResource.getName());
				tr.setMetadata(name);
			}

			if (tabResource.getDescription() != null) {
				DescriptionMetadata description = new DescriptionMetadata(
						tabResource.getDescription());
				tr.setMetadata(description);
			}

			if (tabResource.getAgency() != null) {
				AgencyMetadata agency = new AgencyMetadata(
						tabResource.getAgency());
				tr.setMetadata(agency);
			}

			if (tabResource.getRight() != null) {
				RightsMetadata rights = new RightsMetadata(
						tabResource.getRight());
				tr.setMetadata(rights);
			}

			if (tabResource.isFinalized()) {
				if (!tr.isFinalized()) {
					tr.finalize();
				}
			}

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("Error in setTabResourceInformation: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in setTabResourceInformation: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<Occurrences> getOccurrencesForBatchReplace(
			OccurrencesForReplaceBatchColumnSession occurrencesForReplaceBatchColumnSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("GetOccurencesForBatchReplace: "
					+ occurrencesForReplaceBatchColumnSession.toString());
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			ArrayList<Occurrences> occurences = QueryService.queryOccurences(
					service, occurrencesForReplaceBatchColumnSession,
					Direction.ASC);

			logger.debug("Retrieved Occurences");
			return occurences;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("Error in GetOccurencesForBatchReplace: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in GetOccurencesForBatchReplace: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<TemplateData> getTemplates() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("GetTemplates");
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			List<TemplateDescription> templateDescriptorList = service
					.getTemplates();
			ArrayList<TemplateData> templateDataList = new ArrayList<TemplateData>();
			TemplateData templateData;
			for (TemplateDescription desc : templateDescriptorList) {
				templateData = new TemplateData();
				templateData.setId(desc.getId());
				templateData.setName(desc.getName());
				templateData.setDescription(desc.getDescription());
				templateData.setAgency(desc.getAgency());
				switch (desc.getTemplate().getCategory()) {
				case CODELIST:
					templateData.setCategory("Codelist");
					break;
				case DATASET:
					templateData.setCategory("Dataset");
					break;
				case GENERIC:
					templateData.setCategory("Generic");
					break;
				default:
					break;

				}
				;

				templateDataList.add(templateData);
			}
			logger.debug("Retrieved TemplateData List");

			return templateDataList;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("Error in GetTemplates: " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in GetOccurencesForBatchReplace: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void startTemplateApply(TemplateApplySession templateApplySession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("startTemplateApply: " + templateApplySession);
			SessionUtil.setTemplateApplySession(session, templateApplySession);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TemplateId templateId = new TemplateId(templateApplySession
					.getTemplateData().getId());
			TabularResourceId tabularResourceId = new TabularResourceId(
					new Long(templateApplySession.getTrId().getId()));
			Task task = service.applyTemplate(templateId, tabularResourceId);
			logger.debug("startTemplateApply task start");
			SessionUtil.setTemplateApplyTask(session, task);

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("Error StartTemplateApply: " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error StartTemplateApply: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public TemplateApplyMonitor getTemplateApplyMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			TemplateApplySession templateApplySession = SessionUtil
					.getTemplateApplySession(session);
			Task task = SessionUtil.getTemplateApplyTask(session);
			TemplateApplyMonitor templateApplyMonitor = new TemplateApplyMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in TemplateApplyMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in TemplateApplyMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					templateApplyMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));

					TRId trId;
					TabResource tabResource;
					switch (templateApplyMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							templateApplyMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In TemplateApplyMonitor");
							templateApplyMonitor.setError(new Throwable(
									"Error in operation applying template"));
						}
						templateApplyMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						templateApplyMonitor.setProgress(task.getProgress());

						trId = new TRId();
						trId.setId(templateApplySession.getTrId().getId());

						trId = retrieveTabularResourceBasicData(trId);

						templateApplyMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						templateApplyMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						templateApplyMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						templateApplyMonitor.setProgress(task.getProgress());

						trId = new TRId();
						trId.setId(templateApplySession.getTrId().getId());

						trId = retrieveTabularResourceBasicData(trId);

						templateApplyMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setTemplateApplyTask(session, task);
			}

			logger.debug("TemplateApplyMonitor(): " + templateApplyMonitor);
			return templateApplyMonitor;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in monitor DuplicatesMonitor: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void startTemplateDelete(TemplateDeleteSession templateDeleteSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("startTemplateDelete: " + templateDeleteSession);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TemplateId templateId;
			for (TemplateData template : templateDeleteSession.getTemplates()) {
				templateId = new TemplateId(template.getId());
				service.remove(templateId);
			}

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (NoSuchTemplateException e) {
			logger.debug("Error StartTemplateDelete: No such Template");
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error StartTemplateDelete: No such Template");
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("Error StartTemplateDelete: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error StartTemplateDelete: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void startReplaceColumn(ReplaceColumnSession replaceColumnSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setReplaceColumnSession(session, replaceColumnSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();
			
			OpExecution4ReplaceColumn opEx=new OpExecution4ReplaceColumn(service, replaceColumnSession);
			OpExecutionDirector director=new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();
			
			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error Replace Column Value invocation: Operation not supported");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(replaceColumnSession.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			SessionUtil.setReplaceColumnTask(session, trTask);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in operation for replace column value: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ReplaceColumnMonitor getReplaceColumnMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ReplaceColumnSession replaceColumnSession = SessionUtil
					.getReplaceColumnSession(session);

			Task task = SessionUtil.getReplaceColumnTask(session);
			ReplaceColumnMonitor replaceColumnMonitor = new ReplaceColumnMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in ReplaceColumnMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in ReplaceColumnMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					replaceColumnMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));

					TRId trId;
					TabResource tabResource;
					switch (replaceColumnMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							replaceColumnMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In ReplaceColumnMonitor");
							replaceColumnMonitor.setError(new Throwable(
									"Error replacing the Column value"));
						}
						replaceColumnMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						replaceColumnMonitor.setProgress(task.getProgress());
						trId = new TRId();
						trId.setId(replaceColumnSession.getTrId().getId());

						trId = retrieveTabularResourceBasicData(trId);

						replaceColumnMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						replaceColumnMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						replaceColumnMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						replaceColumnMonitor.setProgress(task.getProgress());
						trId = new TRId();
						trId.setId(replaceColumnSession.getColumnData()
								.getTrId().getId());

						trId = retrieveTabularResourceBasicData(trId);

						replaceColumnMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setReplaceColumnTask(session, task);
			}

			logger.debug("ReplaceColumnMonitor(): " + replaceColumnMonitor);
			return replaceColumnMonitor;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.debug("Error in replace column monitor ReplaceColumnMonitor: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in replace column monitor ReplaceColumnMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void startReplaceBatchColumn(
			ReplaceBatchColumnSession replaceBatchColumnSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setReplaceBatchColumnSession(session,
					replaceBatchColumnSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			OpExecution4ReplaceBatch opEx=new OpExecution4ReplaceBatch(service, replaceBatchColumnSession);
			OpExecutionDirector director=new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			
			List<OperationExecution> invocations = director.getListOperationExecution();
			
			if (invocations == null) {
				throw new TDGWTServiceException("Operation not supported");
			}
			TabularResourceId serviceTRId = new TabularResourceId(
					Long.valueOf(replaceBatchColumnSession.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocations.toString());
			Task trTask = service.executeBatch(invocations, serviceTRId);
			if (trTask == null) {
				logger.error("Error on service Task null");
				throw new TDGWTServiceException("Task not started");
			}
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			SessionUtil.setReplaceBatchColumnTask(session, trTask);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in operation for batch replace on column: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ReplaceBatchColumnMonitor getReplaceBatchColumnMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ReplaceBatchColumnSession replaceBatchColumnSession = SessionUtil
					.getReplaceBatchColumnSession(session);

			Task task = SessionUtil.getReplaceBatchColumnTask(session);
			ReplaceBatchColumnMonitor replaceBatchColumnMonitor = new ReplaceBatchColumnMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in ReplaceBatchColumnMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in ReplaceBatchColumnMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					replaceBatchColumnMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));

					TRId trId;
					TabResource tabResource;
					switch (replaceBatchColumnMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							replaceBatchColumnMonitor.setError(new Throwable(
									task.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In ReplaceBatchColumnMonitor");
							replaceBatchColumnMonitor.setError(new Throwable(
									"Error replacing the Column value"));
						}
						replaceBatchColumnMonitor.setProgress(task
								.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						replaceBatchColumnMonitor.setProgress(task
								.getProgress());
						trId = new TRId();
						trId.setId(replaceBatchColumnSession.getTrId().getId());

						trId = retrieveTabularResourceBasicData(trId);

						replaceBatchColumnMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						replaceBatchColumnMonitor.setProgress(task
								.getProgress());
						break;
					case VALIDATING_RULES:
						replaceBatchColumnMonitor.setProgress(task
								.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						replaceBatchColumnMonitor.setProgress(task
								.getProgress());
						trId = new TRId();
						trId.setId(replaceBatchColumnSession.getColumnData()
								.getTrId().getId());

						trId = retrieveTabularResourceBasicData(trId);

						replaceBatchColumnMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setReplaceBatchColumnTask(session, task);
			}

			logger.debug("ReplaceBatchColumnMonitor(): "
					+ replaceBatchColumnMonitor);
			return replaceBatchColumnMonitor;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.debug("Error in ReplaceBatchColumnMonitor: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error in replace batch: "
					+ e.getLocalizedMessage());

		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<String> getLocales() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			@SuppressWarnings("unused")
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("getLocales()");
			List<String> listLocales = Arrays.asList(Locales.ALLOWED_LOCALES);
			ArrayList<String> locales = new ArrayList<String>();
			locales.addAll(listLocales);

			logger.debug("locales :" + locales);
			return locales;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.debug("getLocales(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving locales: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public OpHistory getLastOperationInfo() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("getLastOperationInfo()");
			TabResource currentTR = SessionUtil.getTabResource(session);
			if (currentTR == null) {
				logger.error("CURRENT_TABULAR_RESOURCE is null");
				throw new TDGWTServiceException(
						"CURRENT_TABULAR_RESOURCE is null");
			}
			TRId trId = currentTR.getTrId();

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId tabularResourceId = new TabularResourceId(
					Long.valueOf(trId.getId()));
			TabularResource tabularResource = service
					.getTabularResource(tabularResourceId);
			List<HistoryStep> history = tabularResource.getHistory();
			long historyId = 0;
			String opDesc = null, opName = null;
			HistoryStep lastStep = null;
			OpHistory op = null;

			if (history != null && history.size() > 0) {
				lastStep = history.get(0);
				if (lastStep != null) {
					opDesc = lastStep.getOperationDescription();
					opName = opDesc;
					historyId = lastStep.getId().getValue();
					op = new OpHistory(historyId, opName, opDesc,
							sdf.format(lastStep.getExecutionDate().getTime()));
				}

			}

			logger.debug("Last Operation Info :" + op);
			return op;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("getLastOperationInfo(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error retrieving last operation info: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 * 
	 */
	@Override
	public OpHistory getLastOperationInfo(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("getLastOperationInfo: " + trId);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId tabularResourceId = new TabularResourceId(
					Long.valueOf(trId.getId()));
			TabularResource tabularResource = service
					.getTabularResource(tabularResourceId);

			List<HistoryStep> history = tabularResource.getHistory();
			long historyId = 0;
			String opDesc = null, opName = null;
			HistoryStep lastStep = null;
			OpHistory op = null;

			if (history != null && history.size() > 0) {
				lastStep = history.get(0);
				if (lastStep != null) {
					opDesc = lastStep.getOperationDescription();
					opName = opDesc;
					historyId = lastStep.getId().getValue();
					op = new OpHistory(historyId, opName, opDesc,
							sdf.format(lastStep.getExecutionDate().getTime()));
				}

			}
			logger.debug("Last Operation Info :" + op);
			return op;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("getLastOperationInfo(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error retrieving last operation info: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<OpHistory> getHistory() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("getHistory()");
			TabResource currentTR = SessionUtil.getTabResource(session);
			if (currentTR == null) {
				logger.error("CURRENT_TABULAR_RESOURCE is null");
				throw new TDGWTServiceException(
						"CURRENT_TABULAR_RESOURCE is null");
			}
			TRId trId = currentTR.getTrId();

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId tabularResourceId = new TabularResourceId(
					Long.valueOf(trId.getId()));
			TabularResource tabularResource = service
					.getTabularResource(tabularResourceId);
			List<HistoryStep> history = tabularResource.getHistory();

			ArrayList<OpHistory> opHistoryList = new ArrayList<OpHistory>();

			long historyId = 0;
			String opDesc = null, opName = null;
			OpHistory op = null;

			for (HistoryStep step : history) {
				if (step != null) {
					historyId = step.getId().getValue();
					opDesc = step.getOperationDescription();
					opName = step.getOperationDescription();
					op = new OpHistory(historyId, opName, opDesc,
							sdf.format(step.getExecutionDate().getTime()));
					opHistoryList.add(op);
				}
			}

			logger.debug("History :" + opHistoryList);
			return opHistoryList;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("getHistory(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving history: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<OpHistory> getHistory(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("getHistory(): " + trId);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId tabularResourceId = new TabularResourceId(
					Long.valueOf(trId.getId()));
			TabularResource tabularResource = service
					.getTabularResource(tabularResourceId);
			List<HistoryStep> history = tabularResource.getHistory();

			ArrayList<OpHistory> opHistoryList = new ArrayList<OpHistory>();

			long historyId = 0;
			String opDesc = null, opName = null;
			OpHistory op = null;

			for (HistoryStep step : history) {
				if (step != null) {
					historyId = step.getId().getValue();
					opDesc = step.getOperationDescription();
					opName = step.getOperationDescription();
					op = new OpHistory(historyId, opName, opDesc,
							sdf.format(step.getExecutionDate().getTime()));
					opHistoryList.add(op);
				}
			}

			logger.debug("History :" + opHistoryList);
			return opHistoryList;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("getHistory(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving history: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public RollBackSession discard(TRId trId) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("discard(): " + trId);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId tabularResourceId = new TabularResourceId(
					Long.valueOf(trId.getId()));
			TabularResource tabularResource = service
					.getTabularResource(tabularResourceId);
			List<HistoryStep> history = tabularResource.getHistory();

			long historyId = 0;
			String opDesc = null, opName = null;
			OpHistory op = null;
			RollBackSession rollBackSession = null;
			if (history != null) {
				if (history.size() > 1) {
					HistoryStep step = history.get(history.size() - 2);
					if (step != null) {
						historyId = step.getId().getValue();
						opDesc = step.getOperationDescription();
						opName = opDesc;
						op = new OpHistory(historyId, opName, opDesc,
								sdf.format(step.getExecutionDate().getTime()));
						logger.debug("Discard :" + op);
						rollBackSession = new RollBackSession(trId, historyId);
						rollBack(rollBackSession);

					} else {
						logger.debug("Discard : step null");
					}
				} else {
					logger.debug("Discard : no previous step exist");
				}

			} else {
				logger.debug("Discard : not present");
			}

			return rollBackSession;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("discard(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Discard: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void rollBack(RollBackSession rollBackSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("rollBack(): " + rollBackSession);
			SessionUtil.setRollBackSession(session, rollBackSession);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId tabularResourceId = new TabularResourceId(
					Long.valueOf(rollBackSession.getTrId().getId()));
			HistoryStepId historyStepId = new HistoryStepId(
					rollBackSession.getHistoryId());

			Task trTask = service.rollbackTo(tabularResourceId, historyStepId);
			if (trTask == null) {
				logger.error("Error on service Task null");
				throw new TDGWTServiceException("Task not started");
			}
			logger.debug("Start Task on service: " + trTask.getId());
			SessionUtil.setRollBackSessionTask(session, trTask);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("rollBack(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("RollBack: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public RollBackSessionMonitor getRollBackMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			RollBackSession rollBackSession = SessionUtil
					.getRollBackSession(session);

			Task task = SessionUtil.getRollBackSessionTask(session);
			RollBackSessionMonitor rollBackMonitor = new RollBackSessionMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in RollBackMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in RollBackSessionMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					rollBackMonitor
							.setStatus(TaskStateMap.map(task.getStatus()));

					TRId trId;
					TabResource tabResource;
					switch (rollBackMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							rollBackMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In RollBackSessionMonitor");
							rollBackMonitor.setError(new Throwable(
									"Error in roll back"));
						}
						rollBackMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						rollBackMonitor.setProgress(task.getProgress());
						trId = new TRId();
						trId.setId(rollBackSession.getTrId().getId());
						trId = retrieveTabularResourceBasicData(trId);
						rollBackMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						rollBackMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						rollBackMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						rollBackMonitor.setProgress(task.getProgress());

						trId = retrieveTabularResourceBasicData(rollBackSession
								.getTrId());

						rollBackMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setRollBackSessionTask(session, task);
			}

			logger.debug("RollBackSessionMonitor(): " + rollBackMonitor);
			return rollBackMonitor;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.debug("Error in RollBackSessionMonitor: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error in rollback: "
					+ e.getLocalizedMessage());

		}

	}

	@Override
	public ValidationsTasksMetadata getValidationsTasksMetadata(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("GetTableValidationsMetadata on " + trId.toString());
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();
			TabularResourceId tabularResourceId = new TabularResourceId(
					new Long(trId.getId()));

			ArrayList<TaskS> taskSList = new ArrayList<TaskS>();
			List<Task> tasks = service.getTasks(tabularResourceId);
			for (Task task : tasks) {
				ArrayList<JobS> jobSList = new ArrayList<JobS>();
				int j = 1;
				for (Job job : task.getTaskJobs()) {
					int i = 1;
					ArrayList<Validations> validations = new ArrayList<Validations>();
					for (ValidationDescriptor val : job.getValidations()) {
						Validations validation = new Validations(
								String.valueOf(i), val.getDescription(),
								val.isValid());
						validations.add(validation);
						i++;
					}
					// TODO Fix refColumn

					InvocationS invocationS = null;
					if (job.getInvocation() != null) {
						HashMap<String, Object> mapSent = new HashMap<String, Object>();
						Map<String, Object> map = job.getInvocation()
								.getParameters();
						Set<String> keys = map.keySet();
						Iterator<String> iterator = keys.iterator();
						while (iterator.hasNext()) {
							String key = iterator.next();
							Object o = map.get(key);
							mapSent.put(key, o.toString());
						}

						RefColumn refColumn = ExtractReferences.extract(job
								.getInvocation());

						invocationS = new InvocationS(job.getInvocation()
								.getColumnId(), job.getInvocation()
								.getIdentifier(), job.getInvocation()
								.getOperationId(), mapSent, task.getId()
								.getValue(), refColumn);
					}
					JobS jobS = new JobS(String.valueOf(j), job.getProgress(),
							job.getHumaReadableStatus(), job.getDescription(),
							validations, invocationS);
					jobSList.add(jobS);
					j++;

				}
				State state = TaskStateMap.map(task.getStatus());
				TaskS taskS = new TaskS(task.getId().getValue(),
						task.getProgress(), state, task.getSubmitter(),
						task.getStartTime(), task.getEndTime(), jobSList);
				taskSList.add(taskS);
			}

			ValidationsTasksMetadata validationsTasksMetadata = new ValidationsTasksMetadata(
					taskSList);

			logger.debug("ValidationsTasksMetadata: "
					+ validationsTasksMetadata);
			return validationsTasksMetadata;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			logger.error(
					"Error in  getValidationsTasksMetadata(): "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error in  getValidationsTasksMetadata: "
							+ e.getLocalizedMessage());
		}
	}

	@Override
	public void startEditRow(EditRowSession editRowSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setEditRowSession(session, editRowSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();
			
			OpExecution4EditRow opEx=new OpExecution4EditRow(service, editRowSession);
			OpExecutionDirector director=new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();
			
			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error in invocation: Operation not supported");
			}
			Long id;
			if (editRowSession.getTrId().isViewTable()) {
				id = Long.valueOf(editRowSession.getTrId()
						.getReferenceTargetTableId());
			} else {
				id = Long.valueOf(editRowSession.getTrId().getId());
			}

			TabularResourceId serviceTR = new TabularResourceId(id);
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			SessionUtil.setEditRowTask(session, trTask);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in operation: "
					+ e.getLocalizedMessage());
		}

	}

	@Override
	public EditRowMonitor getEditRowMonitor() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			EditRowSession editRowSession = SessionUtil
					.getEditRowSession(session);

			Task task = SessionUtil.getEditRowTask(session);
			EditRowMonitor editRowMonitor = new EditRowMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in EditRowMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in EditRowMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					editRowMonitor
							.setStatus(TaskStateMap.map(task.getStatus()));

					TRId trId;
					TabResource tabResource;
					switch (editRowMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							editRowMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In EditRowMonitor");
							editRowMonitor.setError(new Throwable(
									"Error in edit row"));
						}
						editRowMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						editRowMonitor.setProgress(task.getProgress());
						trId = new TRId();
						trId.setId(editRowSession.getTrId().getId());
						trId = retrieveTabularResourceBasicData(trId);
						editRowMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						editRowMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						editRowMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						editRowMonitor.setProgress(task.getProgress());

						trId = retrieveTabularResourceBasicData(editRowSession
								.getTrId());

						editRowMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setEditRowTask(session, task);
			}

			logger.debug("EditMonitor(): " + editRowMonitor);
			return editRowMonitor;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.debug("Error in EditRowMonitor: " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error: " + e.getLocalizedMessage());

		}

	}

	@Override
	public ColumnData getConnection(RefColumn refColumn)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("GetConnection on " + refColumn.toString());
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();
			TableId tableId = new TableId(new Long(refColumn.getTableId()));

			Table table = service.getTable(tableId);
			TableDescriptorMetadata tableDesc = table
					.getMetadata(TableDescriptorMetadata.class);
			if (tableDesc == null) {
				logger.error("Error in getConnection(): No TableDescriptorMetadata found for table "
						+ table);
				throw new TDGWTServiceException(
						"Error in getConnection(): No TableDescriptorMetadata found for table "
								+ table);
			}
			if (tableDesc.getRefId() == 0) {
				logger.error("Error refId=0 for Table:" + table.toString());
				throw new TDGWTServiceException("Error refId=0 for Table:"
						+ table.toString());
			}
			logger.debug("Table connect to tabular resource: "
					+ tableDesc.getRefId());
			TRId tId = new TRId(String.valueOf(tableDesc.getRefId()));
			TRId trId = retrieveTabularResourceBasicData(tId);
			ColumnData columnData = getColumn(refColumn.getColumnId(), trId);

			return columnData;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.debug("Error in getConnection(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error: " + e.getLocalizedMessage());

		}
	}

	// TODO
	@Override
	public void startTaskResubmit(TaskResubmitSession taskResubmitSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setTaskResubmitSession(session, taskResubmitSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("StartTaskResubmit: " + taskResubmitSession);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			if (taskResubmitSession == null) {
				logger.error("TaskResubmitSession is null");
				throw new TDGWTServiceException(
						"Error in resubmit task: TaskResubmitSession is null");
			}
			if (taskResubmitSession.getTaskId() == null
					|| taskResubmitSession.getTaskId().isEmpty()) {
				logger.error("Task Id is: " + taskResubmitSession.getTaskId());
				throw new TDGWTServiceException(
						"Error in resubmit task, Task Id is: "
								+ taskResubmitSession.getTaskId());
			}

			TaskId taskId = new TaskId(taskResubmitSession.getTaskId());

			Task trTask = service.resubmit(taskId);
			logger.debug("Resubmit Task on service: TaskId " + trTask.getId());
			SessionUtil.setTaskResubmitTask(session, trTask);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in resubmit task: "
					+ e.getLocalizedMessage());
		}

	}

	@Override
	public TaskResubmitMonitor getTaskResubmitMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			TaskResubmitSession taskResubmitSession = SessionUtil
					.getTaskResubmitSession(session);

			Task task = SessionUtil.getTaskResubmitTask(session);
			TaskResubmitMonitor taskResubmitMonitor = new TaskResubmitMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in TaskResubmitMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in TaskResubmitMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					taskResubmitMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));

					TRId trId;
					TabResource tabResource;
					switch (taskResubmitMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							taskResubmitMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In TaskResubmitMonitor");
							taskResubmitMonitor.setError(new Throwable(
									"Error task resubmit"));
						}
						taskResubmitMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						taskResubmitMonitor.setProgress(task.getProgress());
						trId = new TRId();
						trId.setId(taskResubmitSession.getTrId().getId());
						trId = retrieveTabularResourceBasicData(trId);
						taskResubmitMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						taskResubmitMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						taskResubmitMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						taskResubmitMonitor.setProgress(task.getProgress());

						trId = retrieveTabularResourceBasicData(taskResubmitSession
								.getTrId());

						taskResubmitMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setTaskResubmitTask(session, task);
			}

			logger.debug("TaskResubmitMonitor(): " + taskResubmitMonitor);
			return taskResubmitMonitor;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.debug("Error in TaskResubmitMonitor: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error: " + e.getLocalizedMessage());

		}
	}

	// TODO
	@Override
	public void startTaskResume(TaskResumeSession taskResumeSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setTaskResumeSession(session, taskResumeSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("StartTaskResume: " + taskResumeSession);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			if (taskResumeSession == null) {
				logger.error("TaskResumeSession is null");
				throw new TDGWTServiceException(
						"Error in resume: TaskResumeSession is null");
			}
			if (taskResumeSession.getTaskId() == null
					|| taskResumeSession.getTaskId().isEmpty()) {
				logger.error("Task Id is: " + taskResumeSession.getTaskId());
				throw new TDGWTServiceException(
						"Error in resume task, Task Id is: "
								+ taskResumeSession.getTaskId());
			}

			TaskId taskId = new TaskId(taskResumeSession.getTaskId());

			Task trTask = service.resubmit(taskId);
			logger.debug("Resume Task on service: TaskId " + trTask.getId());
			SessionUtil.setTaskResumeTask(session, trTask);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in resume task: "
					+ e.getLocalizedMessage());
		}

	}

	@Override
	public TaskResumeMonitor getTaskResumeMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			TaskResumeSession taskResumeSession = SessionUtil
					.getTaskResumeSession(session);

			Task task = SessionUtil.getTaskResumeTask(session);
			TaskResumeMonitor taskResumeMonitor = new TaskResumeMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in TaskResumeMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in TaskResumeMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					taskResumeMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));

					TRId trId;
					TabResource tabResource;
					switch (taskResumeMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							taskResumeMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In TaskResumeMonitor");
							taskResumeMonitor.setError(new Throwable(
									"Error task resume"));
						}
						taskResumeMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						taskResumeMonitor.setProgress(task.getProgress());
						trId = new TRId();
						trId.setId(taskResumeSession.getTrId().getId());
						trId = retrieveTabularResourceBasicData(trId);
						taskResumeMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						taskResumeMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						taskResumeMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						taskResumeMonitor.setProgress(task.getProgress());

						trId = retrieveTabularResourceBasicData(taskResumeSession
								.getTrId());

						taskResumeMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setTaskResumeTask(session, task);
			}

			logger.debug("TaskResumeMonitor(): " + taskResumeMonitor);
			return taskResumeMonitor;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.debug("Error in TaskResumeMonitor: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error: " + e.getLocalizedMessage());

		}
	}

	// TODO
	@Override
	public void startExtractCodelist(
			ExtractCodelistSession extractCodelistSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setExtractCodelistSession(session,
					extractCodelistSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);
			if (extractCodelistSession == null) {
				logger.error("ExtractCodelistSession is null");
				throw new TDGWTServiceException(
						"Error in extract codelist: ExtractCodelistSession is null");
			}

			logger.debug("StartExtractCodelist: " + extractCodelistSession);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();
			
			OpExecution4ExtractCodelist opEx=new OpExecution4ExtractCodelist(service, extractCodelistSession);
			OpExecutionDirector director=new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();
			
			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error in invocation: Operation not supported");
			}
			Long id = Long.valueOf(extractCodelistSession.getTrId().getId());

			TabularResourceId serviceTR = new TabularResourceId(id);
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Extract Codelist on service: TaskId "
					+ trTask.getId());
			SessionUtil.setExtractCodelistTask(session, trTask);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in extract codelist: "
					+ e.getLocalizedMessage());
		}

	}

	@Override
	public ExtractCodelistMonitor getExtractCodelistMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ExtractCodelistSession extractCodelistSession = SessionUtil
					.getExtractCodelistSession(session);

			Task task = SessionUtil.getExtractCodelistTask(session);
			ExtractCodelistMonitor extractCodelistMonitor = new ExtractCodelistMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in ExtractCodelistMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in ExtractCodelistMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					extractCodelistMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));

					TRId trId;
					TabResource tabResource;
					switch (extractCodelistMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							extractCodelistMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In ExtractCodelistMonitor");
							extractCodelistMonitor.setError(new Throwable(
									"Error task resume"));
						}
						extractCodelistMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						extractCodelistMonitor.setProgress(task.getProgress());
						trId = new TRId();
						trId.setId(extractCodelistSession.getTrId().getId());
						trId = retrieveTabularResourceBasicData(trId);
						extractCodelistMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						extractCodelistMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						extractCodelistMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						extractCodelistMonitor.setProgress(task.getProgress());

						trId = retrieveTabularResourceBasicData(extractCodelistSession
								.getTrId());

						extractCodelistMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setExtractCodelistTask(session, task);
			}

			logger.debug("ExtractCodelistMonitor(): " + extractCodelistMonitor);
			return extractCodelistMonitor;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.debug("Error in ExtractCodelistMonitor: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error: " + e.getLocalizedMessage());

		}
	}

	// TODO
	public void startSplitColumn(SplitColumnSession splitColumnSession,
			HttpSession session) throws TDGWTServiceException {
		try {
			// HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setSplitColumnSession(session, splitColumnSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);
			if (splitColumnSession == null) {
				logger.error("SplitColumnSession is null");
				throw new TDGWTServiceException(
						"Error in split column: SplitColumnSession is null");
			}

			logger.debug("StartSplitColumn: " + splitColumnSession);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();
			
			OpExecution4SplitColumn opEx=new OpExecution4SplitColumn(service, splitColumnSession);
			OpExecutionDirector director=new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();	
			ArrayList<OperationExecution> invocations = director.getListOperationExecution();
			
			if (invocations == null) {
				throw new TDGWTServiceException(
						"Error in invocation: Operation not supported");
			}
			Long id = Long.valueOf(splitColumnSession.getColumnData().getTrId()
					.getId());

			TabularResourceId serviceTR = new TabularResourceId(id);
			logger.debug("OperationInvocation: \n" + invocations.toString());
			Task trTask = service.executeBatch(invocations, serviceTR);
			logger.debug("Split Column on service: TaskId " + trTask.getId());
			SessionUtil.setSplitColumnTask(session, trTask);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in split column: "
					+ e.getLocalizedMessage());
		}

	}

	@Override
	public SplitColumnMonitor getSplitColumnMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SplitColumnSession splitColumnSession = SessionUtil
					.getSplitColumnSession(session);

			Task task = SessionUtil.getSplitColumnTask(session);
			SplitColumnMonitor splitColumnMonitor = new SplitColumnMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in SplitColumnMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in SplitColumnMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					splitColumnMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));

					TRId trId;
					TabResource tabResource;
					switch (splitColumnMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							splitColumnMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In SplitColumnMonitor");
							splitColumnMonitor.setError(new Throwable(
									"Error task resume"));
						}
						splitColumnMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						splitColumnMonitor.setProgress(task.getProgress());
						trId = new TRId();
						trId.setId(splitColumnSession.getColumnData().getTrId()
								.getId());
						trId = retrieveTabularResourceBasicData(trId);
						splitColumnMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						splitColumnMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						splitColumnMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						splitColumnMonitor.setProgress(task.getProgress());

						trId = retrieveTabularResourceBasicData(splitColumnSession
								.getColumnData().getTrId());

						splitColumnMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setSplitColumnTask(session, task);
			}

			logger.debug("SplitColumnMonitor(): " + splitColumnMonitor);
			return splitColumnMonitor;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.debug("Error in SplitColumnMonitor: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error: " + e.getLocalizedMessage());

		}
	}

	// TODO
	public void startMergeColumn(MergeColumnSession mergeColumnSession,
			HttpSession session) throws TDGWTServiceException {
		try {
			// HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setMergeColumnSession(session, mergeColumnSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);
			if (mergeColumnSession == null) {
				logger.error("MergeColumnSession is null");
				throw new TDGWTServiceException(
						"Error in split column: MergeColumnSession is null");
			}

			logger.debug("StartMergeColumn: " + mergeColumnSession);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();
			
			OpExecution4MergeColumn opEx=new OpExecution4MergeColumn(service, mergeColumnSession);
			OpExecutionDirector director=new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();
			
		
			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error in invocation: Operation not supported");
			}
			Long id = Long.valueOf(mergeColumnSession.getColumnData().getTrId()
					.getId());

			TabularResourceId serviceTR = new TabularResourceId(id);
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Merge Column on service: TaskId " + trTask.getId());
			SessionUtil.setMergeColumnTask(session, trTask);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in split column: "
					+ e.getLocalizedMessage());
		}

	}

	@Override
	public MergeColumnMonitor getMergeColumnMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			MergeColumnSession mergeColumnSession = SessionUtil
					.getMergeColumnSession(session);

			Task task = SessionUtil.getMergeColumnTask(session);
			MergeColumnMonitor mergeColumnMonitor = new MergeColumnMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in MergeColumnMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in MergeColumnMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					mergeColumnMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));

					TRId trId;
					TabResource tabResource;
					switch (mergeColumnMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							mergeColumnMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In MergeColumnMonitor");
							mergeColumnMonitor.setError(new Throwable(
									"Error task resume"));
						}
						mergeColumnMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						mergeColumnMonitor.setProgress(task.getProgress());
						trId = new TRId();
						trId.setId(mergeColumnSession.getColumnData().getTrId()
								.getId());
						trId = retrieveTabularResourceBasicData(trId);
						mergeColumnMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						mergeColumnMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						mergeColumnMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						mergeColumnMonitor.setProgress(task.getProgress());
						trId = retrieveTabularResourceBasicData(mergeColumnSession
								.getColumnData().getTrId());

						mergeColumnMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setMergeColumnTask(session, task);
			}

			logger.debug("MergeColumnMonitor(): " + mergeColumnMonitor);
			return mergeColumnMonitor;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.debug("Error in MergeColumnMonitor: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error: " + e.getLocalizedMessage());

		}
	}

	@Override
	public void setCodelistMappingSession(
			CodelistMappingSession codelistMappingSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setCodelistMappingSession(session,
					codelistMappingSession);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.error(
					"Error setting CodelistMappingSession parameter: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error setting CodelistMappingSession parameter: "
							+ e.getLocalizedMessage());
		}

	}

	@Override
	public void getFileFromWorkspace(
			CodelistMappingSession codelistMappingSession)
			throws TDGWTServiceException {
		HttpSession session = this.getThreadLocalRequest().getSession();
		ASLSession aslSession = SessionUtil.getAslSession(session);
		Workspace w = null;
		WorkspaceItem wi = null;

		try {
			HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();

			HomeManager manager = factory.getHomeManager();

			Home home = manager.getHome(aslSession.getUsername());

			w = home.getWorkspace();
			wi = w.getItem(codelistMappingSession.getItemId());
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in import Codelist Mapping getFileFromWorkspace accessing the workspace: "
							+ e.getLocalizedMessage(), e);
		}

		if (wi == null) {
			logger.error("Error retrieving the item on workspace"
					+ codelistMappingSession.getItemId());
			throw new TDGWTServiceException(
					"Error retrieving the item on workspace"
							+ codelistMappingSession.getItemId());
		}

		try {
			logger.debug("WorkspaceItem [id:" + wi.getId() + " name:"
					+ wi.getName() + " remotePath:" + wi.getRemotePath() + "]");
		} catch (InternalErrorException e1) {
			e1.printStackTrace();
			throw new TDGWTServiceException(
					"Error retrieving the item on workspace" + wi);
		}

		CodelistMappingFileUploadSession fileUploadSession = new CodelistMappingFileUploadSession();
		CodelistMappingMonitor codelistMappingMonitor = new CodelistMappingMonitor();
		FileUploadMonitor fileUploadMonitor = new FileUploadMonitor();

		fileUploadSession.setId(session.getId());
		fileUploadSession.setFileUploadState(FileUploadState.STARTED);
		fileUploadSession.setCodelistMappingMonitor(codelistMappingMonitor);

		SessionUtil.setFileUploadMonitor(session, fileUploadMonitor);
		SessionUtil.setCodelistMappingFileUploadSession(session,
				fileUploadSession);

		try {
			FilesStorage filesStorage = new FilesStorage();
			InputStream is = filesStorage.retriveImputStream(
					aslSession.getUsername(), wi);

			FileUtil.setImportFileCodelistMapping(fileUploadSession, is,
					wi.getName(), Constants.FILE_XML_MIMETYPE);
		} catch (Throwable e) {
			FileUploadMonitor fum = SessionUtil.getFileUploadMonitor(session);
			fum.setFailed("An error occured elaborating the file",
					FileUtil.exceptionDetailMessage(e));
			SessionUtil.setFileUploadMonitor(session, fum);
			fileUploadSession.setFileUploadState(FileUploadState.FAILED);
			SessionUtil.setCodelistMappingFileUploadSession(session,
					fileUploadSession);
			logger.error("Error elaborating the input stream", e);
			throw new TDGWTServiceException(
					"Error in import Codelist Mapping getFileFromWorkspace: "
							+ e.getLocalizedMessage(), e);
		}

		logger.trace("changing state");
		FileUploadMonitor fum = SessionUtil.getFileUploadMonitor(session);
		fum.setState(FileUploadState.COMPLETED);
		SessionUtil.setFileUploadMonitor(session, fum);

		SessionUtil.setCodelistMappingFileUploadSession(session,
				fileUploadSession);

	}

	@Override
	public void startCodelistMappingImport(
			CodelistMappingSession codelistMappingSession)
			throws TDGWTServiceException {
		try {

			HttpSession session = this.getThreadLocalRequest().getSession();
			if (session == null) {
				throw new TDGWTServiceException(
						"Error retrieving the session: null");
			}
			logger.debug("Session:" + session.getId());

			ASLSession aslSession = SessionUtil.getAslSession(session);
			if (aslSession == null) {
				throw new TDGWTServiceException(
						"Error retrieving the asl session: null");
			}
			String user = aslSession.getUsername();
			logger.debug("Session User:" + user);

			logger.debug("StartCodelistMappingImport: "
					+ codelistMappingSession.toString());

			importCodelistMappingFileOnService(session, aslSession, user,
					codelistMappingSession);
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in Codelist Mapping import: "
							+ e.getLocalizedMessage());
		}
	}

	@Override
	public CodelistMappingMonitor getCodelistMappingMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			CodelistMappingSession codelistMappingSession = SessionUtil
					.getCodelistMappingSession(session);

			Task task = SessionUtil.getMergeColumnTask(session);
			CodelistMappingMonitor codelistMappingMonitor = new CodelistMappingMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in CodelistMappingMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in CodelistMappingMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					codelistMappingMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));

					TRId trId;
					TabResource tabResource;
					switch (codelistMappingMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							codelistMappingMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In CodelistMappingMonitor");
							codelistMappingMonitor.setError(new Throwable(
									"Error task resume"));
						}
						codelistMappingMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						codelistMappingMonitor.setProgress(task.getProgress());
						trId = new TRId();
						trId.setId(codelistMappingSession.getTrId().getId());
						trId = retrieveTabularResourceBasicData(trId);
						codelistMappingMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						codelistMappingMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						codelistMappingMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						codelistMappingMonitor.setProgress(task.getProgress());
						trId = retrieveTabularResourceBasicData(codelistMappingSession
								.getTrId());

						codelistMappingMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setCodelistMappingTask(session, task);
			}

			logger.debug("CodelistMappingMonitor(): " + codelistMappingMonitor);
			return codelistMappingMonitor;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.debug("Error in CodelistMappingMonitor: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error: " + e.getLocalizedMessage());

		}
	}

	/**
	 * 
	 * @param user
	 * @param codelistMappingFileUploadSession
	 * @param codelistMappingSession
	 * @throws TDGWTServiceException
	 */
	protected void importCodelistMappingFileOnService(HttpSession session,
			ASLSession aslSession, String user,
			CodelistMappingSession codelistMappingSession) throws Throwable {

		String importUrl = null;

		if (codelistMappingSession.getSource().getId()
				.compareTo(SourceType.URL.toString()) == 0) {
			importUrl = codelistMappingSession.getUrl();
		} else {
			CodelistMappingFileUploadSession codelistMappingFileUploadSession = SessionUtil
					.getCodelistMappingFileUploadSession(session);
			if (codelistMappingFileUploadSession == null) {
				throw new TDGWTServiceException(
						"Error retrieving the codelistMappingFileUploadSession: null");
			}
			logger.debug("File Storage Access");
			FilesStorage filesStorage = new FilesStorage();
			String fileUrlOnStorage = filesStorage
					.storageCodelistMappingTempFile(user,
							codelistMappingFileUploadSession
									.getCodelistMappingFile());
			logger.debug("File Url On Storage:" + fileUrlOnStorage);
			codelistMappingFileUploadSession.getCodelistMappingFile().delete();

			if (fileUrlOnStorage == null || fileUrlOnStorage.isEmpty()) {
				throw new TDGWTServiceException(
						"Tabular Data Service error loading file on storage");
			}
			importUrl = fileUrlOnStorage;
		}

		AuthorizationProvider.instance.set(new AuthorizationToken(aslSession
				.getUsername()));
		TabularDataService service = TabularDataServiceFactory.getService();
		
		OpExecution4CodelistMapping opEx=new OpExecution4CodelistMapping(service, codelistMappingSession, importUrl);
		OpExecutionDirector director=new OpExecutionDirector();
		director.setOperationExecutionBuilder(opEx);
		director.constructOperationExecution();
		OperationExecution invocation = director.getOperationExecution();
		
		if (invocation == null) {
			throw new TDGWTServiceException(
					"Error in invocation: Operation not supported");
		}
		Long id = Long.valueOf(codelistMappingSession.getTrId().getId());

		TabularResourceId serviceTR = new TabularResourceId(id);
		logger.debug("OperationInvocation: \n" + invocation.toString());
		Task trTask = service.execute(invocation, serviceTR);
		logger.debug("Codelist Mapping Import on service: TaskId "
				+ trTask.getId());
		SessionUtil.setCodelistMappingTask(session, trTask);
		return;

	}
	
	//TODO
	public void startGroupBy(
			GroupBySession groupBySession,HttpSession session)
			throws TDGWTServiceException {
		try {
			// HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setGroupBySession(session, groupBySession);
			ASLSession aslSession = SessionUtil.getAslSession(session);
			if (groupBySession == null) {
				logger.error("GroupBySession is null");
				throw new TDGWTServiceException(
						"Error in groupby : GroupBySession is null");
			}

			logger.debug("StartGroupBy: " + groupBySession);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();
			
			OpExecution4GroupBy opEx=new OpExecution4GroupBy(service, groupBySession);
			OpExecutionDirector director=new OpExecutionDirector();
			director.setOperationExecutionBuilder(opEx);
			director.constructOperationExecution();
			OperationExecution invocation = director.getOperationExecution();
			
		
			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error in invocation: Operation not supported");
			}
			Long id = Long.valueOf(groupBySession.getTrId()
					.getId());

			TabularResourceId serviceTR = new TabularResourceId(id);
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("GroupBy start on service: TaskId " + trTask.getId());
			SessionUtil.setGroupByTask(session, trTask);
			return;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in start group by: "
					+ e.getLocalizedMessage());
		}
	}

	
	@Override
	public GroupByMonitor getGroupByMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			GroupBySession groupBySession = SessionUtil
					.getGroupBySession(session);

			Task task = SessionUtil.getGroupByTask(session);
			GroupByMonitor groupByMonitor = new GroupByMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in GroupByMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in GroupByMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					groupByMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));

					TRId trId;
					TabResource tabResource;
					switch (groupByMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							task.getErrorCause().printStackTrace();
							groupByMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In GroupByMonitor");
							groupByMonitor.setError(new Throwable(
									"Error task resume"));
						}
						groupByMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						groupByMonitor.setProgress(task.getProgress());
						trId = new TRId();
						trId.setId(groupBySession.getTrId()
								.getId());
						trId = retrieveTabularResourceBasicData(trId);
						groupByMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						groupByMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						groupByMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;
					case ABORTED:
						break;
					case STOPPED:
						logger.debug("Task Result:" + task.getResult());
						groupByMonitor.setProgress(task.getProgress());

						trId = retrieveTabularResourceBasicData(groupBySession
								.getTrId());

						groupByMonitor.setTrId(trId);
						tabResource = SessionUtil.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setGroupByTask(session, task);
			}

			logger.debug("GroupByMonitor(): " + groupByMonitor);
			return groupByMonitor;
		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (Throwable e) {
			logger.debug("Error in GroupByMonitor: "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error: " + e.getLocalizedMessage());

		}
	}


	
}
