/**
 * 
 */
package org.gcube.portlets.user.td.gwtservice.client.rpc;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.shared.codelisthelper.CodelistMappingMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.codelisthelper.CodelistMappingSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.AvailableCharsetList;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVRowError;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.extract.ExtractCodelistMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.extract.ExtractCodelistSession;
import org.gcube.portlets.user.td.gwtservice.shared.file.FileUploadMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.file.HeaderPresence;
import org.gcube.portlets.user.td.gwtservice.shared.history.OpHistory;
import org.gcube.portlets.user.td.gwtservice.shared.history.RollBackSession;
import org.gcube.portlets.user.td.gwtservice.shared.history.RollBackSessionMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXExportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.share.ShareInfo;
import org.gcube.portlets.user.td.gwtservice.shared.source.SDMXRegistrySource;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResubmitMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResubmitSession;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResumeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResumeSession;
import org.gcube.portlets.user.td.gwtservice.shared.task.ValidationsTasksMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateApplyMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateApplySession;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateData;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateDeleteSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.RefColumn;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TableData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.Occurrences;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.OccurrencesForReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceBatchColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.clone.CloneTabularResourceSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.AddColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.AddColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.MergeColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.SplitColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.groupby.GroupByMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.open.TDOpenSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadConfig;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadResult;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DeleteRowsMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DeleteRowsSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DuplicatesMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DuplicatesSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.EditRowMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.EditRowSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabValidationsMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Agencies;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Codelist;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Dataset;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * 
 * Implements the basic interfaces for access to the service.
 * 
 * <p>
 * Allows:  
 * <ul>
 * <li>Access to Tabular Resources</li>
 * <li>Import of CSV file</li>
 * <li>Import from SDMX Registry</li>
 * <ul>
 * </p>
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
@RemoteServiceRelativePath("TDGWTService")
public interface TDGWTService extends RemoteService {

	/**
	 * Get informations on the current user
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public String hello() throws TDGWTServiceException;

	// TabularResource
	/**
	 * Get current TRId
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TRId getCurrentTRId() throws TDGWTServiceException;

	/**
	 * Get informations on the current tabular resource
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TabResource getTabResourceInformation() throws TDGWTServiceException;

	/**
	 * Set tabular resource information
	 * 
	 * @param tabResource
	 * @throws TDGWTServiceException
	 */
	public void setTabResourceInformation(TabResource tabResource)
			throws TDGWTServiceException;

	/**
	 * Get informations on tabular resource
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TabResource getTabResourceInformation(TRId trId)
			throws TDGWTServiceException;

	/**
	 * Return true if is a valid tabular resource
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public Boolean isTabularResourceValid(TRId trId)
			throws TDGWTServiceException;

	/**
	 * Get creation date on tabular resource
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public String getTRCreationDate(TRId trId) throws TDGWTServiceException;

	/**
	 * Set current tabular resource
	 * 
	 * @param tr
	 * @throws TDGWTServiceException
	 */
	public void setTabResource(TabResource tabResource)
			throws TDGWTServiceException;

	/**
	 * Creates a TabResource on Service
	 * 
	 * @param tabResource
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TabResource createTabularResource(TabResource tabResource)
			throws TDGWTServiceException;

	/**
	 * Return Last Table
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TableData getLastTable(TRId trId) throws TDGWTServiceException;

	/**
	 * Return Table
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TableData getTable(TRId trId) throws TDGWTServiceException;

	/**
	 * Return Metadata of Table
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<TabMetadata> getTableMetadata(TRId trId)
			throws TDGWTServiceException;

	/**
	 * Return Metadata of Tabular Resources
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<TRMetadata> getTRMetadata(TRId trId)
			throws TDGWTServiceException;

	/**
	 * Retreive a ColumnData that is a connection to external table
	 * 
	 * @param refColumn
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ColumnData getConnection(RefColumn refColumn)
			throws TDGWTServiceException;

	// Task
	/**
	 * Get Operation Monitor during the resubmit task
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TaskResubmitMonitor getTaskResubmitMonitor()
			throws TDGWTServiceException;

	/**
	 * Resubmit task
	 * 
	 * @param taskResubmitSession
	 * @throws TDGWTServiceException
	 */
	public void startTaskResubmit(TaskResubmitSession taskResubmitSession)
			throws TDGWTServiceException;

	/**
	 * Get Operation Monitor during the resume task
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TaskResumeMonitor getTaskResumeMonitor()
			throws TDGWTServiceException;

	/**
	 * Resume task
	 * 
	 * @param taskResumeSession
	 * @throws TDGWTServiceException
	 */
	public void startTaskResume(TaskResumeSession taskResumeSession)
			throws TDGWTServiceException;

	// Validations
	/**
	 * Returns validations contained in the tasks
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ValidationsTasksMetadata getValidationsTasksMetadata(TRId trId)
			throws TDGWTServiceException;

	/**
	 * Return Validations Metadata of Table
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TabValidationsMetadata getTableValidationsMetadata(TRId trId)
			throws TDGWTServiceException;

	/**
	 * Returns ArrayList<ColumnData> that contains all the validation columns of
	 * columnName
	 * 
	 * @param trId
	 * @param columnName
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<ColumnData> getValidationColumns(TRId trId,
			String columnName) throws TDGWTServiceException;

	// RollBack
	/**
	 * Call rollback on tabular resource
	 * 
	 * @param rollBackSession
	 * @throws TDGWTServiceException
	 */
	public void rollBack(RollBackSession rollBackSession)
			throws TDGWTServiceException;

	/**
	 * Get Operation Monitor during the rollback
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public RollBackSessionMonitor getRollBackMonitor()
			throws TDGWTServiceException;

	/**
	 * Call discard operation on tabular resource
	 * 
	 * @param trId
	 * @throws TDGWTServiceException
	 */
	public RollBackSession discard(TRId trId) throws TDGWTServiceException;

	// Share
	/**
	 * Retrieves information sharing on the tabular resource
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ShareInfo getShareInfo(TRId trId) throws TDGWTServiceException;

	/**
	 * Share sabular resource
	 * 
	 * @param shareInfo
	 * @return
	 * @throws TDGWTServiceException
	 */
	public void setShare(ShareInfo shareInfo) throws TDGWTServiceException;

	// Open

	/**
	 * Return all tabular resource of a user
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<TabResource> getTabularResources()
			throws TDGWTServiceException;

	/**
	 * Return all tabular resource of a user and last tables
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<TabResource> getTabularResourcesAndLastTables()
			throws TDGWTServiceException;

	// Clone
	/**
	 * Start clone tabular resource
	 * 
	 * @param labelColumnSession
	 * @throws TDGWTServiceException
	 */
	public TRId startCloneTabularResource(
			CloneTabularResourceSession cloneTabularResourceSession)
			throws TDGWTServiceException;

	//
	/**
	 * Initialize Codelists Paging Loader
	 * 
	 * @throws TDGWTServiceException
	 */
	public void setCodelistsPagingLoader() throws TDGWTServiceException;

	/**
	 * Retrieves a portion of Codelists
	 * 
	 * @param codelistPagingLoadConfig
	 * @return
	 * @throws TDGWTServiceException
	 */
	public CodelistPagingLoadResult getCodelistsPagingLoader(
			CodelistPagingLoadConfig codelistPagingLoadConfig)
			throws TDGWTServiceException;;

	/**
	 * Set open session for return all tabular resource of a user
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void startTDOpen(TDOpenSession tdOpenSession)
			throws TDGWTServiceException;

	/**
	 * Retrieves the list of columns in the current table
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<ColumnData> getColumns() throws TDGWTServiceException;

	/**
	 * Retrieves the list of columns in the table provided by trId
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<ColumnData> getColumns(TRId trId)
			throws TDGWTServiceException;

	/**
	 * Retrieves the list of columns in the table provided by trId only CODE and
	 * CODENAME types
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<ColumnData> getColumnsForDimension(TRId trId)
			throws TDGWTServiceException;

	/**
	 * Retrieves information about a specific column of specific table
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ColumnData getColumn(TRId trId, String columnName)
			throws TDGWTServiceException;

	/**
	 * Retrieves information about a specific column of specific table
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ColumnData getColumn(String columnLocalId, TRId trId)
			throws TDGWTServiceException;

	/**
	 * Remove Tabular Resource From Service
	 * 
	 * @param trId
	 * @throws TDGWTServiceException
	 */
	public void removeTabularResource(TRId trId) throws TDGWTServiceException;

	// SDMX

	/**
	 * Get Codelist on a registry
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<Codelist> getCodelists() throws TDGWTServiceException;

	/**
	 * Get Datasets on a registry
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<Dataset> getDatasets() throws TDGWTServiceException;

	/**
	 * Get Agecies on a registry
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<Agencies> getAgencies() throws TDGWTServiceException;

	/**
	 * Set SDMX Registry Source
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void setSDMXRegistrySource(SDMXRegistrySource sdmxRegistrySource)
			throws TDGWTServiceException;

	// Import SDMX
	/**
	 * Start SDMX Import and invokes the client library
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void startSDMXImport(SDMXImportSession sdmxImportSession)
			throws TDGWTServiceException;

	/**
	 * Get Operation Monitor during the SDMX Import operation
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public SDMXImportMonitor getSDMXImportMonitor()
			throws TDGWTServiceException;

	// Import CSV
	/**
	 * Get File Upload Monitor during the file upload operation in Import CSV
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public FileUploadMonitor getFileUploadMonitor()
			throws TDGWTServiceException;

	/**
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void setCSVSession(CSVImportSession csvImportSession)
			throws TDGWTServiceException;

	/**
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void getFileFromWorkspace(CSVImportSession csvImportSession)
			throws TDGWTServiceException;

	/**
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public AvailableCharsetList getAvailableCharset()
			throws TDGWTServiceException;

	/**
	 * 
	 * @param encoding
	 * @param headerPresence
	 * @param delimiter
	 * @param comment
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<String> configureCSVParser(String encoding,
			HeaderPresence headerPresence, char delimiter, char comment)
			throws TDGWTServiceException;

	/**
	 * 
	 * @param errorsLimit
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<CSVRowError> checkCSV(long errorsLimit)
			throws TDGWTServiceException;

	/**
	 * Start CSV Import and invokes the client library
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void startCSVImport(CSVImportSession csvImportSession)
			throws TDGWTServiceException;

	/**
	 * Get Operation Monitor during the CSV Import operation
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public CSVImportMonitor getCSVImportMonitor() throws TDGWTServiceException;

	// Export CSV
	/**
	 * Get Operation Monitor during the CSV Export operation
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public CSVExportMonitor getCSVExportMonitor() throws TDGWTServiceException;

	/**
	 * Start CSV Export and invokes the client library
	 * 
	 * @param csvExportSession
	 * @throws TDGWTServiceException
	 */
	public void startCSVExport(CSVExportSession csvExportSession)
			throws TDGWTServiceException;

	// Export SDMX
	/**
	 * Get Operation Monitor during the SDMX Export operation
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public SDMXExportMonitor getSDMXExportMonitor()
			throws TDGWTServiceException;

	/**
	 * Start SDMX Export and invokes the client library
	 * 
	 * @param sdmxExportSession
	 * @throws TDGWTServiceException
	 */
	public void startSDMXExport(SDMXExportSession exportSession)
			throws TDGWTServiceException;

	// Table Operations
	/**
	 * Get Operation Monitor during the Change Table Type operation
	 * 
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ChangeTableTypeMonitor getChangeTableTypeMonitor()
			throws TDGWTServiceException;

	/**
	 * Start change table type
	 * 
	 * @param labelColumnSession
	 * @throws TDGWTServiceException
	 */
	public void startChangeTableType(
			ChangeTableTypeSession changeTableTypeSession)
			throws TDGWTServiceException;

	// Rows Operations
	/**
	 * Get Operation Monitor during the Edit Row operation
	 * 
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public EditRowMonitor getEditRowMonitor() throws TDGWTServiceException;

	/**
	 * Start edit row or add row
	 * 
	 * @param labelColumnSession
	 * @throws TDGWTServiceException
	 */
	public void startEditRow(EditRowSession editRowSession)
			throws TDGWTServiceException;

	/**
	 * Get Operation Monitor during the Delete Rows operation
	 * 
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public DeleteRowsMonitor getDeleteRowsMonitor()
			throws TDGWTServiceException;

	/**
	 * Start delete rows
	 * 
	 * @param labelColumnSession
	 * @throws TDGWTServiceException
	 */
	public void startDeleteRows(DeleteRowsSession deleteRowsSession)
			throws TDGWTServiceException;

	/**
	 * Get Operation Monitor during the operation on duplicates
	 * 
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public DuplicatesMonitor getDuplicatesMonitor()
			throws TDGWTServiceException;

	/**
	 * Start operation on duplicates
	 * 
	 * @param labelColumnSession
	 * @throws TDGWTServiceException
	 */
	public void startDuplicates(DuplicatesSession duplicatesSession)
			throws TDGWTServiceException;

	// Column Operation

	/**
	 * Get Operation Monitor during the Change Column Type operation
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ChangeColumnTypeMonitor getChangeColumnTypeMonitor()
			throws TDGWTServiceException;

	/**
	 * Start change column type
	 * 
	 * @param changeColumnTypeSession
	 * @throws TDGWTServiceException
	 */
	public void startChangeColumnType(
			ChangeColumnTypeSession changeColumnTypeSession)
			throws TDGWTServiceException;

	/**
	 * Get Operation Monitor during the Add Column operation
	 * 
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public AddColumnMonitor getAddColumnMonitor() throws TDGWTServiceException;

	/**
	 * Start add column
	 * 
	 * 
	 * @param addColumnSession
	 * @throws TDGWTServiceException
	 */
	public void startAddColumn(AddColumnSession addColumnSession)
			throws TDGWTServiceException;

	/**
	 * Get Operation Monitor during the Delete Column operation
	 * 
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public DeleteColumnMonitor getDeleteColumnMonitor()
			throws TDGWTServiceException;

	/**
	 * Start delete column
	 * 
	 * 
	 * @param deleteColumnSession
	 * @throws TDGWTServiceException
	 */
	public void startDeleteColumn(DeleteColumnSession deleteColumnSession)
			throws TDGWTServiceException;

	/**
	 * Get Operation Monitor during the Change the Column Label operation
	 * 
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public LabelColumnMonitor getLabelColumnMonitor()
			throws TDGWTServiceException;

	/**
	 * Start change the column label
	 * 
	 * @param labelColumnSession
	 * @throws TDGWTServiceException
	 */
	public void startLabelColumn(LabelColumnSession labelColumnSession)
			throws TDGWTServiceException;
	
	/**
	 * Get Operation Monitor during the Split Column operation
	 * 
	 * 
	 * @return
	 * @throws TDGWTServiceException
	*/ 
	public SplitColumnMonitor getSplitColumnMonitor()
			throws TDGWTServiceException;
	
	/**
	 * Start split column
	 * 
	 * @param splitColumnSession
	 * @throws TDGWTServiceException
	
	public void startSplitColumn(SplitColumnSession splitColumnSession)
			throws TDGWTServiceException;
	*/
	
	
	/**
	 * Get Operation Monitor during the Merge Column operation
	 * 
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public MergeColumnMonitor getMergeColumnMonitor()
			throws TDGWTServiceException;

	/**
	 * Start merge column
	 * 
	 * @param splitColumnSession
	 * @throws TDGWTServiceException
	
	public void startMergeColumn(MergeColumnSession mergeColumnSession)
			throws TDGWTServiceException;
	*/
	
	
	/**
	 * Get Operation Monitor during the Group By operation
	 * 
	 * 
	 * @return
	 * @throws TDGWTServiceException
	*/ 
	public GroupByMonitor getGroupByMonitor()
			throws TDGWTServiceException;
	
	/**
	 * Start group by
	 * 
	 * @param groupBySession
	 * @throws TDGWTServiceException
	
	public void startGroupBy(GroupBySession groupBySession)
			throws TDGWTServiceException;
	*/
	
	// BatchReplace Operations
	/**
	 * Retrieves the values ​​in a column grouped by number of occurrences
	 * 
	 * 
	 * @param occurrencesForReplaceBatchColumnSession
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<Occurrences> getOccurrencesForBatchReplace(
			OccurrencesForReplaceBatchColumnSession occurrencesForReplaceBatchColumnSession)
			throws TDGWTServiceException;

	/**
	 * Get Operation Monitor during the batch replace on column
	 * 
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ReplaceBatchColumnMonitor getReplaceBatchColumnMonitor()
			throws TDGWTServiceException;

	/**
	 * Start batch replace on column
	 * 
	 * @param replaceBatchColumnSession
	 * @throws TDGWTServiceException
	 */
	public void startReplaceBatchColumn(
			ReplaceBatchColumnSession replaceBatchColumnSession)
			throws TDGWTServiceException;

	// Replace Operation
	/**
	 * Get Operation Monitor during the replace the Column Value operation
	 * 
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ReplaceColumnMonitor getReplaceColumnMonitor()
			throws TDGWTServiceException;

	/**
	 * Start replace the column value
	 * 
	 * @param labelColumnSession
	 * @throws TDGWTServiceException
	 */
	public void startReplaceColumn(ReplaceColumnSession replaceColumnSession)
			throws TDGWTServiceException;

	// Templates
	/**
	 * Retrieves templates of user
	 * 
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<TemplateData> getTemplates() throws TDGWTServiceException;

	/**
	 * Get Operation Monitor during Apply Template operation
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TemplateApplyMonitor getTemplateApplyMonitor()
			throws TDGWTServiceException;

	/**
	 * Start Apply Template
	 * 
	 * @param templateApplySession
	 * @throws TDGWTServiceException
	 */
	void startTemplateApply(TemplateApplySession templateApplySession)
			throws TDGWTServiceException;

	/**
	 * Start Delete Template
	 * 
	 * @param templateDeleteSession
	 * @throws TDGWTServiceException
	 */
	void startTemplateDelete(TemplateDeleteSession templateDeleteSession)
			throws TDGWTServiceException;

	// Locales
	/**
	 * Retrieve locales supported
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	ArrayList<String> getLocales() throws TDGWTServiceException;

	// History
	/**
	 * Retrieve History
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	ArrayList<OpHistory> getHistory() throws TDGWTServiceException;

	/**
	 * Retrieve History for specific tabular resource
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	ArrayList<OpHistory> getHistory(TRId trId) throws TDGWTServiceException;

	/**
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	OpHistory getLastOperationInfo() throws TDGWTServiceException;

	/**
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	OpHistory getLastOperationInfo(TRId trId) throws TDGWTServiceException;

	// Helper Extract Codelist
	/**
	 * Get Operation Monitor during the Extract Codelist operation
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ExtractCodelistMonitor getExtractCodelistMonitor()
			throws TDGWTServiceException;

	/**
	 * Start Extract Codelist and invokes the client library
	 * 
	 * @param extractCodelistSession
	 * @throws TDGWTServiceException
	 */
	public void startExtractCodelist(
			ExtractCodelistSession extractCodelistSession)
			throws TDGWTServiceException;

	// Helper Codelist Mapping Import
	public CodelistMappingMonitor getCodelistMappingMonitor()
			throws TDGWTServiceException;

	public void setCodelistMappingSession(
			CodelistMappingSession codelistMappingSession)
			throws TDGWTServiceException;

	public void getFileFromWorkspace(
			CodelistMappingSession codelistMappingSession)
			throws TDGWTServiceException;

	public void startCodelistMappingImport(
			CodelistMappingSession codelistMappingSession)
			throws TDGWTServiceException;

}
