package org.gcube.portlets.user.td.gwtservice.server.trservice;


/**
 * 
 * Tabular Data Service Operations Id
 * 
 * <table>
 *  <tr><td>100</td><td>CSVImport</td></tr>
 *  <tr><td>101</td><td>CSVExport</td></tr>
 *  <tr><td>200</td><td>SDMXCodelistImport</td></tr>
 *  <tr><td>201</td><td>SDMXCodelistExport</td></tr> 
 *  <tr><td>202</td><td>SDMXDatasetImport</td></tr> 
 *  <tr><td>203</td><td>SDMXDatasetExport</td></tr> 
 *  <tr><td>300</td><td>JSONImport</td></tr>
 *  <tr><td>301</td><td>JSONExport</td></tr>
 *  <tr><td>1000</td><td>ValidateCodelist</td></tr> 
 *  <tr><td>1001</td><td>ValidateDataset</td></tr> 
 *  <tr><td>1002</td><td>ChangeTableType</td></tr>
 *  <tr><td>1003</td><td>CreateDatasetView</td></tr> 
 *  <tr><td>1004</td><td>RemoveColumn</td></tr> 
 *  <tr><td>1005</td><td>ChangeLabel</td></tr> 
 *  <tr><td>1006</td><td>AddLabel</td></tr>
 *  <tr><td>1007</td><td>RemoveLabel</td></tr>
 *  <tr><td>2000</td><td>ChangeToAnnotationColumn</td></tr> 
 *  <tr><td>2001</td><td>ChangeToAttributeColumn</td></tr>
 *  <tr><td>2002</td><td>ChangeToMeasureColumn</td></tr>
 *  <tr><td>2003</td><td>ChangeToCodeColumn</td></tr>
 *  <tr><td>2004</td><td>ChangeToCodeName</td></tr> 
 *  <tr><td>2005</td><td>ChangeToCodeDescription</td></tr> 
 *  <tr><td>2006</td><td>ChangeToDimensionColumn</td></tr> 
 *  <tr><td>2007</td><td>ChangeToTimeDimensionColumn</td></tr> 
 *  <tr><td>3000</td><td>ModifyTuplesValues</td></tr> 
 *  <tr><td>3001</td><td>ModifyColumnValueOnCondition</td></tr> 
 *  <tr><td>3002</td><td>NewAnnotationColumn</td></tr> 
 *  <tr><td>3201</td><td>FilterByExpression</td></tr> 
 *  <tr><td>3004</td><td>Union</td></tr> 
 *  <tr><td>3005</td><td>Denormalize</td></tr> 
 *  <tr><td>3006</td><td>Aggregate</td></tr>	
 *	</table>
 *
 *	@author "Giancarlo Panichi" 
 *  <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 *
 */
public enum OperationsId {
	CSVImport("100"), 
	CSVExport("101"),
	SDMXCodelistImport("200"),	
	SDMXCodelistExport("201"),
	SDMXDatasetImport("202"), 
  	SDMXDatasetExport("203"),
  	JSONImport("300"),	
  	JSONExport("301"),
  	ValidateCodelist("1000"),
	ValidateDataset("1001"), 
	ChangeTableType("1002"), 
	CreateDatasetView("1003"), 
	RemoveColumn("1004"), 
	ChangeLabel("1005"),
	AddLabel("1006"), 
	RemoveLabel("1007"), 
	ChangeToAnnotationColumn("2000"), 
	ChangeToAttributeColumn("2001"), 
	ChangeToMeasureColumn("2002"), 
	ChangeToCodeColumn("2003"),
	ChangeToCodeName("2004"), 
	ChangeToCodeDescription("2005"), 
	ChangeToDimensionColumn("2006"), 
	ChangeToTimeDimensionColumn("2007"),
	RemoveDuplicateTuples("3007"),
	ReplaceColumnByExpression("3101"),
	ReplaceById("3102"), 
	FilterByExpression("3201"),
	RemoveRowById("3202"),
	Union("3004"),
	Denormalize("3005"),
	Aggregation("3006"),
	CodelistValidation("5001"),
	ColumnTypeCastCheck("5002"),
	DuplicateTupleValidation("5003"),
	PeriodFormatChech("5005"),
	ExpressionValidation("5006"),
	DimensionColumnValidator("5010");
	
	/**
	 * @param text
	 */
	private OperationsId(final String id) {
		this.id = id;
	}

	private final String id;
	
	@Override
	public String toString() {
		return id;
	}

}


