/**
 * 
 */
package org.gcube.portlets.user.td.gwtservice.server;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.user.td.gwtservice.server.file.FileUploadSession;
import org.gcube.portlets.user.td.gwtservice.server.trservice.TRTasksManager;
import org.gcube.portlets.user.td.gwtservice.shared.Constants;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.source.SDMXRegistrySource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.open.TDOpenSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.Direction;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Agencies;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Codelist;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Dataset;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class SessionUtil {

	protected static final String CURRENT_TABULAR_RESOURCE = "CURRENT_TABULAR_RESOURCE";
	protected static final String CURRENT_TR_ID = "CURRENT_TR_ID";
	protected static final String TDOPEN_SESSION = "TDOPEN_SESSION";
	protected static final String TABULAR_RESOURCE_LIST = "TABULAR_RESOURCE_LIST";

	protected static final String TR_TASK_MANAGER = "TR_TASK_MANAGER";

	protected static final String SDMX_REGISTRY_SOURCE = "SDMX_REGISTRY_SOURCE";

	protected static final String SDMX_CLIENT_ATTRIBUTE = "SDMX_CLIENT";
	protected static final String SDMX_IMPORT_SESSION = "SDMX_IMPORT";
	protected static final String SDMX_IMPORT_TABULAR_RESOURCE = "SDMX_IMPORT_TABULAR_RESOURCE";
	protected static final String SDMX_IMPORT_TASK = "SDMX_IMPORT_TASK";

	protected static final String SDMX_EXPORT_SESSION = "SDMX_EXPORT_SESSION";
	protected static final String SDMX_EXPORT_TASK = "SDMX_EXPORT_TASK";

	protected static final String CSV_IMPORT_SESSION = "CSV_IMPORT";
	protected static final String CSV_IMPORT_FILE_UPLOAD_SESSION = "CSV_IMPORT_FILE_UPLOAD";
	protected static final String CSV_IMPORT_TASK = "CSV_IMPORT_TASK";
	protected static final String CSV_IMPORT_TABULAR_RESOURCE = "CSV_IMPORT_TABULAR_RESOURCE";

	protected static final String CSV_EXPORT_SESSION = "CSV_EXPORT_SESSION";
	protected static final String CSV_EXPORT_TASK = "CSV_EXPORT_TASK";
	protected static final String CSV_EXPORT_END = "CSV_EXPORT_END";
	protected static final String CSV_EXPORT_MONITOR = "CSV_EXPORT_MONITOR";

	protected static final String CHANGE_COLUMN_TYPE_SESSION = "CHANGE_COLUMN_TYPE_SESSION";
	protected static final String CHANGE_COLUMN_TYPE_MONITOR = "CHANGE_COLUMN_TYPE_MONITOR";
	protected static final String CHANGE_COLUMN_TYPE_TASK = "CHANGE_COLUMN_TYPE_TASK";

	protected static final String DELETE_COLUMN_SESSION = "DELETE_COLUMN_SESSION";
	protected static final String DELETE_COLUMN_MONITOR = "DELETE_COLUMN_MONITOR";
	protected static final String DELETE_COLUMN_TASK = "DELETE_COLUMN_TASK";
	
	protected static final String CHANGE_THE_COLUMN_LABEL_SESSION = "CHANGE_THE_COLUMN_LABEL_SESSION";
	protected static final String CHANGE_THE_COLUMN_LABEL_MONITOR = "CHANGE_THE_COLUMN_LABEL_MONITOR";
	protected static final String CHANGE_THE_COLUMN_LABEL_TASK = "CHANGE_THE_COLUMN_LABEL_TASK";

	protected static final String CHANGE_TABLE_TYPE_SESSION = "CHANGE_TABLE_TYPE_SESSION";
	protected static final String CHANGE_TABLE_TYPE_MONITOR = "CHANGE_TABLE_TYPE_MONITOR";
	protected static final String CHANGE_TABLE_TYPE_TASK = "CHANGE_TABLE_TYPE_TASK";
	
	
	protected static final String CODELISTS_PAGING_LOADED = "CODELISTS_PAGING_LOADED";
	protected static final String CODELISTS_PAGING_LOADED_DIRECTION = "CODELISTS_PAGING_LOADED_DIRECTION";
	protected static final String CODELISTS_PAGING_LOADED_FILTER = "CODELISTS_PAGING_LOADED_FILTER";

	
	protected static Logger logger = LoggerFactory.getLogger(SessionUtil.class);

	public static ASLSession getAslSession(HttpSession httpSession) {
		String username = (String) httpSession
				.getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		ASLSession session;
		if (username == null) {
			logger.warn("no user found in session, using test one");
			username = Constants.DEFAULT_USER;
			String scope = Constants.DEFAULT_SCOPE;

			httpSession.setAttribute(ScopeHelper.USERNAME_ATTRIBUTE, username);
			session = SessionManager.getInstance().getASLSession(
					httpSession.getId(), username);
			session.setScope(scope);

		} else {
			session = SessionManager.getInstance().getASLSession(
					httpSession.getId(), username);

		}

		logger.info("SessionUtil: aslSession " + session.getUsername() + " "
				+ session.getScope());

		return session;

	}

	public static void setTDOpenSession(HttpSession httpSession, TDOpenSession s) {

		TDOpenSession session = (TDOpenSession) httpSession
				.getAttribute(TDOPEN_SESSION);
		if (session != null)
			httpSession.removeAttribute(TDOPEN_SESSION);
		httpSession.setAttribute(TDOPEN_SESSION, s);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());

	}

	public static void retrieveResources(HttpSession httpSession)
			throws Exception {

		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
		return;
	}

	public static void setTabularResources(HttpSession httpSession,
			List<TabularResource> trs) {

		@SuppressWarnings("unchecked")
		List<TabularResource> tabularResources = (List<TabularResource>) httpSession
				.getAttribute(TABULAR_RESOURCE_LIST);
		if (tabularResources != null)
			httpSession.removeAttribute(TABULAR_RESOURCE_LIST);
		httpSession.setAttribute(TABULAR_RESOURCE_LIST, trs);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static TRId getTRId(HttpSession httpSession) {
		TRId id = (TRId) httpSession.getAttribute(CURRENT_TR_ID);
		if (id == null) {
			logger.error("TR_ID was not acquired");
		}
		return id;
	}

	public static void setTRId(HttpSession httpSession, TRId trId) {
		TRId id = (TRId) httpSession.getAttribute(CURRENT_TR_ID);
		if (id != null)
			httpSession.removeAttribute(CURRENT_TR_ID);
		httpSession.setAttribute(CURRENT_TR_ID, trId);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static TabResource getTabResource(HttpSession httpSession) {
		TabResource tabResource = (TabResource) httpSession
				.getAttribute(CURRENT_TABULAR_RESOURCE);
		if (tabResource == null) {
			logger.error("CURRENT_TABULAR_RESOURCE was not acquired");
		}
		return tabResource;
	}

	public static void setTabResource(HttpSession httpSession,
			TabResource tabResource) {
		TabResource t = (TabResource) httpSession
				.getAttribute(CURRENT_TABULAR_RESOURCE);
		if (t != null)
			httpSession.removeAttribute(CURRENT_TABULAR_RESOURCE);
		httpSession.setAttribute(CURRENT_TABULAR_RESOURCE, tabResource);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static TabResource getSDMXImportTabResource(HttpSession httpSession) {
		TabResource tabResource = (TabResource) httpSession
				.getAttribute(SDMX_IMPORT_TABULAR_RESOURCE);
		if (tabResource == null) {
			logger.error("SDMX_IMPORT_TABULAR_RESOURCE was not acquired");
		}
		return tabResource;
	}

	public static void setSDMXImportTabResource(HttpSession httpSession,
			TabResource tabResource) {
		TabResource t = (TabResource) httpSession
				.getAttribute(SDMX_IMPORT_TABULAR_RESOURCE);
		if (t != null)
			httpSession.removeAttribute(SDMX_IMPORT_TABULAR_RESOURCE);
		httpSession.setAttribute(SDMX_IMPORT_TABULAR_RESOURCE, tabResource);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	// //
	public static TabResource getCSVImportTabResource(HttpSession httpSession) {
		TabResource tabResource = (TabResource) httpSession
				.getAttribute(CSV_IMPORT_TABULAR_RESOURCE);
		if (tabResource == null) {
			logger.error("CSV_IMPORT_TABULAR_RESOURCE was not acquired");
		}
		return tabResource;
	}

	public static void setCSVImportTabResource(HttpSession httpSession,
			TabResource tabResource) {
		TabResource t = (TabResource) httpSession
				.getAttribute(CSV_IMPORT_TABULAR_RESOURCE);
		if (t != null)
			httpSession.removeAttribute(CSV_IMPORT_TABULAR_RESOURCE);
		httpSession.setAttribute(CSV_IMPORT_TABULAR_RESOURCE, tabResource);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	// //

	public static void setSDMXImportSession(HttpSession httpSession,
			SDMXImportSession s) {

		SDMXImportSession session = (SDMXImportSession) httpSession
				.getAttribute(SDMX_IMPORT_SESSION);
		if (session != null)
			httpSession.removeAttribute(SDMX_IMPORT_SESSION);
		httpSession.setAttribute(SDMX_IMPORT_SESSION, s);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static SDMXImportSession getSDMXImportSession(HttpSession httpSession) {
		SDMXImportSession importSession = (SDMXImportSession) httpSession
				.getAttribute(SDMX_IMPORT_SESSION);
		if (importSession == null) {
			logger.error("SDMXImportSession was not acquired");
		}
		return importSession;
	}

	public static void setCSVImportSession(HttpSession httpSession,
			CSVImportSession s) {

		CSVImportSession session = (CSVImportSession) httpSession
				.getAttribute(CSV_IMPORT_SESSION);
		if (session != null)
			httpSession.removeAttribute(CSV_IMPORT_SESSION);
		httpSession.setAttribute(CSV_IMPORT_SESSION, s);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static CSVImportSession getCSVImportSession(HttpSession httpSession) {
		CSVImportSession importSession = (CSVImportSession) httpSession
				.getAttribute(CSV_IMPORT_SESSION);
		if (importSession == null) {
			logger.error("CSVImportSession was not acquired");
		}
		return importSession;
	}

	public static void setCSVExportSession(HttpSession httpSession,
			CSVExportSession s) {

		CSVExportSession session = (CSVExportSession) httpSession
				.getAttribute(CSV_EXPORT_SESSION);
		if (session != null)
			httpSession.removeAttribute(CSV_EXPORT_SESSION);
		httpSession.setAttribute(CSV_EXPORT_SESSION, s);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static CSVExportSession getCSVExportSession(HttpSession httpSession) {
		CSVExportSession exportSession = (CSVExportSession) httpSession
				.getAttribute(CSV_EXPORT_SESSION);
		if (exportSession == null) {
			logger.error("CSVExportSession was not acquired");
		}
		return exportSession;
	}

	public static void setSDMXExportSession(HttpSession httpSession,
			SDMXExportSession s) {

		SDMXExportSession session = (SDMXExportSession) httpSession
				.getAttribute(SDMX_EXPORT_SESSION);
		if (session != null)
			httpSession.removeAttribute(SDMX_EXPORT_SESSION);
		httpSession.setAttribute(SDMX_EXPORT_SESSION, s);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static SDMXExportSession getSDMXExportSession(HttpSession httpSession) {
		SDMXExportSession exportSession = (SDMXExportSession) httpSession
				.getAttribute(SDMX_EXPORT_SESSION);
		if (exportSession == null) {
			logger.error("SDMXExportSession was not acquired");
		}
		return exportSession;
	}

	public static void setFileUploadSession(HttpSession httpSession,
			FileUploadSession s) {

		FileUploadSession session = (FileUploadSession) httpSession
				.getAttribute(CSV_IMPORT_FILE_UPLOAD_SESSION);
		if (session != null)
			httpSession.removeAttribute(CSV_IMPORT_FILE_UPLOAD_SESSION);
		httpSession.setAttribute(CSV_IMPORT_FILE_UPLOAD_SESSION, s);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static FileUploadSession getFileUploadSession(HttpSession httpSession) {
		FileUploadSession fileUploadSession = (FileUploadSession) httpSession
				.getAttribute(CSV_IMPORT_FILE_UPLOAD_SESSION);
		if (fileUploadSession == null) {
			logger.error("FileUploadSession was not acquired");
		}
		return fileUploadSession;
	}

	public static ArrayList<Codelist> retrieveCodelists(HttpSession httpSession)
			throws Exception {
		logger.info("SessionUtil retriveCodelists");
		SDMXClient client = getSdmxClient(httpSession);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
		return client.getAllCodelists();
	}

	public static ArrayList<Dataset> retrieveDatasets(HttpSession httpSession)
			throws Exception {
		logger.info("SessionUtil retriveDatasets");
		SDMXClient client = getSdmxClient(httpSession);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
		return client.getAllDatasets();
	}

	public static ArrayList<Agencies> retrieveAgencies(HttpSession httpSession)
			throws Exception {
		logger.info("SessionUtil retriveAgencies");
		SDMXClient client = getSdmxClient(httpSession);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
		return client.getAllAgencies();
	}

	public static void setSDMXRegistrySource(HttpSession httpSession,
			SDMXRegistrySource sdmxRegistrySource) {

		SDMXRegistrySource source = (SDMXRegistrySource) httpSession
				.getAttribute(SDMX_REGISTRY_SOURCE);
		if (source != null)
			httpSession.removeAttribute(SDMX_REGISTRY_SOURCE);
		httpSession.setAttribute(SDMX_REGISTRY_SOURCE, sdmxRegistrySource);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static SDMXRegistrySource getSDMXRegistrySource(
			HttpSession httpSession) {
		SDMXRegistrySource sdmxRegistrySource = (SDMXRegistrySource) httpSession
				.getAttribute(SDMX_REGISTRY_SOURCE);
		if (sdmxRegistrySource == null) {
			logger.error("SDMXRegistrySource was not acquired");
		}
		return sdmxRegistrySource;
	}

	public static SDMXClient getSdmxClient(HttpSession httpSession) {
		SDMXClient sdmxClient = (SDMXClient) httpSession
				.getAttribute(SDMX_CLIENT_ATTRIBUTE);
		SDMXRegistrySource sdmxRegistrySource = (SDMXRegistrySource) httpSession
				.getAttribute(SDMX_REGISTRY_SOURCE);
		if (sdmxRegistrySource == null) {
			logger.error("SDMXRegistrySource was not acquired");
		} else {
			String url = sdmxRegistrySource.getUrl();
			if (url == null || url.isEmpty()) {
				if (sdmxClient == null) {
					sdmxClient = new SDMXClient();
				} else {
					if (sdmxClient.type.compareTo(SDMXClient.TYPE.ANOTHER) == 0) {
						sdmxClient = new SDMXClient();
					}
				}
			} else {
				if (sdmxClient == null) {
					sdmxClient = new SDMXClient(url);
				} else {
					if (sdmxClient.type.compareTo(SDMXClient.TYPE.INTERNAL) == 0) {
						sdmxClient = new SDMXClient(url);
					} else {
						if (sdmxClient.url.compareTo(url) != 0) {
							sdmxClient = new SDMXClient(url);
						}
					}
				}
			}
			httpSession.setAttribute(SDMX_CLIENT_ATTRIBUTE, sdmxClient);

		}

		return sdmxClient;
	}

	public static Task getSDMXImportTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SDMX_IMPORT_TASK);
		if (monitor == null) {
			logger.error("SDMX_IMPORT_TASK was not acquired");
		}
		return monitor;
	}

	public static void setSDMXImportTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SDMX_IMPORT_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SDMX_IMPORT_TASK);
		httpSession.setAttribute(SDMX_IMPORT_TASK, task);
	}

	public static Task getCSVImportFileTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(CSV_IMPORT_TASK);
		if (monitor == null) {
			logger.error("CSV_IMPORT_TASK was not acquired");
		}
		return monitor;
	}

	public static void setCSVImportFileTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(CSV_IMPORT_TASK);
		if (monitor != null)
			httpSession.removeAttribute(CSV_IMPORT_TASK);
		httpSession.setAttribute(CSV_IMPORT_TASK, task);
	}

	public static Task getCSVExportTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(CSV_EXPORT_TASK);
		if (monitor == null) {
			logger.error("CSV_EXPORT_TASK was not acquired");
		}
		return monitor;
	}

	public static void setCSVExportTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(CSV_EXPORT_TASK);
		if (monitor != null)
			httpSession.removeAttribute(CSV_EXPORT_TASK);
		httpSession.setAttribute(CSV_EXPORT_TASK, task);
	}

	public static void setCSVExportEnd(HttpSession httpSession, Boolean end) {
		Boolean fin = (Boolean) httpSession.getAttribute(CSV_EXPORT_END);
		if (fin != null)
			httpSession.removeAttribute(CSV_EXPORT_END);
		httpSession.setAttribute(CSV_EXPORT_END, end);
	}

	public static Boolean getCSVExportEnd(HttpSession httpSession) {
		Boolean end = (Boolean) httpSession.getAttribute(CSV_EXPORT_END);
		logger.debug("getCSVExportEnd(): " + end);
		if (end == null) {
			logger.error("CSV_EXPORT_END was not acquired");
			end = false;
		}
		return end;
	}

	public static Task getSDMXExportTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SDMX_EXPORT_TASK);
		if (monitor == null) {
			logger.error("SDMX_EXPORT_TASK was not acquired");
		}
		return monitor;
	}

	public static void setSDMXExportTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SDMX_EXPORT_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SDMX_EXPORT_TASK);
		httpSession.setAttribute(SDMX_EXPORT_TASK, task);
	}

	public static TRTasksManager getTRTasksManager(HttpSession httpSession) {
		TRTasksManager tasksManager = (TRTasksManager) httpSession
				.getAttribute(TR_TASK_MANAGER);
		if (tasksManager != null) {
			return tasksManager;
		} else {
			tasksManager = new TRTasksManager();
			httpSession.setAttribute(TR_TASK_MANAGER, tasksManager);
			return tasksManager;
		}
	}

	public static void setTRTasksManager(HttpSession httpSession,
			TRTasksManager trTasksManager) {
		TRTasksManager tm = (TRTasksManager) httpSession
				.getAttribute(TR_TASK_MANAGER);
		if (tm != null) {
			httpSession.removeAttribute(TR_TASK_MANAGER);
		}
		httpSession.setAttribute(TR_TASK_MANAGER, trTasksManager);

	}
	
	//
	public static ChangeColumnTypeSession getChangeColumnTypeSession(
			HttpSession httpSession) {
		ChangeColumnTypeSession changeColumnTypeSession = (ChangeColumnTypeSession) httpSession
				.getAttribute(CHANGE_COLUMN_TYPE_SESSION);
		if (changeColumnTypeSession != null) {
			return changeColumnTypeSession;
		} else {
			changeColumnTypeSession = new ChangeColumnTypeSession();
			httpSession.setAttribute(CHANGE_COLUMN_TYPE_SESSION,
					changeColumnTypeSession);
			return changeColumnTypeSession;
		}
	}

	public static void setChangeColumnTypeSession(HttpSession httpSession,
			ChangeColumnTypeSession changeColumnTypeSession) {
		ChangeColumnTypeSession ct = (ChangeColumnTypeSession) httpSession
				.getAttribute(CHANGE_COLUMN_TYPE_SESSION);
		if (ct != null) {
			httpSession.removeAttribute(CHANGE_COLUMN_TYPE_SESSION);
		}
		httpSession.setAttribute(CHANGE_COLUMN_TYPE_SESSION,
				changeColumnTypeSession);

	}

	public static ChangeColumnTypeMonitor getChangeColumnTypeMonitor(
			HttpSession httpSession) {
		ChangeColumnTypeMonitor changeColumnTypeMonitor = (ChangeColumnTypeMonitor) httpSession
				.getAttribute(CHANGE_COLUMN_TYPE_MONITOR);
		if (changeColumnTypeMonitor != null) {
			return changeColumnTypeMonitor;
		} else {
			changeColumnTypeMonitor = new ChangeColumnTypeMonitor();
			httpSession.setAttribute(CHANGE_COLUMN_TYPE_MONITOR,
					changeColumnTypeMonitor);
			return changeColumnTypeMonitor;
		}
	}

	public static void setChangeColumnTypeMonitor(HttpSession httpSession,
			ChangeColumnTypeMonitor changeColumnTypeMonitor) {
		ChangeColumnTypeMonitor cm = (ChangeColumnTypeMonitor) httpSession
				.getAttribute(CHANGE_COLUMN_TYPE_MONITOR);
		if (cm != null) {
			httpSession.removeAttribute(CHANGE_COLUMN_TYPE_MONITOR);
		}
		httpSession.setAttribute(CHANGE_COLUMN_TYPE_MONITOR,
				changeColumnTypeMonitor);

	}

	public static Task getChangeColumnTypeTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(CHANGE_COLUMN_TYPE_TASK);
		if (monitor == null) {
			logger.error("CHANGE_COLUMN_TYPE_TASK was not acquired");
		}
		return monitor;
	}

	public static void setChangeColumnTypeTask(HttpSession httpSession,
			Task task) {
		Task monitor = (Task) httpSession.getAttribute(CHANGE_COLUMN_TYPE_TASK);
		if (monitor != null)
			httpSession.removeAttribute(CHANGE_COLUMN_TYPE_TASK);
		httpSession.setAttribute(CHANGE_COLUMN_TYPE_TASK, task);
	}
	
	///

	public static LabelColumnSession getLabelColumnSession(
			HttpSession httpSession) {
		LabelColumnSession labelColumnSession = (LabelColumnSession) httpSession
				.getAttribute(CHANGE_THE_COLUMN_LABEL_SESSION);
		if (labelColumnSession != null) {
			return labelColumnSession;
		} else {
			labelColumnSession = new LabelColumnSession();
			httpSession.setAttribute(CHANGE_THE_COLUMN_LABEL_SESSION,
					labelColumnSession);
			return labelColumnSession;
		}
	}

	public static void setLabelColumnSession(HttpSession httpSession,
			LabelColumnSession labelColumnSession) {
		LabelColumnSession lc = (LabelColumnSession) httpSession
				.getAttribute(CHANGE_THE_COLUMN_LABEL_SESSION);
		if (lc != null) {
			httpSession.removeAttribute(CHANGE_THE_COLUMN_LABEL_SESSION);
		}
		httpSession.setAttribute(CHANGE_THE_COLUMN_LABEL_SESSION,
				labelColumnSession);

	}

	public static LabelColumnMonitor getLabelColumnMonitor(
			HttpSession httpSession) {
		LabelColumnMonitor labelColumnMonitor = (LabelColumnMonitor) httpSession
				.getAttribute(CHANGE_THE_COLUMN_LABEL_MONITOR);
		if (labelColumnMonitor != null) {
			return labelColumnMonitor;
		} else {
			labelColumnMonitor = new LabelColumnMonitor();
			httpSession.setAttribute(CHANGE_THE_COLUMN_LABEL_MONITOR,
					labelColumnMonitor);
			return labelColumnMonitor;
		}
	}

	public static void setLabelColumnMonitor(HttpSession httpSession,
			LabelColumnMonitor labelColumnMonitor) {
		LabelColumnMonitor lc = (LabelColumnMonitor) httpSession
				.getAttribute(CHANGE_THE_COLUMN_LABEL_MONITOR);
		if (lc != null) {
			httpSession.removeAttribute(CHANGE_THE_COLUMN_LABEL_MONITOR);
		}
		httpSession.setAttribute(CHANGE_THE_COLUMN_LABEL_MONITOR,
				labelColumnMonitor);

	}

	public static Task getLabelColumnTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(CHANGE_THE_COLUMN_LABEL_TASK);
		if (monitor == null) {
			logger.error("CHANGE_THE_COLUMN_LABEL_TASK was not acquired");
		}
		return monitor;
	}

	public static void setLabelColumnTask(HttpSession httpSession,
			Task task) {
		Task monitor = (Task) httpSession.getAttribute(CHANGE_THE_COLUMN_LABEL_TASK);
		if (monitor != null)
			httpSession.removeAttribute(CHANGE_THE_COLUMN_LABEL_TASK);
		httpSession.setAttribute(CHANGE_THE_COLUMN_LABEL_TASK, task);
	}
	
	///

	public static DeleteColumnSession getDeleteColumnSession(
			HttpSession httpSession) {
		DeleteColumnSession deleteColumnSession = (DeleteColumnSession) httpSession
				.getAttribute(DELETE_COLUMN_SESSION);
		if (deleteColumnSession != null) {
			return deleteColumnSession;
		} else {
			deleteColumnSession = new DeleteColumnSession();
			httpSession.setAttribute(DELETE_COLUMN_SESSION,
					deleteColumnSession);
			return deleteColumnSession;
		}
	}

	public static void setDeleteColumnSession(HttpSession httpSession,
			DeleteColumnSession deleteColumnSession) {
		DeleteColumnSession dc = (DeleteColumnSession) httpSession
				.getAttribute(DELETE_COLUMN_SESSION);
		if (dc != null) {
			httpSession.removeAttribute(DELETE_COLUMN_SESSION);
		}
		httpSession.setAttribute(DELETE_COLUMN_SESSION,
				deleteColumnSession);

	}

	public static DeleteColumnMonitor getDeleteColumnMonitor(
			HttpSession httpSession) {
		DeleteColumnMonitor deleteColumnMonitor = (DeleteColumnMonitor) httpSession
				.getAttribute(DELETE_COLUMN_MONITOR);
		if (deleteColumnMonitor != null) {
			return deleteColumnMonitor;
		} else {
			deleteColumnMonitor = new DeleteColumnMonitor();
			httpSession.setAttribute(DELETE_COLUMN_MONITOR,
					deleteColumnMonitor);
			return deleteColumnMonitor;
		}
	}

	public static void setDeleteColumnMonitor(HttpSession httpSession,
			DeleteColumnMonitor deleteColumnMonitor) {
		DeleteColumnMonitor cm = (DeleteColumnMonitor) httpSession
				.getAttribute(DELETE_COLUMN_MONITOR);
		if (cm != null) {
			httpSession.removeAttribute(DELETE_COLUMN_MONITOR);
		}
		httpSession.setAttribute(DELETE_COLUMN_MONITOR,
				deleteColumnMonitor);

	}

	public static Task getDeleteColumnTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(DELETE_COLUMN_TASK);
		if (monitor == null) {
			logger.error("DELETE_COLUMN_TASK was not acquired");
		}
		return monitor;
	}

	public static void setDeleteColumnTask(HttpSession httpSession,
			Task task) {
		Task monitor = (Task) httpSession.getAttribute(DELETE_COLUMN_TASK);
		if (monitor != null)
			httpSession.removeAttribute(DELETE_COLUMN_TASK);
		httpSession.setAttribute(DELETE_COLUMN_TASK, task);
	}
	
	
	///

	public static ChangeTableTypeSession getChangeTableTypeSession(
			HttpSession httpSession) {
		ChangeTableTypeSession changeTableTypeSession = (ChangeTableTypeSession) httpSession
				.getAttribute(CHANGE_TABLE_TYPE_SESSION);
		if (changeTableTypeSession != null) {
			return changeTableTypeSession;
		} else {
			changeTableTypeSession = new ChangeTableTypeSession();
			httpSession.setAttribute(CHANGE_TABLE_TYPE_SESSION,
					changeTableTypeSession);
			return changeTableTypeSession;
		}
	}

	public static void setChangeTableTypeSession(HttpSession httpSession,
			ChangeTableTypeSession changeTableTypeSession) {
		ChangeTableTypeSession ctts = (ChangeTableTypeSession) httpSession
				.getAttribute(CHANGE_TABLE_TYPE_SESSION);
		if (ctts != null) {
			httpSession.removeAttribute(CHANGE_TABLE_TYPE_SESSION);
		}
		httpSession.setAttribute(CHANGE_TABLE_TYPE_SESSION,
				changeTableTypeSession);

	}

	public static ChangeTableTypeMonitor getChangeTableTypeMonitor(
			HttpSession httpSession) {
		ChangeTableTypeMonitor changeTableTypeMonitor = (ChangeTableTypeMonitor) httpSession
				.getAttribute(CHANGE_TABLE_TYPE_MONITOR);
		if (changeTableTypeMonitor != null) {
			return changeTableTypeMonitor;
		} else {
			changeTableTypeMonitor = new ChangeTableTypeMonitor();
			httpSession.setAttribute(CHANGE_TABLE_TYPE_MONITOR,
					changeTableTypeMonitor);
			return changeTableTypeMonitor;
		}
	}

	public static void setChangeTableTypeMonitor(HttpSession httpSession,
			ChangeTableTypeMonitor changeTableTypeMonitor) {
		ChangeTableTypeMonitor ctt = (ChangeTableTypeMonitor) httpSession
				.getAttribute(CHANGE_TABLE_TYPE_MONITOR);
		if (ctt != null) {
			httpSession.removeAttribute(CHANGE_TABLE_TYPE_MONITOR);
		}
		httpSession.setAttribute(CHANGE_TABLE_TYPE_MONITOR,
				changeTableTypeMonitor);

	}

	public static Task getChangeTableTypeTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(CHANGE_TABLE_TYPE_TASK);
		if (monitor == null) {
			logger.error("CHANGE_TABLE_TYPE_TASK was not acquired");
		}
		return monitor;
	}

	public static void setChangeTableTypeTask(HttpSession httpSession,
			Task task) {
		Task monitor = (Task) httpSession.getAttribute(CHANGE_TABLE_TYPE_TASK);
		if (monitor != null)
			httpSession.removeAttribute(CHANGE_TABLE_TYPE_TASK);
		httpSession.setAttribute(CHANGE_TABLE_TYPE_TASK, task);
	}
	
	
	
	
	
	///
	public static ArrayList<TabResource> getCodelistsPagingLoaded(
			HttpSession httpSession) {
		@SuppressWarnings("unchecked")
		ArrayList<TabResource> ltr = ((ArrayList<TabResource>) httpSession
				.getAttribute(CODELISTS_PAGING_LOADED));
		if (ltr == null) {
			logger.error("CODELISTS_PAGING_LOADED was not acquired");
		}
		return ltr;
	}

	public static void setCodelistsPagingLoaded(HttpSession httpSession,
			ArrayList<TabResource> listCodelists) {
		@SuppressWarnings("unchecked")
		ArrayList<TabResource> ltr = ((ArrayList<TabResource>) httpSession
				.getAttribute(CODELISTS_PAGING_LOADED));
		if (ltr != null)
			httpSession.removeAttribute(CODELISTS_PAGING_LOADED);
		httpSession.setAttribute(CODELISTS_PAGING_LOADED, listCodelists);
	}

	public static Direction getCodelistsPagingLoadedDirection(
			HttpSession httpSession) {
		Direction direction = (Direction) httpSession
				.getAttribute(CODELISTS_PAGING_LOADED_DIRECTION);
		if (direction == null) {
			logger.error("CODELISTS_PAGING_LOADED_DIRECTION was not acquired");
		}
		return direction;
	}

	public static void setCodelistsPagingLoadedDirection(
			HttpSession httpSession, Direction direction) {

		Direction dir = ((Direction) httpSession
				.getAttribute(CODELISTS_PAGING_LOADED_DIRECTION));
		if (dir != null)
			httpSession.removeAttribute(CODELISTS_PAGING_LOADED_DIRECTION);
		httpSession.setAttribute(CODELISTS_PAGING_LOADED_DIRECTION, direction);
	}

	public static String getCodelistsPagingLoadedFilter(HttpSession httpSession) {
		String filter = (String) httpSession
				.getAttribute(CODELISTS_PAGING_LOADED_FILTER);
		if (filter == null) {
			logger.error("CODELISTS_PAGING_LOADED_FILTER was not acquired");
		}
		return filter;
	}

	public static void setCodelistsPagingLoadedFilter(HttpSession httpSession,
			String filter) {

		String fil = ((String) httpSession
				.getAttribute(CODELISTS_PAGING_LOADED_FILTER));
		if (fil != null)
			httpSession.removeAttribute(CODELISTS_PAGING_LOADED_FILTER);
		httpSession.setAttribute(CODELISTS_PAGING_LOADED_FILTER, filter);
	}

}
