/**
 * 
 */
package org.gcube.portlets.user.td.gwtservice.server;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import net.sf.csv4j.ParseException;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.Profile;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.DescriptionsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.ExportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GenericMapMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.ImportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.VersionMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.impl.TabularDataServiceFactory;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.AgencyMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.DescriptionMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.NameMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.RightsMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.TabularResourceMetadata;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryDescriptor;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryInterfaceType;
import org.gcube.datapublishing.sdmx.impl.model.GCubeSDMXRegistryDescriptor;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTService;
import org.gcube.portlets.user.td.gwtservice.server.file.FileUploadSession;
import org.gcube.portlets.user.td.gwtservice.server.file.FileUtil;
import org.gcube.portlets.user.td.gwtservice.server.storage.FilesStorage;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ColumnDataTypeMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationsId;
import org.gcube.portlets.user.td.gwtservice.server.trservice.TaskStateMap;
import org.gcube.portlets.user.td.gwtservice.shared.Constants;
import org.gcube.portlets.user.td.gwtservice.shared.csv.AvailableCharsetList;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVFileUtil;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVParserConfiguration;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVRowError;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.file.FileUploadMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.file.FileUploadState;
import org.gcube.portlets.user.td.gwtservice.shared.file.HeaderPresence;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXExportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.source.SDMXRegistrySource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TableData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRAgencyMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRCreationDateMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRDescriptionMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRLocalizedText;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRNameMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRRightsMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.open.TDOpenSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadConfig;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadResult;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabDescriptionsMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabExportMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabGenericMapMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabImportMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabNamesMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabVersionMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Agencies;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Codelist;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Dataset;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class TDGWTServiceImpl extends RemoteServiceServlet implements
		TDGWTService {

	private static final long serialVersionUID = -5707400086333186368L;
	protected static Logger logger = LoggerFactory
			.getLogger(TDGWTServiceImpl.class);

	protected static SimpleDateFormat sdf = new SimpleDateFormat(
			"yyyy/MM/dd HH:mm");

	/**
	 * 
	 * {@inheritDoc}
	 */

	public void setTabResource(TabResource tabResource)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			if (tabResource == null) {
				logger.error("Error setting TabResource: null");
				throw new TDGWTServiceException(
						"Error setting TabResource: null");
			}

			SessionUtil.setTabResource(session, tabResource);
			SessionUtil.setTRId(session, tabResource.getTrId());
			return;

		} catch (Exception e) {
			logger.error(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public TabResource getTabResourceInformation() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();

			// ASLSession aslSession = SessionUtil.getAslSession(session);

			TabResource currentTR = SessionUtil.getTabResource(session);
			if (currentTR == null) {
				logger.error("CURRENT_TABULAR_RESOURCE is null");
				throw new TDGWTServiceException(
						"CURRENT_TABULAR_RESOURCE is null");
			}

			logger.debug("GetTabResourceInformation():" + currentTR.toString());

			ArrayList<TRMetadata> trMetadatas = getTRMetadata(currentTR
					.getTrId());
			updateTabResourceInformation(currentTR, trMetadatas);
			currentTR.setDate(getTRCreationDate(currentTR.getTrId()));
			SessionUtil.setTabResource(session, currentTR);
			logger.debug("GetTabResourceInformation() updated information:"
					+ currentTR.toString());
			return currentTR;

		} catch (Exception e) {
			logger.error(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public TabResource getTabResourceInformation(TRId trId)
			throws TDGWTServiceException {
		try {
			@SuppressWarnings("unused")
			HttpSession session = this.getThreadLocalRequest().getSession();
			// ASLSession aslSession = SessionUtil.getAslSession(session);
			logger.debug("GetTabResourceInformation(TRId):" + trId.toString());
			TabResource currentTR = new TabResource();
			currentTR.setTrId(trId);
			ArrayList<TRMetadata> trMetadatas = getTRMetadata(currentTR
					.getTrId());
			updateTabResourceInformation(currentTR, trMetadatas);
			currentTR.setDate(getTRCreationDate(trId));
			logger.debug("GetTabResourceInformation() updated information:"
					+ currentTR.toString());
			return currentTR;

		} catch (Exception e) {
			logger.error(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error setting TabResource parameter: "
							+ e.getLocalizedMessage());
		}
	}

	protected void updateTabResourceInformation(TabResource tabResource,
			ArrayList<TRMetadata> trMetadatas) {
		for (TRMetadata trMetadata : trMetadatas) {
			if (trMetadata instanceof TRDescriptionMetadata) {
				tabResource.setDescription(((TRDescriptionMetadata) trMetadata)
						.getValue());
			} else {
				if (trMetadata instanceof TRNameMetadata) {
					tabResource.setName(((TRNameMetadata) trMetadata)
							.getValue());
				} else {
					if (trMetadata instanceof TRAgencyMetadata) {
						tabResource.setAgency(((TRAgencyMetadata) trMetadata)
								.getValue());
					} else {
						if (trMetadata instanceof TRCreationDateMetadata) {
							tabResource
									.setDate(((TRCreationDateMetadata) trMetadata)
											.getDate());
						} else {
							if (trMetadata instanceof TRRightsMetadata) {
								tabResource
										.setRight(((TRRightsMetadata) trMetadata)
												.getValue());
							} else {

							}
						}

					}
				}
			}
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public ArrayList<ColumnData> getColumns() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			TabResource currentTR = SessionUtil.getTabResource(session);
			if (currentTR == null) {
				logger.error("CURRENT_TABULAR_RESOURCE is null");
				throw new TDGWTServiceException(
						"CURRENT_TABULAR_RESOURCE is null");
			}
			TRId trId = currentTR.getTrId();

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getLastTable(new TabularResourceId(Long
					.valueOf(trId.getId())));

			ArrayList<ColumnData> columns = new ArrayList<ColumnData>();

			List<Column> cols = table.getColumns();
			int i = 0;
			for (Column c : cols) {
				if (c.getColumnType() instanceof IdColumnType) {

				} else {
					ColumnData cData = new ColumnData();
					cData.setId(Integer.toString(i));
					cData.setColumnId(c.getLocalId().getValue());
					cData.setName(c.getName());
					cData.setTypeCode(c.getColumnType().getCode());
					cData.setTypeName(c.getColumnType().getName());
					cData.setDataTypeName(c.getDataType().getName());
					NamesMetadata labelsMetadata = null;
					try {
						labelsMetadata = c.getMetadata(NamesMetadata.class);
					} catch (NoSuchMetadataException e) {
						logger.debug("labelMetadata: NoSuchMetadataException "
								+ e.getLocalizedMessage());
					}

					if (labelsMetadata == null) {
						cData.setLabel("nolabel");
						logger.debug("LabelsMetadata no labels");
					} else {
						LocalizedText cl = null;
						cl = labelsMetadata.getTextWithLocale("en");
						if (cl == null) {
							cData.setLabel("nolabel");
							logger.debug("ColumnLabel no label in en");
						} else {
							cData.setLabel(cl.getValue());
							logger.debug("Column Set Label: " + cl.getValue());
						}
					}
					cData.setTrId(trId);
					columns.add(cData);
					i++;
				}
			}

			return columns;

		} catch (Exception e) {
			logger.error(
					"Error retrieving Columns: " + e.getLocalizedMessage(), e);
			throw new TDGWTServiceException("Error retrieving Columns: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public ArrayList<ColumnData> getColumns(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			logger.debug("getColumns():" + trId.toString());

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));

			ArrayList<ColumnData> columns = new ArrayList<ColumnData>();

			List<Column> cols = table.getColumns();
			int i = 0;
			for (Column c : cols) {
				if (c.getColumnType() instanceof IdColumnType) {

				} else {
					ColumnData cData = new ColumnData();
					cData.setId(Integer.toString(i));
					cData.setColumnId(c.getLocalId().getValue());
					cData.setName(c.getName());
					cData.setTypeCode(c.getColumnType().getCode());
					cData.setTypeName(c.getColumnType().getName());
					cData.setDataTypeName(c.getDataType().getName());
					NamesMetadata labelsMetadata = null;
					try {
						labelsMetadata = c.getMetadata(NamesMetadata.class);
					} catch (NoSuchMetadataException e) {
						logger.debug("labelMetadata: NoSuchMetadataException "
								+ e.getLocalizedMessage());
					}

					if (labelsMetadata == null) {
						cData.setLabel("nolabel");
						logger.debug("LabelsMetadata no labels");
					} else {
						LocalizedText cl = null;
						cl = labelsMetadata.getTextWithLocale("en");
						if (cl == null) {
							cData.setLabel("nolabel");
							logger.debug("ColumnLabel no label in en");
						} else {
							cData.setLabel(cl.getValue());
							logger.debug("Column Set Label: " + cl.getValue());
						}
					}
					cData.setTrId(trId);
					columns.add(cData);
					i++;
				}
			}

			return columns;

		} catch (Exception e) {
			logger.error(
					"Error retrieving Columns: " + e.getLocalizedMessage(), e);
			throw new TDGWTServiceException("Error retrieving Columns: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public ColumnData getColumn(TRId trId, String columnName)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));

			ColumnData cData = new ColumnData();

			Column c = table.getColumnByName(columnName);
			if (c.getColumnType() instanceof IdColumnType) {

			} else {
				cData.setId(Integer.toString(0));
				cData.setColumnId(c.getLocalId().getValue());
				cData.setName(c.getName());
				cData.setTypeCode(c.getColumnType().getCode());
				cData.setTypeName(c.getColumnType().getName());
				cData.setDataTypeName(c.getDataType().getName());
				NamesMetadata labelsMetadata = null;
				try {
					labelsMetadata = c.getMetadata(NamesMetadata.class);
				} catch (NoSuchMetadataException e) {
					logger.debug("labelMetadata: NoSuchMetadataException "
							+ e.getLocalizedMessage());
				}

				if (labelsMetadata == null) {
					cData.setLabel("nolabel");
					logger.debug("LabelsMetadata no labels");
				} else {
					LocalizedText cl = null;
					cl = labelsMetadata.getTextWithLocale("en");
					if (cl == null) {
						cData.setLabel("nolabel");
						logger.debug("ColumnLabel no label in en");
					} else {
						cData.setLabel(cl.getValue());
						logger.debug("Column Set Label: " + cl.getValue());
					}
				}
				cData.setTrId(trId);

			}

			return cData;

		} catch (Exception e) {
			logger.error("Error retrieving Column: " + e.getLocalizedMessage(),
					e);
			throw new TDGWTServiceException("Error retrieving Column: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public TableData getLastTable(TRId trId) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getLastTable(new TabularResourceId(Long
					.valueOf(trId.getId())));

			TableData tData = new TableData();
			trId.setTableId(String.valueOf(table.getId().getValue()));
			tData.setTrId(trId);
			tData.setName(table.getName());
			tData.setTypeName(table.getTableType().getName());
			tData.setTypeCode(table.getTableType().getCode());
			Collection<TableMetadata> cMeta = table.getAllMetadata();

			tData.setMetaData(cMeta.toString());

			ArrayList<ColumnData> lColumnData = new ArrayList<ColumnData>();
			for (Column column : table.getColumns()) {
				ColumnData colData = new ColumnData();
				colData.setColumnId(column.getLocalId().getValue());
				colData.setName(column.getName());
				colData.setTypeName(column.getColumnType().getName());
				colData.setTypeCode(column.getColumnType().getCode());
				colData.setDataTypeName(column.getDataType().getName());
				lColumnData.add(colData);
			}

			tData.setListColumnData(lColumnData);

			return tData;

		} catch (Exception e) {
			logger.error("Error in getLastTable(): " + e.getLocalizedMessage(),
					e);
			throw new TDGWTServiceException("Error in getLastTable(): "
					+ e.getLocalizedMessage());
		}
	}
	
	
	/**
	 * 
	 * {@inheritDoc}
	 */
	public TableData getTable(TRId trId) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getTable(new TableId(Long
					.valueOf(trId.getTableId())));

			TableData tData = new TableData();
			trId.setTableId(String.valueOf(table.getId().getValue()));
			tData.setTrId(trId);
			tData.setName(table.getName());
			tData.setTypeName(table.getTableType().getName());
			tData.setTypeCode(table.getTableType().getCode());
			Collection<TableMetadata> cMeta = table.getAllMetadata();

			tData.setMetaData(cMeta.toString());

			ArrayList<ColumnData> lColumnData = new ArrayList<ColumnData>();
			for (Column column : table.getColumns()) {
				ColumnData colData = new ColumnData();
				colData.setColumnId(column.getLocalId().getValue());
				colData.setName(column.getName());
				colData.setTypeName(column.getColumnType().getName());
				colData.setTypeCode(column.getColumnType().getCode());
				colData.setDataTypeName(column.getDataType().getName());
				lColumnData.add(colData);
			}

			tData.setListColumnData(lColumnData);

			return tData;

		} catch (Exception e) {
			logger.error("Error in getTable(): " + e.getLocalizedMessage(),
					e);
			throw new TDGWTServiceException("Error in getTable(): "
					+ e.getLocalizedMessage());
		}
	}
	

	/**
	 * Not used now, but it will be necessary in the future to retrieve task
	 * pending
	 * 
	 * {@inheritDoc}
	 */
	public void startTDOpen(TDOpenSession s) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setTDOpenSession(session, s);
			return;

		} catch (Exception e) {
			logger.error("Error setting TDOpenSession parameter: "
					+ e.getLocalizedMessage());
			throw new TDGWTServiceException(
					"Error setting TDOpenSession parameter: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * 
	 * @param tr
	 * @param tabResource
	 */
	protected void syncTRMetaData(TabularResource tr, TabResource tabResource) {
		// Date date = Calendar.getInstance().getTime();
		logger.debug("TRservice [id:" + tr.getId() + " ,creationDate:"
				+ tr.getCreationDate() + "]");
		logger.debug("TabResource [name:" + tabResource.getName()
				+ " ,description:" + tabResource.getDescription() + " ,agency:"
				+ tabResource.getAgency() + " ,rights:"
				+ tabResource.getRight() + "]");
		tabResource.setDate(sdf.format(tr.getCreationDate().getTime()));
		tr.setMetadata(new NameMetadata(tabResource.getName()));
		tr.setMetadata(new DescriptionMetadata(tabResource.getDescription()));
		// tr.setMetadata(new CreationDateMetadata(date));
		if (tabResource.getAgency() != null
				&& !tabResource.getAgency().isEmpty()) {
			tr.setMetadata(new AgencyMetadata(tabResource.getAgency()));
		}
		tr.setMetadata(new RightsMetadata(tabResource.getRight()));

	}

	/**
	 * 
	 * @param tr
	 * @throws TDGWTServiceException
	 */
	protected void retriveTRMetadataFromService(TabularDataService service,
			TabularResource tr) throws TDGWTServiceException {
		retriveTRMetadataFromService(service, tr, 0);
	}

	/**
	 * Retrieves the informations for a specific Tabular Resource from service
	 * 
	 * @param tr
	 *            TabularResource on service
	 * @param i
	 *            Index on Grid
	 * @return TabResource for Grid
	 * @throws TDGWTServiceException
	 */
	protected TabResource retriveTRMetadataFromService(
			TabularDataService service, TabularResource tr, int i)
			throws TDGWTServiceException {

		Table table = null;
		try {
			table = service.getLastTable(tr.getId());
		} catch (NoSuchTabularResourceException e) {
			e.printStackTrace();
		} catch (InvalidTabularResourceException e) {
			e.printStackTrace();
		}

		TableId tableId = null;

		if (table == null) {
			logger.info("Tabular resource " + tr.getId() + " has no table.");
		} else {
			tableId = table.getId();
		}

		TRId trId;
		TabResource t;
		if (tableId == null) {
			logger.info("Tabular Resource " + tr.getId()
					+ " has last table with id null.");
			t = new TabResource();
			t.setTrId(null);
		} else {
			trId = new TRId(String.valueOf(tr.getId().getValue()),
					String.valueOf(tableId.getValue()), table.getTableType()
							.getName());
			t = getTabResourceInformation(trId);

		}
		t.setId(String.valueOf(i));

		return t;
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public void setCodelistsPagingLoader() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			CodelistTableType codType = new CodelistTableType();

			List<TabularResource> trs = service
					.getTabularResourcesByType(codType.getName());
			SessionUtil.setTabularResources(session, trs);

			ArrayList<TabResource> ltr = new ArrayList<TabResource>();

			int i;
			for (i = 0; i < trs.size(); i++) {
				TabularResource tr = trs.get(i);
				TabResource t = retriveTRMetadataFromService(service, tr, i);
				if (t.getTrId() != null) {
					ltr.add(t);
				}
			}

			logger.debug("Codelists retrived: " + ltr);
			SessionUtil.setCodelistsPagingLoaded(session, ltr);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error retrieving Codelist in setCodelistsPagingLoader(): "
					+ e.getLocalizedMessage());
			throw new TDGWTServiceException("Error retrieving Codelist: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public CodelistPagingLoadResult getCodelistsPagingLoader(
			CodelistPagingLoadConfig plc) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();

			ArrayList<TabResource> ltr = SessionUtil
					.getCodelistsPagingLoaded(session);
			String direction = SessionUtil
					.getCodelistsPagingLoadedDirection(session);
			String filter = SessionUtil.getCodelistsPagingLoadedFilter(session);

			if (ltr == null) {
				logger.error("Error no codelist present in session");
				throw new TDGWTServiceException(
						"Error no codelist present in session");
			}

			if (direction == null) {
				logger.error("Error no codelist direction present in session");
				throw new TDGWTServiceException(
						"Error no codelist direction present in session");
			}
			if (filter == null) {
				logger.error("Error no codelist filter present in session");
				throw new TDGWTServiceException(
						"Error no codelist filter present in session");
			}

			if (plc.getOffset() < 0 || plc.getOffset() >= ltr.size()) {
				logger.error("Error CodelistPagingLoadConfig no valid range request");
				throw new TDGWTServiceException(
						"Error CodelistPagingLoadConfig no valid range request");
			}

			int request_end = plc.getOffset() + plc.getLimit();
			if (request_end > ltr.size()) {
				request_end = ltr.size();
			}

			ArrayList<TabResource> ltrTemp = new ArrayList<TabResource>();

			if (filter.compareTo(plc.getFilter()) != 0) {

			}

			if (direction.compareTo(plc.getDirection()) != 0) {

			}

			for (int i = plc.getOffset(); i < request_end; i++) {
				try {
					ltr.get(i);
					ltrTemp.add(ltr.get(i));

				} catch (IndexOutOfBoundsException e) {
					logger.debug("OutOfBounds in getCodelistsPagingLoader() size:"
							+ ltr.size()
							+ " index: "
							+ i
							+ " Error:"
							+ e.getMessage() + "\n");
				}
			}

			CodelistPagingLoadResult codelistPagingLoadResult = new CodelistPagingLoadResult();
			codelistPagingLoadResult.setFilter(plc.getFilter());
			codelistPagingLoadResult.setDirection(plc.getDirection());
			codelistPagingLoadResult.setLimit(plc.getLimit());
			codelistPagingLoadResult.setOffset(plc.getOffset());
			codelistPagingLoadResult.setTotalLenght(ltr.size());
			codelistPagingLoadResult.setLtr(ltrTemp);

			logger.debug("Codelists retrieved: " + ltrTemp);
			return codelistPagingLoadResult;
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error retrieving Codelist in getCodelistsPagingLoader(): "
					+ e.getLocalizedMessage());
			throw new TDGWTServiceException("Error retrieving Codelist: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public ArrayList<TabResource> getTabularResources()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			List<TabularResource> trs = service.getTabularResources();
			SessionUtil.setTabularResources(session, trs);

			ArrayList<TabResource> ltr = new ArrayList<TabResource>();

			int i;
			for (i = 0; i < trs.size(); i++) {
				TabularResource tr = trs.get(i);
				TabResource t = retriveTRMetadataFromService(service, tr, i);
				if (t.getTrId() != null) {
					ltr.add(t);
				}
			}

			logger.debug("Tabular Resources retrived: " + ltr);
			return ltr;
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error retrieving TabularResources: "
					+ e.getLocalizedMessage());
			throw new TDGWTServiceException(
					"Error retrieving TabularResources: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * @param tabResource
	 * @throws TDGWTServiceException
	 */
	public void removeTabularResource(TRId trId) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			if (trId == null) {
				logger.error("Error removing TabularResource: trId is null");
				throw new TDGWTServiceException(
						"Error removing TabularResource no parameters set");
			}
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResourceId id = new TabularResourceId(Long.valueOf(trId
					.getId()));
			service.removeTabularResource(id);
			return;
		} catch (Exception e) {
			logger.error(
					"Error removing TabularResource: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException("Error removing TabularResource: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public TabResource createTabularResource(TabResource tabResource)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			if (tabResource == null) {
				logger.error("Error creating new TabularResource: tabResource is null");
				throw new TDGWTServiceException(
						"Error creating new TabularResource no parameters set");
			}

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResource serviceTR = service.createTabularResource();
			Table table = service.getLastTable(serviceTR.getId());
			syncTRMetaData(serviceTR, tabResource);
			TRId trId = new TRId(String.valueOf(serviceTR.getId().getValue()),
					String.valueOf(table.getId().getValue()), table
							.getTableType().getName());
			tabResource.setTrId(trId);
			return tabResource;
		} catch (Exception e) {
			logger.error(
					"Error creating new TabularResource: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error creating new TabularResource: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public ArrayList<Codelist> getCodelists() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			return SessionUtil.retrieveCodelists(session);
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving codelists: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public ArrayList<Dataset> getDatasets() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			return SessionUtil.retrieveDatasets(session);
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving datasets: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public ArrayList<Agencies> getAgencies() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			return SessionUtil.retrieveAgencies(session);
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving datasets: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * @param sdmxImportSession
	 * @return
	 */
	protected Map<String, Object> retrieveOperationParameters(
			SDMXImportSession sdmxImportSession) {

		Map<String, Object> map = new HashMap<String, Object>();

		Codelist codelist = sdmxImportSession.getSelectedCodelist();

		map.put(Constants.PARAMETER_AGENCY, codelist.getAgencyId());
		map.put(Constants.PARAMETER_ID, codelist.getId());
		map.put(Constants.PARAMETER_VERSION, codelist.getVersion());

		// TODO-GP: Get registry url from client

		SDMXRegistryDescriptor descriptor = new GCubeSDMXRegistryDescriptor();
		map.put(Constants.PARAMETER_REGISTRYBASEURL,
				descriptor.getUrl(SDMXRegistryInterfaceType.RESTV2_1));

		return map;

	}

	/**
	 * {@inheritDoc}
	 */
	public void startSDMXImport(SDMXImportSession sdmxImportSession)
			throws TDGWTServiceException {

		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setSDMXImportSession(session, sdmxImportSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			List<OperationDefinition> capabilities = service.getCapabilities();

			// Import SDMX Codelist takes id 200
			OperationDefinition importSDMXCodelistOperation = OperationDefinitionMap.map(
					OperationsId.SDMXCodelistImport.toString(), capabilities);

			TabResource sdmxImportTabResource = sdmxImportSession
					.getTabResource();

			TabularResource serviceTR = service.createTabularResource();

			syncTRMetaData(serviceTR, sdmxImportTabResource);

			TRId trId = new TRId(String.valueOf(serviceTR.getId().getValue()));
			sdmxImportTabResource.setTrId(trId);
			logger.debug(sdmxImportTabResource.toString());

			SessionUtil
					.setSDMXImportTabResource(session, sdmxImportTabResource);

			Map<String, Object> parameterInstance = retrieveOperationParameters(sdmxImportSession);

			OperationExecution invocation = new OperationExecution(
					importSDMXCodelistOperation.getOperationId(),
					parameterInstance);

			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR.getId());
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			SessionUtil.setSDMXImportTask(session, trTask);
			return;
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in Client Library Request: "
					+ e.getLocalizedMessage());
		}
	}

	

	

	/**
	 * {@inheritDoc}
	 */
	public SDMXImportMonitor getSDMXImportMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			// ASLSession aslSession = SessionUtil.getAslSession(session);
			Task task = SessionUtil.getSDMXImportTask(session);
			TabResource sdmxImportTabResource = SessionUtil
					.getSDMXImportTabResource(session);
			TRId trId = sdmxImportTabResource.getTrId();

			SDMXImportMonitor importMonitor = new SDMXImportMonitor();
			if (trId == null) {
				throw new TDGWTServiceException(
						"Error in importSDMX TabularResource Id null");
			} else {
				if (task == null) {
					throw new TDGWTServiceException(
							"Error in importSDMX task null");
				} else {
					logger.debug("Service task: " + task.toString());
					TaskStatus status = task.getStatus();
					if (status == null) {
						throw new TDGWTServiceException(
								"Error in importSDMX Status null");
					} else {
						logger.debug("Service Task.getStatus(): "
								+ task.getStatus());

						importMonitor
								.setStatus(TaskStateMap.map(task.getStatus()));

						switch (importMonitor.getStatus()) {
						case SUCCEDED:
							importMonitor.setProgress(task.getProgress());
							logger.debug("Task Result: " + task.getResult());
							Table table = task.getResult().getPrimaryTable();
							trId.setTableId(String.valueOf(table.getId()
									.getValue()));
							trId.setTableType(table.getTableType().getName());
							sdmxImportTabResource.setTrId(trId);
							SessionUtil.setSDMXImportTabResource(session,
									sdmxImportTabResource);
							SessionUtil.setTabResource(session,
									sdmxImportTabResource);

							SessionUtil.setTRId(session, trId);
							break;
						case FAILED:
							if (task.getResult() != null) {
								logger.debug("Task exception:"
										+ task.getErrorCause());
								importMonitor.setError(task.getErrorCause());
							} else {
								logger.debug("Task exception: Error In Import");
								importMonitor.setError(new Throwable(
										"Error In Import"));
							}
							importMonitor.setProgress(task.getProgress());
							break;
						case STOPPED:
							importMonitor.setError(new Throwable(
									"Not passed validation task stopped"));
							break;
						case ABORTED:
							break;
						case IN_PROGRESS:
							importMonitor.setProgress(task.getProgress());
							break;
						case VALIDATING_RULES:
							importMonitor.setProgress(task.getProgress());
							break;
						case INITIALIZING:
							break;
						default:
							break;
						}
					}
					SessionUtil.setSDMXImportTask(session, task);
				}

				importMonitor.setTrId(trId);
			}
			logger.debug("getSDMXImportMonitor(): " + importMonitor);
			return importMonitor;
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in importSDMX ImportMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	/**
	 * {@inheritDoc}
	 */
	public void setSDMXRegistrySource(SDMXRegistrySource sdmxRegistrySource)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setSDMXRegistrySource(session, sdmxRegistrySource);
			return;

		} catch (Exception e) {
			logger.error(
					"Error setting SDMXRegistrySource parameter: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error setting SDMXRegistrySource parameter: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public void setCSVSession(CSVImportSession importSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setCSVImportSession(session, importSession);
			return;

		} catch (Exception e) {
			logger.error(
					"Error setting SDMXImportSession parameter: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error setting SDMXImportSession parameter: "
							+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public FileUploadMonitor getFileUploadMonitor()
			throws TDGWTServiceException {

		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}
		FileUploadSession fileUploadSession = SessionUtil
				.getFileUploadSession(session);
		if (fileUploadSession == null) {
			throw new TDGWTServiceException(
					"Error retrieving the fileUploadSession: null");
		}
		return fileUploadSession.getFileUploadMonitor();
	}

	/**
	 * {@inheritDoc}
	 */
	public AvailableCharsetList getAvailableCharset()
			throws TDGWTServiceException {
		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}
		logger.info("Session:" + session.getId());
		String defaultEncoding = Charset.defaultCharset().displayName();
		ArrayList<String> charsetList = new ArrayList<String>(Charset
				.availableCharsets().keySet());
		return new AvailableCharsetList(charsetList, defaultEncoding);
	}

	public ArrayList<String> configureCSVParser(String encoding,
			HeaderPresence headerPresence, char delimiter, char comment)
			throws TDGWTServiceException {
		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}
		logger.info("Session:" + session.getId());
		logger.info("configureCSVParser  encoding: " + encoding
				+ " headerPresence: " + headerPresence + " delimiter: "
				+ delimiter + " comment: " + comment);

		FileUploadSession fileUploadSession = SessionUtil
				.getFileUploadSession(session);
		if (fileUploadSession == null) {
			throw new TDGWTServiceException(
					"Error retrieving the fileUploadSession: null");
		}
		CSVParserConfiguration parserConfiguration = fileUploadSession
				.getParserConfiguration();
		if (parserConfiguration == null) {
			parserConfiguration = new CSVParserConfiguration(
					Charset.forName(encoding), delimiter, comment,
					headerPresence);
			fileUploadSession.setParserConfiguration(parserConfiguration);
		} else {
			parserConfiguration.update(encoding, delimiter, comment,
					headerPresence);
		}
		SessionUtil.setFileUploadSession(session, fileUploadSession);
		try {
			return CSVFileUtil.getHeader(fileUploadSession.getCsvFile(),
					fileUploadSession.getParserConfiguration());
		} catch (Exception e) {
			logger.error("Error retrieving the CSV header", e);
			throw new TDGWTServiceException(
					"Error calculating the CSV header: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public ArrayList<CSVRowError> checkCSV(long errorsLimit)
			throws TDGWTServiceException {

		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}
		logger.info("Session:" + session.getId());
		FileUploadSession fileUploadSession = SessionUtil
				.getFileUploadSession(session);
		if (fileUploadSession == null) {
			throw new TDGWTServiceException(
					"Error retrieving the fileUploadSession: null");
		}

		try {
			return CSVFileUtil.checkCSV(fileUploadSession.getCsvFile(),
					fileUploadSession.getParserConfiguration(), errorsLimit);
		} catch (Exception e) {
			logger.error("Error checking the CSV file", e);
			throw new TDGWTServiceException("Error checking the CSV file: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public void startCSVImport(CSVImportSession csvImportSession)
			throws TDGWTServiceException {
		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}
		logger.info("Session:" + session.getId());

		ASLSession aslSession = SessionUtil.getAslSession(session);
		if (aslSession == null) {
			throw new TDGWTServiceException(
					"Error retrieving the asl session: null");
		}
		String user = aslSession.getUsername();
		logger.info("Session User:" + user);

		FileUploadSession fileUploadSession = SessionUtil
				.getFileUploadSession(session);
		if (fileUploadSession == null) {
			throw new TDGWTServiceException(
					"Error retrieving the fileUploadSession: null");
		}

		importCSVFileOnService(session, aslSession, user, fileUploadSession,
				csvImportSession);

	}

	/**
	 * 
	 * @param fileUrlOnStorage
	 * @param fileUploadSession
	 * @param csvImportSession
	 * @return
	 */
	protected Map<String, Object> csvImportFileParameter(
			String fileUrlOnStorage, FileUploadSession fileUploadSession,
			CSVImportSession csvImportSession) {
		Map<String, Object> parameterInstances = new HashMap<String, Object>();
		parameterInstances.put(Constants.PARAMETER_URL, fileUrlOnStorage);
		parameterInstances.put(Constants.PARAMETER_SEPARATOR, String
				.valueOf(fileUploadSession.getParserConfiguration()
						.getDelimiter()));// ','
		parameterInstances.put(Constants.PARAMETER_ENCODING, fileUploadSession
				.getParserConfiguration().getCharset().name());// "UTF-8"
		boolean hasHeader = true;
		if (fileUploadSession.getParserConfiguration().getHeaderPresence() == HeaderPresence.NONE) {
			hasHeader = false;
		}
		parameterInstances.put(Constants.PARAMETER_HASHEADER, hasHeader);// true
		return parameterInstances;
	}

	/**
	 * 
	 * @param user
	 * @param fileUploadSession
	 * @param csvImportSession
	 * @throws TDGWTServiceException
	 */
	protected void importCSVFileOnService(HttpSession session,
			ASLSession aslSession, String user,
			FileUploadSession fileUploadSession,
			CSVImportSession csvImportSession) throws TDGWTServiceException {
		logger.debug("File Storage Access");

		logger.debug("CSVImportSession skip:"
				+ csvImportSession.isSkipInvalidLines());

		if (csvImportSession.isSkipInvalidLines()) {
			try {
				fileUploadSession.setCsvFile(CSVFileUtil.skipError(
						fileUploadSession.getCsvFile(),
						fileUploadSession.getParserConfiguration()));
			} catch (ParseException e) {
				logger.debug("Error parsing file for skip:" + e.getMessage());
				throw new TDGWTServiceException("Error parsing file for skip: "
						+ e.getMessage());

			} catch (IOException e) {
				logger.debug("Error IOException skipping file error: "
						+ e.getMessage());
				throw new TDGWTServiceException(
						"Error IOException skipping file error: "
								+ e.getMessage());

			}
		}

		FilesStorage filesStorage = new FilesStorage();

		String fileUrlOnStorage = filesStorage.storageCSVTempFile(user,
				fileUploadSession.getCsvFile());
		logger.debug("File Url On Storage:" + fileUrlOnStorage);

		Map<String, Object> parameterInstance = csvImportFileParameter(
				fileUrlOnStorage, fileUploadSession, csvImportSession);

		logger.debug("Tabular Data Service");

		AuthorizationProvider.instance.set(new AuthorizationToken(aslSession
				.getUsername()));
		TabularDataService service = TabularDataServiceFactory.getService();

		List<OperationDefinition> capabilities = service.getCapabilities();

		// Import CSV file

		OperationDefinition importCSVFileOperation = OperationDefinitionMap.map(
				OperationsId.CSVImport.toString(), capabilities);

		OperationExecution invocation = new OperationExecution(
				importCSVFileOperation.getOperationId(), parameterInstance);

		logger.debug("OperationInvocation: \n" + invocation.toString());
		TabularResource tabularResource = service.createTabularResource();
		TabResource csvImportTabResource = csvImportSession.getTabResource();
		syncTRMetaData(tabularResource, csvImportTabResource);
		TRId trId = new TRId(String.valueOf(tabularResource.getId().getValue()));
		csvImportTabResource.setTrId(trId);
		logger.debug(csvImportTabResource.toString());
		SessionUtil.setCSVImportTabResource(session, csvImportTabResource);
		Task trTask;
		try {
			trTask = service.execute(invocation, tabularResource.getId());
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Tabular Data Service error creating TabularResource: "
							+ e.getLocalizedMessage());
		}

		logger.debug("Start Task on service: TaskId " + trTask.getId());
		SessionUtil.setCSVImportFileTask(session, trTask);

	}

	/**
	 * {@inheritDoc}
	 */
	public CSVImportMonitor getCSVImportMonitor() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			// ASLSession aslSession = SessionUtil.getAslSession(session);
			Task task = SessionUtil.getCSVImportFileTask(session);
			TabResource csvImportTabResource = SessionUtil
					.getCSVImportTabResource(session);
			TRId trId = csvImportTabResource.getTrId();

			CSVImportMonitor importMonitor = new CSVImportMonitor();
			if (trId == null) {
				throw new TDGWTServiceException(
						"Error in importCSV TabularResource Id null");
			} else {
				if (task == null) {
					logger.debug("Task null");
					throw new TDGWTServiceException(
							"Error in importCSV task null");
				} else {
					TaskStatus status = task.getStatus();
					if (status == null) {
						throw new TDGWTServiceException(
								"Error in importCSV Status null");
					} else {
						logger.debug("Status: " + task.getStatus());

						importMonitor
								.setStatus(TaskStateMap.map(task.getStatus()));
						switch (importMonitor.getStatus()) {
						case FAILED:
							if (task.getResult() != null) {
								logger.debug("Task exception:"
										+ task.getErrorCause());
								importMonitor.setError(task.getErrorCause());
							} else {
								logger.debug("Task exception: Error In Import");
								importMonitor.setError(new Throwable(
										"Error In Import"));
							}
							importMonitor.setProgress(task.getProgress());
							break;
						case SUCCEDED:
							logger.debug("Task Result: " + task.getResult());
							importMonitor.setProgress(task.getProgress());
							Table table = task.getResult().getPrimaryTable();
							logger.debug("Table retrived: " + table.toString());
							trId.setTableId(String.valueOf(table.getId()
									.getValue()));
							trId.setTableType(table.getTableType().getName());
							csvImportTabResource.setTrId(trId);
							SessionUtil.setCSVImportTabResource(session,
									csvImportTabResource);
							logger.debug("Import CSV Succeded TabResource Set:"
									+ csvImportTabResource);
							SessionUtil.setTabResource(session,
									csvImportTabResource);
							SessionUtil.setTRId(session, trId);
							break;
						case STOPPED:
							importMonitor.setError(new Throwable(
									"Not passed validation task stopped"));
							break;
						case IN_PROGRESS:
							importMonitor.setProgress(task.getProgress());
							break;
						case VALIDATING_RULES:
							importMonitor.setProgress(task.getProgress());
							break;
						case ABORTED:
							break;
						case INITIALIZING:
							break;
						default:
							break;
						}
					}
					SessionUtil.setCSVImportFileTask(session, task);
				}

				importMonitor.setTrId(trId);
			}
			logger.info("getImportMonitor(): " + importMonitor);
			return importMonitor;
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in importCSV CSVImportMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public void getFileFromWorkspace(CSVImportSession csvImportSession)
			throws TDGWTServiceException {
		// TODO Auto-generated method stub
		HttpSession session = this.getThreadLocalRequest().getSession();
		ASLSession aslSession = SessionUtil.getAslSession(session);
		Workspace w = null;
		WorkspaceItem wi = null;

		try {
			HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();

			HomeManager manager = factory.getHomeManager();

			Home home = manager.getHome(aslSession.getUsername());

			w = home.getWorkspace();
			wi = w.getItem(csvImportSession.getItemId());
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in importCSV getFileFromWorkspace accessing the workspace: "
							+ e.getLocalizedMessage(), e);
		}

		if (wi == null) {
			logger.error("Error retrieving the item on workspace"
					+ csvImportSession.getItemId());
			throw new TDGWTServiceException(
					"Error retrieving the item on workspace"
							+ csvImportSession.getItemId());
		}

		try {
			logger.debug("WorkspaceItem [id:" + wi.getId() + " name:"
					+ wi.getName() + " remotePath:" + wi.getRemotePath() + "]");
		} catch (InternalErrorException e1) {
			e1.printStackTrace();
			throw new TDGWTServiceException(
					"Error retrieving the item on workspace" + wi);
		}

		FileUploadSession fileUploadSession = new FileUploadSession();
		CSVImportMonitor csvImportMonitor = new CSVImportMonitor();
		FileUploadMonitor fileUploadMonitor = new FileUploadMonitor();

		fileUploadSession.setId(session.getId());
		fileUploadSession.setFileUploadState(FileUploadState.STARTED);
		fileUploadSession.setCsvImportMonitor(csvImportMonitor);
		fileUploadSession.setFileUploadMonitor(fileUploadMonitor);

		SessionUtil.setFileUploadSession(session, fileUploadSession);

		try {
			FilesStorage filesStorage = new FilesStorage();
			InputStream is = filesStorage.retriveImputStream(
					aslSession.getUsername(), wi);

			FileUtil.setImportFile(fileUploadSession, is, wi.getName(),
					"text/csv");
		} catch (Exception e) {
			fileUploadSession/**
			 * Get informations on tabular resource
			 * 
			 * @return
			 * @throws TDGWTServiceException
			 */
			.getFileUploadMonitor().setFailed(
					"An error occured elaborating the file",
					FileUtil.exceptionDetailMessage(e));
			fileUploadSession.setFileUploadState(FileUploadState.FAILED);
			SessionUtil.setFileUploadSession(session, fileUploadSession);
			logger.error("Error elaborating the imput stream", e);
			throw new TDGWTServiceException(
					"Error in importCSV getFileFromWorkspace: "
							+ e.getLocalizedMessage(), e);
		}

		logger.trace("changing state");
		fileUploadSession.getFileUploadMonitor().setState(
				FileUploadState.COMPLETED);
		SessionUtil.setFileUploadSession(session, fileUploadSession);
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public String getTRCreationDate(TRId trId) throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("GetTRMetadata on " + trId.toString());

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResource tr = service
					.getTabularResource(new TabularResourceId(Long.valueOf(trId
							.getId())));

			return sdf.format(tr.getCreationDate().getTime());

		} catch (Exception e) {
			logger.error(
					"Error in getTRCreationDate(): " + e.getLocalizedMessage(),
					e);
			throw new TDGWTServiceException("Error in getTRCreationDate(): "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public ArrayList<TRMetadata> getTRMetadata(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("GetTRMetadata on " + trId.toString());

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			TabularResource tr = service
					.getTabularResource(new TabularResourceId(Long.valueOf(trId
							.getId())));

			Collection<TabularResourceMetadata> trMetas = tr.getAllMetadata();

			logger.debug("GetTRMetadata size: " + trMetas.size());
			ArrayList<TRMetadata> listTRMetadata = new ArrayList<TRMetadata>();

			for (TabularResourceMetadata trMetadata : trMetas) {
				if (trMetadata instanceof org.gcube.data.analysis.tabulardata.service.tabular.metadata.DescriptionMetadata) {
					TRDescriptionMetadata trDescriptionMetadata = new TRDescriptionMetadata();
					trDescriptionMetadata
							.setValue(((org.gcube.data.analysis.tabulardata.service.tabular.metadata.DescriptionMetadata) trMetadata)
									.getValue());
					listTRMetadata.add(trDescriptionMetadata);
				} else {
					if (trMetadata instanceof org.gcube.data.analysis.tabulardata.service.tabular.metadata.NameMetadata) {
						TRNameMetadata trNameMetadata = new TRNameMetadata();
						trNameMetadata
								.setValue(((org.gcube.data.analysis.tabulardata.service.tabular.metadata.NameMetadata) trMetadata)
										.getValue());
						listTRMetadata.add(trNameMetadata);
					} else {
						if (trMetadata instanceof AgencyMetadata) {
							TRAgencyMetadata trAgencyMetadata = new TRAgencyMetadata();
							trAgencyMetadata
									.setValue(((AgencyMetadata) trMetadata)
											.getValue());
							listTRMetadata.add(trAgencyMetadata);
						} else {
							if (trMetadata instanceof RightsMetadata) {
								TRRightsMetadata trRightsMetadata = new TRRightsMetadata();
								trRightsMetadata
										.setValue(((RightsMetadata) trMetadata)
												.getValue());
								listTRMetadata.add(trRightsMetadata);
							} else {

							}

						}
					}
				}
			}

			logger.debug("GetTRMetadata retrived: " + listTRMetadata.size());
			return listTRMetadata;

		} catch (Exception e) {
			logger.error(
					"Error in getTRMetadata(): " + e.getLocalizedMessage(), e);
			throw new TDGWTServiceException("Error in getTableMetadata(): "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public ArrayList<TabMetadata> getTableMetadata(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("GetTableMetadata on " + trId.toString());
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			Table table = service.getTable(new TableId(Long.valueOf(trId
					.getTableId())));

			Collection<TableMetadata> cMeta = table.getAllMetadata();

			ArrayList<TabMetadata> listTabMetadata = new ArrayList<TabMetadata>();
			logger.debug("Metadata size:" + cMeta.size());
			for (TableMetadata tMetadata : cMeta) {
				if (tMetadata instanceof DescriptionsMetadata) {
					TabDescriptionsMetadata trDescriptionsMetadata = new TabDescriptionsMetadata();
					ArrayList<TRLocalizedText> listTRLocalizedText = new ArrayList<TRLocalizedText>();
					List<LocalizedText> lLocalizedText = ((DescriptionsMetadata) tMetadata)
							.getTexts();
					int i = 0;
					for (LocalizedText lt : lLocalizedText) {
						TRLocalizedText trLocalizedText = new TRLocalizedText();
						trLocalizedText.setId(i);
						trLocalizedText.setValue(lt.getValue());
						trLocalizedText.setLocaleCode(lt.getLocale());
						listTRLocalizedText.add(trLocalizedText);
						i++;
					}
					trDescriptionsMetadata
							.setListTRLocalizedText(listTRLocalizedText);
					listTabMetadata.add(trDescriptionsMetadata);

				} else {
					if (tMetadata instanceof NamesMetadata) {
						TabNamesMetadata trNamesMetadata = new TabNamesMetadata();
						ArrayList<TRLocalizedText> listTRLocalizedText = new ArrayList<TRLocalizedText>();
						List<LocalizedText> lLocalizedText = ((NamesMetadata) tMetadata)
								.getTexts();
						int i = 0;
						for (LocalizedText lt : lLocalizedText) {
							TRLocalizedText trLocalizedText = new TRLocalizedText();
							trLocalizedText.setId(i);
							trLocalizedText.setValue(lt.getValue());
							trLocalizedText.setLocaleCode(lt.getLocale());
							listTRLocalizedText.add(trLocalizedText);
							i++;
						}
						trNamesMetadata
								.setListTRLocalizedText(listTRLocalizedText);
						listTabMetadata.add(trNamesMetadata);

					} else {
						if (tMetadata instanceof VersionMetadata) {
							TabVersionMetadata trVersionMetadata = new TabVersionMetadata();
							trVersionMetadata
									.setVersion(((VersionMetadata) tMetadata)
											.getVersion());
							listTabMetadata.add(trVersionMetadata);
						} else {
							if (tMetadata instanceof ExportMetadata) {
								TabExportMetadata trExportMetadata = new TabExportMetadata();
								trExportMetadata
										.setDestinationType(((ExportMetadata) tMetadata)
												.getDestinationType());
								trExportMetadata.setExportDate(sdf
										.format(((ExportMetadata) tMetadata)
												.getExportDate()));
								trExportMetadata
										.setUrl(((ExportMetadata) tMetadata)
												.getUri());
								listTabMetadata.add(trExportMetadata);
							} else {
								if (tMetadata instanceof ImportMetadata) {
									TabImportMetadata trImportMetadata = new TabImportMetadata();
									trImportMetadata
											.setSourceType(((ImportMetadata) tMetadata)
													.getSourceType());
									trImportMetadata
											.setImportDate(sdf
													.format(((ImportMetadata) tMetadata)
															.getImportDate()));
									trImportMetadata
											.setUrl(((ImportMetadata) tMetadata)
													.getUri());
									listTabMetadata.add(trImportMetadata);
								} else {
									if (tMetadata instanceof GenericMapMetadata) {
										TabGenericMapMetadata trGenericMapMetadata = new TabGenericMapMetadata();
										trGenericMapMetadata
												.setMetadataMap((HashMap<String, String>) ((GenericMapMetadata) tMetadata)
														.getMetadataMap());
										listTabMetadata
												.add(trGenericMapMetadata);
									} else {

									}

								}
							}
						}
					}
				}
			}

			return listTabMetadata;

		} catch (Exception e) {
			logger.error(
					"Error in getTableMetadata(): " + e.getLocalizedMessage(),
					e);
			throw new TDGWTServiceException("Error in getTableMetadata(): "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * @param exportSession
	 * @return
	 */
	protected Map<String, Object> csvExportFileParameter(
			CSVExportSession exportSession) {
		Map<String, Object> parameterInstances = new HashMap<String, Object>();
		parameterInstances.put(Constants.PARAMETER_ENCODING,
				exportSession.getEncoding());
		parameterInstances.put(Constants.PARAMETER_SEPARATOR,
				exportSession.getSeparator());
		parameterInstances.put(Constants.PARAMETER_COLUMNS,
				exportSession.getColumnsAsArrayOfString());
		return parameterInstances;
	}

	/**
	 * 
	 * @param exportSession
	 * @return
	 */
	protected Map<String, Object> sdmxExportParameter(
			SDMXExportSession exportSession) throws TDGWTServiceException {
		boolean internalRegistry = false;
		String destination = null;// Es:
									// http://pc-fortunati.isti.cnr.it:8080/FusionRegistry/ws/rest/

		if (exportSession != null) {
			if (exportSession.getRegistryBaseUrl() != null
					&& !exportSession.getRegistryBaseUrl().isEmpty()) {
				destination = exportSession.getRegistryBaseUrl();
			} else {
				internalRegistry = true;
			}
		} else {
			internalRegistry = true;
		}

		if (internalRegistry) {
			SimpleQuery query = queryFor(ServiceEndpoint.class);
			query.addCondition("$resource/Profile/Category/text() eq 'SDMX'")
					.addCondition(
							"$resource/Profile/Name/text() eq 'SDMXRegistry'");
			DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
			List<ServiceEndpoint> listService = client.submit(query);
			if (listService.size() > 0) {
				ServiceEndpoint serviceEnd = listService.get(0);
				if (serviceEnd != null) {
					Profile prof = serviceEnd.profile();
					Group<AccessPoint> groupA = prof.accessPoints();
					for (AccessPoint acc : groupA) {
						if (acc.description().compareTo("REST Interface v2.1") == 0) {
							destination = acc.address();
							break;
						}
					}
				} else {

				}
			} else {

			}
		}
		if (destination == null) {
			logger.debug("Destination: " + destination);
			throw new TDGWTServiceException("SDMX Service not discovered");
		}

		Map<String, Object> parameterInstances = new HashMap<String, Object>();
		parameterInstances
				.put(Constants.PARAMETER_REGISTRYBASEURL, destination);
		parameterInstances.put(Constants.PARAMETER_AGENCY, "SDMX");
		parameterInstances.put(Constants.PARAMETER_ID, "NEW_CL_DIVISION");
		parameterInstances.put(Constants.PARAMETER_VERSION, "2.0");
		return parameterInstances;
	}

	/**
	 * 
	 * @param exportSession
	 * @return
	 */
	public void startSDMXExport(SDMXExportSession exportSession)
			throws TDGWTServiceException {
		logger.debug("Start SDMX Export");
		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}
		logger.info("Session:" + session.getId());

		ASLSession aslSession = SessionUtil.getAslSession(session);
		if (aslSession == null) {
			throw new TDGWTServiceException(
					"Error retrieving the asl session: null");
		}
		String user = aslSession.getUsername();
		logger.info("Session User:" + user);

		TRId trId = SessionUtil.getTRId(session);
		if (trId == null) {
			throw new TDGWTServiceException(
					"Error no tabular resource in session");
		}

		if (trId.getTableId() == null) {
			throw new TDGWTServiceException("Error no table present in session");
		}

		SessionUtil.setSDMXExportSession(session, exportSession);

		Map<String, Object> parameterInstance = sdmxExportParameter(exportSession);

		logger.debug("Tabular Data Service");

		AuthorizationProvider.instance.set(new AuthorizationToken(aslSession
				.getUsername()));
		TabularDataService service = TabularDataServiceFactory.getService();

		List<OperationDefinition> capabilities = service.getCapabilities();

		// Export SDMX Codelist
		OperationDefinition exportSDMXOperation = OperationDefinitionMap.map(
				OperationsId.SDMXCodelistExport.toString(), capabilities);

		OperationExecution invocation = new OperationExecution(
				exportSDMXOperation.getOperationId(), parameterInstance);

		logger.debug("OperationInvocation: \n" + invocation.toString());

		Task trTask;
		try {
			trTask = service.execute(invocation,
					new TabularResourceId(Long.valueOf(trId.getId())));
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Tabular Data Service error exporting TabularResource: "
							+ e.getLocalizedMessage());
		}

		logger.debug("Start Task on service: TaskId " + trTask.getId());
		SessionUtil.setSDMXExportTask(session, trTask);
	}

	/**
	 * {@inheritDoc}
	 */
	public SDMXExportMonitor getSDMXExportMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			// ASLSession aslSession = SessionUtil.getAslSession(session);
			Task task = SessionUtil.getSDMXExportTask(session);
			SDMXExportMonitor exportMonitor = new SDMXExportMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException("Error in exportSDMX task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					throw new TDGWTServiceException(
							"Error in exportSDMX Status null");
				} else {
					logger.debug("Status: " + task.getStatus());

					exportMonitor.setStatus(TaskStateMap.map(task.getStatus()));
					switch (exportMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							exportMonitor.setError(task.getErrorCause());
						} else {
							logger.debug("Task exception: Error In Export");
							exportMonitor.setError(new Throwable(
									"Error In Export"));
						}
						exportMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						exportMonitor.setProgress(task.getProgress());
						Table table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						ExportMetadata exportMetadata = table
								.getMetadata(ExportMetadata.class);
						logger.debug("ExportMetadata: " + exportMetadata);

						exportMonitor.setTrId(SessionUtil.getTRId(session));
						TabExportMetadata tabExportMetadata = new TabExportMetadata();
						tabExportMetadata.setUrl(exportMetadata.getUri());
						tabExportMetadata.setDestinationType(exportMetadata
								.getDestinationType());
						tabExportMetadata.setExportDate(sdf
								.format(exportMetadata.getExportDate()));
						exportMonitor.setTabExportMetadata(tabExportMetadata);
						break;
					case STOPPED:
						exportMonitor.setError(new Throwable(
								"Not passed validation task stopped"));
						break;
					case IN_PROGRESS:
						exportMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						exportMonitor.setProgress(task.getProgress());
						break;
					case ABORTED:
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setSDMXExportTask(session, task);
			}

			logger.info("getExportMonitor(): " + exportMonitor);
			return exportMonitor;
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in exportSDMX SDMXExportMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public void startCSVExport(CSVExportSession exportSession)
			throws TDGWTServiceException {
		logger.debug("Start CSV Export");
		HttpSession session = this.getThreadLocalRequest().getSession();
		if (session == null) {
			throw new TDGWTServiceException(
					"Error retrieving the session: null");
		}
		logger.info("Session:" + session.getId());

		ASLSession aslSession = SessionUtil.getAslSession(session);
		if (aslSession == null) {
			throw new TDGWTServiceException(
					"Error retrieving the asl session: null");
		}
		String user = aslSession.getUsername();
		logger.info("Session User:" + user);

		TRId trId = SessionUtil.getTRId(session);
		if (trId == null) {
			throw new TDGWTServiceException(
					"Error no tabular resource in session");
		}

		if (trId.getTableId() == null) {
			throw new TDGWTServiceException("Error no table present in session");
		}

		SessionUtil.setCSVExportSession(session, exportSession);

		Map<String, Object> parameterInstance = csvExportFileParameter(exportSession);

		logger.debug("Tabular Data Service");

		AuthorizationProvider.instance.set(new AuthorizationToken(aslSession
				.getUsername()));
		TabularDataService service = TabularDataServiceFactory.getService();

		List<OperationDefinition> capabilities = service.getCapabilities();

		// Export CSV file
		OperationDefinition exportCSVFileOperation = OperationDefinitionMap.map(
				OperationsId.CSVExport.toString(), capabilities);

		OperationExecution invocation = new OperationExecution(
				exportCSVFileOperation.getOperationId(), parameterInstance);

		logger.debug("OperationInvocation: \n" + invocation.toString());

		Task trTask;
		try {
			trTask = service.execute(invocation,
					new TabularResourceId(Long.valueOf(trId.getId())));
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Tabular Data Service error exporting TabularResource: "
							+ e.getLocalizedMessage());
		}

		logger.debug("Start Task on service: TaskId " + trTask.getId());
		SessionUtil.setCSVExportEnd(session, false);
		SessionUtil.setCSVExportTask(session, trTask);

	}

	/**
	 * {@inheritDoc}
	 */
	public CSVExportMonitor getCSVExportMonitor() throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);
			CSVExportSession exportSession = SessionUtil
					.getCSVExportSession(session);
			Task task = SessionUtil.getCSVExportTask(session);
			CSVExportMonitor exportMonitor = new CSVExportMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException("Error in exportCSV task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in exportCSV Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					exportMonitor.setStatus(TaskStateMap.map(task.getStatus()));
					switch (exportMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							exportMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In Export");
							exportMonitor.setError(new Throwable(
									"Error In Export"));
						}
						exportMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						exportMonitor.setProgress(task.getProgress());
						Table table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						ExportMetadata exportMetadata = table
								.getMetadata(ExportMetadata.class);
						logger.debug("ExportMetadata: " + exportMetadata);

						exportMonitor.setTrId(SessionUtil.getTRId(session));
						TabExportMetadata trExportMetadata = new TabExportMetadata();
						trExportMetadata.setUrl(exportMetadata.getUri());
						trExportMetadata.setDestinationType(exportMetadata
								.getDestinationType());
						trExportMetadata.setExportDate(sdf
								.format(exportMetadata.getExportDate()));
						exportMonitor.setTrExportMetadata(trExportMetadata);
						saveInDestination(session, aslSession.getUsername(),
								exportMetadata, exportSession);

						break;
					case IN_PROGRESS:
						exportMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						exportMonitor.setProgress(task.getProgress());
						break;
					case ABORTED:
						break;
					case STOPPED:
						exportMonitor.setError(new Throwable(
								"Not passed validation task stopped"));
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setCSVExportTask(session, task);
			}

			logger.info("getExportMonitor(): " + exportMonitor);
			return exportMonitor;
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in exportCSV CSVExportMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	protected void saveInDestination(HttpSession session, String user,
			ExportMetadata exportMetadata, CSVExportSession exportSession)
			throws TDGWTServiceException {
		logger.debug("Save Export In Destination");
		logger.debug("Destination: " + exportSession.getDestination().getId());
		if (exportSession.getDestination().getId().compareTo("Workspace") == 0) {
			logger.debug("Save on Workspace");
			boolean end = SessionUtil.getCSVExportEnd(session);
			if (end == false) {
				SessionUtil.setCSVExportEnd(session, true);
				FilesStorage storage = new FilesStorage();
				logger.debug("Create Item On Workspace: [ uri: "
						+ exportMetadata.getUri() + " ,user: " + user
						+ " ,fileName: " + exportSession.getFileName()
						+ " ,fileDescription: "
						+ exportSession.getFileDescription()
						+ " ,mimetype: text/csv" + " ,folder: "
						+ exportSession.getItemId() + "]");
				storage.createItemOnWorkspace(exportMetadata.getUri(), user,
						exportSession.getFileName(),
						exportSession.getFileDescription(), "text/csv",
						exportSession.getItemId());

			} else {
				logger.debug("getCSVExportEnd(): true");
			}
		} else {
			logger.error("Destination No Present");
			throw new TDGWTServiceException(
					"Error in exportCSV CSVExportMonitor: no destination present");
		}
	}

	/**
	 * Retrieve OperationExecution for change column type
	 * 
	 * @param changeColumnTypeSession
	 * @return
	 */
	protected OperationExecution retriveOperationExecution(
			TabularDataService service,
			ChangeColumnTypeSession changeColumnTypeSession)
			throws TDGWTServiceException {

		OperationExecution invocation = null;
		List<OperationDefinition> capabilities = service.getCapabilities();

		logger.debug(changeColumnTypeSession.toString());
		OperationDefinition operationDefinition;
		Map<String, Object> map = new HashMap<String, Object>();

		if (changeColumnTypeSession.getColumnTypeCodeTarget().compareTo(
				ColumnTypeCode.MEASURE) == 0) {
			operationDefinition = OperationDefinitionMap.map(
					OperationsId.ChangeToMeasureColumn.toString(), capabilities);

			map.put(Constants.PARAMETER_TARGET_DATA_TYPE, ColumnDataTypeMap
					.map(changeColumnTypeSession.getColumnDataTypeTarget()));
			invocation = new OperationExecution(changeColumnTypeSession
					.getColumnData().getColumnId(),
					operationDefinition.getOperationId(), map);
		} else {
			if (changeColumnTypeSession.getColumnTypeCodeTarget().compareTo(
					ColumnTypeCode.ATTRIBUTE) == 0) {
				operationDefinition = OperationDefinitionMap.map(
						OperationsId.ChangeToAttributeColumn.toString(),
						capabilities);

				map.put(Constants.PARAMETER_TARGET_DATA_TYPE, ColumnDataTypeMap
						.map(changeColumnTypeSession.getColumnDataTypeTarget()));
				invocation = new OperationExecution(changeColumnTypeSession
						.getColumnData().getColumnId(),
						operationDefinition.getOperationId(), map);
			} else {
				if (changeColumnTypeSession.getColumnTypeCodeTarget()
						.compareTo(ColumnTypeCode.CODE) == 0) {
					operationDefinition = OperationDefinitionMap.map(
							OperationsId.ChangeToCodeColumn.toString(),
							capabilities);
					invocation = new OperationExecution(changeColumnTypeSession
							.getColumnData().getColumnId(),
							operationDefinition.getOperationId(), map);
				} else {
					if (changeColumnTypeSession.getColumnTypeCodeTarget()
							.compareTo(ColumnTypeCode.CODENAME) == 0) {
						operationDefinition = OperationDefinitionMap.map(
								OperationsId.ChangeToCodeName.toString(),
								capabilities);
						invocation = new OperationExecution(
								changeColumnTypeSession.getColumnData()
										.getColumnId(),
								operationDefinition.getOperationId(), map);
					} else {
						if (changeColumnTypeSession.getColumnTypeCodeTarget()
								.compareTo(ColumnTypeCode.CODEDESCRIPTION) == 0) {
							operationDefinition = OperationDefinitionMap.map(
									OperationsId.ChangeToCodeDescription
											.toString(),
									capabilities);
							invocation = new OperationExecution(
									changeColumnTypeSession.getColumnData()
											.getColumnId(),
									operationDefinition.getOperationId(), map);
						} else {
							if (changeColumnTypeSession
									.getColumnTypeCodeTarget().compareTo(
											ColumnTypeCode.ANNOTATION) == 0) {
								operationDefinition = OperationDefinitionMap.map(
										OperationsId.ChangeToAnnotationColumn
												.toString(),
										capabilities);
								invocation = new OperationExecution(
										changeColumnTypeSession.getColumnData()
												.getColumnId(),
										operationDefinition.getOperationId(),
										map);
							} else {
								if (changeColumnTypeSession
										.getColumnTypeCodeTarget().compareTo(
												ColumnTypeCode.DIMENSION) == 0) {
								} else {
									if (changeColumnTypeSession
											.getColumnTypeCodeTarget()
											.compareTo(
													ColumnTypeCode.TIMEDIMENSION) == 0) {
									} else {

									}
								}
							}
						}

					}
				}
			}
		}

		return invocation;
	}

	
	protected OperationExecution retriveOperationExecution(
			TabularDataService service, DeleteColumnSession deleteColumnSession)
			throws TDGWTServiceException {

		OperationExecution invocation = null;
		List<OperationDefinition> capabilities = service.getCapabilities();

		logger.debug(deleteColumnSession.toString());
		OperationDefinition operationDefinition;
		Map<String, Object> map = new HashMap<String, Object>();

		operationDefinition = OperationDefinitionMap.map(
				OperationsId.RemoveColumn.toString(), capabilities);

		invocation = new OperationExecution(deleteColumnSession
				.getColumnData().getColumnId(),
				operationDefinition.getOperationId(), map);

		return invocation;
	}
	
	
	protected OperationExecution retriveOperationExecution(
			TabularDataService service, LabelColumnSession labelColumnSession)
			throws TDGWTServiceException {

		OperationExecution invocation = null;
		List<OperationDefinition> capabilities = service.getCapabilities();

		logger.debug(labelColumnSession.toString());
		OperationDefinition operationDefinition;
		Map<String, Object> map = new HashMap<String, Object>();

		operationDefinition = OperationDefinitionMap.map(
				OperationsId.ChangeLabel.toString(), capabilities);

		invocation = new OperationExecution(labelColumnSession
				.getColumnData().getColumnId(),
				operationDefinition.getOperationId(), map);

		return invocation;
	}
	
	
	protected OperationExecution retriveOperationExecution(
			TabularDataService service, ChangeTableTypeSession changeTableTypeSession)
			throws TDGWTServiceException {

		OperationExecution invocation = null;
		List<OperationDefinition> capabilities = service.getCapabilities();

		logger.debug(changeTableTypeSession.toString());
		OperationDefinition operationDefinition;
		Map<String, Object> map = new HashMap<String, Object>();
		
		operationDefinition = OperationDefinitionMap.map(
				OperationsId.ChangeTableType.toString(), capabilities);
		map.put(Constants.PARAMETER_TABLE_TYPE, changeTableTypeSession.getTableType().toString());
		
		invocation = new OperationExecution(
				operationDefinition.getOperationId(), map);

		return invocation;
	}
	
	

	/**
	 * 
	 * {@inheritDoc}
	 */
	public void startChangeColumnType(
			ChangeColumnTypeSession changeColumnTypeSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setChangeColumnTypeSession(session,
					changeColumnTypeSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			OperationExecution invocation = retriveOperationExecution(service,
					changeColumnTypeSession);
			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error in ChangeColumnType: Operation not supported for now!");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(changeColumnTypeSession.getColumnData()
							.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			SessionUtil.setChangeColumnTypeTask(session, trTask);
			return;
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in ChangeColumnType: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public ChangeColumnTypeMonitor getChangeColumnTypeMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ChangeColumnTypeSession changeColumnTypeSession = SessionUtil
					.getChangeColumnTypeSession(session);

			Task task = SessionUtil.getChangeColumnTypeTask(session);
			ChangeColumnTypeMonitor changeColumnTypeMonitor = new ChangeColumnTypeMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in ChangeColumnType task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in ChangeColumnType Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					changeColumnTypeMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));
					switch (changeColumnTypeMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							changeColumnTypeMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In ChangeColumnType");
							changeColumnTypeMonitor.setError(new Throwable(
									"Error In ChangeColumnType"));
						}
						changeColumnTypeMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						changeColumnTypeMonitor.setProgress(task.getProgress());
						Table table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						TRId trId = new TRId();
						trId.setId(changeColumnTypeSession.getColumnData()
								.getTrId().getId());
						trId.setTableId(String
								.valueOf(table.getId().getValue()));
						trId.setTableType(table.getTableType().getName());
						changeColumnTypeMonitor.setTrId(trId);
						TabResource tabResource = SessionUtil
								.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						changeColumnTypeMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						changeColumnTypeMonitor.setProgress(task.getProgress());
						break;
					case ABORTED:
						break;
					case STOPPED:
						changeColumnTypeMonitor.setError(new Throwable(
								"Not passed validation task stopped"));
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setChangeColumnTypeTask(session, task);
			}

			logger.info("ChangeColumnTypeMonitor(): " + changeColumnTypeMonitor);
			return changeColumnTypeMonitor;
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in change column type ChangeColumnTypeMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public void startDeleteColumn(DeleteColumnSession deleteColumnSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setDeleteColumnSession(session, deleteColumnSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			OperationExecution invocation = retriveOperationExecution(service,
					deleteColumnSession);
			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error Delete Column: Operation not supported for now!");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(deleteColumnSession.getColumnData().getTrId()
							.getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			SessionUtil.setDeleteColumnTask(session, trTask);
			return;
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in DeleteColumn: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public DeleteColumnMonitor getDeleteColumnMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			DeleteColumnSession deleteColumnSession = SessionUtil
					.getDeleteColumnSession(session);

			Task task = SessionUtil.getDeleteColumnTask(session);
			DeleteColumnMonitor deleteColumnMonitor = new DeleteColumnMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in DeleteColumnMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in DeleteColumnMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					deleteColumnMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));
					switch (deleteColumnMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							deleteColumnMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In DeleteColumnMonitor");
							deleteColumnMonitor.setError(new Throwable(
									"Error Deleting Column"));
						}
						deleteColumnMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						deleteColumnMonitor.setProgress(task.getProgress());
						Table table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						TRId trId = new TRId();
						trId.setId(deleteColumnSession.getColumnData()
								.getTrId().getId());
						trId.setTableId(String
								.valueOf(table.getId().getValue()));
						trId.setTableType(table.getTableType().getName());
						deleteColumnMonitor.setTrId(trId);
						TabResource tabResource = SessionUtil
								.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						deleteColumnMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						deleteColumnMonitor.setProgress(task.getProgress());
						break;
					case ABORTED:
						break;
					case STOPPED:
						deleteColumnMonitor.setError(new Throwable(
								"Not passed validation task stopped"));
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setDeleteColumnTask(session, task);
			}

			logger.info("DeleteColumnMonitor(): " + deleteColumnMonitor);
			return deleteColumnMonitor;
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in delete column monitor DeleteColumnMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	
	/**
	 * 
	 * {@inheritDoc}
	 */
	public void startLabelColumn(LabelColumnSession labelColumnSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setLabelColumnSession(session, labelColumnSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			OperationExecution invocation = retriveOperationExecution(service,
					labelColumnSession);
			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error Changing the Column Label: Operation not supported for now!");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(labelColumnSession.getColumnData().getTrId()
							.getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			SessionUtil.setDeleteColumnTask(session, trTask);
			return;
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error Changing The Column Label: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public LabelColumnMonitor getLabelColumnMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			LabelColumnSession labelColumnSession = SessionUtil
					.getLabelColumnSession(session);

			Task task = SessionUtil.getLabelColumnTask(session);
			LabelColumnMonitor labelColumnMonitor = new LabelColumnMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in LabelColumnMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in LabelColumnMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					labelColumnMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));
					switch (labelColumnMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							labelColumnMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In LabelColumnMonitor");
							labelColumnMonitor.setError(new Throwable(
									"Error Changing the Column Label"));
						}
						labelColumnMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						labelColumnMonitor.setProgress(task.getProgress());
						Table table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						TRId trId = new TRId();
						trId.setId(labelColumnSession.getColumnData()
								.getTrId().getId());
						trId.setTableId(String
								.valueOf(table.getId().getValue()));
						trId.setTableType(table.getTableType().getName());
						labelColumnMonitor.setTrId(trId);
						TabResource tabResource = SessionUtil
								.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						labelColumnMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						labelColumnMonitor.setProgress(task.getProgress());
						break;
					case ABORTED:
						break;
					case STOPPED:
						labelColumnMonitor.setError(new Throwable(
								"Not passed validation task stopped"));
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setLabelColumnTask(session, task);
			}

			logger.info("LabelColumnMonitor(): " + labelColumnMonitor);
			return labelColumnMonitor;
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in delete column monitor LabelColumnMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	
	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void startChangeTableType(
			ChangeTableTypeSession changeTableTypeSession)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			SessionUtil.setChangeTableTypeSession(session, changeTableTypeSession);
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			TabularDataService service = TabularDataServiceFactory.getService();

			OperationExecution invocation = retriveOperationExecution(service,
					changeTableTypeSession);
			if (invocation == null) {
				throw new TDGWTServiceException(
						"Error Change Table Type invocation: Operation not supported");
			}

			TabularResourceId serviceTR = new TabularResourceId(
					Long.valueOf(changeTableTypeSession.getTrId().getId()));
			logger.debug("OperationInvocation: \n" + invocation.toString());
			Task trTask = service.execute(invocation, serviceTR);
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			SessionUtil.setChangeTableTypeTask(session, trTask);
			return;
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error Changing Table Type: "
					+ e.getLocalizedMessage());
		}
	}
	
	
	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ChangeTableTypeMonitor getChangeTableTypeMonitor()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ChangeTableTypeSession changeTableTypeSession = SessionUtil
					.getChangeTableTypeSession(session);

			Task task = SessionUtil.getChangeTableTypeTask(session);
			ChangeTableTypeMonitor changeTableTypeMonitor = new ChangeTableTypeMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new TDGWTServiceException(
						"Error in ChangeTableTypeMonitor task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new TDGWTServiceException(
							"Error in ChangeTableTypeMonitor Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					changeTableTypeMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));
					switch (changeTableTypeMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							changeTableTypeMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In ChangeTableTypeMonitor");
							changeTableTypeMonitor.setError(new Throwable(
									"Error Changing the Table Type"));
						}
						changeTableTypeMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						changeTableTypeMonitor.setProgress(task.getProgress());
						Table table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						TRId trId = new TRId();
						trId.setId(changeTableTypeSession.getTrId().getId());
						trId.setTableId(String
								.valueOf(table.getId().getValue()));
						trId.setTableType(table.getTableType().getName());
						changeTableTypeMonitor.setTrId(trId);
						TabResource tabResource = SessionUtil
								.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						changeTableTypeMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						changeTableTypeMonitor.setProgress(task.getProgress());
						break;
					case ABORTED:
						break;
					case STOPPED:
						changeTableTypeMonitor.setError(new Throwable(
								"Not passed validation task stopped"));
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				SessionUtil.setChangeTableTypeTask(session, task);
			}

			logger.info("ChangeTableTypeMonitor(): " + changeTableTypeMonitor);
			return changeTableTypeMonitor;
		} catch (Exception e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in change table type monitor ChangeTableTypeMonitor: "
							+ e.getLocalizedMessage());

		}

	}

	

	
	
	
	
}
