/**
 * 
 */
package org.gcube.portlets.user.td.gwtservice.client.rpc;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.td.gwtservice.shared.csv.AvailableCharsetList;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVRowError;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.file.FileUploadMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.file.HeaderPresence;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TRId;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TableData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.open.TDOpenSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Agencies;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Codelist;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Dataset;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * 
 * Implements the basic interfaces for access to the service.
 * 
 * <p>
 * Allows:  
 * <ul>
 * <li>Access to Tabular Resources</li>
 * <li>Import of CSV file</li>
 * <li>Import from SDMX Registry</li>
 * <ul>
 * </p>
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
@RemoteServiceRelativePath("TDGWTService")
public interface TDGWTService extends RemoteService {

	/**
	 * Get informations on the current tabular resource
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TabResource getTabResourceInformation() throws TDGWTServiceException;

	/**
	 * Set current tabular resource
	 * 
	 * @param tr
	 * @throws TDGWTServiceException
	 */
	public void setTabResource(TabResource tabResource) throws TDGWTServiceException;

	/**
	 * Creates a TabResource on Service
	 * 
	 * @param tabResource
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TabResource createTabularResource(TabResource tabResource)
			throws TDGWTServiceException;

	
	/**
	 * Return Last Table
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TableData getLastTable(TRId trId) throws TDGWTServiceException;
	
	
	/**
	 * Return Metadata
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
    public ArrayList<TRMetadata> getTableMetadata(TRId trId) throws TDGWTServiceException;
    
	
	// Open

	/**
	 * Return all tabular resource of a user
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public List<TabResource> getTabularResources() throws TDGWTServiceException;

	/**
	 * Set open session for return all tabular resource of a user
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void setTDOpenSession(TDOpenSession tdOpenSession) throws TDGWTServiceException;

	// Import SDMX

	/**
	 * Get Codelist on a registry
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<Codelist> getCodelists() throws TDGWTServiceException;

	/**
	 * Get Datasets on a registry
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<Dataset> getDatasets() throws TDGWTServiceException;

	/**
	 * Get Agecies on a registry
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<Agencies> getAgencies() throws TDGWTServiceException;

	/**
	 * Set SDMXImportSession for SDMX Import
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void setSDMXSession(SDMXImportSession sdmxImportSession)
			throws TDGWTServiceException;

	

	/**
	 * Start SDMX Import and invokes the client library
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void startSDMXImport(SDMXImportSession sdmxImportSession)
			throws TDGWTServiceException;

	
	/**
	 * Get Operation Monitor during the SDMX Import operation
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public SDMXImportMonitor getSDMXImportMonitor()
			throws TDGWTServiceException;
	
	// Import CSV
	/**
	 * Get File Upload Monitor during the file upload operation in Import CSV
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public FileUploadMonitor getFileUploadMonitor()
			throws TDGWTServiceException;
	
	/**
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void setCSVSession(CSVImportSession csvImportSession) throws TDGWTServiceException;


	/**
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void getFileFromWorkspace(CSVImportSession csvImportSession) throws TDGWTServiceException;

	
	/**
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public AvailableCharsetList getAvailableCharset()
			throws TDGWTServiceException;

	/**
	 * 
	 * @param encoding
	 * @param headerPresence
	 * @param delimiter
	 * @param comment
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<String> configureCSVParser(String encoding,
			HeaderPresence headerPresence, char delimiter, char comment)
			throws TDGWTServiceException;

	/**
	 * 
	 * @param errorsLimit
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<CSVRowError> checkCSV(long errorsLimit)
			throws TDGWTServiceException;

	/**
	 * Start CSV Import and invokes the client library
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void startCSVImport(CSVImportSession csvImportSession) throws TDGWTServiceException;

	/**
	 * Get Operation Monitor during the CSV Import operation
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public CSVImportMonitor getCSVImportMonitor() throws TDGWTServiceException;

}
