/**
 * 
 */
package org.gcube.portlets.user.td.gwtservice.server;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.user.td.gwtservice.server.file.FileUploadSession;
import org.gcube.portlets.user.td.gwtservice.server.trservice.TRTasksManager;
import org.gcube.portlets.user.td.gwtservice.shared.Constants;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.source.SDMXRegistrySource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TRId;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.open.TDOpenSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Agencies;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Codelist;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;



/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class SessionUtil {

	protected static final String CURRENT_TABULAR_RESOURCE = "CURRENT_TABULAR_RESOURCE";
	protected static final String CURRENT_TR_ID= "CURRENT_TR_ID";
	protected static final String TDOPEN_SESSION = "TDOPEN_SESSION";
	protected static final String TABULAR_RESOURCE_LIST = "TABULAR_RESOURCE_LIST";
	
	protected static final String TR_TASK_MANAGER= "TR_TASK_MANAGER";
	
	protected static final String SDMX_CLIENT_ATTRIBUTE = "SDMX_CLIENT";
	protected static final String SDMX_IMPORT_SESSION = "SDMX_IMPORT";
	protected static final String SDMX_IMPORT_TABULAR_RESOURCE = "SDMX_IMPORT_TABULAR_RESOURCE";
	protected static final String SDMX_IMPORT_TASK="SDMX_IMPORT_TASK";
	

	protected static final String CSV_IMPORT_SESSION = "CSV_IMPORT";
	protected static final String CSV_IMPORT_FILE_UPLOAD_SESSION = "CSV_IMPORT_FILE_UPLOAD";
	protected static final String CSV_IMPORT_TASK="CSV_IMPORT_TASK";
	protected static final String CSV_IMPORT_TABULAR_RESOURCE = "CSV_IMPORT_TABULAR_RESOURCE";
	
	protected static Logger logger = LoggerFactory.getLogger(SessionUtil.class);

	protected static ASLSession getAslSession(HttpSession httpSession) {
		String username = (String) httpSession
				.getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		ASLSession session;
		if (username == null) {
			logger.warn("no user found in session, using test one");
			username = Constants.DEFAULT_USER;
			String scope = Constants.DEFAULT_SCOPE;

			httpSession.setAttribute(ScopeHelper.USERNAME_ATTRIBUTE, username);
			session = SessionManager.getInstance().getASLSession(
					httpSession.getId(), username);
			session.setScope(scope);

		} else {
			session= SessionManager.getInstance().getASLSession(
					httpSession.getId(), username);
			
		}
		
		logger.info("SessionUtil: aslSession "+session.getUsername()+" "+session.getScope());
		return session;
		
		
		
	}

	public static void setTDOpenSession(HttpSession httpSession, TDOpenSession s) {

		TDOpenSession session = (TDOpenSession) httpSession
				.getAttribute(TDOPEN_SESSION);
		if (session != null)
			httpSession.removeAttribute(TDOPEN_SESSION);
		httpSession.setAttribute(TDOPEN_SESSION, s);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());

	}

	
	public static void retrieveResources(HttpSession httpSession)
			throws Exception {

		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
		return;
	}

	public static void setTabularResources(HttpSession httpSession,
			List<TabularResource> trs) {

		@SuppressWarnings("unchecked")
		List<TabularResource> tabularResources = (List<TabularResource>) httpSession
				.getAttribute(TABULAR_RESOURCE_LIST);
		if (tabularResources != null)
			httpSession.removeAttribute(TABULAR_RESOURCE_LIST);
		httpSession.setAttribute(TABULAR_RESOURCE_LIST, trs);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static TRId getTRId(HttpSession httpSession) {
		TRId id = (TRId) httpSession.getAttribute(CURRENT_TR_ID);
		if (id == null) {
			logger.error("SDMX_TR_ID was not acquired");
		}
		return id;
	}

	public static void setTRId(HttpSession httpSession, TRId trId) {
		TRId id = (TRId) httpSession.getAttribute(CURRENT_TR_ID);
		if (id != null)
			httpSession.removeAttribute(CURRENT_TR_ID);
		httpSession.setAttribute(CURRENT_TR_ID, trId);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static TabResource getTabResource(HttpSession httpSession) {
		TabResource tabResource = (TabResource) httpSession
				.getAttribute(CURRENT_TABULAR_RESOURCE);
		if (tabResource == null) {
			logger.error("CURRENT_TABULAR_RESOURCE was not acquired");
		}
		return tabResource;
	}

	public static void setTabResource(HttpSession httpSession,
			TabResource tabResource) {
		TabResource t = (TabResource) httpSession
				.getAttribute(CURRENT_TABULAR_RESOURCE);
		if (t != null)
			httpSession.removeAttribute(CURRENT_TABULAR_RESOURCE);
		httpSession.setAttribute(CURRENT_TABULAR_RESOURCE, tabResource);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static TabResource getSDMXImportTabResource(HttpSession httpSession) {
		TabResource tabResource = (TabResource) httpSession
				.getAttribute(SDMX_IMPORT_TABULAR_RESOURCE);
		if (tabResource == null) {
			logger.error("SDMX_IMPORT_TABULAR_RESOURCE was not acquired");
		}
		return tabResource;
	}

	public static void setSDMXImportTabResource(HttpSession httpSession,
			TabResource tabResource) {
		TabResource t = (TabResource) httpSession
				.getAttribute(SDMX_IMPORT_TABULAR_RESOURCE);
		if (t != null)
			httpSession.removeAttribute(SDMX_IMPORT_TABULAR_RESOURCE);
		httpSession.setAttribute(SDMX_IMPORT_TABULAR_RESOURCE, tabResource);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}
	
	
	////
	public static TabResource getCSVImportTabResource(HttpSession httpSession) {
		TabResource tabResource = (TabResource) httpSession
				.getAttribute(CSV_IMPORT_TABULAR_RESOURCE);
		if (tabResource == null) {
			logger.error("CSV_IMPORT_TABULAR_RESOURCE was not acquired");
		}
		return tabResource;
	}

	public static void setCSVImportTabResource(HttpSession httpSession,
			TabResource tabResource) {
		TabResource t = (TabResource) httpSession
				.getAttribute(CSV_IMPORT_TABULAR_RESOURCE);
		if (t != null)
			httpSession.removeAttribute(CSV_IMPORT_TABULAR_RESOURCE);
		httpSession.setAttribute(CSV_IMPORT_TABULAR_RESOURCE, tabResource);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}
	
	////
	

	public static void setSDMXImportSession(HttpSession httpSession,
			SDMXImportSession s) {

		SDMXImportSession session = (SDMXImportSession) httpSession
				.getAttribute(SDMX_IMPORT_SESSION);
		if (session != null)
			httpSession.removeAttribute(SDMX_IMPORT_SESSION);
		httpSession.setAttribute(SDMX_IMPORT_SESSION, s);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static SDMXImportSession getSDMXImportSession(HttpSession httpSession) {
		SDMXImportSession importSession = (SDMXImportSession) httpSession
				.getAttribute(SDMX_IMPORT_SESSION);
		if (importSession == null) {
			logger.error("SDMXImportSession was not acquired");
		}
		return importSession;
	}

	public static void setCSVImportSession(HttpSession httpSession,
			CSVImportSession s) {

		CSVImportSession session = (CSVImportSession) httpSession
				.getAttribute(CSV_IMPORT_SESSION);
		if (session != null)
			httpSession.removeAttribute(CSV_IMPORT_SESSION);
		httpSession.setAttribute(CSV_IMPORT_SESSION, s);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static CSVImportSession getCSVImportSession(HttpSession httpSession) {
		CSVImportSession importSession = (CSVImportSession) httpSession
				.getAttribute(CSV_IMPORT_SESSION);
		if (importSession == null) {
			logger.error("CSVImportSession was not acquired");
		}
		return importSession;
	}
	
	
	public static void setFileUploadSession(HttpSession httpSession,
			FileUploadSession s) {

		FileUploadSession session = (FileUploadSession) httpSession
				.getAttribute(CSV_IMPORT_FILE_UPLOAD_SESSION);
		if (session != null)
			httpSession.removeAttribute(CSV_IMPORT_FILE_UPLOAD_SESSION);
		httpSession.setAttribute(CSV_IMPORT_FILE_UPLOAD_SESSION, s);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	
	public static FileUploadSession getFileUploadSession(HttpSession httpSession) {
		FileUploadSession fileUploadSession = (FileUploadSession) httpSession
				.getAttribute(CSV_IMPORT_FILE_UPLOAD_SESSION);
		if (fileUploadSession == null) {
			logger.error("FileUploadSession was not acquired");
		}
		return fileUploadSession;
	}
	
	
	public static ArrayList<Codelist> retrieveCodelists(HttpSession httpSession)
			throws Exception {
		logger.info("SessionUtil retriveCodelists");
		SDMXClient client = getSdmxClient(httpSession);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
		return client.getAllCodelists();
	}

	public static ArrayList<Dataset> retrieveDatasets(HttpSession httpSession)
			throws Exception {
		logger.info("SessionUtil retriveDatasets");
		SDMXClient client = getSdmxClient(httpSession);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
		return client.getAllDatasets();
	}

	public static ArrayList<Agencies> retrieveAgencies(HttpSession httpSession)
			throws Exception {
		logger.info("SessionUtil retriveAgencies");
		SDMXClient client = getSdmxClient(httpSession);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
		return client.getAllAgencies();
	}

	public static SDMXClient getSdmxClient(HttpSession httpSession) {
		SDMXClient sdmxClient = (SDMXClient) httpSession
				.getAttribute(SDMX_CLIENT_ATTRIBUTE);
		SDMXImportSession sdmxImportSession = (SDMXImportSession) httpSession
				.getAttribute(SDMX_IMPORT_SESSION);
		if (sdmxImportSession == null) {
			logger.error("SDMXImportSession was not acquired");
		} else {
			if (sdmxImportSession.getSource() instanceof SDMXRegistrySource) {
				String url = ((SDMXRegistrySource) sdmxImportSession
						.getSource()).getUrl();
				if (url == null || url.isEmpty()) {
					if (sdmxClient == null) {
						sdmxClient = new SDMXClient();
					} else {
						if (sdmxClient.type.compareTo(SDMXClient.TYPE.ANOTHER) == 0) {
							sdmxClient = new SDMXClient();
						}
					}
				} else {
					if (sdmxClient == null) {
						sdmxClient = new SDMXClient(url);
					} else {
						if (sdmxClient.type.compareTo(SDMXClient.TYPE.INTERNAL) == 0) {
							sdmxClient = new SDMXClient(url);
						} else {
							if (sdmxClient.url.compareTo(url) != 0) {
								sdmxClient = new SDMXClient(url);
							}
						}
					}
				}
				httpSession.setAttribute(SDMX_CLIENT_ATTRIBUTE, sdmxClient);
			} else {
				logger.error("SDMXImportSession does not have a SDMXRegistrySource");
			}
		}

		return sdmxClient;
	}

	public static Task getSDMXImportTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SDMX_IMPORT_TASK);
		if (monitor == null) {
			logger.error("SDMX_IMPORT_TASK was not acquired");
		}
		return monitor;
	}

	public static void setSDMXImportTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SDMX_IMPORT_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SDMX_IMPORT_TASK);
		httpSession.setAttribute(SDMX_IMPORT_TASK, task);
	}
	
	
	public static Task getCSVImportFileTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(CSV_IMPORT_TASK);
		if (monitor == null) {
			logger.error("CSV_IMPORT_TASK was not acquired");
		}
		return monitor;
	}

	public static void setCSVImportFileTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(CSV_IMPORT_TASK);
		if (monitor != null)
			httpSession.removeAttribute(CSV_IMPORT_TASK);
		httpSession.setAttribute(CSV_IMPORT_TASK, task);
	}
	

	public static TRTasksManager getTRTasksManager(HttpSession httpSession) {
		TRTasksManager tasksManager = (TRTasksManager) httpSession.getAttribute(TR_TASK_MANAGER);
		if (tasksManager != null) {
			return tasksManager;
		} else {
			tasksManager=new TRTasksManager();
			httpSession.setAttribute(TR_TASK_MANAGER, tasksManager);
			return tasksManager;
		}
	}

	public static void setTRTasksManager(HttpSession httpSession,TRTasksManager trTasksManager) {
		TRTasksManager tm = (TRTasksManager) httpSession.getAttribute(TR_TASK_MANAGER);
		if (tm != null) {
			httpSession.removeAttribute(TR_TASK_MANAGER);
		}
		httpSession.setAttribute(TR_TASK_MANAGER, trTasksManager);
		
	}

}
