package org.gcube.portlets.user.td.expressionwidget.shared.rule;

import java.io.Serializable;

import org.gcube.portlets.user.td.expressionwidget.shared.rule.type.TDRuleColumnType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class RuleDescriptionData implements Serializable {

	private static final long serialVersionUID = 2238695825091799598L;
	private long id;
	private String name;
	private String description;
	private String owner;
	private RuleScopeType scope;
	private TDRuleColumnType tdRuleColumnType;
	private C_Expression expression;

	public RuleDescriptionData() {
		super();
	}

	public RuleDescriptionData(long id, String name, String description, String owner,
			RuleScopeType scope,
			C_Expression expression) {
		super();
		this.id = id;
		this.name = name;
		this.description = description;
		this.owner=owner;
		this.scope = scope;
		this.tdRuleColumnType = null;
		this.expression = expression;
	}
	
	
	public RuleDescriptionData(long id, String name, String description,String owner,
			RuleScopeType scope, TDRuleColumnType tdRuleColumnType,
			C_Expression expression) {
		super();
		this.id = id;
		this.name = name;
		this.description = description;
		this.owner=owner;
		this.scope = scope;
		this.tdRuleColumnType = tdRuleColumnType;
		this.expression = expression;
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getOwner() {
		return owner;
	}

	public void setOwner(String owner) {
		this.owner = owner;
	}

	public RuleScopeType getScope() {
		return scope;
	}

	public void setScope(RuleScopeType scope) {
		this.scope = scope;
	}

	public TDRuleColumnType getTdRuleColumnType() {
		return tdRuleColumnType;
	}

	public void setTdRuleColumnType(TDRuleColumnType tdRuleColumnType) {
		this.tdRuleColumnType = tdRuleColumnType;
	}

	public C_Expression getExpression() {
		return expression;
	}

	public void setExpression(C_Expression expression) {
		this.expression = expression;
	}
	

	public String getReadableExpression() {
		if (expression != null) {
			return expression.getReadableExpression();
		} else {
			return "";
		}
	}

	@Override
	public String toString() {
		return "RuleDescriptionData [id=" + id + ", name=" + name
				+ ", description=" + description + ", owner=" + owner
				+ ", scope=" + scope + ", tdRuleColumnType=" + tdRuleColumnType
				+ ", expression=" + expression + "]";
	}

	

}
